<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_bank_info_list = new _bank_info_list();

// Run the page
$_bank_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_bank_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_bank_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_bank_infolist = currentForm = new ew.Form("f_bank_infolist", "list");
f_bank_infolist.formKeyCountName = '<?php echo $_bank_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_bank_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_bank_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_bank_infolist.lists["x_user_id"] = <?php echo $_bank_info_list->user_id->Lookup->toClientList() ?>;
f_bank_infolist.lists["x_user_id"].options = <?php echo JsonEncode($_bank_info_list->user_id->lookupOptions()) ?>;
f_bank_infolist.lists["x_currency"] = <?php echo $_bank_info_list->currency->Lookup->toClientList() ?>;
f_bank_infolist.lists["x_currency"].options = <?php echo JsonEncode($_bank_info_list->currency->lookupOptions()) ?>;
f_bank_infolist.lists["x_status"] = <?php echo $_bank_info_list->status->Lookup->toClientList() ?>;
f_bank_infolist.lists["x_status"].options = <?php echo JsonEncode($_bank_info_list->status->options(FALSE, TRUE)) ?>;
f_bank_infolist.lists["x_operator"] = <?php echo $_bank_info_list->operator->Lookup->toClientList() ?>;
f_bank_infolist.lists["x_operator"].options = <?php echo JsonEncode($_bank_info_list->operator->lookupOptions()) ?>;

// Form object for search
var f_bank_infolistsrch = currentSearchForm = new ew.Form("f_bank_infolistsrch");

// Filters
f_bank_infolistsrch.filterList = <?php echo $_bank_info_list->getFilterList() ?>;

// Init search panel as collapsed
f_bank_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_bank_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_bank_info_list->TotalRecs > 0 && $_bank_info_list->ExportOptions->visible()) { ?>
<?php $_bank_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_bank_info_list->ImportOptions->visible()) { ?>
<?php $_bank_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_bank_info_list->SearchOptions->visible()) { ?>
<?php $_bank_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_bank_info_list->FilterOptions->visible()) { ?>
<?php $_bank_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$_bank_info->isExport() || EXPORT_MASTER_RECORD && $_bank_info->isExport("print")) { ?>
<?php
if ($_bank_info_list->DbMasterFilter <> "" && $_bank_info->getCurrentMasterTable() == "production_partner") {
	if ($_bank_info_list->MasterRecordExists) {
		include_once "production_partnermaster.php";
	}
}
?>
<?php } ?>
<?php
$_bank_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_bank_info->isExport() && !$_bank_info->CurrentAction) { ?>
<form name="f_bank_infolistsrch" id="f_bank_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_bank_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="f_bank_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_bank_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_bank_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_bank_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_bank_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_bank_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_bank_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_bank_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_bank_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_bank_info_list->showPageHeader(); ?>
<?php
$_bank_info_list->showMessage();
?>
<?php if ($_bank_info_list->TotalRecs > 0 || $_bank_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_bank_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _bank_info">
<?php if (!$_bank_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_bank_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_bank_info_list->Pager)) $_bank_info_list->Pager = new PrevNextPager($_bank_info_list->StartRec, $_bank_info_list->DisplayRecs, $_bank_info_list->TotalRecs, $_bank_info_list->AutoHidePager) ?>
<?php if ($_bank_info_list->Pager->RecordCount > 0 && $_bank_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_bank_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_bank_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_bank_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_bank_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_bank_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_bank_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_bank_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_bank_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_bank_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_bank_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_bank_info_list->TotalRecs > 0 && (!$_bank_info_list->AutoHidePageSizeSelector || $_bank_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_bank_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_bank_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_bank_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_bank_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_bank_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_bank_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_bank_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_bank_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_bank_infolist" id="f_bank_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_bank_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_bank_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_bank_info">
<?php if ($_bank_info->getCurrentMasterTable() == "production_partner" && $_bank_info->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="production_partner">
<input type="hidden" name="fk_id" value="<?php echo $_bank_info->user_id->getSessionValue() ?>">
<?php } ?>
<div id="gmp__bank_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_bank_info_list->TotalRecs > 0 || $_bank_info->isGridEdit()) { ?>
<table id="tbl__bank_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_bank_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$_bank_info_list->renderListOptions();

// Render list options (header, left)
$_bank_info_list->ListOptions->render("header", "left");
?>
<?php if ($_bank_info->id->Visible) { // id ?>
	<?php if ($_bank_info->sortUrl($_bank_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $_bank_info->id->headerCellClass() ?>"><div id="elh__bank_info_id" class="_bank_info_id"><div class="ew-table-header-caption"><?php echo $_bank_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $_bank_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->id) ?>',2);"><div id="elh__bank_info_id" class="_bank_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->user_id->Visible) { // user_id ?>
	<?php if ($_bank_info->sortUrl($_bank_info->user_id) == "") { ?>
		<th data-name="user_id" class="<?php echo $_bank_info->user_id->headerCellClass() ?>"><div id="elh__bank_info_user_id" class="_bank_info_user_id"><div class="ew-table-header-caption"><?php echo $_bank_info->user_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_id" class="<?php echo $_bank_info->user_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->user_id) ?>',2);"><div id="elh__bank_info_user_id" class="_bank_info_user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->user_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->user_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->user_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->account_holder_name->Visible) { // account_holder_name ?>
	<?php if ($_bank_info->sortUrl($_bank_info->account_holder_name) == "") { ?>
		<th data-name="account_holder_name" class="<?php echo $_bank_info->account_holder_name->headerCellClass() ?>"><div id="elh__bank_info_account_holder_name" class="_bank_info_account_holder_name"><div class="ew-table-header-caption"><?php echo $_bank_info->account_holder_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_holder_name" class="<?php echo $_bank_info->account_holder_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->account_holder_name) ?>',2);"><div id="elh__bank_info_account_holder_name" class="_bank_info_account_holder_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->account_holder_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->account_holder_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->account_holder_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->currency->Visible) { // currency ?>
	<?php if ($_bank_info->sortUrl($_bank_info->currency) == "") { ?>
		<th data-name="currency" class="<?php echo $_bank_info->currency->headerCellClass() ?>"><div id="elh__bank_info_currency" class="_bank_info_currency"><div class="ew-table-header-caption"><?php echo $_bank_info->currency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="currency" class="<?php echo $_bank_info->currency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->currency) ?>',2);"><div id="elh__bank_info_currency" class="_bank_info_currency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->currency->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->currency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->currency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->bank_name->Visible) { // bank_name ?>
	<?php if ($_bank_info->sortUrl($_bank_info->bank_name) == "") { ?>
		<th data-name="bank_name" class="<?php echo $_bank_info->bank_name->headerCellClass() ?>"><div id="elh__bank_info_bank_name" class="_bank_info_bank_name"><div class="ew-table-header-caption"><?php echo $_bank_info->bank_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="bank_name" class="<?php echo $_bank_info->bank_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->bank_name) ?>',2);"><div id="elh__bank_info_bank_name" class="_bank_info_bank_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->bank_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->bank_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->bank_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->account_no->Visible) { // account_no ?>
	<?php if ($_bank_info->sortUrl($_bank_info->account_no) == "") { ?>
		<th data-name="account_no" class="<?php echo $_bank_info->account_no->headerCellClass() ?>"><div id="elh__bank_info_account_no" class="_bank_info_account_no"><div class="ew-table-header-caption"><?php echo $_bank_info->account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_no" class="<?php echo $_bank_info->account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->account_no) ?>',2);"><div id="elh__bank_info_account_no" class="_bank_info_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->account_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->c_account_no->Visible) { // c_account_no ?>
	<?php if ($_bank_info->sortUrl($_bank_info->c_account_no) == "") { ?>
		<th data-name="c_account_no" class="<?php echo $_bank_info->c_account_no->headerCellClass() ?>"><div id="elh__bank_info_c_account_no" class="_bank_info_c_account_no"><div class="ew-table-header-caption"><?php echo $_bank_info->c_account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="c_account_no" class="<?php echo $_bank_info->c_account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->c_account_no) ?>',2);"><div id="elh__bank_info_c_account_no" class="_bank_info_c_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->c_account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->c_account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->c_account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->address->Visible) { // address ?>
	<?php if ($_bank_info->sortUrl($_bank_info->address) == "") { ?>
		<th data-name="address" class="<?php echo $_bank_info->address->headerCellClass() ?>"><div id="elh__bank_info_address" class="_bank_info_address"><div class="ew-table-header-caption"><?php echo $_bank_info->address->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="address" class="<?php echo $_bank_info->address->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->address) ?>',2);"><div id="elh__bank_info_address" class="_bank_info_address">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->address->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->address->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->address->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->ifsc->Visible) { // ifsc ?>
	<?php if ($_bank_info->sortUrl($_bank_info->ifsc) == "") { ?>
		<th data-name="ifsc" class="<?php echo $_bank_info->ifsc->headerCellClass() ?>"><div id="elh__bank_info_ifsc" class="_bank_info_ifsc"><div class="ew-table-header-caption"><?php echo $_bank_info->ifsc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ifsc" class="<?php echo $_bank_info->ifsc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->ifsc) ?>',2);"><div id="elh__bank_info_ifsc" class="_bank_info_ifsc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->ifsc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->ifsc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->ifsc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->swift->Visible) { // swift ?>
	<?php if ($_bank_info->sortUrl($_bank_info->swift) == "") { ?>
		<th data-name="swift" class="<?php echo $_bank_info->swift->headerCellClass() ?>"><div id="elh__bank_info_swift" class="_bank_info_swift"><div class="ew-table-header-caption"><?php echo $_bank_info->swift->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="swift" class="<?php echo $_bank_info->swift->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->swift) ?>',2);"><div id="elh__bank_info_swift" class="_bank_info_swift">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->swift->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->swift->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->swift->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->ad->Visible) { // ad ?>
	<?php if ($_bank_info->sortUrl($_bank_info->ad) == "") { ?>
		<th data-name="ad" class="<?php echo $_bank_info->ad->headerCellClass() ?>"><div id="elh__bank_info_ad" class="_bank_info_ad"><div class="ew-table-header-caption"><?php echo $_bank_info->ad->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ad" class="<?php echo $_bank_info->ad->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->ad) ?>',2);"><div id="elh__bank_info_ad" class="_bank_info_ad">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->ad->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->ad->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->ad->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->routing->Visible) { // routing ?>
	<?php if ($_bank_info->sortUrl($_bank_info->routing) == "") { ?>
		<th data-name="routing" class="<?php echo $_bank_info->routing->headerCellClass() ?>"><div id="elh__bank_info_routing" class="_bank_info_routing"><div class="ew-table-header-caption"><?php echo $_bank_info->routing->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="routing" class="<?php echo $_bank_info->routing->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->routing) ?>',2);"><div id="elh__bank_info_routing" class="_bank_info_routing">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->routing->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->routing->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->routing->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->routing_swift->Visible) { // routing_swift ?>
	<?php if ($_bank_info->sortUrl($_bank_info->routing_swift) == "") { ?>
		<th data-name="routing_swift" class="<?php echo $_bank_info->routing_swift->headerCellClass() ?>"><div id="elh__bank_info_routing_swift" class="_bank_info_routing_swift"><div class="ew-table-header-caption"><?php echo $_bank_info->routing_swift->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="routing_swift" class="<?php echo $_bank_info->routing_swift->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->routing_swift) ?>',2);"><div id="elh__bank_info_routing_swift" class="_bank_info_routing_swift">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->routing_swift->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->routing_swift->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->routing_swift->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->nostro_account->Visible) { // nostro_account ?>
	<?php if ($_bank_info->sortUrl($_bank_info->nostro_account) == "") { ?>
		<th data-name="nostro_account" class="<?php echo $_bank_info->nostro_account->headerCellClass() ?>"><div id="elh__bank_info_nostro_account" class="_bank_info_nostro_account"><div class="ew-table-header-caption"><?php echo $_bank_info->nostro_account->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="nostro_account" class="<?php echo $_bank_info->nostro_account->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->nostro_account) ?>',2);"><div id="elh__bank_info_nostro_account" class="_bank_info_nostro_account">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->nostro_account->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->nostro_account->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->nostro_account->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->upi->Visible) { // upi ?>
	<?php if ($_bank_info->sortUrl($_bank_info->upi) == "") { ?>
		<th data-name="upi" class="<?php echo $_bank_info->upi->headerCellClass() ?>"><div id="elh__bank_info_upi" class="_bank_info_upi"><div class="ew-table-header-caption"><?php echo $_bank_info->upi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="upi" class="<?php echo $_bank_info->upi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->upi) ?>',2);"><div id="elh__bank_info_upi" class="_bank_info_upi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->upi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->upi->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->upi->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->status->Visible) { // status ?>
	<?php if ($_bank_info->sortUrl($_bank_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $_bank_info->status->headerCellClass() ?>"><div id="elh__bank_info_status" class="_bank_info_status"><div class="ew-table-header-caption"><?php echo $_bank_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $_bank_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->status) ?>',2);"><div id="elh__bank_info_status" class="_bank_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->operator->Visible) { // operator ?>
	<?php if ($_bank_info->sortUrl($_bank_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $_bank_info->operator->headerCellClass() ?>"><div id="elh__bank_info_operator" class="_bank_info_operator"><div class="ew-table-header-caption"><?php echo $_bank_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $_bank_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->operator) ?>',2);"><div id="elh__bank_info_operator" class="_bank_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_bank_info->datetime->Visible) { // datetime ?>
	<?php if ($_bank_info->sortUrl($_bank_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $_bank_info->datetime->headerCellClass() ?>"><div id="elh__bank_info_datetime" class="_bank_info_datetime"><div class="ew-table-header-caption"><?php echo $_bank_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $_bank_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_bank_info->SortUrl($_bank_info->datetime) ?>',2);"><div id="elh__bank_info_datetime" class="_bank_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_bank_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($_bank_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_bank_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_bank_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_bank_info->ExportAll && $_bank_info->isExport()) {
	$_bank_info_list->StopRec = $_bank_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_bank_info_list->TotalRecs > $_bank_info_list->StartRec + $_bank_info_list->DisplayRecs - 1)
		$_bank_info_list->StopRec = $_bank_info_list->StartRec + $_bank_info_list->DisplayRecs - 1;
	else
		$_bank_info_list->StopRec = $_bank_info_list->TotalRecs;
}
$_bank_info_list->RecCnt = $_bank_info_list->StartRec - 1;
if ($_bank_info_list->Recordset && !$_bank_info_list->Recordset->EOF) {
	$_bank_info_list->Recordset->moveFirst();
	$selectLimit = $_bank_info_list->UseSelectLimit;
	if (!$selectLimit && $_bank_info_list->StartRec > 1)
		$_bank_info_list->Recordset->move($_bank_info_list->StartRec - 1);
} elseif (!$_bank_info->AllowAddDeleteRow && $_bank_info_list->StopRec == 0) {
	$_bank_info_list->StopRec = $_bank_info->GridAddRowCount;
}

// Initialize aggregate
$_bank_info->RowType = ROWTYPE_AGGREGATEINIT;
$_bank_info->resetAttributes();
$_bank_info_list->renderRow();
while ($_bank_info_list->RecCnt < $_bank_info_list->StopRec) {
	$_bank_info_list->RecCnt++;
	if ($_bank_info_list->RecCnt >= $_bank_info_list->StartRec) {
		$_bank_info_list->RowCnt++;

		// Set up key count
		$_bank_info_list->KeyCount = $_bank_info_list->RowIndex;

		// Init row class and style
		$_bank_info->resetAttributes();
		$_bank_info->CssClass = "";
		if ($_bank_info->isGridAdd()) {
		} else {
			$_bank_info_list->loadRowValues($_bank_info_list->Recordset); // Load row values
		}
		$_bank_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_bank_info->RowAttrs = array_merge($_bank_info->RowAttrs, array('data-rowindex'=>$_bank_info_list->RowCnt, 'id'=>'r' . $_bank_info_list->RowCnt . '__bank_info', 'data-rowtype'=>$_bank_info->RowType));

		// Render row
		$_bank_info_list->renderRow();

		// Render list options
		$_bank_info_list->renderListOptions();
?>
	<tr<?php echo $_bank_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_bank_info_list->ListOptions->render("body", "left", $_bank_info_list->RowCnt);
?>
	<?php if ($_bank_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $_bank_info->id->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_id" class="_bank_info_id">
<span<?php echo $_bank_info->id->viewAttributes() ?>>
<?php echo $_bank_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->user_id->Visible) { // user_id ?>
		<td data-name="user_id"<?php echo $_bank_info->user_id->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_user_id" class="_bank_info_user_id">
<span<?php echo $_bank_info->user_id->viewAttributes() ?>>
<?php echo $_bank_info->user_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->account_holder_name->Visible) { // account_holder_name ?>
		<td data-name="account_holder_name"<?php echo $_bank_info->account_holder_name->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_account_holder_name" class="_bank_info_account_holder_name">
<span<?php echo $_bank_info->account_holder_name->viewAttributes() ?>>
<?php echo $_bank_info->account_holder_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->currency->Visible) { // currency ?>
		<td data-name="currency"<?php echo $_bank_info->currency->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_currency" class="_bank_info_currency">
<span<?php echo $_bank_info->currency->viewAttributes() ?>>
<?php echo $_bank_info->currency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->bank_name->Visible) { // bank_name ?>
		<td data-name="bank_name"<?php echo $_bank_info->bank_name->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_bank_name" class="_bank_info_bank_name">
<span<?php echo $_bank_info->bank_name->viewAttributes() ?>>
<?php echo $_bank_info->bank_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->account_no->Visible) { // account_no ?>
		<td data-name="account_no"<?php echo $_bank_info->account_no->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_account_no" class="_bank_info_account_no">
<span<?php echo $_bank_info->account_no->viewAttributes() ?>>
<?php echo $_bank_info->account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->c_account_no->Visible) { // c_account_no ?>
		<td data-name="c_account_no"<?php echo $_bank_info->c_account_no->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_c_account_no" class="_bank_info_c_account_no">
<span<?php echo $_bank_info->c_account_no->viewAttributes() ?>>
<?php echo $_bank_info->c_account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->address->Visible) { // address ?>
		<td data-name="address"<?php echo $_bank_info->address->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_address" class="_bank_info_address">
<span<?php echo $_bank_info->address->viewAttributes() ?>>
<?php echo $_bank_info->address->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->ifsc->Visible) { // ifsc ?>
		<td data-name="ifsc"<?php echo $_bank_info->ifsc->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_ifsc" class="_bank_info_ifsc">
<span<?php echo $_bank_info->ifsc->viewAttributes() ?>>
<?php echo $_bank_info->ifsc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->swift->Visible) { // swift ?>
		<td data-name="swift"<?php echo $_bank_info->swift->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_swift" class="_bank_info_swift">
<span<?php echo $_bank_info->swift->viewAttributes() ?>>
<?php echo $_bank_info->swift->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->ad->Visible) { // ad ?>
		<td data-name="ad"<?php echo $_bank_info->ad->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_ad" class="_bank_info_ad">
<span<?php echo $_bank_info->ad->viewAttributes() ?>>
<?php echo $_bank_info->ad->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->routing->Visible) { // routing ?>
		<td data-name="routing"<?php echo $_bank_info->routing->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_routing" class="_bank_info_routing">
<span<?php echo $_bank_info->routing->viewAttributes() ?>>
<?php echo $_bank_info->routing->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->routing_swift->Visible) { // routing_swift ?>
		<td data-name="routing_swift"<?php echo $_bank_info->routing_swift->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_routing_swift" class="_bank_info_routing_swift">
<span<?php echo $_bank_info->routing_swift->viewAttributes() ?>>
<?php echo $_bank_info->routing_swift->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->nostro_account->Visible) { // nostro_account ?>
		<td data-name="nostro_account"<?php echo $_bank_info->nostro_account->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_nostro_account" class="_bank_info_nostro_account">
<span<?php echo $_bank_info->nostro_account->viewAttributes() ?>>
<?php echo $_bank_info->nostro_account->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->upi->Visible) { // upi ?>
		<td data-name="upi"<?php echo $_bank_info->upi->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_upi" class="_bank_info_upi">
<span<?php echo $_bank_info->upi->viewAttributes() ?>>
<?php echo $_bank_info->upi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $_bank_info->status->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_status" class="_bank_info_status">
<span<?php echo $_bank_info->status->viewAttributes() ?>>
<?php echo $_bank_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $_bank_info->operator->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_operator" class="_bank_info_operator">
<span<?php echo $_bank_info->operator->viewAttributes() ?>>
<?php echo $_bank_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_bank_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $_bank_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $_bank_info_list->RowCnt ?>__bank_info_datetime" class="_bank_info_datetime">
<span<?php echo $_bank_info->datetime->viewAttributes() ?>>
<?php echo $_bank_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_bank_info_list->ListOptions->render("body", "right", $_bank_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_bank_info->isGridAdd())
		$_bank_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_bank_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_bank_info_list->Recordset)
	$_bank_info_list->Recordset->Close();
?>
<?php if (!$_bank_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_bank_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_bank_info_list->Pager)) $_bank_info_list->Pager = new PrevNextPager($_bank_info_list->StartRec, $_bank_info_list->DisplayRecs, $_bank_info_list->TotalRecs, $_bank_info_list->AutoHidePager) ?>
<?php if ($_bank_info_list->Pager->RecordCount > 0 && $_bank_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_bank_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_bank_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_bank_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_bank_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_bank_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_bank_info_list->pageUrl() ?>start=<?php echo $_bank_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_bank_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_bank_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_bank_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_bank_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_bank_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_bank_info_list->TotalRecs > 0 && (!$_bank_info_list->AutoHidePageSizeSelector || $_bank_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_bank_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_bank_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_bank_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_bank_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_bank_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_bank_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_bank_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_bank_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_bank_info_list->TotalRecs == 0 && !$_bank_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_bank_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_bank_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_bank_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_bank_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp__bank_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_bank_info_list->terminate();
?>