<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_barcode_list = new _barcode_list();

// Run the page
$_barcode_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_barcode_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_barcode->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_barcodelist = currentForm = new ew.Form("f_barcodelist", "list");
f_barcodelist.formKeyCountName = '<?php echo $_barcode_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_barcodelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_barcodelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_barcodelist.lists["x_despatch_week"] = <?php echo $_barcode_list->despatch_week->Lookup->toClientList() ?>;
f_barcodelist.lists["x_despatch_week"].options = <?php echo JsonEncode($_barcode_list->despatch_week->lookupOptions()) ?>;
f_barcodelist.lists["x__barcode"] = <?php echo $_barcode_list->_barcode->Lookup->toClientList() ?>;
f_barcodelist.lists["x__barcode"].options = <?php echo JsonEncode($_barcode_list->_barcode->lookupOptions()) ?>;
f_barcodelist.lists["x_buyers_id"] = <?php echo $_barcode_list->buyers_id->Lookup->toClientList() ?>;
f_barcodelist.lists["x_buyers_id"].options = <?php echo JsonEncode($_barcode_list->buyers_id->lookupOptions()) ?>;
f_barcodelist.autoSuggests["x_buyers_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_barcodelist.lists["x_buyer_ref"] = <?php echo $_barcode_list->buyer_ref->Lookup->toClientList() ?>;
f_barcodelist.lists["x_buyer_ref"].options = <?php echo JsonEncode($_barcode_list->buyer_ref->lookupOptions()) ?>;
f_barcodelist.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_barcodelist.lists["x_status"] = <?php echo $_barcode_list->status->Lookup->toClientList() ?>;
f_barcodelist.lists["x_status"].options = <?php echo JsonEncode($_barcode_list->status->lookupOptions()) ?>;
f_barcodelist.lists["x_cs"] = <?php echo $_barcode_list->cs->Lookup->toClientList() ?>;
f_barcodelist.lists["x_cs"].options = <?php echo JsonEncode($_barcode_list->cs->options(FALSE, TRUE)) ?>;
f_barcodelist.lists["x_weaving_works"] = <?php echo $_barcode_list->weaving_works->Lookup->toClientList() ?>;
f_barcodelist.lists["x_weaving_works"].options = <?php echo JsonEncode($_barcode_list->weaving_works->lookupOptions()) ?>;
f_barcodelist.lists["x_current_works"] = <?php echo $_barcode_list->current_works->Lookup->toClientList() ?>;
f_barcodelist.lists["x_current_works"].options = <?php echo JsonEncode($_barcode_list->current_works->lookupOptions()) ?>;
f_barcodelist.lists["x_process_c[]"] = <?php echo $_barcode_list->process_c->Lookup->toClientList() ?>;
f_barcodelist.lists["x_process_c[]"].options = <?php echo JsonEncode($_barcode_list->process_c->lookupOptions()) ?>;
f_barcodelist.lists["x_process_d[]"] = <?php echo $_barcode_list->process_d->Lookup->toClientList() ?>;
f_barcodelist.lists["x_process_d[]"].options = <?php echo JsonEncode($_barcode_list->process_d->lookupOptions()) ?>;
f_barcodelist.lists["x_batch_no"] = <?php echo $_barcode_list->batch_no->Lookup->toClientList() ?>;
f_barcodelist.lists["x_batch_no"].options = <?php echo JsonEncode($_barcode_list->batch_no->lookupOptions()) ?>;
f_barcodelist.lists["x_completed"] = <?php echo $_barcode_list->completed->Lookup->toClientList() ?>;
f_barcodelist.lists["x_completed"].options = <?php echo JsonEncode($_barcode_list->completed->options(FALSE, TRUE)) ?>;
f_barcodelist.lists["x_category"] = <?php echo $_barcode_list->category->Lookup->toClientList() ?>;
f_barcodelist.lists["x_category"].options = <?php echo JsonEncode($_barcode_list->category->lookupOptions()) ?>;

// Form object for search
var f_barcodelistsrch = currentSearchForm = new ew.Form("f_barcodelistsrch");

// Validate function for search
f_barcodelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_design_size");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->design_size->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->pl_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
f_barcodelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_barcodelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_barcodelistsrch.lists["x_despatch_week"] = <?php echo $_barcode_list->despatch_week->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x_despatch_week"].options = <?php echo JsonEncode($_barcode_list->despatch_week->lookupOptions()) ?>;
f_barcodelistsrch.lists["x__barcode"] = <?php echo $_barcode_list->_barcode->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x__barcode"].options = <?php echo JsonEncode($_barcode_list->_barcode->lookupOptions()) ?>;
f_barcodelistsrch.lists["x_buyers_id"] = <?php echo $_barcode_list->buyers_id->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x_buyers_id"].options = <?php echo JsonEncode($_barcode_list->buyers_id->lookupOptions()) ?>;
f_barcodelistsrch.autoSuggests["x_buyers_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_barcodelistsrch.lists["x_buyer_ref"] = <?php echo $_barcode_list->buyer_ref->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x_buyer_ref"].options = <?php echo JsonEncode($_barcode_list->buyer_ref->lookupOptions()) ?>;
f_barcodelistsrch.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_barcodelistsrch.lists["x_status"] = <?php echo $_barcode_list->status->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x_status"].options = <?php echo JsonEncode($_barcode_list->status->lookupOptions()) ?>;
f_barcodelistsrch.lists["x_process_c[]"] = <?php echo $_barcode_list->process_c->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x_process_c[]"].options = <?php echo JsonEncode($_barcode_list->process_c->lookupOptions()) ?>;
f_barcodelistsrch.lists["x_process_d[]"] = <?php echo $_barcode_list->process_d->Lookup->toClientList() ?>;
f_barcodelistsrch.lists["x_process_d[]"].options = <?php echo JsonEncode($_barcode_list->process_d->lookupOptions()) ?>;

// Filters
f_barcodelistsrch.filterList = <?php echo $_barcode_list->getFilterList() ?>;

// Init search panel as collapsed
f_barcodelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_barcode->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_barcode_list->TotalRecs > 0 && $_barcode_list->ExportOptions->visible()) { ?>
<?php $_barcode_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_barcode_list->ImportOptions->visible()) { ?>
<?php $_barcode_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_barcode_list->SearchOptions->visible()) { ?>
<?php $_barcode_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_barcode_list->FilterOptions->visible()) { ?>
<?php $_barcode_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$_barcode_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_barcode->isExport() && !$_barcode->CurrentAction) { ?>
<form name="f_barcodelistsrch" id="f_barcodelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_barcode_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="f_barcodelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_barcode">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$_barcode_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$_barcode->RowType = ROWTYPE_SEARCH;

// Render row
$_barcode->resetAttributes();
$_barcode_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($_barcode->po->Visible) { // po ?>
	<div id="xsc_po" class="ew-cell form-group">
		<label for="x_po" class="ew-search-caption ew-label"><?php echo $_barcode->po->caption() ?></label>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="_barcode" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($_barcode->po->getPlaceHolder()) ?>" value="<?php echo $_barcode->po->EditValue ?>"<?php echo $_barcode->po->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_po style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_po style="d-none"">
<input type="text" data-table="_barcode" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($_barcode->po->getPlaceHolder()) ?>" value="<?php echo $_barcode->po->EditValue2 ?>"<?php echo $_barcode->po->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($_barcode->despatch_week->Visible) { // despatch_week ?>
	<div id="xsc_despatch_week" class="ew-cell form-group">
		<label for="x_despatch_week" class="ew-search-caption ew-label"><?php echo $_barcode->despatch_week->caption() ?></label>
		<span class="ew-search-operator"><select name="z_despatch_week" id="z_despatch_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_despatch_week" data-value-separator="<?php echo $_barcode->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $_barcode->despatch_week->editAttributes() ?>>
		<?php echo $_barcode->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $_barcode->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
		<span class="ew-search-cond btw1_despatch_week style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_despatch_week style="d-none"">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_despatch_week" data-value-separator="<?php echo $_barcode->despatch_week->displayValueSeparatorAttribute() ?>" id="y_despatch_week" name="y_despatch_week"<?php echo $_barcode->despatch_week->editAttributes() ?>>
		<?php echo $_barcode->despatch_week->selectOptionListHtml("y_despatch_week") ?>
	</select>
</div>
<?php echo $_barcode->despatch_week->Lookup->getParamTag("p_y_despatch_week") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($_barcode->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $_barcode->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="_barcode" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($_barcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $_barcode->_barcode->EditValue ?>"<?php echo $_barcode->_barcode->editAttributes() ?>>
<?php echo $_barcode->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="_barcode" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($_barcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $_barcode->_barcode->EditValue2 ?>"<?php echo $_barcode->_barcode->editAttributes() ?>>
<?php echo $_barcode->_barcode->Lookup->getParamTag("p_y__barcode") ?>
</span>
	</div>
<?php } ?>
<?php if ($_barcode->buyers_id->Visible) { // buyers_id ?>
	<div id="xsc_buyers_id" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $_barcode->buyers_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$_barcode->buyers_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_barcode->buyers_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyers_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyers_id" id="sv_x_buyers_id" value="<?php echo RemoveHtml($_barcode->buyers_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_barcode->buyers_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_barcode->buyers_id->getPlaceHolder()) ?>"<?php echo $_barcode->buyers_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->buyers_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyers_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->buyers_id->ReadOnly || $_barcode->buyers_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_barcode" data-field="x_buyers_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_barcode->buyers_id->displayValueSeparatorAttribute() ?>" name="x_buyers_id" id="x_buyers_id" value="<?php echo HtmlEncode($_barcode->buyers_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_barcodelistsrch.createAutoSuggest({"id":"x_buyers_id","forceSelect":false});
</script>
<?php echo $_barcode->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($_barcode->buyer_ref->Visible) { // buyer_ref ?>
	<div id="xsc_buyer_ref" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $_barcode->buyer_ref->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$_barcode->buyer_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_barcode->buyer_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_ref" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?php echo RemoveHtml($_barcode->buyer_ref->EditValue) ?>" placeholder="<?php echo HtmlEncode($_barcode->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_barcode->buyer_ref->getPlaceHolder()) ?>"<?php echo $_barcode->buyer_ref->editAttributes() ?>>
</span>
<input type="hidden" data-table="_barcode" data-field="x_buyer_ref" data-value-separator="<?php echo $_barcode->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($_barcode->buyer_ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_barcodelistsrch.createAutoSuggest({"id":"x_buyer_ref","forceSelect":false});
</script>
<?php echo $_barcode->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
	</div>
<?php } ?>
<?php if ($_barcode->design_size->Visible) { // design_size ?>
	<div id="xsc_design_size" class="ew-cell form-group">
		<label for="x_design_size" class="ew-search-caption ew-label"><?php echo $_barcode->design_size->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_size" id="z_design_size" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="_barcode" data-field="x_design_size" name="x_design_size" id="x_design_size" size="30" placeholder="<?php echo HtmlEncode($_barcode->design_size->getPlaceHolder()) ?>" value="<?php echo $_barcode->design_size->EditValue ?>"<?php echo $_barcode->design_size->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
<?php if ($_barcode->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $_barcode->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_status" data-value-separator="<?php echo $_barcode->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $_barcode->status->editAttributes() ?>>
		<?php echo $_barcode->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $_barcode->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
<?php if ($_barcode->process_c->Visible) { // process_c ?>
	<div id="xsc_process_c" class="ew-cell form-group">
		<label for="x_process_c" class="ew-search-caption ew-label"><?php echo $_barcode->process_c->caption() ?></label>
		<span class="ew-search-operator"><select name="z_process_c" id="z_process_c" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_process_c"><?php echo strval($_barcode->process_c->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_c->AdvancedSearch->ViewValue) : $_barcode->process_c->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_c->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_c->ReadOnly || $_barcode->process_c->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_process_c[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_c->Lookup->getParamTag("p_x_process_c") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_c" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_c->displayValueSeparatorAttribute() ?>" name="x_process_c[]" id="x_process_c[]" value="<?php echo $_barcode->process_c->AdvancedSearch->SearchValue ?>"<?php echo $_barcode->process_c->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_process_c style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_process_c style="d-none"">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_process_c"><?php echo strval($_barcode->process_c->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_c->AdvancedSearch->ViewValue2) : $_barcode->process_c->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_c->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_c->ReadOnly || $_barcode->process_c->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_process_c[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_c->Lookup->getParamTag("p_y_process_c") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_c" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_c->displayValueSeparatorAttribute() ?>" name="y_process_c[]" id="y_process_c[]" value="<?php echo $_barcode->process_c->AdvancedSearch->SearchValue2 ?>"<?php echo $_barcode->process_c->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_5" class="ew-row d-sm-flex">
<?php if ($_barcode->process_d->Visible) { // process_d ?>
	<div id="xsc_process_d" class="ew-cell form-group">
		<label for="x_process_d" class="ew-search-caption ew-label"><?php echo $_barcode->process_d->caption() ?></label>
		<span class="ew-search-operator"><select name="z_process_d" id="z_process_d" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_process_d"><?php echo strval($_barcode->process_d->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_d->AdvancedSearch->ViewValue) : $_barcode->process_d->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_d->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_d->ReadOnly || $_barcode->process_d->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_process_d[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_d->Lookup->getParamTag("p_x_process_d") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_d" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_d->displayValueSeparatorAttribute() ?>" name="x_process_d[]" id="x_process_d[]" value="<?php echo $_barcode->process_d->AdvancedSearch->SearchValue ?>"<?php echo $_barcode->process_d->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_process_d style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_process_d style="d-none"">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_process_d"><?php echo strval($_barcode->process_d->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_d->AdvancedSearch->ViewValue2) : $_barcode->process_d->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_d->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_d->ReadOnly || $_barcode->process_d->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_process_d[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_d->Lookup->getParamTag("p_y_process_d") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_d" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_d->displayValueSeparatorAttribute() ?>" name="y_process_d[]" id="y_process_d[]" value="<?php echo $_barcode->process_d->AdvancedSearch->SearchValue2 ?>"<?php echo $_barcode->process_d->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($_barcode->pl_no->Visible) { // pl_no ?>
	<div id="xsc_pl_no" class="ew-cell form-group">
		<label for="x_pl_no" class="ew-search-caption ew-label"><?php echo $_barcode->pl_no->caption() ?></label>
		<span class="ew-search-operator"><select name="z_pl_no" id="z_pl_no" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="_barcode" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($_barcode->pl_no->getPlaceHolder()) ?>" value="<?php echo $_barcode->pl_no->EditValue ?>"<?php echo $_barcode->pl_no->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_pl_no style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_pl_no style="d-none"">
<input type="text" data-table="_barcode" data-field="x_pl_no" name="y_pl_no" id="y_pl_no" size="30" placeholder="<?php echo HtmlEncode($_barcode->pl_no->getPlaceHolder()) ?>" value="<?php echo $_barcode->pl_no->EditValue2 ?>"<?php echo $_barcode->pl_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_6" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_barcode_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_barcode_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_barcode_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_barcode_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_barcode_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_barcode_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_barcode_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_barcode_list->showPageHeader(); ?>
<?php
$_barcode_list->showMessage();
?>
<?php if ($_barcode_list->TotalRecs > 0 || $_barcode->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_barcode_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _barcode">
<?php if (!$_barcode->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_barcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_barcode_list->Pager)) $_barcode_list->Pager = new PrevNextPager($_barcode_list->StartRec, $_barcode_list->DisplayRecs, $_barcode_list->TotalRecs, $_barcode_list->AutoHidePager) ?>
<?php if ($_barcode_list->Pager->RecordCount > 0 && $_barcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_barcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_barcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_barcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_barcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_barcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_barcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_barcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_barcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_barcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_barcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_barcode_list->TotalRecs > 0 && (!$_barcode_list->AutoHidePageSizeSelector || $_barcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_barcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_barcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_barcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_barcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_barcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_barcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_barcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_barcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_barcodelist" id="f_barcodelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_barcode_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_barcode_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_barcode">
<div id="gmp__barcode" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_barcode_list->TotalRecs > 0 || $_barcode->isGridEdit()) { ?>
<table id="tbl__barcodelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_barcode_list->RowType = ROWTYPE_HEADER;

// Render list options
$_barcode_list->renderListOptions();

// Render list options (header, left)
$_barcode_list->ListOptions->render("header", "left");
?>
<?php if ($_barcode->po->Visible) { // po ?>
	<?php if ($_barcode->sortUrl($_barcode->po) == "") { ?>
		<th data-name="po" class="<?php echo $_barcode->po->headerCellClass() ?>"><div id="elh__barcode_po" class="_barcode_po"><div class="ew-table-header-caption"><?php echo $_barcode->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $_barcode->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->po) ?>',2);"><div id="elh__barcode_po" class="_barcode_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->despatch_week->Visible) { // despatch_week ?>
	<?php if ($_barcode->sortUrl($_barcode->despatch_week) == "") { ?>
		<th data-name="despatch_week" class="<?php echo $_barcode->despatch_week->headerCellClass() ?>"><div id="elh__barcode_despatch_week" class="_barcode_despatch_week"><div class="ew-table-header-caption"><?php echo $_barcode->despatch_week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="despatch_week" class="<?php echo $_barcode->despatch_week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->despatch_week) ?>',2);"><div id="elh__barcode_despatch_week" class="_barcode_despatch_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->despatch_week->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->despatch_week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->despatch_week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->_barcode->Visible) { // barcode ?>
	<?php if ($_barcode->sortUrl($_barcode->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $_barcode->_barcode->headerCellClass() ?>"><div id="elh__barcode__barcode" class="_barcode__barcode"><div class="ew-table-header-caption"><?php echo $_barcode->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $_barcode->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->_barcode) ?>',2);"><div id="elh__barcode__barcode" class="_barcode__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->_barcode->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->buyers_id->Visible) { // buyers_id ?>
	<?php if ($_barcode->sortUrl($_barcode->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $_barcode->buyers_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh__barcode_buyers_id" class="_barcode_buyers_id"><div class="ew-table-header-caption"><?php echo $_barcode->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $_barcode->buyers_id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->buyers_id) ?>',2);"><div id="elh__barcode_buyers_id" class="_barcode_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->buyers_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->buyer_ref->Visible) { // buyer_ref ?>
	<?php if ($_barcode->sortUrl($_barcode->buyer_ref) == "") { ?>
		<th data-name="buyer_ref" class="<?php echo $_barcode->buyer_ref->headerCellClass() ?>"><div id="elh__barcode_buyer_ref" class="_barcode_buyer_ref"><div class="ew-table-header-caption"><?php echo $_barcode->buyer_ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_ref" class="<?php echo $_barcode->buyer_ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->buyer_ref) ?>',2);"><div id="elh__barcode_buyer_ref" class="_barcode_buyer_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->buyer_ref->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->buyer_ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->buyer_ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->design_size->Visible) { // design_size ?>
	<?php if ($_barcode->sortUrl($_barcode->design_size) == "") { ?>
		<th data-name="design_size" class="<?php echo $_barcode->design_size->headerCellClass() ?>"><div id="elh__barcode_design_size" class="_barcode_design_size"><div class="ew-table-header-caption"><?php echo $_barcode->design_size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design_size" class="<?php echo $_barcode->design_size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->design_size) ?>',2);"><div id="elh__barcode_design_size" class="_barcode_design_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->design_size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->design_size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->design_size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->sqm->Visible) { // sqm ?>
	<?php if ($_barcode->sortUrl($_barcode->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $_barcode->sqm->headerCellClass() ?>"><div id="elh__barcode_sqm" class="_barcode_sqm"><div class="ew-table-header-caption"><?php echo $_barcode->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $_barcode->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->sqm) ?>',2);"><div id="elh__barcode_sqm" class="_barcode_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->sqm_a->Visible) { // sqm_a ?>
	<?php if ($_barcode->sortUrl($_barcode->sqm_a) == "") { ?>
		<th data-name="sqm_a" class="<?php echo $_barcode->sqm_a->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh__barcode_sqm_a" class="_barcode_sqm_a"><div class="ew-table-header-caption"><?php echo $_barcode->sqm_a->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm_a" class="<?php echo $_barcode->sqm_a->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->sqm_a) ?>',2);"><div id="elh__barcode_sqm_a" class="_barcode_sqm_a">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->sqm_a->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->sqm_a->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->sqm_a->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->status->Visible) { // status ?>
	<?php if ($_barcode->sortUrl($_barcode->status) == "") { ?>
		<th data-name="status" class="<?php echo $_barcode->status->headerCellClass() ?>"><div id="elh__barcode_status" class="_barcode_status"><div class="ew-table-header-caption"><?php echo $_barcode->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $_barcode->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->status) ?>',2);"><div id="elh__barcode_status" class="_barcode_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->jc_no->Visible) { // jc_no ?>
	<?php if ($_barcode->sortUrl($_barcode->jc_no) == "") { ?>
		<th data-name="jc_no" class="<?php echo $_barcode->jc_no->headerCellClass() ?>"><div id="elh__barcode_jc_no" class="_barcode_jc_no"><div class="ew-table-header-caption"><?php echo $_barcode->jc_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="jc_no" class="<?php echo $_barcode->jc_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->jc_no) ?>',2);"><div id="elh__barcode_jc_no" class="_barcode_jc_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->jc_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->jc_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->jc_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->cs->Visible) { // cs ?>
	<?php if ($_barcode->sortUrl($_barcode->cs) == "") { ?>
		<th data-name="cs" class="<?php echo $_barcode->cs->headerCellClass() ?>"><div id="elh__barcode_cs" class="_barcode_cs"><div class="ew-table-header-caption"><?php echo $_barcode->cs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cs" class="<?php echo $_barcode->cs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->cs) ?>',2);"><div id="elh__barcode_cs" class="_barcode_cs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->cs->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->cs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->cs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->weaving_works->Visible) { // weaving_works ?>
	<?php if ($_barcode->sortUrl($_barcode->weaving_works) == "") { ?>
		<th data-name="weaving_works" class="<?php echo $_barcode->weaving_works->headerCellClass() ?>"><div id="elh__barcode_weaving_works" class="_barcode_weaving_works"><div class="ew-table-header-caption"><?php echo $_barcode->weaving_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="weaving_works" class="<?php echo $_barcode->weaving_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->weaving_works) ?>',2);"><div id="elh__barcode_weaving_works" class="_barcode_weaving_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->weaving_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->weaving_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->weaving_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->current_works->Visible) { // current_works ?>
	<?php if ($_barcode->sortUrl($_barcode->current_works) == "") { ?>
		<th data-name="current_works" class="<?php echo $_barcode->current_works->headerCellClass() ?>"><div id="elh__barcode_current_works" class="_barcode_current_works"><div class="ew-table-header-caption"><?php echo $_barcode->current_works->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_works" class="<?php echo $_barcode->current_works->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->current_works) ?>',2);"><div id="elh__barcode_current_works" class="_barcode_current_works">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->current_works->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->current_works->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->current_works->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->process_c->Visible) { // process_c ?>
	<?php if ($_barcode->sortUrl($_barcode->process_c) == "") { ?>
		<th data-name="process_c" class="<?php echo $_barcode->process_c->headerCellClass() ?>"><div id="elh__barcode_process_c" class="_barcode_process_c"><div class="ew-table-header-caption"><?php echo $_barcode->process_c->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_c" class="<?php echo $_barcode->process_c->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->process_c) ?>',2);"><div id="elh__barcode_process_c" class="_barcode_process_c">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->process_c->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->process_c->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->process_c->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->process_d->Visible) { // process_d ?>
	<?php if ($_barcode->sortUrl($_barcode->process_d) == "") { ?>
		<th data-name="process_d" class="<?php echo $_barcode->process_d->headerCellClass() ?>"><div id="elh__barcode_process_d" class="_barcode_process_d"><div class="ew-table-header-caption"><?php echo $_barcode->process_d->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process_d" class="<?php echo $_barcode->process_d->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->process_d) ?>',2);"><div id="elh__barcode_process_d" class="_barcode_process_d">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->process_d->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->process_d->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->process_d->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->remarks->Visible) { // remarks ?>
	<?php if ($_barcode->sortUrl($_barcode->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $_barcode->remarks->headerCellClass() ?>"><div id="elh__barcode_remarks" class="_barcode_remarks"><div class="ew-table-header-caption"><?php echo $_barcode->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $_barcode->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->remarks) ?>',2);"><div id="elh__barcode_remarks" class="_barcode_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->p_remarks->Visible) { // p_remarks ?>
	<?php if ($_barcode->sortUrl($_barcode->p_remarks) == "") { ?>
		<th data-name="p_remarks" class="<?php echo $_barcode->p_remarks->headerCellClass() ?>"><div id="elh__barcode_p_remarks" class="_barcode_p_remarks"><div class="ew-table-header-caption"><?php echo $_barcode->p_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="p_remarks" class="<?php echo $_barcode->p_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->p_remarks) ?>',2);"><div id="elh__barcode_p_remarks" class="_barcode_p_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->p_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->p_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->p_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->batch_no->Visible) { // batch_no ?>
	<?php if ($_barcode->sortUrl($_barcode->batch_no) == "") { ?>
		<th data-name="batch_no" class="<?php echo $_barcode->batch_no->headerCellClass() ?>"><div id="elh__barcode_batch_no" class="_barcode_batch_no"><div class="ew-table-header-caption"><?php echo $_barcode->batch_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="batch_no" class="<?php echo $_barcode->batch_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->batch_no) ?>',2);"><div id="elh__barcode_batch_no" class="_barcode_batch_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->batch_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->batch_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->batch_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->buyer_po->Visible) { // buyer_po ?>
	<?php if ($_barcode->sortUrl($_barcode->buyer_po) == "") { ?>
		<th data-name="buyer_po" class="<?php echo $_barcode->buyer_po->headerCellClass() ?>"><div id="elh__barcode_buyer_po" class="_barcode_buyer_po"><div class="ew-table-header-caption"><?php echo $_barcode->buyer_po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_po" class="<?php echo $_barcode->buyer_po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->buyer_po) ?>',2);"><div id="elh__barcode_buyer_po" class="_barcode_buyer_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->buyer_po->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->buyer_po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->buyer_po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->buyer_uid_loc->Visible) { // buyer_uid_loc ?>
	<?php if ($_barcode->sortUrl($_barcode->buyer_uid_loc) == "") { ?>
		<th data-name="buyer_uid_loc" class="<?php echo $_barcode->buyer_uid_loc->headerCellClass() ?>"><div id="elh__barcode_buyer_uid_loc" class="_barcode_buyer_uid_loc"><div class="ew-table-header-caption"><?php echo $_barcode->buyer_uid_loc->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_uid_loc" class="<?php echo $_barcode->buyer_uid_loc->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->buyer_uid_loc) ?>',2);"><div id="elh__barcode_buyer_uid_loc" class="_barcode_buyer_uid_loc">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->buyer_uid_loc->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->buyer_uid_loc->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->buyer_uid_loc->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->order_date->Visible) { // order_date ?>
	<?php if ($_barcode->sortUrl($_barcode->order_date) == "") { ?>
		<th data-name="order_date" class="<?php echo $_barcode->order_date->headerCellClass() ?>"><div id="elh__barcode_order_date" class="_barcode_order_date"><div class="ew-table-header-caption"><?php echo $_barcode->order_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_date" class="<?php echo $_barcode->order_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->order_date) ?>',2);"><div id="elh__barcode_order_date" class="_barcode_order_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->order_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->order_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->order_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->completed->Visible) { // completed ?>
	<?php if ($_barcode->sortUrl($_barcode->completed) == "") { ?>
		<th data-name="completed" class="<?php echo $_barcode->completed->headerCellClass() ?>"><div id="elh__barcode_completed" class="_barcode_completed"><div class="ew-table-header-caption"><?php echo $_barcode->completed->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="completed" class="<?php echo $_barcode->completed->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->completed) ?>',2);"><div id="elh__barcode_completed" class="_barcode_completed">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->completed->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->completed->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->completed->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->category->Visible) { // category ?>
	<?php if ($_barcode->sortUrl($_barcode->category) == "") { ?>
		<th data-name="category" class="<?php echo $_barcode->category->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh__barcode_category" class="_barcode_category"><div class="ew-table-header-caption"><?php echo $_barcode->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $_barcode->category->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->category) ?>',2);"><div id="elh__barcode_category" class="_barcode_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($_barcode->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->pl_no->Visible) { // pl_no ?>
	<?php if ($_barcode->sortUrl($_barcode->pl_no) == "") { ?>
		<th data-name="pl_no" class="<?php echo $_barcode->pl_no->headerCellClass() ?>"><div id="elh__barcode_pl_no" class="_barcode_pl_no"><div class="ew-table-header-caption"><?php echo $_barcode->pl_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pl_no" class="<?php echo $_barcode->pl_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->pl_no) ?>',2);"><div id="elh__barcode_pl_no" class="_barcode_pl_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->pl_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->pl_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->pl_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_barcode->buyer_barcode->Visible) { // buyer_barcode ?>
	<?php if ($_barcode->sortUrl($_barcode->buyer_barcode) == "") { ?>
		<th data-name="buyer_barcode" class="<?php echo $_barcode->buyer_barcode->headerCellClass() ?>"><div id="elh__barcode_buyer_barcode" class="_barcode_buyer_barcode"><div class="ew-table-header-caption"><?php echo $_barcode->buyer_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer_barcode" class="<?php echo $_barcode->buyer_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_barcode->SortUrl($_barcode->buyer_barcode) ?>',2);"><div id="elh__barcode_buyer_barcode" class="_barcode_buyer_barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_barcode->buyer_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_barcode->buyer_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_barcode->buyer_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_barcode_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_barcode->ExportAll && $_barcode->isExport()) {
	$_barcode_list->StopRec = $_barcode_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_barcode_list->TotalRecs > $_barcode_list->StartRec + $_barcode_list->DisplayRecs - 1)
		$_barcode_list->StopRec = $_barcode_list->StartRec + $_barcode_list->DisplayRecs - 1;
	else
		$_barcode_list->StopRec = $_barcode_list->TotalRecs;
}
$_barcode_list->RecCnt = $_barcode_list->StartRec - 1;
if ($_barcode_list->Recordset && !$_barcode_list->Recordset->EOF) {
	$_barcode_list->Recordset->moveFirst();
	$selectLimit = $_barcode_list->UseSelectLimit;
	if (!$selectLimit && $_barcode_list->StartRec > 1)
		$_barcode_list->Recordset->move($_barcode_list->StartRec - 1);
} elseif (!$_barcode->AllowAddDeleteRow && $_barcode_list->StopRec == 0) {
	$_barcode_list->StopRec = $_barcode->GridAddRowCount;
}

// Initialize aggregate
$_barcode->RowType = ROWTYPE_AGGREGATEINIT;
$_barcode->resetAttributes();
$_barcode_list->renderRow();
while ($_barcode_list->RecCnt < $_barcode_list->StopRec) {
	$_barcode_list->RecCnt++;
	if ($_barcode_list->RecCnt >= $_barcode_list->StartRec) {
		$_barcode_list->RowCnt++;

		// Set up key count
		$_barcode_list->KeyCount = $_barcode_list->RowIndex;

		// Init row class and style
		$_barcode->resetAttributes();
		$_barcode->CssClass = "";
		if ($_barcode->isGridAdd()) {
		} else {
			$_barcode_list->loadRowValues($_barcode_list->Recordset); // Load row values
		}
		$_barcode->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_barcode->RowAttrs = array_merge($_barcode->RowAttrs, array('data-rowindex'=>$_barcode_list->RowCnt, 'id'=>'r' . $_barcode_list->RowCnt . '__barcode', 'data-rowtype'=>$_barcode->RowType));

		// Render row
		$_barcode_list->renderRow();

		// Render list options
		$_barcode_list->renderListOptions();
?>
	<tr<?php echo $_barcode->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_barcode_list->ListOptions->render("body", "left", $_barcode_list->RowCnt);
?>
	<?php if ($_barcode->po->Visible) { // po ?>
		<td data-name="po"<?php echo $_barcode->po->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_po" class="_barcode_po">
<span<?php echo $_barcode->po->viewAttributes() ?>>
<?php echo $_barcode->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week"<?php echo $_barcode->despatch_week->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_despatch_week" class="_barcode_despatch_week">
<span<?php echo $_barcode->despatch_week->viewAttributes() ?>>
<?php echo $_barcode->despatch_week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $_barcode->_barcode->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode__barcode" class="_barcode__barcode">
<span<?php echo $_barcode->_barcode->viewAttributes() ?>>
<?php echo $_barcode->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $_barcode->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_buyers_id" class="_barcode_buyers_id">
<span<?php echo $_barcode->buyers_id->viewAttributes() ?>>
<?php echo $_barcode->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref"<?php echo $_barcode->buyer_ref->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_buyer_ref" class="_barcode_buyer_ref">
<span<?php echo $_barcode->buyer_ref->viewAttributes() ?>>
<?php echo $_barcode->buyer_ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->design_size->Visible) { // design_size ?>
		<td data-name="design_size"<?php echo $_barcode->design_size->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_design_size" class="_barcode_design_size">
<span<?php echo $_barcode->design_size->viewAttributes() ?>>
<?php echo $_barcode->design_size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $_barcode->sqm->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_sqm" class="_barcode_sqm">
<span<?php echo $_barcode->sqm->viewAttributes() ?>>
<?php echo $_barcode->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a"<?php echo $_barcode->sqm_a->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_sqm_a" class="_barcode_sqm_a">
<span<?php echo $_barcode->sqm_a->viewAttributes() ?>>
<?php echo $_barcode->sqm_a->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->status->Visible) { // status ?>
		<td data-name="status"<?php echo $_barcode->status->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_status" class="_barcode_status">
<span<?php echo $_barcode->status->viewAttributes() ?>>
<?php echo $_barcode->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no"<?php echo $_barcode->jc_no->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_jc_no" class="_barcode_jc_no">
<span<?php echo $_barcode->jc_no->viewAttributes() ?>>
<?php echo $_barcode->jc_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->cs->Visible) { // cs ?>
		<td data-name="cs"<?php echo $_barcode->cs->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_cs" class="_barcode_cs">
<span<?php echo $_barcode->cs->viewAttributes() ?>>
<?php echo $_barcode->cs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works"<?php echo $_barcode->weaving_works->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_weaving_works" class="_barcode_weaving_works">
<span<?php echo $_barcode->weaving_works->viewAttributes() ?>>
<?php echo $_barcode->weaving_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->current_works->Visible) { // current_works ?>
		<td data-name="current_works"<?php echo $_barcode->current_works->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_current_works" class="_barcode_current_works">
<span<?php echo $_barcode->current_works->viewAttributes() ?>>
<?php echo $_barcode->current_works->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->process_c->Visible) { // process_c ?>
		<td data-name="process_c"<?php echo $_barcode->process_c->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_process_c" class="_barcode_process_c">
<span<?php echo $_barcode->process_c->viewAttributes() ?>>
<?php echo $_barcode->process_c->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->process_d->Visible) { // process_d ?>
		<td data-name="process_d"<?php echo $_barcode->process_d->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_process_d" class="_barcode_process_d">
<span<?php echo $_barcode->process_d->viewAttributes() ?>>
<?php echo $_barcode->process_d->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $_barcode->remarks->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_remarks" class="_barcode_remarks">
<span<?php echo $_barcode->remarks->viewAttributes() ?>>
<?php echo $_barcode->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->p_remarks->Visible) { // p_remarks ?>
		<td data-name="p_remarks"<?php echo $_barcode->p_remarks->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_p_remarks" class="_barcode_p_remarks">
<span<?php echo $_barcode->p_remarks->viewAttributes() ?>>
<?php echo $_barcode->p_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no"<?php echo $_barcode->batch_no->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_batch_no" class="_barcode_batch_no">
<span<?php echo $_barcode->batch_no->viewAttributes() ?>>
<?php echo $_barcode->batch_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po"<?php echo $_barcode->buyer_po->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_buyer_po" class="_barcode_buyer_po">
<span<?php echo $_barcode->buyer_po->viewAttributes() ?>>
<?php echo $_barcode->buyer_po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->buyer_uid_loc->Visible) { // buyer_uid_loc ?>
		<td data-name="buyer_uid_loc"<?php echo $_barcode->buyer_uid_loc->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_buyer_uid_loc" class="_barcode_buyer_uid_loc">
<span<?php echo $_barcode->buyer_uid_loc->viewAttributes() ?>>
<?php echo $_barcode->buyer_uid_loc->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->order_date->Visible) { // order_date ?>
		<td data-name="order_date"<?php echo $_barcode->order_date->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_order_date" class="_barcode_order_date">
<span<?php echo $_barcode->order_date->viewAttributes() ?>>
<?php echo $_barcode->order_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->completed->Visible) { // completed ?>
		<td data-name="completed"<?php echo $_barcode->completed->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_completed" class="_barcode_completed">
<span<?php echo $_barcode->completed->viewAttributes() ?>>
<?php echo $_barcode->completed->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->category->Visible) { // category ?>
		<td data-name="category"<?php echo $_barcode->category->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_category" class="_barcode_category">
<span<?php echo $_barcode->category->viewAttributes() ?>>
<?php echo $_barcode->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no"<?php echo $_barcode->pl_no->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_pl_no" class="_barcode_pl_no">
<span<?php echo $_barcode->pl_no->viewAttributes() ?>>
<?php echo $_barcode->pl_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_barcode->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode"<?php echo $_barcode->buyer_barcode->cellAttributes() ?>>
<span id="el<?php echo $_barcode_list->RowCnt ?>__barcode_buyer_barcode" class="_barcode_buyer_barcode">
<span<?php echo $_barcode->buyer_barcode->viewAttributes() ?>>
<?php echo $_barcode->buyer_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_barcode_list->ListOptions->render("body", "right", $_barcode_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_barcode->isGridAdd())
		$_barcode_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$_barcode->RowType = ROWTYPE_AGGREGATE;
$_barcode->resetAttributes();
$_barcode_list->renderRow();
?>
<?php if ($_barcode_list->TotalRecs > 0 && !$_barcode->isGridAdd() && !$_barcode->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$_barcode_list->renderListOptions();

// Render list options (footer, left)
$_barcode_list->ListOptions->render("footer", "left");
?>
	<?php if ($_barcode->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $_barcode->po->footerCellClass() ?>"><span id="elf__barcode_po" class="_barcode_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->despatch_week->Visible) { // despatch_week ?>
		<td data-name="despatch_week" class="<?php echo $_barcode->despatch_week->footerCellClass() ?>"><span id="elf__barcode_despatch_week" class="_barcode_despatch_week">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $_barcode->_barcode->footerCellClass() ?>"><span id="elf__barcode__barcode" class="_barcode__barcode">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $_barcode->buyers_id->footerCellClass() ?>"><span id="elf__barcode_buyers_id" class="_barcode_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->buyer_ref->Visible) { // buyer_ref ?>
		<td data-name="buyer_ref" class="<?php echo $_barcode->buyer_ref->footerCellClass() ?>"><span id="elf__barcode_buyer_ref" class="_barcode_buyer_ref">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->design_size->Visible) { // design_size ?>
		<td data-name="design_size" class="<?php echo $_barcode->design_size->footerCellClass() ?>"><span id="elf__barcode_design_size" class="_barcode_design_size">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->sqm->Visible) { // sqm ?>
		<td data-name="sqm" class="<?php echo $_barcode->sqm->footerCellClass() ?>"><span id="elf__barcode_sqm" class="_barcode_sqm">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $_barcode->sqm->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($_barcode->sqm_a->Visible) { // sqm_a ?>
		<td data-name="sqm_a" class="<?php echo $_barcode->sqm_a->footerCellClass() ?>"><span id="elf__barcode_sqm_a" class="_barcode_sqm_a">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $_barcode->status->footerCellClass() ?>"><span id="elf__barcode_status" class="_barcode_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->jc_no->Visible) { // jc_no ?>
		<td data-name="jc_no" class="<?php echo $_barcode->jc_no->footerCellClass() ?>"><span id="elf__barcode_jc_no" class="_barcode_jc_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->cs->Visible) { // cs ?>
		<td data-name="cs" class="<?php echo $_barcode->cs->footerCellClass() ?>"><span id="elf__barcode_cs" class="_barcode_cs">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->weaving_works->Visible) { // weaving_works ?>
		<td data-name="weaving_works" class="<?php echo $_barcode->weaving_works->footerCellClass() ?>"><span id="elf__barcode_weaving_works" class="_barcode_weaving_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->current_works->Visible) { // current_works ?>
		<td data-name="current_works" class="<?php echo $_barcode->current_works->footerCellClass() ?>"><span id="elf__barcode_current_works" class="_barcode_current_works">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->process_c->Visible) { // process_c ?>
		<td data-name="process_c" class="<?php echo $_barcode->process_c->footerCellClass() ?>"><span id="elf__barcode_process_c" class="_barcode_process_c">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->process_d->Visible) { // process_d ?>
		<td data-name="process_d" class="<?php echo $_barcode->process_d->footerCellClass() ?>"><span id="elf__barcode_process_d" class="_barcode_process_d">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->remarks->Visible) { // remarks ?>
		<td data-name="remarks" class="<?php echo $_barcode->remarks->footerCellClass() ?>"><span id="elf__barcode_remarks" class="_barcode_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->p_remarks->Visible) { // p_remarks ?>
		<td data-name="p_remarks" class="<?php echo $_barcode->p_remarks->footerCellClass() ?>"><span id="elf__barcode_p_remarks" class="_barcode_p_remarks">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->batch_no->Visible) { // batch_no ?>
		<td data-name="batch_no" class="<?php echo $_barcode->batch_no->footerCellClass() ?>"><span id="elf__barcode_batch_no" class="_barcode_batch_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->buyer_po->Visible) { // buyer_po ?>
		<td data-name="buyer_po" class="<?php echo $_barcode->buyer_po->footerCellClass() ?>"><span id="elf__barcode_buyer_po" class="_barcode_buyer_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->buyer_uid_loc->Visible) { // buyer_uid_loc ?>
		<td data-name="buyer_uid_loc" class="<?php echo $_barcode->buyer_uid_loc->footerCellClass() ?>"><span id="elf__barcode_buyer_uid_loc" class="_barcode_buyer_uid_loc">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->order_date->Visible) { // order_date ?>
		<td data-name="order_date" class="<?php echo $_barcode->order_date->footerCellClass() ?>"><span id="elf__barcode_order_date" class="_barcode_order_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->completed->Visible) { // completed ?>
		<td data-name="completed" class="<?php echo $_barcode->completed->footerCellClass() ?>"><span id="elf__barcode_completed" class="_barcode_completed">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->category->Visible) { // category ?>
		<td data-name="category" class="<?php echo $_barcode->category->footerCellClass() ?>"><span id="elf__barcode_category" class="_barcode_category">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->pl_no->Visible) { // pl_no ?>
		<td data-name="pl_no" class="<?php echo $_barcode->pl_no->footerCellClass() ?>"><span id="elf__barcode_pl_no" class="_barcode_pl_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($_barcode->buyer_barcode->Visible) { // buyer_barcode ?>
		<td data-name="buyer_barcode" class="<?php echo $_barcode->buyer_barcode->footerCellClass() ?>"><span id="elf__barcode_buyer_barcode" class="_barcode_buyer_barcode">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$_barcode_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_barcode->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_barcode_list->Recordset)
	$_barcode_list->Recordset->Close();
?>
<?php if (!$_barcode->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_barcode->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_barcode_list->Pager)) $_barcode_list->Pager = new PrevNextPager($_barcode_list->StartRec, $_barcode_list->DisplayRecs, $_barcode_list->TotalRecs, $_barcode_list->AutoHidePager) ?>
<?php if ($_barcode_list->Pager->RecordCount > 0 && $_barcode_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_barcode_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_barcode_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_barcode_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_barcode_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_barcode_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_barcode_list->pageUrl() ?>start=<?php echo $_barcode_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_barcode_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_barcode_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_barcode_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_barcode_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_barcode_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_barcode_list->TotalRecs > 0 && (!$_barcode_list->AutoHidePageSizeSelector || $_barcode_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_barcode">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_barcode_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_barcode_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_barcode_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_barcode_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_barcode_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_barcode->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_barcode_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_barcode_list->TotalRecs == 0 && !$_barcode->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_barcode_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_barcode_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_barcode->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_barcode->isExport()) { ?>
<script>
ew.scrollableTable("gmp__barcode", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_barcode_list->terminate();
?>