<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_barcode_search = new _barcode_search();

// Run the page
$_barcode_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_barcode_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($_barcode_search->IsModal) { ?>
var f_barcodesearch = currentAdvancedSearchForm = new ew.Form("f_barcodesearch", "search");
<?php } else { ?>
var f_barcodesearch = currentForm = new ew.Form("f_barcodesearch", "search");
<?php } ?>

// Form_CustomValidate event
f_barcodesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_barcodesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_barcodesearch.lists["x_despatch_week"] = <?php echo $_barcode_search->despatch_week->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_despatch_week"].options = <?php echo JsonEncode($_barcode_search->despatch_week->lookupOptions()) ?>;
f_barcodesearch.lists["x__barcode"] = <?php echo $_barcode_search->_barcode->Lookup->toClientList() ?>;
f_barcodesearch.lists["x__barcode"].options = <?php echo JsonEncode($_barcode_search->_barcode->lookupOptions()) ?>;
f_barcodesearch.lists["x_buyers_id"] = <?php echo $_barcode_search->buyers_id->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_buyers_id"].options = <?php echo JsonEncode($_barcode_search->buyers_id->lookupOptions()) ?>;
f_barcodesearch.autoSuggests["x_buyers_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_barcodesearch.lists["x_buyer_ref"] = <?php echo $_barcode_search->buyer_ref->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_buyer_ref"].options = <?php echo JsonEncode($_barcode_search->buyer_ref->lookupOptions()) ?>;
f_barcodesearch.autoSuggests["x_buyer_ref"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_barcodesearch.lists["x_status"] = <?php echo $_barcode_search->status->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_status"].options = <?php echo JsonEncode($_barcode_search->status->lookupOptions()) ?>;
f_barcodesearch.lists["x_cs"] = <?php echo $_barcode_search->cs->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_cs"].options = <?php echo JsonEncode($_barcode_search->cs->options(FALSE, TRUE)) ?>;
f_barcodesearch.lists["x_weaving_works"] = <?php echo $_barcode_search->weaving_works->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_weaving_works"].options = <?php echo JsonEncode($_barcode_search->weaving_works->lookupOptions()) ?>;
f_barcodesearch.lists["x_current_works"] = <?php echo $_barcode_search->current_works->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_current_works"].options = <?php echo JsonEncode($_barcode_search->current_works->lookupOptions()) ?>;
f_barcodesearch.lists["x_process_c[]"] = <?php echo $_barcode_search->process_c->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_process_c[]"].options = <?php echo JsonEncode($_barcode_search->process_c->lookupOptions()) ?>;
f_barcodesearch.lists["x_process_d[]"] = <?php echo $_barcode_search->process_d->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_process_d[]"].options = <?php echo JsonEncode($_barcode_search->process_d->lookupOptions()) ?>;
f_barcodesearch.lists["x_batch_no"] = <?php echo $_barcode_search->batch_no->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_batch_no"].options = <?php echo JsonEncode($_barcode_search->batch_no->lookupOptions()) ?>;
f_barcodesearch.lists["x_completed"] = <?php echo $_barcode_search->completed->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_completed"].options = <?php echo JsonEncode($_barcode_search->completed->options(FALSE, TRUE)) ?>;
f_barcodesearch.lists["x_category"] = <?php echo $_barcode_search->category->Lookup->toClientList() ?>;
f_barcodesearch.lists["x_category"].options = <?php echo JsonEncode($_barcode_search->category->lookupOptions()) ?>;

// Form object for search
// Validate function for search

f_barcodesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_po");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->po->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_design_size");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->design_size->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_sqm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->sqm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_jc_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->jc_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->order_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->pid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pl_no");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_barcode->pl_no->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $_barcode_search->showPageHeader(); ?>
<?php
$_barcode_search->showMessage();
?>
<form name="f_barcodesearch" id="f_barcodesearch" class="<?php echo $_barcode_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_barcode_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_barcode_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_barcode">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$_barcode_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($_barcode->po->Visible) { // po ?>
	<div id="r_po" class="form-group row">
		<label for="x_po" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_po"><?php echo $_barcode->po->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->po->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_po" id="z_po" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->po->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode_po">
<input type="text" data-table="_barcode" data-field="x_po" name="x_po" id="x_po" size="30" placeholder="<?php echo HtmlEncode($_barcode->po->getPlaceHolder()) ?>" value="<?php echo $_barcode->po->EditValue ?>"<?php echo $_barcode->po->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_po d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode_po" class="btw1_po d-none">
<input type="text" data-table="_barcode" data-field="x_po" name="y_po" id="y_po" size="30" placeholder="<?php echo HtmlEncode($_barcode->po->getPlaceHolder()) ?>" value="<?php echo $_barcode->po->EditValue2 ?>"<?php echo $_barcode->po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->despatch_week->Visible) { // despatch_week ?>
	<div id="r_despatch_week" class="form-group row">
		<label for="x_despatch_week" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_despatch_week"><?php echo $_barcode->despatch_week->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->despatch_week->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_despatch_week" id="z_despatch_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->despatch_week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode_despatch_week">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_despatch_week" data-value-separator="<?php echo $_barcode->despatch_week->displayValueSeparatorAttribute() ?>" id="x_despatch_week" name="x_despatch_week"<?php echo $_barcode->despatch_week->editAttributes() ?>>
		<?php echo $_barcode->despatch_week->selectOptionListHtml("x_despatch_week") ?>
	</select>
</div>
<?php echo $_barcode->despatch_week->Lookup->getParamTag("p_x_despatch_week") ?>
</span>
			<span class="ew-search-cond btw1_despatch_week d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode_despatch_week" class="btw1_despatch_week d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_despatch_week" data-value-separator="<?php echo $_barcode->despatch_week->displayValueSeparatorAttribute() ?>" id="y_despatch_week" name="y_despatch_week"<?php echo $_barcode->despatch_week->editAttributes() ?>>
		<?php echo $_barcode->despatch_week->selectOptionListHtml("y_despatch_week") ?>
	</select>
</div>
<?php echo $_barcode->despatch_week->Lookup->getParamTag("p_y_despatch_week") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label for="x__barcode" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode__barcode"><?php echo $_barcode->_barcode->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->_barcode->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="BETWEEN"<?php echo ($_barcode->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode__barcode">
<input type="text" data-table="_barcode" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($_barcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $_barcode->_barcode->EditValue ?>"<?php echo $_barcode->_barcode->editAttributes() ?>>
<?php echo $_barcode->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
			<span class="ew-search-cond btw1__barcode d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode__barcode" class="btw1__barcode d-none">
<input type="text" data-table="_barcode" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($_barcode->_barcode->getPlaceHolder()) ?>" value="<?php echo $_barcode->_barcode->EditValue2 ?>"<?php echo $_barcode->_barcode->editAttributes() ?>>
<?php echo $_barcode->_barcode->Lookup->getParamTag("p_y__barcode") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->buyers_id->Visible) { // buyers_id ?>
	<div id="r_buyers_id" class="form-group row">
		<label class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_buyers_id"><?php echo $_barcode->buyers_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyers_id" id="z_buyers_id" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->buyers_id->cellAttributes() ?>>
			<span id="el__barcode_buyers_id">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$_barcode->buyers_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_barcode->buyers_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyers_id" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyers_id" id="sv_x_buyers_id" value="<?php echo RemoveHtml($_barcode->buyers_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_barcode->buyers_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_barcode->buyers_id->getPlaceHolder()) ?>"<?php echo $_barcode->buyers_id->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->buyers_id->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyers_id',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->buyers_id->ReadOnly || $_barcode->buyers_id->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_barcode" data-field="x_buyers_id" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_barcode->buyers_id->displayValueSeparatorAttribute() ?>" name="x_buyers_id" id="x_buyers_id" value="<?php echo HtmlEncode($_barcode->buyers_id->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_barcodesearch.createAutoSuggest({"id":"x_buyers_id","forceSelect":false});
</script>
<?php echo $_barcode->buyers_id->Lookup->getParamTag("p_x_buyers_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->buyer_ref->Visible) { // buyer_ref ?>
	<div id="r_buyer_ref" class="form-group row">
		<label class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_buyer_ref"><?php echo $_barcode->buyer_ref->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->buyer_ref->cellAttributes() ?>>
			<span id="el__barcode_buyer_ref">
<?php
$wrkonchange = "" . trim(@$_barcode->buyer_ref->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_barcode->buyer_ref->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer_ref" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_buyer_ref" id="sv_x_buyer_ref" value="<?php echo RemoveHtml($_barcode->buyer_ref->EditValue) ?>" placeholder="<?php echo HtmlEncode($_barcode->buyer_ref->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_barcode->buyer_ref->getPlaceHolder()) ?>"<?php echo $_barcode->buyer_ref->editAttributes() ?>>
</span>
<input type="hidden" data-table="_barcode" data-field="x_buyer_ref" data-value-separator="<?php echo $_barcode->buyer_ref->displayValueSeparatorAttribute() ?>" name="x_buyer_ref" id="x_buyer_ref" value="<?php echo HtmlEncode($_barcode->buyer_ref->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_barcodesearch.createAutoSuggest({"id":"x_buyer_ref","forceSelect":false});
</script>
<?php echo $_barcode->buyer_ref->Lookup->getParamTag("p_x_buyer_ref") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->design_size->Visible) { // design_size ?>
	<div id="r_design_size" class="form-group row">
		<label for="x_design_size" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_design_size"><?php echo $_barcode->design_size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design_size" id="z_design_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->design_size->cellAttributes() ?>>
			<span id="el__barcode_design_size">
<input type="text" data-table="_barcode" data-field="x_design_size" name="x_design_size" id="x_design_size" size="30" placeholder="<?php echo HtmlEncode($_barcode->design_size->getPlaceHolder()) ?>" value="<?php echo $_barcode->design_size->EditValue ?>"<?php echo $_barcode->design_size->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->sqm->Visible) { // sqm ?>
	<div id="r_sqm" class="form-group row">
		<label for="x_sqm" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_sqm"><?php echo $_barcode->sqm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sqm" id="z_sqm" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->sqm->cellAttributes() ?>>
			<span id="el__barcode_sqm">
<input type="text" data-table="_barcode" data-field="x_sqm" name="x_sqm" id="x_sqm" size="30" placeholder="<?php echo HtmlEncode($_barcode->sqm->getPlaceHolder()) ?>" value="<?php echo $_barcode->sqm->EditValue ?>"<?php echo $_barcode->sqm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_status"><?php echo $_barcode->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->status->cellAttributes() ?>>
			<span id="el__barcode_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_status" data-value-separator="<?php echo $_barcode->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $_barcode->status->editAttributes() ?>>
		<?php echo $_barcode->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $_barcode->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->jc_no->Visible) { // jc_no ?>
	<div id="r_jc_no" class="form-group row">
		<label for="x_jc_no" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_jc_no"><?php echo $_barcode->jc_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_jc_no" id="z_jc_no" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->jc_no->cellAttributes() ?>>
			<span id="el__barcode_jc_no">
<input type="text" data-table="_barcode" data-field="x_jc_no" name="x_jc_no" id="x_jc_no" size="30" placeholder="<?php echo HtmlEncode($_barcode->jc_no->getPlaceHolder()) ?>" value="<?php echo $_barcode->jc_no->EditValue ?>"<?php echo $_barcode->jc_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->cs->Visible) { // cs ?>
	<div id="r_cs" class="form-group row">
		<label for="x_cs" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_cs"><?php echo $_barcode->cs->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cs" id="z_cs" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->cs->cellAttributes() ?>>
			<span id="el__barcode_cs">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_cs" data-value-separator="<?php echo $_barcode->cs->displayValueSeparatorAttribute() ?>" id="x_cs" name="x_cs"<?php echo $_barcode->cs->editAttributes() ?>>
		<?php echo $_barcode->cs->selectOptionListHtml("x_cs") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->weaving_works->Visible) { // weaving_works ?>
	<div id="r_weaving_works" class="form-group row">
		<label for="x_weaving_works" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_weaving_works"><?php echo $_barcode->weaving_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weaving_works" id="z_weaving_works" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->weaving_works->cellAttributes() ?>>
			<span id="el__barcode_weaving_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_weaving_works" data-value-separator="<?php echo $_barcode->weaving_works->displayValueSeparatorAttribute() ?>" id="x_weaving_works" name="x_weaving_works"<?php echo $_barcode->weaving_works->editAttributes() ?>>
		<?php echo $_barcode->weaving_works->selectOptionListHtml("x_weaving_works") ?>
	</select>
</div>
<?php echo $_barcode->weaving_works->Lookup->getParamTag("p_x_weaving_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->current_works->Visible) { // current_works ?>
	<div id="r_current_works" class="form-group row">
		<label for="x_current_works" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_current_works"><?php echo $_barcode->current_works->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_works" id="z_current_works" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->current_works->cellAttributes() ?>>
			<span id="el__barcode_current_works">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_current_works" data-value-separator="<?php echo $_barcode->current_works->displayValueSeparatorAttribute() ?>" id="x_current_works" name="x_current_works"<?php echo $_barcode->current_works->editAttributes() ?>>
		<?php echo $_barcode->current_works->selectOptionListHtml("x_current_works") ?>
	</select>
</div>
<?php echo $_barcode->current_works->Lookup->getParamTag("p_x_current_works") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->process_c->Visible) { // process_c ?>
	<div id="r_process_c" class="form-group row">
		<label for="x_process_c" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_process_c"><?php echo $_barcode->process_c->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->process_c->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_process_c" id="z_process_c" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->process_c->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode_process_c">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_process_c"><?php echo strval($_barcode->process_c->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_c->AdvancedSearch->ViewValue) : $_barcode->process_c->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_c->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_c->ReadOnly || $_barcode->process_c->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_process_c[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_c->Lookup->getParamTag("p_x_process_c") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_c" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_c->displayValueSeparatorAttribute() ?>" name="x_process_c[]" id="x_process_c[]" value="<?php echo $_barcode->process_c->AdvancedSearch->SearchValue ?>"<?php echo $_barcode->process_c->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_process_c d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode_process_c" class="btw1_process_c d-none">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_process_c"><?php echo strval($_barcode->process_c->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_c->AdvancedSearch->ViewValue2) : $_barcode->process_c->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_c->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_c->ReadOnly || $_barcode->process_c->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_process_c[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_c->Lookup->getParamTag("p_y_process_c") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_c" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_c->displayValueSeparatorAttribute() ?>" name="y_process_c[]" id="y_process_c[]" value="<?php echo $_barcode->process_c->AdvancedSearch->SearchValue2 ?>"<?php echo $_barcode->process_c->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->process_d->Visible) { // process_d ?>
	<div id="r_process_d" class="form-group row">
		<label for="x_process_d" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_process_d"><?php echo $_barcode->process_d->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->process_d->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_process_d" id="z_process_d" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->process_d->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode_process_d">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_process_d"><?php echo strval($_barcode->process_d->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_d->AdvancedSearch->ViewValue) : $_barcode->process_d->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_d->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_d->ReadOnly || $_barcode->process_d->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_process_d[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_d->Lookup->getParamTag("p_x_process_d") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_d" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_d->displayValueSeparatorAttribute() ?>" name="x_process_d[]" id="x_process_d[]" value="<?php echo $_barcode->process_d->AdvancedSearch->SearchValue ?>"<?php echo $_barcode->process_d->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_process_d d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode_process_d" class="btw1_process_d d-none">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_y_process_d"><?php echo strval($_barcode->process_d->AdvancedSearch->ViewValue2) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($_barcode->process_d->AdvancedSearch->ViewValue2) : $_barcode->process_d->AdvancedSearch->ViewValue2) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_barcode->process_d->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($_barcode->process_d->ReadOnly || $_barcode->process_d->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'y_process_d[]',m:1,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $_barcode->process_d->Lookup->getParamTag("p_y_process_d") ?>
<input type="hidden" data-table="_barcode" data-field="x_process_d" data-multiple="1" data-lookup="1" data-value-separator="<?php echo $_barcode->process_d->displayValueSeparatorAttribute() ?>" name="y_process_d[]" id="y_process_d[]" value="<?php echo $_barcode->process_d->AdvancedSearch->SearchValue2 ?>"<?php echo $_barcode->process_d->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_remarks"><?php echo $_barcode->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->remarks->cellAttributes() ?>>
			<span id="el__barcode_remarks">
<input type="text" data-table="_barcode" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($_barcode->remarks->getPlaceHolder()) ?>" value="<?php echo $_barcode->remarks->EditValue ?>"<?php echo $_barcode->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->p_remarks->Visible) { // p_remarks ?>
	<div id="r_p_remarks" class="form-group row">
		<label for="x_p_remarks" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_p_remarks"><?php echo $_barcode->p_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_p_remarks" id="z_p_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->p_remarks->cellAttributes() ?>>
			<span id="el__barcode_p_remarks">
<input type="text" data-table="_barcode" data-field="x_p_remarks" name="x_p_remarks" id="x_p_remarks" size="35" placeholder="<?php echo HtmlEncode($_barcode->p_remarks->getPlaceHolder()) ?>" value="<?php echo $_barcode->p_remarks->EditValue ?>"<?php echo $_barcode->p_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->batch_no->Visible) { // batch_no ?>
	<div id="r_batch_no" class="form-group row">
		<label for="x_batch_no" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_batch_no"><?php echo $_barcode->batch_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_batch_no" id="z_batch_no" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->batch_no->cellAttributes() ?>>
			<span id="el__barcode_batch_no">
<input type="text" data-table="_barcode" data-field="x_batch_no" name="x_batch_no" id="x_batch_no" size="30" placeholder="<?php echo HtmlEncode($_barcode->batch_no->getPlaceHolder()) ?>" value="<?php echo $_barcode->batch_no->EditValue ?>"<?php echo $_barcode->batch_no->editAttributes() ?>>
<?php echo $_barcode->batch_no->Lookup->getParamTag("p_x_batch_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->weight->Visible) { // weight ?>
	<div id="r_weight" class="form-group row">
		<label for="x_weight" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_weight"><?php echo $_barcode->weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_weight" id="z_weight" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->weight->cellAttributes() ?>>
			<span id="el__barcode_weight">
<input type="text" data-table="_barcode" data-field="x_weight" name="x_weight" id="x_weight" size="30" placeholder="<?php echo HtmlEncode($_barcode->weight->getPlaceHolder()) ?>" value="<?php echo $_barcode->weight->EditValue ?>"<?php echo $_barcode->weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->buyer_po->Visible) { // buyer_po ?>
	<div id="r_buyer_po" class="form-group row">
		<label for="x_buyer_po" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_buyer_po"><?php echo $_barcode->buyer_po->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_po" id="z_buyer_po" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->buyer_po->cellAttributes() ?>>
			<span id="el__barcode_buyer_po">
<input type="text" data-table="_barcode" data-field="x_buyer_po" name="x_buyer_po" id="x_buyer_po" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_barcode->buyer_po->getPlaceHolder()) ?>" value="<?php echo $_barcode->buyer_po->EditValue ?>"<?php echo $_barcode->buyer_po->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->buyer_uid_loc->Visible) { // buyer_uid_loc ?>
	<div id="r_buyer_uid_loc" class="form-group row">
		<label for="x_buyer_uid_loc" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_buyer_uid_loc"><?php echo $_barcode->buyer_uid_loc->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_uid_loc" id="z_buyer_uid_loc" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->buyer_uid_loc->cellAttributes() ?>>
			<span id="el__barcode_buyer_uid_loc">
<input type="text" data-table="_barcode" data-field="x_buyer_uid_loc" name="x_buyer_uid_loc" id="x_buyer_uid_loc" size="30" maxlength="73" placeholder="<?php echo HtmlEncode($_barcode->buyer_uid_loc->getPlaceHolder()) ?>" value="<?php echo $_barcode->buyer_uid_loc->EditValue ?>"<?php echo $_barcode->buyer_uid_loc->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->order_date->Visible) { // order_date ?>
	<div id="r_order_date" class="form-group row">
		<label for="x_order_date" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_order_date"><?php echo $_barcode->order_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_date" id="z_order_date" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->order_date->cellAttributes() ?>>
			<span id="el__barcode_order_date">
<input type="text" data-table="_barcode" data-field="x_order_date" name="x_order_date" id="x_order_date" placeholder="<?php echo HtmlEncode($_barcode->order_date->getPlaceHolder()) ?>" value="<?php echo $_barcode->order_date->EditValue ?>"<?php echo $_barcode->order_date->editAttributes() ?>>
<?php if (!$_barcode->order_date->ReadOnly && !$_barcode->order_date->Disabled && !isset($_barcode->order_date->EditAttrs["readonly"]) && !isset($_barcode->order_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("f_barcodesearch", "x_order_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->completed->Visible) { // completed ?>
	<div id="r_completed" class="form-group row">
		<label for="x_completed" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_completed"><?php echo $_barcode->completed->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_completed" id="z_completed" value="="></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->completed->cellAttributes() ?>>
			<span id="el__barcode_completed">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_completed" data-value-separator="<?php echo $_barcode->completed->displayValueSeparatorAttribute() ?>" id="x_completed" name="x_completed"<?php echo $_barcode->completed->editAttributes() ?>>
		<?php echo $_barcode->completed->selectOptionListHtml("x_completed") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->pid->Visible) { // pid ?>
	<div id="r_pid" class="form-group row">
		<label for="x_pid" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_pid"><?php echo $_barcode->pid->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->pid->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pid" id="z_pid" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($_barcode->pid->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode_pid">
<input type="text" data-table="_barcode" data-field="x_pid" name="x_pid" id="x_pid" size="30" placeholder="<?php echo HtmlEncode($_barcode->pid->getPlaceHolder()) ?>" value="<?php echo $_barcode->pid->EditValue ?>"<?php echo $_barcode->pid->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pid d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode_pid" class="btw1_pid d-none">
<input type="text" data-table="_barcode" data-field="x_pid" name="y_pid" id="y_pid" size="30" placeholder="<?php echo HtmlEncode($_barcode->pid->getPlaceHolder()) ?>" value="<?php echo $_barcode->pid->EditValue2 ?>"<?php echo $_barcode->pid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label for="x_category" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_category"><?php echo $_barcode->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_category" id="z_category" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->category->cellAttributes() ?>>
			<span id="el__barcode_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_barcode" data-field="x_category" data-value-separator="<?php echo $_barcode->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $_barcode->category->editAttributes() ?>>
		<?php echo $_barcode->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $_barcode->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->pl_no->Visible) { // pl_no ?>
	<div id="r_pl_no" class="form-group row">
		<label for="x_pl_no" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_pl_no"><?php echo $_barcode->pl_no->caption() ?></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->pl_no->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_pl_no" id="z_pl_no" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($_barcode->pl_no->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el__barcode_pl_no">
<input type="text" data-table="_barcode" data-field="x_pl_no" name="x_pl_no" id="x_pl_no" size="30" placeholder="<?php echo HtmlEncode($_barcode->pl_no->getPlaceHolder()) ?>" value="<?php echo $_barcode->pl_no->EditValue ?>"<?php echo $_barcode->pl_no->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_pl_no d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2__barcode_pl_no" class="btw1_pl_no d-none">
<input type="text" data-table="_barcode" data-field="x_pl_no" name="y_pl_no" id="y_pl_no" size="30" placeholder="<?php echo HtmlEncode($_barcode->pl_no->getPlaceHolder()) ?>" value="<?php echo $_barcode->pl_no->EditValue2 ?>"<?php echo $_barcode->pl_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_barcode->buyer_barcode->Visible) { // buyer_barcode ?>
	<div id="r_buyer_barcode" class="form-group row">
		<label for="x_buyer_barcode" class="<?php echo $_barcode_search->LeftColumnClass ?>"><span id="elh__barcode_buyer_barcode"><?php echo $_barcode->buyer_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_buyer_barcode" id="z_buyer_barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $_barcode_search->RightColumnClass ?>"><div<?php echo $_barcode->buyer_barcode->cellAttributes() ?>>
			<span id="el__barcode_buyer_barcode">
<input type="text" data-table="_barcode" data-field="x_buyer_barcode" name="x_buyer_barcode" id="x_buyer_barcode" size="30" maxlength="200" placeholder="<?php echo HtmlEncode($_barcode->buyer_barcode->getPlaceHolder()) ?>" value="<?php echo $_barcode->buyer_barcode->EditValue ?>"<?php echo $_barcode->buyer_barcode->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$_barcode_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $_barcode_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$_barcode_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$_barcode_search->terminate();
?>