<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_l_examination_report_edit = new _l_examination_report_edit();

// Run the page
$_l_examination_report_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_l_examination_report_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var f_l_examination_reportedit = currentForm = new ew.Form("f_l_examination_reportedit", "edit");

// Validate form
f_l_examination_reportedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($_l_examination_report_edit->d_id->Required) { ?>
			elm = this.getElements("x" + infix + "_d_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->d_id->caption(), $_l_examination_report->d_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->mobile->caption(), $_l_examination_report->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->name->caption(), $_l_examination_report->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->examination_code->Required) { ?>
			elm = this.getElements("x" + infix + "_examination_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->examination_code->caption(), $_l_examination_report->examination_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->diagnosis_value->Required) { ?>
			elm = this.getElements("x" + infix + "_diagnosis_value");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->diagnosis_value->caption(), $_l_examination_report->diagnosis_value->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->diagnosis_st_min->Required) { ?>
			elm = this.getElements("x" + infix + "_diagnosis_st_min");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->diagnosis_st_min->caption(), $_l_examination_report->diagnosis_st_min->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->diagnosis_st_max->Required) { ?>
			elm = this.getElements("x" + infix + "_diagnosis_st_max");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->diagnosis_st_max->caption(), $_l_examination_report->diagnosis_st_max->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_diagnosis_st_max");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($_l_examination_report->diagnosis_st_max->errorMessage()) ?>");
		<?php if ($_l_examination_report_edit->diagnosis_unit->Required) { ?>
			elm = this.getElements("x" + infix + "_diagnosis_unit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->diagnosis_unit->caption(), $_l_examination_report->diagnosis_unit->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->balance_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_balance_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->balance_amount->caption(), $_l_examination_report->balance_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->age->Required) { ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->age->caption(), $_l_examination_report->age->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_age");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($_l_examination_report->age->errorMessage()) ?>");
		<?php if ($_l_examination_report_edit->sex->Required) { ?>
			elm = this.getElements("x" + infix + "_sex");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->sex->caption(), $_l_examination_report->sex->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->referral->Required) { ?>
			elm = this.getElements("x" + infix + "_referral");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->referral->caption(), $_l_examination_report->referral->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_referral");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($_l_examination_report->referral->errorMessage()) ?>");
		<?php if ($_l_examination_report_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->remarks->caption(), $_l_examination_report->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->examination_grp->Required) { ?>
			elm = this.getElements("x" + infix + "_examination_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->examination_grp->caption(), $_l_examination_report->examination_grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->diagnosis_datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_diagnosis_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->diagnosis_datetime->caption(), $_l_examination_report->diagnosis_datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->import_value->Required) { ?>
			elm = this.getElements("x" + infix + "_import_value");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->import_value->caption(), $_l_examination_report->import_value->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->total_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_total_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->total_amount->caption(), $_l_examination_report->total_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->discount_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_discount_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->discount_amount->caption(), $_l_examination_report->discount_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_discount_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($_l_examination_report->discount_amount->errorMessage()) ?>");
		<?php if ($_l_examination_report_edit->received_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_received_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->received_amount->caption(), $_l_examination_report->received_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->examination_id->Required) { ?>
			elm = this.getElements("x" + infix + "_examination_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->examination_id->caption(), $_l_examination_report->examination_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->examination_name->Required) { ?>
			elm = this.getElements("x" + infix + "_examination_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->examination_name->caption(), $_l_examination_report->examination_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->uid->Required) { ?>
			elm = this.getElements("x" + infix + "_uid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->uid->caption(), $_l_examination_report->uid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->operator->caption(), $_l_examination_report->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_l_examination_report_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_l_examination_report->datetime->caption(), $_l_examination_report->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
f_l_examination_reportedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_l_examination_reportedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_l_examination_reportedit.lists["x_mobile"] = <?php echo $_l_examination_report_edit->mobile->Lookup->toClientList() ?>;
f_l_examination_reportedit.lists["x_mobile"].options = <?php echo JsonEncode($_l_examination_report_edit->mobile->lookupOptions()) ?>;
f_l_examination_reportedit.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportedit.lists["x_name"] = <?php echo $_l_examination_report_edit->name->Lookup->toClientList() ?>;
f_l_examination_reportedit.lists["x_name"].options = <?php echo JsonEncode($_l_examination_report_edit->name->lookupOptions()) ?>;
f_l_examination_reportedit.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportedit.lists["x_sex"] = <?php echo $_l_examination_report_edit->sex->Lookup->toClientList() ?>;
f_l_examination_reportedit.lists["x_sex"].options = <?php echo JsonEncode($_l_examination_report_edit->sex->options(FALSE, TRUE)) ?>;
f_l_examination_reportedit.lists["x_referral"] = <?php echo $_l_examination_report_edit->referral->Lookup->toClientList() ?>;
f_l_examination_reportedit.lists["x_referral"].options = <?php echo JsonEncode($_l_examination_report_edit->referral->lookupOptions()) ?>;
f_l_examination_reportedit.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportedit.lists["x_examination_grp"] = <?php echo $_l_examination_report_edit->examination_grp->Lookup->toClientList() ?>;
f_l_examination_reportedit.lists["x_examination_grp"].options = <?php echo JsonEncode($_l_examination_report_edit->examination_grp->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $_l_examination_report_edit->showPageHeader(); ?>
<?php
$_l_examination_report_edit->showMessage();
?>
<form name="f_l_examination_reportedit" id="f_l_examination_reportedit" class="<?php echo $_l_examination_report_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_l_examination_report_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_l_examination_report_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_l_examination_report">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$_l_examination_report_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($_l_examination_report->d_id->Visible) { // d_id ?>
	<div id="r_d_id" class="form-group row">
		<label id="elh__l_examination_report_d_id" for="x_d_id" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->d_id->caption() ?><?php echo ($_l_examination_report->d_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->d_id->cellAttributes() ?>>
<span id="el__l_examination_report_d_id">
<span<?php echo $_l_examination_report->d_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->d_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_d_id" name="x_d_id" id="x_d_id" value="<?php echo HtmlEncode($_l_examination_report->d_id->CurrentValue) ?>">
<?php echo $_l_examination_report->d_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh__l_examination_report_mobile" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->mobile->caption() ?><?php echo ($_l_examination_report->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->mobile->cellAttributes() ?>>
<span id="el__l_examination_report_mobile">
<span<?php echo $_l_examination_report->mobile->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->mobile->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_mobile" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($_l_examination_report->mobile->CurrentValue) ?>">
<?php echo $_l_examination_report->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh__l_examination_report_name" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->name->caption() ?><?php echo ($_l_examination_report->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->name->cellAttributes() ?>>
<span id="el__l_examination_report_name">
<?php
$wrkonchange = "" . trim(@$_l_examination_report->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_l_examination_report->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($_l_examination_report->name->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_l_examination_report->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_l_examination_report->name->getPlaceHolder()) ?>"<?php echo $_l_examination_report->name->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_l_examination_report->name->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_name',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($_l_examination_report->name->ReadOnly || $_l_examination_report->name->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_name" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_l_examination_report->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($_l_examination_report->name->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_l_examination_reportedit.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $_l_examination_report->name->Lookup->getParamTag("p_x_name") ?>
</span>
<?php echo $_l_examination_report->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_code->Visible) { // examination_code ?>
	<div id="r_examination_code" class="form-group row">
		<label id="elh__l_examination_report_examination_code" for="x_examination_code" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->examination_code->caption() ?><?php echo ($_l_examination_report->examination_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_code->cellAttributes() ?>>
<span id="el__l_examination_report_examination_code">
<span<?php echo $_l_examination_report->examination_code->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->examination_code->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_examination_code" name="x_examination_code" id="x_examination_code" value="<?php echo HtmlEncode($_l_examination_report->examination_code->CurrentValue) ?>">
<?php echo $_l_examination_report->examination_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_value->Visible) { // diagnosis_value ?>
	<div id="r_diagnosis_value" class="form-group row">
		<label id="elh__l_examination_report_diagnosis_value" for="x_diagnosis_value" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->diagnosis_value->caption() ?><?php echo ($_l_examination_report->diagnosis_value->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_value->cellAttributes() ?>>
<span id="el__l_examination_report_diagnosis_value">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_value" name="x_diagnosis_value" id="x_diagnosis_value" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_value->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_value->EditValue ?>"<?php echo $_l_examination_report->diagnosis_value->editAttributes() ?>>
</span>
<?php echo $_l_examination_report->diagnosis_value->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_st_min->Visible) { // diagnosis_st_min ?>
	<div id="r_diagnosis_st_min" class="form-group row">
		<label id="elh__l_examination_report_diagnosis_st_min" for="x_diagnosis_st_min" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->diagnosis_st_min->caption() ?><?php echo ($_l_examination_report->diagnosis_st_min->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_st_min->cellAttributes() ?>>
<span id="el__l_examination_report_diagnosis_st_min">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_st_min" name="x_diagnosis_st_min" id="x_diagnosis_st_min" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_st_min->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_st_min->EditValue ?>"<?php echo $_l_examination_report->diagnosis_st_min->editAttributes() ?>>
</span>
<?php echo $_l_examination_report->diagnosis_st_min->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_st_max->Visible) { // diagnosis_st_max ?>
	<div id="r_diagnosis_st_max" class="form-group row">
		<label id="elh__l_examination_report_diagnosis_st_max" for="x_diagnosis_st_max" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->diagnosis_st_max->caption() ?><?php echo ($_l_examination_report->diagnosis_st_max->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_st_max->cellAttributes() ?>>
<span id="el__l_examination_report_diagnosis_st_max">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_st_max" name="x_diagnosis_st_max" id="x_diagnosis_st_max" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_st_max->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_st_max->EditValue ?>"<?php echo $_l_examination_report->diagnosis_st_max->editAttributes() ?>>
</span>
<?php echo $_l_examination_report->diagnosis_st_max->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_unit->Visible) { // diagnosis_unit ?>
	<div id="r_diagnosis_unit" class="form-group row">
		<label id="elh__l_examination_report_diagnosis_unit" for="x_diagnosis_unit" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->diagnosis_unit->caption() ?><?php echo ($_l_examination_report->diagnosis_unit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_unit->cellAttributes() ?>>
<span id="el__l_examination_report_diagnosis_unit">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_unit" name="x_diagnosis_unit" id="x_diagnosis_unit" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_unit->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_unit->EditValue ?>"<?php echo $_l_examination_report->diagnosis_unit->editAttributes() ?>>
</span>
<?php echo $_l_examination_report->diagnosis_unit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->balance_amount->Visible) { // balance_amount ?>
	<div id="r_balance_amount" class="form-group row">
		<label id="elh__l_examination_report_balance_amount" for="x_balance_amount" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->balance_amount->caption() ?><?php echo ($_l_examination_report->balance_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->balance_amount->cellAttributes() ?>>
<span id="el__l_examination_report_balance_amount">
<span<?php echo $_l_examination_report->balance_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->balance_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_balance_amount" name="x_balance_amount" id="x_balance_amount" value="<?php echo HtmlEncode($_l_examination_report->balance_amount->CurrentValue) ?>">
<?php echo $_l_examination_report->balance_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label id="elh__l_examination_report_age" for="x_age" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->age->caption() ?><?php echo ($_l_examination_report->age->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->age->cellAttributes() ?>>
<span id="el__l_examination_report_age">
<input type="text" data-table="_l_examination_report" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->age->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->age->EditValue ?>"<?php echo $_l_examination_report->age->editAttributes() ?>>
</span>
<?php echo $_l_examination_report->age->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->sex->Visible) { // sex ?>
	<div id="r_sex" class="form-group row">
		<label id="elh__l_examination_report_sex" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->sex->caption() ?><?php echo ($_l_examination_report->sex->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->sex->cellAttributes() ?>>
<span id="el__l_examination_report_sex">
<div id="tp_x_sex" class="ew-template"><input type="radio" class="form-check-input" data-table="_l_examination_report" data-field="x_sex" data-value-separator="<?php echo $_l_examination_report->sex->displayValueSeparatorAttribute() ?>" name="x_sex" id="x_sex" value="{value}"<?php echo $_l_examination_report->sex->editAttributes() ?>></div>
<div id="dsl_x_sex" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $_l_examination_report->sex->radioButtonListHtml(FALSE, "x_sex") ?>
</div></div>
</span>
<?php echo $_l_examination_report->sex->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->referral->Visible) { // referral ?>
	<div id="r_referral" class="form-group row">
		<label id="elh__l_examination_report_referral" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->referral->caption() ?><?php echo ($_l_examination_report->referral->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->referral->cellAttributes() ?>>
<span id="el__l_examination_report_referral">
<?php
$wrkonchange = "" . trim(@$_l_examination_report->referral->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_l_examination_report->referral->EditAttrs["onchange"] = "";
?>
<span id="as_x_referral" class="text-nowrap" style="z-index: 8880">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_referral" id="sv_x_referral" value="<?php echo RemoveHtml($_l_examination_report->referral->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->referral->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_l_examination_report->referral->getPlaceHolder()) ?>"<?php echo $_l_examination_report->referral->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_l_examination_report->referral->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_referral',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($_l_examination_report->referral->ReadOnly || $_l_examination_report->referral->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_referral" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_l_examination_report->referral->displayValueSeparatorAttribute() ?>" name="x_referral" id="x_referral" value="<?php echo HtmlEncode($_l_examination_report->referral->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_l_examination_reportedit.createAutoSuggest({"id":"x_referral","forceSelect":true});
</script>
<?php echo $_l_examination_report->referral->Lookup->getParamTag("p_x_referral") ?>
</span>
<?php echo $_l_examination_report->referral->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh__l_examination_report_remarks" for="x_remarks" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->remarks->caption() ?><?php echo ($_l_examination_report->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->remarks->cellAttributes() ?>>
<span id="el__l_examination_report_remarks">
<span<?php echo $_l_examination_report->remarks->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->remarks->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_remarks" name="x_remarks" id="x_remarks" value="<?php echo HtmlEncode($_l_examination_report->remarks->CurrentValue) ?>">
<?php echo $_l_examination_report->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_grp->Visible) { // examination_grp ?>
	<div id="r_examination_grp" class="form-group row">
		<label id="elh__l_examination_report_examination_grp" for="x_examination_grp" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->examination_grp->caption() ?><?php echo ($_l_examination_report->examination_grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_grp->cellAttributes() ?>>
<span id="el__l_examination_report_examination_grp">
<span<?php echo $_l_examination_report->examination_grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->examination_grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_examination_grp" name="x_examination_grp" id="x_examination_grp" value="<?php echo HtmlEncode($_l_examination_report->examination_grp->CurrentValue) ?>">
<?php echo $_l_examination_report->examination_grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_datetime->Visible) { // diagnosis_datetime ?>
	<div id="r_diagnosis_datetime" class="form-group row">
		<label id="elh__l_examination_report_diagnosis_datetime" for="x_diagnosis_datetime" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->diagnosis_datetime->caption() ?><?php echo ($_l_examination_report->diagnosis_datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_datetime->cellAttributes() ?>>
<span id="el__l_examination_report_diagnosis_datetime">
<span<?php echo $_l_examination_report->diagnosis_datetime->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->diagnosis_datetime->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_diagnosis_datetime" name="x_diagnosis_datetime" id="x_diagnosis_datetime" value="<?php echo HtmlEncode($_l_examination_report->diagnosis_datetime->CurrentValue) ?>">
<?php echo $_l_examination_report->diagnosis_datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->import_value->Visible) { // import_value ?>
	<div id="r_import_value" class="form-group row">
		<label id="elh__l_examination_report_import_value" for="x_import_value" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->import_value->caption() ?><?php echo ($_l_examination_report->import_value->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->import_value->cellAttributes() ?>>
<span id="el__l_examination_report_import_value">
<span<?php echo $_l_examination_report->import_value->viewAttributes() ?>>
<?php echo $_l_examination_report->import_value->EditValue ?></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_import_value" name="x_import_value" id="x_import_value" value="<?php echo HtmlEncode($_l_examination_report->import_value->CurrentValue) ?>">
<?php echo $_l_examination_report->import_value->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label id="elh__l_examination_report_total_amount" for="x_total_amount" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->total_amount->caption() ?><?php echo ($_l_examination_report->total_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->total_amount->cellAttributes() ?>>
<span id="el__l_examination_report_total_amount">
<span<?php echo $_l_examination_report->total_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->total_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" value="<?php echo HtmlEncode($_l_examination_report->total_amount->CurrentValue) ?>">
<?php echo $_l_examination_report->total_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->discount_amount->Visible) { // discount_amount ?>
	<div id="r_discount_amount" class="form-group row">
		<label id="elh__l_examination_report_discount_amount" for="x_discount_amount" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->discount_amount->caption() ?><?php echo ($_l_examination_report->discount_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->discount_amount->cellAttributes() ?>>
<span id="el__l_examination_report_discount_amount">
<input type="text" data-table="_l_examination_report" data-field="x_discount_amount" name="x_discount_amount" id="x_discount_amount" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->discount_amount->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->discount_amount->EditValue ?>"<?php echo $_l_examination_report->discount_amount->editAttributes() ?>>
</span>
<?php echo $_l_examination_report->discount_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->received_amount->Visible) { // received_amount ?>
	<div id="r_received_amount" class="form-group row">
		<label id="elh__l_examination_report_received_amount" for="x_received_amount" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->received_amount->caption() ?><?php echo ($_l_examination_report->received_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->received_amount->cellAttributes() ?>>
<span id="el__l_examination_report_received_amount">
<span<?php echo $_l_examination_report->received_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->received_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_received_amount" name="x_received_amount" id="x_received_amount" value="<?php echo HtmlEncode($_l_examination_report->received_amount->CurrentValue) ?>">
<?php echo $_l_examination_report->received_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_id->Visible) { // examination_id ?>
	<div id="r_examination_id" class="form-group row">
		<label id="elh__l_examination_report_examination_id" for="x_examination_id" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->examination_id->caption() ?><?php echo ($_l_examination_report->examination_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_id->cellAttributes() ?>>
<span id="el__l_examination_report_examination_id">
<span<?php echo $_l_examination_report->examination_id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->examination_id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_examination_id" name="x_examination_id" id="x_examination_id" value="<?php echo HtmlEncode($_l_examination_report->examination_id->CurrentValue) ?>">
<?php echo $_l_examination_report->examination_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_name->Visible) { // examination_name ?>
	<div id="r_examination_name" class="form-group row">
		<label id="elh__l_examination_report_examination_name" for="x_examination_name" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->examination_name->caption() ?><?php echo ($_l_examination_report->examination_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_name->cellAttributes() ?>>
<span id="el__l_examination_report_examination_name">
<span<?php echo $_l_examination_report->examination_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->examination_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_examination_name" name="x_examination_name" id="x_examination_name" value="<?php echo HtmlEncode($_l_examination_report->examination_name->CurrentValue) ?>">
<?php echo $_l_examination_report->examination_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->uid->Visible) { // uid ?>
	<div id="r_uid" class="form-group row">
		<label id="elh__l_examination_report_uid" for="x_uid" class="<?php echo $_l_examination_report_edit->LeftColumnClass ?>"><?php echo $_l_examination_report->uid->caption() ?><?php echo ($_l_examination_report->uid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_l_examination_report_edit->RightColumnClass ?>"><div<?php echo $_l_examination_report->uid->cellAttributes() ?>>
<span id="el__l_examination_report_uid">
<span<?php echo $_l_examination_report->uid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_l_examination_report->uid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_uid" name="x_uid" id="x_uid" value="<?php echo HtmlEncode($_l_examination_report->uid->CurrentValue) ?>">
<?php echo $_l_examination_report->uid->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$_l_examination_report_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $_l_examination_report_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $_l_examination_report_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$_l_examination_report_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$_l_examination_report_edit->terminate();
?>