<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_l_examination_report_list = new _l_examination_report_list();

// Run the page
$_l_examination_report_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_l_examination_report_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_l_examination_report->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_l_examination_reportlist = currentForm = new ew.Form("f_l_examination_reportlist", "list");
f_l_examination_reportlist.formKeyCountName = '<?php echo $_l_examination_report_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_l_examination_reportlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_l_examination_reportlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_l_examination_reportlist.lists["x_mobile"] = <?php echo $_l_examination_report_list->mobile->Lookup->toClientList() ?>;
f_l_examination_reportlist.lists["x_mobile"].options = <?php echo JsonEncode($_l_examination_report_list->mobile->lookupOptions()) ?>;
f_l_examination_reportlist.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportlist.lists["x_name"] = <?php echo $_l_examination_report_list->name->Lookup->toClientList() ?>;
f_l_examination_reportlist.lists["x_name"].options = <?php echo JsonEncode($_l_examination_report_list->name->lookupOptions()) ?>;
f_l_examination_reportlist.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportlist.lists["x_sex"] = <?php echo $_l_examination_report_list->sex->Lookup->toClientList() ?>;
f_l_examination_reportlist.lists["x_sex"].options = <?php echo JsonEncode($_l_examination_report_list->sex->options(FALSE, TRUE)) ?>;
f_l_examination_reportlist.lists["x_referral"] = <?php echo $_l_examination_report_list->referral->Lookup->toClientList() ?>;
f_l_examination_reportlist.lists["x_referral"].options = <?php echo JsonEncode($_l_examination_report_list->referral->lookupOptions()) ?>;
f_l_examination_reportlist.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportlist.lists["x_examination_grp"] = <?php echo $_l_examination_report_list->examination_grp->Lookup->toClientList() ?>;
f_l_examination_reportlist.lists["x_examination_grp"].options = <?php echo JsonEncode($_l_examination_report_list->examination_grp->lookupOptions()) ?>;

// Form object for search
var f_l_examination_reportlistsrch = currentSearchForm = new ew.Form("f_l_examination_reportlistsrch");

// Filters
f_l_examination_reportlistsrch.filterList = <?php echo $_l_examination_report_list->getFilterList() ?>;

// Init search panel as collapsed
f_l_examination_reportlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_l_examination_report->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_l_examination_report_list->TotalRecs > 0 && $_l_examination_report_list->ExportOptions->visible()) { ?>
<?php $_l_examination_report_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_l_examination_report_list->ImportOptions->visible()) { ?>
<?php $_l_examination_report_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_l_examination_report_list->SearchOptions->visible()) { ?>
<?php $_l_examination_report_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_l_examination_report_list->FilterOptions->visible()) { ?>
<?php $_l_examination_report_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$_l_examination_report_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_l_examination_report->isExport() && !$_l_examination_report->CurrentAction) { ?>
<form name="f_l_examination_reportlistsrch" id="f_l_examination_reportlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_l_examination_report_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="f_l_examination_reportlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_l_examination_report">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_l_examination_report_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_l_examination_report_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_l_examination_report_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_l_examination_report_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_l_examination_report_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_l_examination_report_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_l_examination_report_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_l_examination_report_list->showPageHeader(); ?>
<?php
$_l_examination_report_list->showMessage();
?>
<?php if ($_l_examination_report_list->TotalRecs > 0 || $_l_examination_report->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_l_examination_report_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _l_examination_report">
<?php if (!$_l_examination_report->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_l_examination_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_l_examination_report_list->Pager)) $_l_examination_report_list->Pager = new PrevNextPager($_l_examination_report_list->StartRec, $_l_examination_report_list->DisplayRecs, $_l_examination_report_list->TotalRecs, $_l_examination_report_list->AutoHidePager) ?>
<?php if ($_l_examination_report_list->Pager->RecordCount > 0 && $_l_examination_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_l_examination_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_l_examination_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_l_examination_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_l_examination_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_l_examination_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_l_examination_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_l_examination_report_list->TotalRecs > 0 && (!$_l_examination_report_list->AutoHidePageSizeSelector || $_l_examination_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_l_examination_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_l_examination_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_l_examination_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_l_examination_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_l_examination_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_l_examination_report_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_l_examination_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_l_examination_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_l_examination_reportlist" id="f_l_examination_reportlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_l_examination_report_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_l_examination_report_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_l_examination_report">
<div id="gmp__l_examination_report" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_l_examination_report_list->TotalRecs > 0 || $_l_examination_report->isGridEdit()) { ?>
<table id="tbl__l_examination_reportlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_l_examination_report_list->RowType = ROWTYPE_HEADER;

// Render list options
$_l_examination_report_list->renderListOptions();

// Render list options (header, left)
$_l_examination_report_list->ListOptions->render("header", "left");
?>
<?php if ($_l_examination_report->d_id->Visible) { // d_id ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->d_id) == "") { ?>
		<th data-name="d_id" class="<?php echo $_l_examination_report->d_id->headerCellClass() ?>"><div id="elh__l_examination_report_d_id" class="_l_examination_report_d_id"><div class="ew-table-header-caption"><?php echo $_l_examination_report->d_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_id" class="<?php echo $_l_examination_report->d_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->d_id) ?>',2);"><div id="elh__l_examination_report_d_id" class="_l_examination_report_d_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->d_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->d_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->d_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->mobile->Visible) { // mobile ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $_l_examination_report->mobile->headerCellClass() ?>"><div id="elh__l_examination_report_mobile" class="_l_examination_report_mobile"><div class="ew-table-header-caption"><?php echo $_l_examination_report->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $_l_examination_report->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->mobile) ?>',2);"><div id="elh__l_examination_report_mobile" class="_l_examination_report_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->name->Visible) { // name ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->name) == "") { ?>
		<th data-name="name" class="<?php echo $_l_examination_report->name->headerCellClass() ?>"><div id="elh__l_examination_report_name" class="_l_examination_report_name"><div class="ew-table-header-caption"><?php echo $_l_examination_report->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $_l_examination_report->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->name) ?>',2);"><div id="elh__l_examination_report_name" class="_l_examination_report_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->examination_code->Visible) { // examination_code ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->examination_code) == "") { ?>
		<th data-name="examination_code" class="<?php echo $_l_examination_report->examination_code->headerCellClass() ?>"><div id="elh__l_examination_report_examination_code" class="_l_examination_report_examination_code"><div class="ew-table-header-caption"><?php echo $_l_examination_report->examination_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="examination_code" class="<?php echo $_l_examination_report->examination_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->examination_code) ?>',2);"><div id="elh__l_examination_report_examination_code" class="_l_examination_report_examination_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->examination_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->examination_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->examination_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_value->Visible) { // diagnosis_value ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->diagnosis_value) == "") { ?>
		<th data-name="diagnosis_value" class="<?php echo $_l_examination_report->diagnosis_value->headerCellClass() ?>"><div id="elh__l_examination_report_diagnosis_value" class="_l_examination_report_diagnosis_value"><div class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_value->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diagnosis_value" class="<?php echo $_l_examination_report->diagnosis_value->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->diagnosis_value) ?>',2);"><div id="elh__l_examination_report_diagnosis_value" class="_l_examination_report_diagnosis_value">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_value->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->diagnosis_value->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->diagnosis_value->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_st_min->Visible) { // diagnosis_st_min ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->diagnosis_st_min) == "") { ?>
		<th data-name="diagnosis_st_min" class="<?php echo $_l_examination_report->diagnosis_st_min->headerCellClass() ?>"><div id="elh__l_examination_report_diagnosis_st_min" class="_l_examination_report_diagnosis_st_min"><div class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_st_min->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diagnosis_st_min" class="<?php echo $_l_examination_report->diagnosis_st_min->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->diagnosis_st_min) ?>',2);"><div id="elh__l_examination_report_diagnosis_st_min" class="_l_examination_report_diagnosis_st_min">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_st_min->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->diagnosis_st_min->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->diagnosis_st_min->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_st_max->Visible) { // diagnosis_st_max ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->diagnosis_st_max) == "") { ?>
		<th data-name="diagnosis_st_max" class="<?php echo $_l_examination_report->diagnosis_st_max->headerCellClass() ?>"><div id="elh__l_examination_report_diagnosis_st_max" class="_l_examination_report_diagnosis_st_max"><div class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_st_max->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diagnosis_st_max" class="<?php echo $_l_examination_report->diagnosis_st_max->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->diagnosis_st_max) ?>',2);"><div id="elh__l_examination_report_diagnosis_st_max" class="_l_examination_report_diagnosis_st_max">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_st_max->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->diagnosis_st_max->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->diagnosis_st_max->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_unit->Visible) { // diagnosis_unit ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->diagnosis_unit) == "") { ?>
		<th data-name="diagnosis_unit" class="<?php echo $_l_examination_report->diagnosis_unit->headerCellClass() ?>"><div id="elh__l_examination_report_diagnosis_unit" class="_l_examination_report_diagnosis_unit"><div class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_unit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diagnosis_unit" class="<?php echo $_l_examination_report->diagnosis_unit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->diagnosis_unit) ?>',2);"><div id="elh__l_examination_report_diagnosis_unit" class="_l_examination_report_diagnosis_unit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_unit->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->diagnosis_unit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->diagnosis_unit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->balance_amount->Visible) { // balance_amount ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->balance_amount) == "") { ?>
		<th data-name="balance_amount" class="<?php echo $_l_examination_report->balance_amount->headerCellClass() ?>"><div id="elh__l_examination_report_balance_amount" class="_l_examination_report_balance_amount"><div class="ew-table-header-caption"><?php echo $_l_examination_report->balance_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance_amount" class="<?php echo $_l_examination_report->balance_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->balance_amount) ?>',2);"><div id="elh__l_examination_report_balance_amount" class="_l_examination_report_balance_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->balance_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->balance_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->balance_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->age->Visible) { // age ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->age) == "") { ?>
		<th data-name="age" class="<?php echo $_l_examination_report->age->headerCellClass() ?>"><div id="elh__l_examination_report_age" class="_l_examination_report_age"><div class="ew-table-header-caption"><?php echo $_l_examination_report->age->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="age" class="<?php echo $_l_examination_report->age->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->age) ?>',2);"><div id="elh__l_examination_report_age" class="_l_examination_report_age">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->age->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->age->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->age->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->sex->Visible) { // sex ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->sex) == "") { ?>
		<th data-name="sex" class="<?php echo $_l_examination_report->sex->headerCellClass() ?>"><div id="elh__l_examination_report_sex" class="_l_examination_report_sex"><div class="ew-table-header-caption"><?php echo $_l_examination_report->sex->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sex" class="<?php echo $_l_examination_report->sex->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->sex) ?>',2);"><div id="elh__l_examination_report_sex" class="_l_examination_report_sex">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->sex->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->sex->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->sex->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->referral->Visible) { // referral ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->referral) == "") { ?>
		<th data-name="referral" class="<?php echo $_l_examination_report->referral->headerCellClass() ?>"><div id="elh__l_examination_report_referral" class="_l_examination_report_referral"><div class="ew-table-header-caption"><?php echo $_l_examination_report->referral->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="referral" class="<?php echo $_l_examination_report->referral->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->referral) ?>',2);"><div id="elh__l_examination_report_referral" class="_l_examination_report_referral">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->referral->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->referral->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->referral->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->examination_grp->Visible) { // examination_grp ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->examination_grp) == "") { ?>
		<th data-name="examination_grp" class="<?php echo $_l_examination_report->examination_grp->headerCellClass() ?>"><div id="elh__l_examination_report_examination_grp" class="_l_examination_report_examination_grp"><div class="ew-table-header-caption"><?php echo $_l_examination_report->examination_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="examination_grp" class="<?php echo $_l_examination_report->examination_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->examination_grp) ?>',2);"><div id="elh__l_examination_report_examination_grp" class="_l_examination_report_examination_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->examination_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->examination_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->examination_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_datetime->Visible) { // diagnosis_datetime ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->diagnosis_datetime) == "") { ?>
		<th data-name="diagnosis_datetime" class="<?php echo $_l_examination_report->diagnosis_datetime->headerCellClass() ?>"><div id="elh__l_examination_report_diagnosis_datetime" class="_l_examination_report_diagnosis_datetime"><div class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diagnosis_datetime" class="<?php echo $_l_examination_report->diagnosis_datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->diagnosis_datetime) ?>',2);"><div id="elh__l_examination_report_diagnosis_datetime" class="_l_examination_report_diagnosis_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->diagnosis_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->diagnosis_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->diagnosis_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->uid->Visible) { // uid ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->uid) == "") { ?>
		<th data-name="uid" class="<?php echo $_l_examination_report->uid->headerCellClass() ?>"><div id="elh__l_examination_report_uid" class="_l_examination_report_uid"><div class="ew-table-header-caption"><?php echo $_l_examination_report->uid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="uid" class="<?php echo $_l_examination_report->uid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->uid) ?>',2);"><div id="elh__l_examination_report_uid" class="_l_examination_report_uid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->uid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->uid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->uid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->operator->Visible) { // operator ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $_l_examination_report->operator->headerCellClass() ?>"><div id="elh__l_examination_report_operator" class="_l_examination_report_operator"><div class="ew-table-header-caption"><?php echo $_l_examination_report->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $_l_examination_report->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->operator) ?>',2);"><div id="elh__l_examination_report_operator" class="_l_examination_report_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_l_examination_report->datetime->Visible) { // datetime ?>
	<?php if ($_l_examination_report->sortUrl($_l_examination_report->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $_l_examination_report->datetime->headerCellClass() ?>"><div id="elh__l_examination_report_datetime" class="_l_examination_report_datetime"><div class="ew-table-header-caption"><?php echo $_l_examination_report->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $_l_examination_report->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_l_examination_report->SortUrl($_l_examination_report->datetime) ?>',2);"><div id="elh__l_examination_report_datetime" class="_l_examination_report_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_l_examination_report->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($_l_examination_report->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_l_examination_report->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_l_examination_report_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_l_examination_report->ExportAll && $_l_examination_report->isExport()) {
	$_l_examination_report_list->StopRec = $_l_examination_report_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_l_examination_report_list->TotalRecs > $_l_examination_report_list->StartRec + $_l_examination_report_list->DisplayRecs - 1)
		$_l_examination_report_list->StopRec = $_l_examination_report_list->StartRec + $_l_examination_report_list->DisplayRecs - 1;
	else
		$_l_examination_report_list->StopRec = $_l_examination_report_list->TotalRecs;
}
$_l_examination_report_list->RecCnt = $_l_examination_report_list->StartRec - 1;
if ($_l_examination_report_list->Recordset && !$_l_examination_report_list->Recordset->EOF) {
	$_l_examination_report_list->Recordset->moveFirst();
	$selectLimit = $_l_examination_report_list->UseSelectLimit;
	if (!$selectLimit && $_l_examination_report_list->StartRec > 1)
		$_l_examination_report_list->Recordset->move($_l_examination_report_list->StartRec - 1);
} elseif (!$_l_examination_report->AllowAddDeleteRow && $_l_examination_report_list->StopRec == 0) {
	$_l_examination_report_list->StopRec = $_l_examination_report->GridAddRowCount;
}

// Initialize aggregate
$_l_examination_report->RowType = ROWTYPE_AGGREGATEINIT;
$_l_examination_report->resetAttributes();
$_l_examination_report_list->renderRow();
while ($_l_examination_report_list->RecCnt < $_l_examination_report_list->StopRec) {
	$_l_examination_report_list->RecCnt++;
	if ($_l_examination_report_list->RecCnt >= $_l_examination_report_list->StartRec) {
		$_l_examination_report_list->RowCnt++;

		// Set up key count
		$_l_examination_report_list->KeyCount = $_l_examination_report_list->RowIndex;

		// Init row class and style
		$_l_examination_report->resetAttributes();
		$_l_examination_report->CssClass = "";
		if ($_l_examination_report->isGridAdd()) {
		} else {
			$_l_examination_report_list->loadRowValues($_l_examination_report_list->Recordset); // Load row values
		}
		$_l_examination_report->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_l_examination_report->RowAttrs = array_merge($_l_examination_report->RowAttrs, array('data-rowindex'=>$_l_examination_report_list->RowCnt, 'id'=>'r' . $_l_examination_report_list->RowCnt . '__l_examination_report', 'data-rowtype'=>$_l_examination_report->RowType));

		// Render row
		$_l_examination_report_list->renderRow();

		// Render list options
		$_l_examination_report_list->renderListOptions();
?>
	<tr<?php echo $_l_examination_report->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_l_examination_report_list->ListOptions->render("body", "left", $_l_examination_report_list->RowCnt);
?>
	<?php if ($_l_examination_report->d_id->Visible) { // d_id ?>
		<td data-name="d_id"<?php echo $_l_examination_report->d_id->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_d_id" class="_l_examination_report_d_id">
<span<?php echo $_l_examination_report->d_id->viewAttributes() ?>>
<?php echo $_l_examination_report->d_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $_l_examination_report->mobile->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_mobile" class="_l_examination_report_mobile">
<span<?php echo $_l_examination_report->mobile->viewAttributes() ?>>
<?php echo $_l_examination_report->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->name->Visible) { // name ?>
		<td data-name="name"<?php echo $_l_examination_report->name->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_name" class="_l_examination_report_name">
<span<?php echo $_l_examination_report->name->viewAttributes() ?>>
<?php echo $_l_examination_report->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->examination_code->Visible) { // examination_code ?>
		<td data-name="examination_code"<?php echo $_l_examination_report->examination_code->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_examination_code" class="_l_examination_report_examination_code">
<span<?php echo $_l_examination_report->examination_code->viewAttributes() ?>>
<?php echo $_l_examination_report->examination_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->diagnosis_value->Visible) { // diagnosis_value ?>
		<td data-name="diagnosis_value"<?php echo $_l_examination_report->diagnosis_value->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_diagnosis_value" class="_l_examination_report_diagnosis_value">
<span<?php echo $_l_examination_report->diagnosis_value->viewAttributes() ?>>
<?php echo $_l_examination_report->diagnosis_value->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->diagnosis_st_min->Visible) { // diagnosis_st_min ?>
		<td data-name="diagnosis_st_min"<?php echo $_l_examination_report->diagnosis_st_min->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_diagnosis_st_min" class="_l_examination_report_diagnosis_st_min">
<span<?php echo $_l_examination_report->diagnosis_st_min->viewAttributes() ?>>
<?php echo $_l_examination_report->diagnosis_st_min->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->diagnosis_st_max->Visible) { // diagnosis_st_max ?>
		<td data-name="diagnosis_st_max"<?php echo $_l_examination_report->diagnosis_st_max->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_diagnosis_st_max" class="_l_examination_report_diagnosis_st_max">
<span<?php echo $_l_examination_report->diagnosis_st_max->viewAttributes() ?>>
<?php echo $_l_examination_report->diagnosis_st_max->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->diagnosis_unit->Visible) { // diagnosis_unit ?>
		<td data-name="diagnosis_unit"<?php echo $_l_examination_report->diagnosis_unit->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_diagnosis_unit" class="_l_examination_report_diagnosis_unit">
<span<?php echo $_l_examination_report->diagnosis_unit->viewAttributes() ?>>
<?php echo $_l_examination_report->diagnosis_unit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->balance_amount->Visible) { // balance_amount ?>
		<td data-name="balance_amount"<?php echo $_l_examination_report->balance_amount->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_balance_amount" class="_l_examination_report_balance_amount">
<span<?php echo $_l_examination_report->balance_amount->viewAttributes() ?>>
<?php echo $_l_examination_report->balance_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->age->Visible) { // age ?>
		<td data-name="age"<?php echo $_l_examination_report->age->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_age" class="_l_examination_report_age">
<span<?php echo $_l_examination_report->age->viewAttributes() ?>>
<?php echo $_l_examination_report->age->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->sex->Visible) { // sex ?>
		<td data-name="sex"<?php echo $_l_examination_report->sex->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_sex" class="_l_examination_report_sex">
<span<?php echo $_l_examination_report->sex->viewAttributes() ?>>
<?php echo $_l_examination_report->sex->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->referral->Visible) { // referral ?>
		<td data-name="referral"<?php echo $_l_examination_report->referral->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_referral" class="_l_examination_report_referral">
<span<?php echo $_l_examination_report->referral->viewAttributes() ?>>
<?php echo $_l_examination_report->referral->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->examination_grp->Visible) { // examination_grp ?>
		<td data-name="examination_grp"<?php echo $_l_examination_report->examination_grp->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_examination_grp" class="_l_examination_report_examination_grp">
<span<?php echo $_l_examination_report->examination_grp->viewAttributes() ?>>
<?php echo $_l_examination_report->examination_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->diagnosis_datetime->Visible) { // diagnosis_datetime ?>
		<td data-name="diagnosis_datetime"<?php echo $_l_examination_report->diagnosis_datetime->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_diagnosis_datetime" class="_l_examination_report_diagnosis_datetime">
<span<?php echo $_l_examination_report->diagnosis_datetime->viewAttributes() ?>>
<?php echo $_l_examination_report->diagnosis_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->uid->Visible) { // uid ?>
		<td data-name="uid"<?php echo $_l_examination_report->uid->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_uid" class="_l_examination_report_uid">
<span<?php echo $_l_examination_report->uid->viewAttributes() ?>>
<?php echo $_l_examination_report->uid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $_l_examination_report->operator->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_operator" class="_l_examination_report_operator">
<span<?php echo $_l_examination_report->operator->viewAttributes() ?>>
<?php echo $_l_examination_report->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_l_examination_report->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $_l_examination_report->datetime->cellAttributes() ?>>
<span id="el<?php echo $_l_examination_report_list->RowCnt ?>__l_examination_report_datetime" class="_l_examination_report_datetime">
<span<?php echo $_l_examination_report->datetime->viewAttributes() ?>>
<?php echo $_l_examination_report->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_l_examination_report_list->ListOptions->render("body", "right", $_l_examination_report_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_l_examination_report->isGridAdd())
		$_l_examination_report_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_l_examination_report->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_l_examination_report_list->Recordset)
	$_l_examination_report_list->Recordset->Close();
?>
<?php if (!$_l_examination_report->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_l_examination_report->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_l_examination_report_list->Pager)) $_l_examination_report_list->Pager = new PrevNextPager($_l_examination_report_list->StartRec, $_l_examination_report_list->DisplayRecs, $_l_examination_report_list->TotalRecs, $_l_examination_report_list->AutoHidePager) ?>
<?php if ($_l_examination_report_list->Pager->RecordCount > 0 && $_l_examination_report_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_l_examination_report_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_l_examination_report_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_l_examination_report_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_l_examination_report_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_l_examination_report_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_l_examination_report_list->pageUrl() ?>start=<?php echo $_l_examination_report_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_l_examination_report_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_l_examination_report_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_l_examination_report_list->TotalRecs > 0 && (!$_l_examination_report_list->AutoHidePageSizeSelector || $_l_examination_report_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_l_examination_report">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_l_examination_report_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_l_examination_report_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_l_examination_report_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_l_examination_report_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_l_examination_report_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_l_examination_report->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_l_examination_report_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_l_examination_report_list->TotalRecs == 0 && !$_l_examination_report->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_l_examination_report_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_l_examination_report_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_l_examination_report->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_l_examination_report->isExport()) { ?>
<script>
ew.scrollableTable("gmp__l_examination_report", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_l_examination_report_list->terminate();
?>