<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_l_examination_report_search = new _l_examination_report_search();

// Run the page
$_l_examination_report_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_l_examination_report_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($_l_examination_report_search->IsModal) { ?>
var f_l_examination_reportsearch = currentAdvancedSearchForm = new ew.Form("f_l_examination_reportsearch", "search");
<?php } else { ?>
var f_l_examination_reportsearch = currentForm = new ew.Form("f_l_examination_reportsearch", "search");
<?php } ?>

// Form_CustomValidate event
f_l_examination_reportsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_l_examination_reportsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_l_examination_reportsearch.lists["x_mobile"] = <?php echo $_l_examination_report_search->mobile->Lookup->toClientList() ?>;
f_l_examination_reportsearch.lists["x_mobile"].options = <?php echo JsonEncode($_l_examination_report_search->mobile->lookupOptions()) ?>;
f_l_examination_reportsearch.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportsearch.lists["x_name"] = <?php echo $_l_examination_report_search->name->Lookup->toClientList() ?>;
f_l_examination_reportsearch.lists["x_name"].options = <?php echo JsonEncode($_l_examination_report_search->name->lookupOptions()) ?>;
f_l_examination_reportsearch.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportsearch.lists["x_sex"] = <?php echo $_l_examination_report_search->sex->Lookup->toClientList() ?>;
f_l_examination_reportsearch.lists["x_sex"].options = <?php echo JsonEncode($_l_examination_report_search->sex->options(FALSE, TRUE)) ?>;
f_l_examination_reportsearch.lists["x_referral"] = <?php echo $_l_examination_report_search->referral->Lookup->toClientList() ?>;
f_l_examination_reportsearch.lists["x_referral"].options = <?php echo JsonEncode($_l_examination_report_search->referral->lookupOptions()) ?>;
f_l_examination_reportsearch.autoSuggests["x_referral"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_l_examination_reportsearch.lists["x_examination_grp"] = <?php echo $_l_examination_report_search->examination_grp->Lookup->toClientList() ?>;
f_l_examination_reportsearch.lists["x_examination_grp"].options = <?php echo JsonEncode($_l_examination_report_search->examination_grp->lookupOptions()) ?>;
f_l_examination_reportsearch.lists["x_user"] = <?php echo $_l_examination_report_search->user->Lookup->toClientList() ?>;
f_l_examination_reportsearch.lists["x_user"].options = <?php echo JsonEncode($_l_examination_report_search->user->lookupOptions()) ?>;
f_l_examination_reportsearch.autoSuggests["x_user"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

f_l_examination_reportsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_d_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->d_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diagnosis_st_max");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->diagnosis_st_max->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->balance_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_age");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->age->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_referral");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->referral->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diagnosis_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->diagnosis_datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_total_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->total_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_discount_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->discount_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_received_amount");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->received_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_examination_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->examination_id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_user");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($_l_examination_report->user->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $_l_examination_report_search->showPageHeader(); ?>
<?php
$_l_examination_report_search->showMessage();
?>
<form name="f_l_examination_reportsearch" id="f_l_examination_reportsearch" class="<?php echo $_l_examination_report_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_l_examination_report_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_l_examination_report_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_l_examination_report">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$_l_examination_report_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($_l_examination_report->d_id->Visible) { // d_id ?>
	<div id="r_d_id" class="form-group row">
		<label for="x_d_id" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_d_id"><?php echo $_l_examination_report->d_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_d_id" id="z_d_id" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->d_id->cellAttributes() ?>>
			<span id="el__l_examination_report_d_id">
<input type="text" data-table="_l_examination_report" data-field="x_d_id" name="x_d_id" id="x_d_id" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->d_id->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->d_id->EditValue ?>"<?php echo $_l_examination_report->d_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_mobile"><?php echo $_l_examination_report->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mobile" id="z_mobile" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->mobile->cellAttributes() ?>>
			<span id="el__l_examination_report_mobile">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$_l_examination_report->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_l_examination_report->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($_l_examination_report->mobile->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_l_examination_report->mobile->getPlaceHolder()) ?>"<?php echo $_l_examination_report->mobile->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_l_examination_report->mobile->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_mobile',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($_l_examination_report->mobile->ReadOnly || $_l_examination_report->mobile->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_mobile" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_l_examination_report->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($_l_examination_report->mobile->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_l_examination_reportsearch.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $_l_examination_report->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_name"><?php echo $_l_examination_report->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->name->cellAttributes() ?>>
			<span id="el__l_examination_report_name">
<?php
$wrkonchange = "" . trim(@$_l_examination_report->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_l_examination_report->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($_l_examination_report->name->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_l_examination_report->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_l_examination_report->name->getPlaceHolder()) ?>"<?php echo $_l_examination_report->name->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_l_examination_report->name->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_name',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($_l_examination_report->name->ReadOnly || $_l_examination_report->name->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_name" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_l_examination_report->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($_l_examination_report->name->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_l_examination_reportsearch.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $_l_examination_report->name->Lookup->getParamTag("p_x_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_code->Visible) { // examination_code ?>
	<div id="r_examination_code" class="form-group row">
		<label for="x_examination_code" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_examination_code"><?php echo $_l_examination_report->examination_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_examination_code" id="z_examination_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_code->cellAttributes() ?>>
			<span id="el__l_examination_report_examination_code">
<input type="text" data-table="_l_examination_report" data-field="x_examination_code" name="x_examination_code" id="x_examination_code" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($_l_examination_report->examination_code->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->examination_code->EditValue ?>"<?php echo $_l_examination_report->examination_code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_value->Visible) { // diagnosis_value ?>
	<div id="r_diagnosis_value" class="form-group row">
		<label for="x_diagnosis_value" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_diagnosis_value"><?php echo $_l_examination_report->diagnosis_value->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_diagnosis_value" id="z_diagnosis_value" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_value->cellAttributes() ?>>
			<span id="el__l_examination_report_diagnosis_value">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_value" name="x_diagnosis_value" id="x_diagnosis_value" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_value->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_value->EditValue ?>"<?php echo $_l_examination_report->diagnosis_value->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_st_min->Visible) { // diagnosis_st_min ?>
	<div id="r_diagnosis_st_min" class="form-group row">
		<label for="x_diagnosis_st_min" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_diagnosis_st_min"><?php echo $_l_examination_report->diagnosis_st_min->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_diagnosis_st_min" id="z_diagnosis_st_min" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_st_min->cellAttributes() ?>>
			<span id="el__l_examination_report_diagnosis_st_min">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_st_min" name="x_diagnosis_st_min" id="x_diagnosis_st_min" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_st_min->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_st_min->EditValue ?>"<?php echo $_l_examination_report->diagnosis_st_min->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_st_max->Visible) { // diagnosis_st_max ?>
	<div id="r_diagnosis_st_max" class="form-group row">
		<label for="x_diagnosis_st_max" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_diagnosis_st_max"><?php echo $_l_examination_report->diagnosis_st_max->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diagnosis_st_max" id="z_diagnosis_st_max" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_st_max->cellAttributes() ?>>
			<span id="el__l_examination_report_diagnosis_st_max">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_st_max" name="x_diagnosis_st_max" id="x_diagnosis_st_max" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_st_max->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_st_max->EditValue ?>"<?php echo $_l_examination_report->diagnosis_st_max->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_unit->Visible) { // diagnosis_unit ?>
	<div id="r_diagnosis_unit" class="form-group row">
		<label for="x_diagnosis_unit" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_diagnosis_unit"><?php echo $_l_examination_report->diagnosis_unit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_diagnosis_unit" id="z_diagnosis_unit" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_unit->cellAttributes() ?>>
			<span id="el__l_examination_report_diagnosis_unit">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_unit" name="x_diagnosis_unit" id="x_diagnosis_unit" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_unit->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_unit->EditValue ?>"<?php echo $_l_examination_report->diagnosis_unit->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->balance_amount->Visible) { // balance_amount ?>
	<div id="r_balance_amount" class="form-group row">
		<label for="x_balance_amount" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_balance_amount"><?php echo $_l_examination_report->balance_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance_amount" id="z_balance_amount" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->balance_amount->cellAttributes() ?>>
			<span id="el__l_examination_report_balance_amount">
<input type="text" data-table="_l_examination_report" data-field="x_balance_amount" name="x_balance_amount" id="x_balance_amount" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->balance_amount->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->balance_amount->EditValue ?>"<?php echo $_l_examination_report->balance_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->age->Visible) { // age ?>
	<div id="r_age" class="form-group row">
		<label for="x_age" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_age"><?php echo $_l_examination_report->age->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_age" id="z_age" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->age->cellAttributes() ?>>
			<span id="el__l_examination_report_age">
<input type="text" data-table="_l_examination_report" data-field="x_age" name="x_age" id="x_age" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->age->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->age->EditValue ?>"<?php echo $_l_examination_report->age->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->sex->Visible) { // sex ?>
	<div id="r_sex" class="form-group row">
		<label class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_sex"><?php echo $_l_examination_report->sex->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sex" id="z_sex" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->sex->cellAttributes() ?>>
			<span id="el__l_examination_report_sex">
<div id="tp_x_sex" class="ew-template"><input type="radio" class="form-check-input" data-table="_l_examination_report" data-field="x_sex" data-value-separator="<?php echo $_l_examination_report->sex->displayValueSeparatorAttribute() ?>" name="x_sex" id="x_sex" value="{value}"<?php echo $_l_examination_report->sex->editAttributes() ?>></div>
<div id="dsl_x_sex" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $_l_examination_report->sex->radioButtonListHtml(FALSE, "x_sex") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->referral->Visible) { // referral ?>
	<div id="r_referral" class="form-group row">
		<label class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_referral"><?php echo $_l_examination_report->referral->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_referral" id="z_referral" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->referral->cellAttributes() ?>>
			<span id="el__l_examination_report_referral">
<?php
$wrkonchange = "" . trim(@$_l_examination_report->referral->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_l_examination_report->referral->EditAttrs["onchange"] = "";
?>
<span id="as_x_referral" class="text-nowrap" style="z-index: 8880">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_referral" id="sv_x_referral" value="<?php echo RemoveHtml($_l_examination_report->referral->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->referral->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_l_examination_report->referral->getPlaceHolder()) ?>"<?php echo $_l_examination_report->referral->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_l_examination_report->referral->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_referral',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($_l_examination_report->referral->ReadOnly || $_l_examination_report->referral->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_referral" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_l_examination_report->referral->displayValueSeparatorAttribute() ?>" name="x_referral" id="x_referral" value="<?php echo HtmlEncode($_l_examination_report->referral->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_l_examination_reportsearch.createAutoSuggest({"id":"x_referral","forceSelect":true});
</script>
<?php echo $_l_examination_report->referral->Lookup->getParamTag("p_x_referral") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_remarks"><?php echo $_l_examination_report->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->remarks->cellAttributes() ?>>
			<span id="el__l_examination_report_remarks">
<input type="text" data-table="_l_examination_report" data-field="x_remarks" name="x_remarks" id="x_remarks" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($_l_examination_report->remarks->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->remarks->EditValue ?>"<?php echo $_l_examination_report->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_grp->Visible) { // examination_grp ?>
	<div id="r_examination_grp" class="form-group row">
		<label for="x_examination_grp" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_examination_grp"><?php echo $_l_examination_report->examination_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_examination_grp" id="z_examination_grp" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_grp->cellAttributes() ?>>
			<span id="el__l_examination_report_examination_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_l_examination_report" data-field="x_examination_grp" data-value-separator="<?php echo $_l_examination_report->examination_grp->displayValueSeparatorAttribute() ?>" id="x_examination_grp" name="x_examination_grp"<?php echo $_l_examination_report->examination_grp->editAttributes() ?>>
		<?php echo $_l_examination_report->examination_grp->selectOptionListHtml("x_examination_grp") ?>
	</select>
</div>
<?php echo $_l_examination_report->examination_grp->Lookup->getParamTag("p_x_examination_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->diagnosis_datetime->Visible) { // diagnosis_datetime ?>
	<div id="r_diagnosis_datetime" class="form-group row">
		<label for="x_diagnosis_datetime" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_diagnosis_datetime"><?php echo $_l_examination_report->diagnosis_datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diagnosis_datetime" id="z_diagnosis_datetime" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->diagnosis_datetime->cellAttributes() ?>>
			<span id="el__l_examination_report_diagnosis_datetime">
<input type="text" data-table="_l_examination_report" data-field="x_diagnosis_datetime" name="x_diagnosis_datetime" id="x_diagnosis_datetime" placeholder="<?php echo HtmlEncode($_l_examination_report->diagnosis_datetime->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->diagnosis_datetime->EditValue ?>"<?php echo $_l_examination_report->diagnosis_datetime->editAttributes() ?>>
<?php if (!$_l_examination_report->diagnosis_datetime->ReadOnly && !$_l_examination_report->diagnosis_datetime->Disabled && !isset($_l_examination_report->diagnosis_datetime->EditAttrs["readonly"]) && !isset($_l_examination_report->diagnosis_datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("f_l_examination_reportsearch", "x_diagnosis_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->import_value->Visible) { // import_value ?>
	<div id="r_import_value" class="form-group row">
		<label for="x_import_value" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_import_value"><?php echo $_l_examination_report->import_value->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_import_value" id="z_import_value" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->import_value->cellAttributes() ?>>
			<span id="el__l_examination_report_import_value">
<input type="text" data-table="_l_examination_report" data-field="x_import_value" name="x_import_value" id="x_import_value" size="35" placeholder="<?php echo HtmlEncode($_l_examination_report->import_value->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->import_value->EditValue ?>"<?php echo $_l_examination_report->import_value->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->total_amount->Visible) { // total_amount ?>
	<div id="r_total_amount" class="form-group row">
		<label for="x_total_amount" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_total_amount"><?php echo $_l_examination_report->total_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_total_amount" id="z_total_amount" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->total_amount->cellAttributes() ?>>
			<span id="el__l_examination_report_total_amount">
<input type="text" data-table="_l_examination_report" data-field="x_total_amount" name="x_total_amount" id="x_total_amount" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->total_amount->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->total_amount->EditValue ?>"<?php echo $_l_examination_report->total_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->discount_amount->Visible) { // discount_amount ?>
	<div id="r_discount_amount" class="form-group row">
		<label for="x_discount_amount" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_discount_amount"><?php echo $_l_examination_report->discount_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_discount_amount" id="z_discount_amount" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->discount_amount->cellAttributes() ?>>
			<span id="el__l_examination_report_discount_amount">
<input type="text" data-table="_l_examination_report" data-field="x_discount_amount" name="x_discount_amount" id="x_discount_amount" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->discount_amount->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->discount_amount->EditValue ?>"<?php echo $_l_examination_report->discount_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->received_amount->Visible) { // received_amount ?>
	<div id="r_received_amount" class="form-group row">
		<label for="x_received_amount" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_received_amount"><?php echo $_l_examination_report->received_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_received_amount" id="z_received_amount" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->received_amount->cellAttributes() ?>>
			<span id="el__l_examination_report_received_amount">
<input type="text" data-table="_l_examination_report" data-field="x_received_amount" name="x_received_amount" id="x_received_amount" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->received_amount->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->received_amount->EditValue ?>"<?php echo $_l_examination_report->received_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_id->Visible) { // examination_id ?>
	<div id="r_examination_id" class="form-group row">
		<label for="x_examination_id" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_examination_id"><?php echo $_l_examination_report->examination_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_examination_id" id="z_examination_id" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_id->cellAttributes() ?>>
			<span id="el__l_examination_report_examination_id">
<input type="text" data-table="_l_examination_report" data-field="x_examination_id" name="x_examination_id" id="x_examination_id" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->examination_id->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->examination_id->EditValue ?>"<?php echo $_l_examination_report->examination_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->examination_name->Visible) { // examination_name ?>
	<div id="r_examination_name" class="form-group row">
		<label for="x_examination_name" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_examination_name"><?php echo $_l_examination_report->examination_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_examination_name" id="z_examination_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->examination_name->cellAttributes() ?>>
			<span id="el__l_examination_report_examination_name">
<input type="text" data-table="_l_examination_report" data-field="x_examination_name" name="x_examination_name" id="x_examination_name" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($_l_examination_report->examination_name->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->examination_name->EditValue ?>"<?php echo $_l_examination_report->examination_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->uid->Visible) { // uid ?>
	<div id="r_uid" class="form-group row">
		<label for="x_uid" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_uid"><?php echo $_l_examination_report->uid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uid" id="z_uid" value="LIKE"></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->uid->cellAttributes() ?>>
			<span id="el__l_examination_report_uid">
<input type="text" data-table="_l_examination_report" data-field="x_uid" name="x_uid" id="x_uid" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($_l_examination_report->uid->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->uid->EditValue ?>"<?php echo $_l_examination_report->uid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_operator"><?php echo $_l_examination_report->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->operator->cellAttributes() ?>>
			<span id="el__l_examination_report_operator">
<input type="text" data-table="_l_examination_report" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->operator->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->operator->EditValue ?>"<?php echo $_l_examination_report->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_datetime"><?php echo $_l_examination_report->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->datetime->cellAttributes() ?>>
			<span id="el__l_examination_report_datetime">
<input type="text" data-table="_l_examination_report" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($_l_examination_report->datetime->getPlaceHolder()) ?>" value="<?php echo $_l_examination_report->datetime->EditValue ?>"<?php echo $_l_examination_report->datetime->editAttributes() ?>>
<?php if (!$_l_examination_report->datetime->ReadOnly && !$_l_examination_report->datetime->Disabled && !isset($_l_examination_report->datetime->EditAttrs["readonly"]) && !isset($_l_examination_report->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("f_l_examination_reportsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($_l_examination_report->user->Visible) { // user ?>
	<div id="r_user" class="form-group row">
		<label class="<?php echo $_l_examination_report_search->LeftColumnClass ?>"><span id="elh__l_examination_report_user"><?php echo $_l_examination_report->user->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_user" id="z_user" value="="></span>
		</label>
		<div class="<?php echo $_l_examination_report_search->RightColumnClass ?>"><div<?php echo $_l_examination_report->user->cellAttributes() ?>>
			<span id="el__l_examination_report_user">
<?php
$wrkonchange = "" . trim(@$_l_examination_report->user->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_l_examination_report->user->EditAttrs["onchange"] = "";
?>
<span id="as_x_user" class="text-nowrap" style="z-index: 8750">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_user" id="sv_x_user" value="<?php echo RemoveHtml($_l_examination_report->user->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_l_examination_report->user->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_l_examination_report->user->getPlaceHolder()) ?>"<?php echo $_l_examination_report->user->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($_l_examination_report->user->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_user',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($_l_examination_report->user->ReadOnly || $_l_examination_report->user->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="_l_examination_report" data-field="x_user" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $_l_examination_report->user->displayValueSeparatorAttribute() ?>" name="x_user" id="x_user" value="<?php echo HtmlEncode($_l_examination_report->user->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_l_examination_reportsearch.createAutoSuggest({"id":"x_user","forceSelect":true});
</script>
<?php echo $_l_examination_report->user->Lookup->getParamTag("p_x_user") ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$_l_examination_report_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $_l_examination_report_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$_l_examination_report_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$_l_examination_report_search->terminate();
?>