<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_product_view_list = new _product_view_list();

// Run the page
$_product_view_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_product_view_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_product_view->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_product_viewlist = currentForm = new ew.Form("f_product_viewlist", "list");
f_product_viewlist.formKeyCountName = '<?php echo $_product_view_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_product_viewlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_product_viewlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var f_product_viewlistsrch = currentSearchForm = new ew.Form("f_product_viewlistsrch");

// Filters
f_product_viewlistsrch.filterList = <?php echo $_product_view_list->getFilterList() ?>;

// Init search panel as collapsed
f_product_viewlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_product_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_product_view_list->TotalRecs > 0 && $_product_view_list->ExportOptions->visible()) { ?>
<?php $_product_view_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_product_view_list->ImportOptions->visible()) { ?>
<?php $_product_view_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_product_view_list->SearchOptions->visible()) { ?>
<?php $_product_view_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_product_view_list->FilterOptions->visible()) { ?>
<?php $_product_view_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$_product_view_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_product_view->isExport() && !$_product_view->CurrentAction) { ?>
<form name="f_product_viewlistsrch" id="f_product_viewlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_product_view_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="f_product_viewlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_product_view">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_product_view_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_product_view_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_product_view_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_product_view_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_product_view_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_product_view_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_product_view_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_product_view_list->showPageHeader(); ?>
<?php
$_product_view_list->showMessage();
?>
<?php if ($_product_view_list->TotalRecs > 0 || $_product_view->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_product_view_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _product_view">
<?php if (!$_product_view->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_product_view->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_product_view_list->Pager)) $_product_view_list->Pager = new PrevNextPager($_product_view_list->StartRec, $_product_view_list->DisplayRecs, $_product_view_list->TotalRecs, $_product_view_list->AutoHidePager) ?>
<?php if ($_product_view_list->Pager->RecordCount > 0 && $_product_view_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_product_view_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_product_view_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_product_view_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_product_view_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_product_view_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_product_view_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_product_view_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_product_view_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_product_view_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_product_view_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_product_view_list->TotalRecs > 0 && (!$_product_view_list->AutoHidePageSizeSelector || $_product_view_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_product_view">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_product_view_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_product_view_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_product_view_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_product_view_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_product_view_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_product_view->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_product_view_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_product_viewlist" id="f_product_viewlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_product_view_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_product_view_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_product_view">
<div id="gmp__product_view" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_product_view_list->TotalRecs > 0 || $_product_view->isGridEdit()) { ?>
<table id="tbl__product_viewlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_product_view_list->RowType = ROWTYPE_HEADER;

// Render list options
$_product_view_list->renderListOptions();

// Render list options (header, left)
$_product_view_list->ListOptions->render("header", "left");
?>
<?php if ($_product_view->id->Visible) { // id ?>
	<?php if ($_product_view->sortUrl($_product_view->id) == "") { ?>
		<th data-name="id" class="<?php echo $_product_view->id->headerCellClass() ?>"><div id="elh__product_view_id" class="_product_view_id"><div class="ew-table-header-caption"><?php echo $_product_view->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $_product_view->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->id) ?>',2);"><div id="elh__product_view_id" class="_product_view_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->grp->Visible) { // grp ?>
	<?php if ($_product_view->sortUrl($_product_view->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $_product_view->grp->headerCellClass() ?>"><div id="elh__product_view_grp" class="_product_view_grp"><div class="ew-table-header-caption"><?php echo $_product_view->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $_product_view->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->grp) ?>',2);"><div id="elh__product_view_grp" class="_product_view_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->s_grp->Visible) { // s_grp ?>
	<?php if ($_product_view->sortUrl($_product_view->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $_product_view->s_grp->headerCellClass() ?>"><div id="elh__product_view_s_grp" class="_product_view_s_grp"><div class="ew-table-header-caption"><?php echo $_product_view->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $_product_view->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->s_grp) ?>',2);"><div id="elh__product_view_s_grp" class="_product_view_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->product->Visible) { // product ?>
	<?php if ($_product_view->sortUrl($_product_view->product) == "") { ?>
		<th data-name="product" class="<?php echo $_product_view->product->headerCellClass() ?>"><div id="elh__product_view_product" class="_product_view_product"><div class="ew-table-header-caption"><?php echo $_product_view->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $_product_view->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->product) ?>',2);"><div id="elh__product_view_product" class="_product_view_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_product_view->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->remarks->Visible) { // remarks ?>
	<?php if ($_product_view->sortUrl($_product_view->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $_product_view->remarks->headerCellClass() ?>"><div id="elh__product_view_remarks" class="_product_view_remarks"><div class="ew-table-header-caption"><?php echo $_product_view->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $_product_view->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->remarks) ?>',2);"><div id="elh__product_view_remarks" class="_product_view_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_product_view->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->status->Visible) { // status ?>
	<?php if ($_product_view->sortUrl($_product_view->status) == "") { ?>
		<th data-name="status" class="<?php echo $_product_view->status->headerCellClass() ?>"><div id="elh__product_view_status" class="_product_view_status"><div class="ew-table-header-caption"><?php echo $_product_view->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $_product_view->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->status) ?>',2);"><div id="elh__product_view_status" class="_product_view_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->company_id->Visible) { // company_id ?>
	<?php if ($_product_view->sortUrl($_product_view->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $_product_view->company_id->headerCellClass() ?>"><div id="elh__product_view_company_id" class="_product_view_company_id"><div class="ew-table-header-caption"><?php echo $_product_view->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $_product_view->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->company_id) ?>',2);"><div id="elh__product_view_company_id" class="_product_view_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->operator->Visible) { // operator ?>
	<?php if ($_product_view->sortUrl($_product_view->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $_product_view->operator->headerCellClass() ?>"><div id="elh__product_view_operator" class="_product_view_operator"><div class="ew-table-header-caption"><?php echo $_product_view->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $_product_view->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->operator) ?>',2);"><div id="elh__product_view_operator" class="_product_view_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_product_view->datetime->Visible) { // datetime ?>
	<?php if ($_product_view->sortUrl($_product_view->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $_product_view->datetime->headerCellClass() ?>"><div id="elh__product_view_datetime" class="_product_view_datetime"><div class="ew-table-header-caption"><?php echo $_product_view->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $_product_view->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_product_view->SortUrl($_product_view->datetime) ?>',2);"><div id="elh__product_view_datetime" class="_product_view_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_product_view->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($_product_view->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_product_view->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_product_view_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_product_view->ExportAll && $_product_view->isExport()) {
	$_product_view_list->StopRec = $_product_view_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_product_view_list->TotalRecs > $_product_view_list->StartRec + $_product_view_list->DisplayRecs - 1)
		$_product_view_list->StopRec = $_product_view_list->StartRec + $_product_view_list->DisplayRecs - 1;
	else
		$_product_view_list->StopRec = $_product_view_list->TotalRecs;
}
$_product_view_list->RecCnt = $_product_view_list->StartRec - 1;
if ($_product_view_list->Recordset && !$_product_view_list->Recordset->EOF) {
	$_product_view_list->Recordset->moveFirst();
	$selectLimit = $_product_view_list->UseSelectLimit;
	if (!$selectLimit && $_product_view_list->StartRec > 1)
		$_product_view_list->Recordset->move($_product_view_list->StartRec - 1);
} elseif (!$_product_view->AllowAddDeleteRow && $_product_view_list->StopRec == 0) {
	$_product_view_list->StopRec = $_product_view->GridAddRowCount;
}

// Initialize aggregate
$_product_view->RowType = ROWTYPE_AGGREGATEINIT;
$_product_view->resetAttributes();
$_product_view_list->renderRow();
while ($_product_view_list->RecCnt < $_product_view_list->StopRec) {
	$_product_view_list->RecCnt++;
	if ($_product_view_list->RecCnt >= $_product_view_list->StartRec) {
		$_product_view_list->RowCnt++;

		// Set up key count
		$_product_view_list->KeyCount = $_product_view_list->RowIndex;

		// Init row class and style
		$_product_view->resetAttributes();
		$_product_view->CssClass = "";
		if ($_product_view->isGridAdd()) {
		} else {
			$_product_view_list->loadRowValues($_product_view_list->Recordset); // Load row values
		}
		$_product_view->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_product_view->RowAttrs = array_merge($_product_view->RowAttrs, array('data-rowindex'=>$_product_view_list->RowCnt, 'id'=>'r' . $_product_view_list->RowCnt . '__product_view', 'data-rowtype'=>$_product_view->RowType));

		// Render row
		$_product_view_list->renderRow();

		// Render list options
		$_product_view_list->renderListOptions();
?>
	<tr<?php echo $_product_view->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_product_view_list->ListOptions->render("body", "left", $_product_view_list->RowCnt);
?>
	<?php if ($_product_view->id->Visible) { // id ?>
		<td data-name="id"<?php echo $_product_view->id->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_id" class="_product_view_id">
<span<?php echo $_product_view->id->viewAttributes() ?>>
<?php echo $_product_view->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $_product_view->grp->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_grp" class="_product_view_grp">
<span<?php echo $_product_view->grp->viewAttributes() ?>>
<?php echo $_product_view->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $_product_view->s_grp->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_s_grp" class="_product_view_s_grp">
<span<?php echo $_product_view->s_grp->viewAttributes() ?>>
<?php echo $_product_view->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->product->Visible) { // product ?>
		<td data-name="product"<?php echo $_product_view->product->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_product" class="_product_view_product">
<span<?php echo $_product_view->product->viewAttributes() ?>>
<?php echo $_product_view->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $_product_view->remarks->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_remarks" class="_product_view_remarks">
<span<?php echo $_product_view->remarks->viewAttributes() ?>>
<?php echo $_product_view->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->status->Visible) { // status ?>
		<td data-name="status"<?php echo $_product_view->status->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_status" class="_product_view_status">
<span<?php echo $_product_view->status->viewAttributes() ?>>
<?php echo $_product_view->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $_product_view->company_id->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_company_id" class="_product_view_company_id">
<span<?php echo $_product_view->company_id->viewAttributes() ?>>
<?php echo $_product_view->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $_product_view->operator->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_operator" class="_product_view_operator">
<span<?php echo $_product_view->operator->viewAttributes() ?>>
<?php echo $_product_view->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_product_view->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $_product_view->datetime->cellAttributes() ?>>
<span id="el<?php echo $_product_view_list->RowCnt ?>__product_view_datetime" class="_product_view_datetime">
<span<?php echo $_product_view->datetime->viewAttributes() ?>>
<?php echo $_product_view->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_product_view_list->ListOptions->render("body", "right", $_product_view_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_product_view->isGridAdd())
		$_product_view_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_product_view->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_product_view_list->Recordset)
	$_product_view_list->Recordset->Close();
?>
<?php if (!$_product_view->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_product_view->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_product_view_list->Pager)) $_product_view_list->Pager = new PrevNextPager($_product_view_list->StartRec, $_product_view_list->DisplayRecs, $_product_view_list->TotalRecs, $_product_view_list->AutoHidePager) ?>
<?php if ($_product_view_list->Pager->RecordCount > 0 && $_product_view_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_product_view_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_product_view_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_product_view_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_product_view_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_product_view_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_product_view_list->pageUrl() ?>start=<?php echo $_product_view_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_product_view_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_product_view_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_product_view_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_product_view_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_product_view_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_product_view_list->TotalRecs > 0 && (!$_product_view_list->AutoHidePageSizeSelector || $_product_view_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_product_view">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_product_view_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_product_view_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_product_view_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_product_view_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_product_view_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_product_view->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_product_view_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_product_view_list->TotalRecs == 0 && !$_product_view->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_product_view_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_product_view_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_product_view->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_product_view->isExport()) { ?>
<script>
ew.scrollableTable("gmp__product_view", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_product_view_list->terminate();
?>