<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_ref_view_list = new _ref_view_list();

// Run the page
$_ref_view_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_ref_view_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_ref_view->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_ref_viewlist = currentForm = new ew.Form("f_ref_viewlist", "list");
f_ref_viewlist.formKeyCountName = '<?php echo $_ref_view_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_ref_viewlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_ref_viewlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_ref_viewlist.lists["x_product"] = <?php echo $_ref_view_list->product->Lookup->toClientList() ?>;
f_ref_viewlist.lists["x_product"].options = <?php echo JsonEncode($_ref_view_list->product->lookupOptions()) ?>;
f_ref_viewlist.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
f_ref_viewlist.lists["x_company_id"] = <?php echo $_ref_view_list->company_id->Lookup->toClientList() ?>;
f_ref_viewlist.lists["x_company_id"].options = <?php echo JsonEncode($_ref_view_list->company_id->lookupOptions()) ?>;
f_ref_viewlist.lists["x_product_type"] = <?php echo $_ref_view_list->product_type->Lookup->toClientList() ?>;
f_ref_viewlist.lists["x_product_type"].options = <?php echo JsonEncode($_ref_view_list->product_type->lookupOptions()) ?>;
f_ref_viewlist.autoSuggests["x_product_type"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var f_ref_viewlistsrch = currentSearchForm = new ew.Form("f_ref_viewlistsrch");

// Validate function for search
f_ref_viewlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
f_ref_viewlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_ref_viewlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_ref_viewlistsrch.lists["x_product"] = <?php echo $_ref_view_list->product->Lookup->toClientList() ?>;
f_ref_viewlistsrch.lists["x_product"].options = <?php echo JsonEncode($_ref_view_list->product->lookupOptions()) ?>;
f_ref_viewlistsrch.autoSuggests["x_product"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
f_ref_viewlistsrch.filterList = <?php echo $_ref_view_list->getFilterList() ?>;

// Init search panel as collapsed
f_ref_viewlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_ref_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_ref_view_list->TotalRecs > 0 && $_ref_view_list->ExportOptions->visible()) { ?>
<?php $_ref_view_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_ref_view_list->ImportOptions->visible()) { ?>
<?php $_ref_view_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_ref_view_list->SearchOptions->visible()) { ?>
<?php $_ref_view_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_ref_view_list->FilterOptions->visible()) { ?>
<?php $_ref_view_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$_ref_view->isExport() || EXPORT_MASTER_RECORD && $_ref_view->isExport("print")) { ?>
<?php
if ($_ref_view_list->DbMasterFilter <> "" && $_ref_view->getCurrentMasterTable() == "ref_multi") {
	if ($_ref_view_list->MasterRecordExists) {
		include_once "ref_multimaster.php";
	}
}
?>
<?php } ?>
<?php
$_ref_view_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_ref_view->isExport() && !$_ref_view->CurrentAction) { ?>
<form name="f_ref_viewlistsrch" id="f_ref_viewlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_ref_view_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="f_ref_viewlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_ref_view">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$_ref_view_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$_ref_view->RowType = ROWTYPE_SEARCH;

// Render row
$_ref_view->resetAttributes();
$_ref_view_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($_ref_view->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $_ref_view->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product" id="z_product" value="LIKE"></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$_ref_view->product->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$_ref_view->product->EditAttrs["onchange"] = "";
?>
<span id="as_x_product" class="text-nowrap" style="z-index: 8980">
	<input type="text" class="form-control" name="sv_x_product" id="sv_x_product" value="<?php echo RemoveHtml($_ref_view->product->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($_ref_view->product->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($_ref_view->product->getPlaceHolder()) ?>"<?php echo $_ref_view->product->editAttributes() ?>>
</span>
<input type="hidden" data-table="_ref_view" data-field="x_product" data-value-separator="<?php echo $_ref_view->product->displayValueSeparatorAttribute() ?>" name="x_product" id="x_product" value="<?php echo HtmlEncode($_ref_view->product->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
f_ref_viewlistsrch.createAutoSuggest({"id":"x_product","forceSelect":false});
</script>
<?php echo $_ref_view->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($_ref_view->ref_status->Visible) { // ref_status ?>
	<div id="xsc_ref_status" class="ew-cell form-group">
		<label for="x_ref_status" class="ew-search-caption ew-label"><?php echo $_ref_view->ref_status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ref_status" id="z_ref_status" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="_ref_view" data-field="x_ref_status" name="x_ref_status" id="x_ref_status" size="30" maxlength="13" placeholder="<?php echo HtmlEncode($_ref_view->ref_status->getPlaceHolder()) ?>" value="<?php echo $_ref_view->ref_status->EditValue ?>"<?php echo $_ref_view->ref_status->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($_ref_view->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label for="x_product_code" class="ew-search-caption ew-label"><?php echo $_ref_view->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_product_code" id="z_product_code" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="_ref_view" data-field="x_product_code" name="x_product_code" id="x_product_code" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($_ref_view->product_code->getPlaceHolder()) ?>" value="<?php echo $_ref_view->product_code->EditValue ?>"<?php echo $_ref_view->product_code->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_ref_view_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_ref_view_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_ref_view_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_ref_view_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_ref_view_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_ref_view_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_ref_view_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_ref_view_list->showPageHeader(); ?>
<?php
$_ref_view_list->showMessage();
?>
<?php if ($_ref_view_list->TotalRecs > 0 || $_ref_view->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_ref_view_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _ref_view">
<?php if (!$_ref_view->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_ref_view->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_ref_view_list->Pager)) $_ref_view_list->Pager = new PrevNextPager($_ref_view_list->StartRec, $_ref_view_list->DisplayRecs, $_ref_view_list->TotalRecs, $_ref_view_list->AutoHidePager) ?>
<?php if ($_ref_view_list->Pager->RecordCount > 0 && $_ref_view_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_ref_view_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_ref_view_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_ref_view_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_ref_view_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_ref_view_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_ref_view_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_ref_view_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_ref_view_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_ref_view_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_ref_view_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_ref_view_list->TotalRecs > 0 && (!$_ref_view_list->AutoHidePageSizeSelector || $_ref_view_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_ref_view">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_ref_view_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_ref_view_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_ref_view_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_ref_view_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_ref_view_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_ref_view->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_ref_view_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_ref_viewlist" id="f_ref_viewlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_ref_view_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_ref_view_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_ref_view">
<?php if ($_ref_view->getCurrentMasterTable() == "ref_multi" && $_ref_view->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="ref_multi">
<input type="hidden" name="fk_id" value="<?php echo $_ref_view->id->getSessionValue() ?>">
<?php } ?>
<div id="gmp__ref_view" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_ref_view_list->TotalRecs > 0 || $_ref_view->isGridEdit()) { ?>
<table id="tbl__ref_viewlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_ref_view_list->RowType = ROWTYPE_HEADER;

// Render list options
$_ref_view_list->renderListOptions();

// Render list options (header, left)
$_ref_view_list->ListOptions->render("header", "left");
?>
<?php if ($_ref_view->id->Visible) { // id ?>
	<?php if ($_ref_view->sortUrl($_ref_view->id) == "") { ?>
		<th data-name="id" class="<?php echo $_ref_view->id->headerCellClass() ?>"><div id="elh__ref_view_id" class="_ref_view_id"><div class="ew-table-header-caption"><?php echo $_ref_view->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $_ref_view->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->id) ?>',2);"><div id="elh__ref_view_id" class="_ref_view_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_ref_view->product->Visible) { // product ?>
	<?php if ($_ref_view->sortUrl($_ref_view->product) == "") { ?>
		<th data-name="product" class="<?php echo $_ref_view->product->headerCellClass() ?>"><div id="elh__ref_view_product" class="_ref_view_product"><div class="ew-table-header-caption"><?php echo $_ref_view->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $_ref_view->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->product) ?>',2);"><div id="elh__ref_view_product" class="_ref_view_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->product->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_ref_view->product_n->Visible) { // product_n ?>
	<?php if ($_ref_view->sortUrl($_ref_view->product_n) == "") { ?>
		<th data-name="product_n" class="<?php echo $_ref_view->product_n->headerCellClass() ?>"><div id="elh__ref_view_product_n" class="_ref_view_product_n"><div class="ew-table-header-caption"><?php echo $_ref_view->product_n->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_n" class="<?php echo $_ref_view->product_n->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->product_n) ?>',2);"><div id="elh__ref_view_product_n" class="_ref_view_product_n">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->product_n->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->product_n->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->product_n->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_ref_view->ref_status->Visible) { // ref_status ?>
	<?php if ($_ref_view->sortUrl($_ref_view->ref_status) == "") { ?>
		<th data-name="ref_status" class="<?php echo $_ref_view->ref_status->headerCellClass() ?>"><div id="elh__ref_view_ref_status" class="_ref_view_ref_status"><div class="ew-table-header-caption"><?php echo $_ref_view->ref_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref_status" class="<?php echo $_ref_view->ref_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->ref_status) ?>',2);"><div id="elh__ref_view_ref_status" class="_ref_view_ref_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->ref_status->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->ref_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->ref_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_ref_view->product_code->Visible) { // product_code ?>
	<?php if ($_ref_view->sortUrl($_ref_view->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $_ref_view->product_code->headerCellClass() ?>"><div id="elh__ref_view_product_code" class="_ref_view_product_code"><div class="ew-table-header-caption"><?php echo $_ref_view->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $_ref_view->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->product_code) ?>',2);"><div id="elh__ref_view_product_code" class="_ref_view_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_ref_view->company_id->Visible) { // company_id ?>
	<?php if ($_ref_view->sortUrl($_ref_view->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $_ref_view->company_id->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh__ref_view_company_id" class="_ref_view_company_id"><div class="ew-table-header-caption"><?php echo $_ref_view->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $_ref_view->company_id->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->company_id) ?>',2);"><div id="elh__ref_view_company_id" class="_ref_view_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_ref_view->product_type->Visible) { // product_type ?>
	<?php if ($_ref_view->sortUrl($_ref_view->product_type) == "") { ?>
		<th data-name="product_type" class="<?php echo $_ref_view->product_type->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh__ref_view_product_type" class="_ref_view_product_type"><div class="ew-table-header-caption"><?php echo $_ref_view->product_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_type" class="<?php echo $_ref_view->product_type->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_ref_view->SortUrl($_ref_view->product_type) ?>',2);"><div id="elh__ref_view_product_type" class="_ref_view_product_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_ref_view->product_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($_ref_view->product_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_ref_view->product_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_ref_view_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_ref_view->ExportAll && $_ref_view->isExport()) {
	$_ref_view_list->StopRec = $_ref_view_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_ref_view_list->TotalRecs > $_ref_view_list->StartRec + $_ref_view_list->DisplayRecs - 1)
		$_ref_view_list->StopRec = $_ref_view_list->StartRec + $_ref_view_list->DisplayRecs - 1;
	else
		$_ref_view_list->StopRec = $_ref_view_list->TotalRecs;
}
$_ref_view_list->RecCnt = $_ref_view_list->StartRec - 1;
if ($_ref_view_list->Recordset && !$_ref_view_list->Recordset->EOF) {
	$_ref_view_list->Recordset->moveFirst();
	$selectLimit = $_ref_view_list->UseSelectLimit;
	if (!$selectLimit && $_ref_view_list->StartRec > 1)
		$_ref_view_list->Recordset->move($_ref_view_list->StartRec - 1);
} elseif (!$_ref_view->AllowAddDeleteRow && $_ref_view_list->StopRec == 0) {
	$_ref_view_list->StopRec = $_ref_view->GridAddRowCount;
}

// Initialize aggregate
$_ref_view->RowType = ROWTYPE_AGGREGATEINIT;
$_ref_view->resetAttributes();
$_ref_view_list->renderRow();
while ($_ref_view_list->RecCnt < $_ref_view_list->StopRec) {
	$_ref_view_list->RecCnt++;
	if ($_ref_view_list->RecCnt >= $_ref_view_list->StartRec) {
		$_ref_view_list->RowCnt++;

		// Set up key count
		$_ref_view_list->KeyCount = $_ref_view_list->RowIndex;

		// Init row class and style
		$_ref_view->resetAttributes();
		$_ref_view->CssClass = "";
		if ($_ref_view->isGridAdd()) {
		} else {
			$_ref_view_list->loadRowValues($_ref_view_list->Recordset); // Load row values
		}
		$_ref_view->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_ref_view->RowAttrs = array_merge($_ref_view->RowAttrs, array('data-rowindex'=>$_ref_view_list->RowCnt, 'id'=>'r' . $_ref_view_list->RowCnt . '__ref_view', 'data-rowtype'=>$_ref_view->RowType));

		// Render row
		$_ref_view_list->renderRow();

		// Render list options
		$_ref_view_list->renderListOptions();
?>
	<tr<?php echo $_ref_view->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_ref_view_list->ListOptions->render("body", "left", $_ref_view_list->RowCnt);
?>
	<?php if ($_ref_view->id->Visible) { // id ?>
		<td data-name="id"<?php echo $_ref_view->id->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_id" class="_ref_view_id">
<span<?php echo $_ref_view->id->viewAttributes() ?>>
<?php echo $_ref_view->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_ref_view->product->Visible) { // product ?>
		<td data-name="product"<?php echo $_ref_view->product->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_product" class="_ref_view_product">
<span<?php echo $_ref_view->product->viewAttributes() ?>>
<?php if ((!EmptyString($_ref_view->product->getViewValue())) && $_ref_view->product->linkAttributes() <> "") { ?>
<a<?php echo $_ref_view->product->linkAttributes() ?>><?php echo $_ref_view->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_ref_view->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_ref_view->product_n->Visible) { // product_n ?>
		<td data-name="product_n"<?php echo $_ref_view->product_n->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_product_n" class="_ref_view_product_n">
<span<?php echo $_ref_view->product_n->viewAttributes() ?>>
<?php if ((!EmptyString($_ref_view->product_n->getViewValue())) && $_ref_view->product_n->linkAttributes() <> "") { ?>
<a<?php echo $_ref_view->product_n->linkAttributes() ?>><?php echo $_ref_view->product_n->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_ref_view->product_n->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_ref_view->ref_status->Visible) { // ref_status ?>
		<td data-name="ref_status"<?php echo $_ref_view->ref_status->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_ref_status" class="_ref_view_ref_status">
<span<?php echo $_ref_view->ref_status->viewAttributes() ?>>
<?php if ((!EmptyString($_ref_view->ref_status->getViewValue())) && $_ref_view->ref_status->linkAttributes() <> "") { ?>
<a<?php echo $_ref_view->ref_status->linkAttributes() ?>><?php echo $_ref_view->ref_status->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_ref_view->ref_status->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_ref_view->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $_ref_view->product_code->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_product_code" class="_ref_view_product_code">
<span<?php echo $_ref_view->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($_ref_view->product_code->getViewValue())) && $_ref_view->product_code->linkAttributes() <> "") { ?>
<a<?php echo $_ref_view->product_code->linkAttributes() ?>><?php echo $_ref_view->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $_ref_view->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_ref_view->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $_ref_view->company_id->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_company_id" class="_ref_view_company_id">
<span<?php echo $_ref_view->company_id->viewAttributes() ?>>
<?php echo $_ref_view->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_ref_view->product_type->Visible) { // product_type ?>
		<td data-name="product_type"<?php echo $_ref_view->product_type->cellAttributes() ?>>
<span id="el<?php echo $_ref_view_list->RowCnt ?>__ref_view_product_type" class="_ref_view_product_type">
<span<?php echo $_ref_view->product_type->viewAttributes() ?>>
<?php echo $_ref_view->product_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_ref_view_list->ListOptions->render("body", "right", $_ref_view_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_ref_view->isGridAdd())
		$_ref_view_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_ref_view->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_ref_view_list->Recordset)
	$_ref_view_list->Recordset->Close();
?>
<?php if (!$_ref_view->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_ref_view->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_ref_view_list->Pager)) $_ref_view_list->Pager = new PrevNextPager($_ref_view_list->StartRec, $_ref_view_list->DisplayRecs, $_ref_view_list->TotalRecs, $_ref_view_list->AutoHidePager) ?>
<?php if ($_ref_view_list->Pager->RecordCount > 0 && $_ref_view_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_ref_view_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_ref_view_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_ref_view_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_ref_view_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_ref_view_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_ref_view_list->pageUrl() ?>start=<?php echo $_ref_view_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_ref_view_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_ref_view_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_ref_view_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_ref_view_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_ref_view_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_ref_view_list->TotalRecs > 0 && (!$_ref_view_list->AutoHidePageSizeSelector || $_ref_view_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_ref_view">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_ref_view_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_ref_view_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_ref_view_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_ref_view_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_ref_view_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_ref_view->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_ref_view_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_ref_view_list->TotalRecs == 0 && !$_ref_view->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_ref_view_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_ref_view_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_ref_view->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_ref_view->isExport()) { ?>
<script>
ew.scrollableTable("gmp__ref_view", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_ref_view_list->terminate();
?>