<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_t_expenses_info_edit = new _t_expenses_info_edit();

// Run the page
$_t_expenses_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_t_expenses_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var f_t_expenses_infoedit = currentForm = new ew.Form("f_t_expenses_infoedit", "edit");

// Validate form
f_t_expenses_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($_t_expenses_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->id->caption(), $_t_expenses_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_t_expenses_info_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->grp->caption(), $_t_expenses_info->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_t_expenses_info_edit->expense->Required) { ?>
			elm = this.getElements("x" + infix + "_expense");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->expense->caption(), $_t_expenses_info->expense->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_t_expenses_info_edit->image->Required) { ?>
			felm = this.getElements("x" + infix + "_image");
			elm = this.getElements("fn_x" + infix + "_image");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->image->caption(), $_t_expenses_info->image->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_t_expenses_info_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->status->caption(), $_t_expenses_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_t_expenses_info_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->operator->caption(), $_t_expenses_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($_t_expenses_info_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $_t_expenses_info->datetime->caption(), $_t_expenses_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
f_t_expenses_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_t_expenses_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_t_expenses_infoedit.lists["x_grp"] = <?php echo $_t_expenses_info_edit->grp->Lookup->toClientList() ?>;
f_t_expenses_infoedit.lists["x_grp"].options = <?php echo JsonEncode($_t_expenses_info_edit->grp->lookupOptions()) ?>;
f_t_expenses_infoedit.lists["x_status"] = <?php echo $_t_expenses_info_edit->status->Lookup->toClientList() ?>;
f_t_expenses_infoedit.lists["x_status"].options = <?php echo JsonEncode($_t_expenses_info_edit->status->options(FALSE, TRUE)) ?>;
f_t_expenses_infoedit.lists["x_operator"] = <?php echo $_t_expenses_info_edit->operator->Lookup->toClientList() ?>;
f_t_expenses_infoedit.lists["x_operator"].options = <?php echo JsonEncode($_t_expenses_info_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $_t_expenses_info_edit->showPageHeader(); ?>
<?php
$_t_expenses_info_edit->showMessage();
?>
<form name="f_t_expenses_infoedit" id="f_t_expenses_infoedit" class="<?php echo $_t_expenses_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_t_expenses_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_t_expenses_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_t_expenses_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$_t_expenses_info_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($_t_expenses_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh__t_expenses_info_id" class="<?php echo $_t_expenses_info_edit->LeftColumnClass ?>"><?php echo $_t_expenses_info->id->caption() ?><?php echo ($_t_expenses_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_t_expenses_info_edit->RightColumnClass ?>"><div<?php echo $_t_expenses_info->id->cellAttributes() ?>>
<span id="el__t_expenses_info_id">
<span<?php echo $_t_expenses_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($_t_expenses_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="_t_expenses_info" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($_t_expenses_info->id->CurrentValue) ?>">
<?php echo $_t_expenses_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_t_expenses_info->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh__t_expenses_info_grp" for="x_grp" class="<?php echo $_t_expenses_info_edit->LeftColumnClass ?>"><?php echo $_t_expenses_info->grp->caption() ?><?php echo ($_t_expenses_info->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_t_expenses_info_edit->RightColumnClass ?>"><div<?php echo $_t_expenses_info->grp->cellAttributes() ?>>
<span id="el__t_expenses_info_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_t_expenses_info" data-field="x_grp" data-value-separator="<?php echo $_t_expenses_info->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $_t_expenses_info->grp->editAttributes() ?>>
		<?php echo $_t_expenses_info->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $_t_expenses_info->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $_t_expenses_info->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_t_expenses_info->expense->Visible) { // expense ?>
	<div id="r_expense" class="form-group row">
		<label id="elh__t_expenses_info_expense" for="x_expense" class="<?php echo $_t_expenses_info_edit->LeftColumnClass ?>"><?php echo $_t_expenses_info->expense->caption() ?><?php echo ($_t_expenses_info->expense->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_t_expenses_info_edit->RightColumnClass ?>"><div<?php echo $_t_expenses_info->expense->cellAttributes() ?>>
<span id="el__t_expenses_info_expense">
<input type="text" data-table="_t_expenses_info" data-field="x_expense" name="x_expense" id="x_expense" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($_t_expenses_info->expense->getPlaceHolder()) ?>" value="<?php echo $_t_expenses_info->expense->EditValue ?>"<?php echo $_t_expenses_info->expense->editAttributes() ?>>
</span>
<?php echo $_t_expenses_info->expense->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_t_expenses_info->image->Visible) { // image ?>
	<div id="r_image" class="form-group row">
		<label id="elh__t_expenses_info_image" class="<?php echo $_t_expenses_info_edit->LeftColumnClass ?>"><?php echo $_t_expenses_info->image->caption() ?><?php echo ($_t_expenses_info->image->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_t_expenses_info_edit->RightColumnClass ?>"><div<?php echo $_t_expenses_info->image->cellAttributes() ?>>
<span id="el__t_expenses_info_image">
<div id="fd_x_image">
<span title="<?php echo $_t_expenses_info->image->title() ? $_t_expenses_info->image->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($_t_expenses_info->image->ReadOnly || $_t_expenses_info->image->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="_t_expenses_info" data-field="x_image" name="x_image" id="x_image"<?php echo $_t_expenses_info->image->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?php echo $_t_expenses_info->image->Upload->FileName ?>">
<?php if (Post("fa_x_image") == "0") { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="1">
<?php } ?>
<input type="hidden" name="fs_x_image" id= "fs_x_image" value="16777215">
<input type="hidden" name="fx_x_image" id= "fx_x_image" value="<?php echo $_t_expenses_info->image->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_image" id= "fm_x_image" value="<?php echo $_t_expenses_info->image->UploadMaxFileSize ?>">
</div>
<table id="ft_x_image" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $_t_expenses_info->image->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($_t_expenses_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh__t_expenses_info_status" for="x_status" class="<?php echo $_t_expenses_info_edit->LeftColumnClass ?>"><?php echo $_t_expenses_info->status->caption() ?><?php echo ($_t_expenses_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $_t_expenses_info_edit->RightColumnClass ?>"><div<?php echo $_t_expenses_info->status->cellAttributes() ?>>
<span id="el__t_expenses_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="_t_expenses_info" data-field="x_status" data-value-separator="<?php echo $_t_expenses_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $_t_expenses_info->status->editAttributes() ?>>
		<?php echo $_t_expenses_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $_t_expenses_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$_t_expenses_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $_t_expenses_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $_t_expenses_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$_t_expenses_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$_t_expenses_info_edit->terminate();
?>