<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$_t_expenses_info_list = new _t_expenses_info_list();

// Run the page
$_t_expenses_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$_t_expenses_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$_t_expenses_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var f_t_expenses_infolist = currentForm = new ew.Form("f_t_expenses_infolist", "list");
f_t_expenses_infolist.formKeyCountName = '<?php echo $_t_expenses_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
f_t_expenses_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
f_t_expenses_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
f_t_expenses_infolist.lists["x_grp"] = <?php echo $_t_expenses_info_list->grp->Lookup->toClientList() ?>;
f_t_expenses_infolist.lists["x_grp"].options = <?php echo JsonEncode($_t_expenses_info_list->grp->lookupOptions()) ?>;
f_t_expenses_infolist.lists["x_status"] = <?php echo $_t_expenses_info_list->status->Lookup->toClientList() ?>;
f_t_expenses_infolist.lists["x_status"].options = <?php echo JsonEncode($_t_expenses_info_list->status->options(FALSE, TRUE)) ?>;
f_t_expenses_infolist.lists["x_operator"] = <?php echo $_t_expenses_info_list->operator->Lookup->toClientList() ?>;
f_t_expenses_infolist.lists["x_operator"].options = <?php echo JsonEncode($_t_expenses_info_list->operator->lookupOptions()) ?>;

// Form object for search
var f_t_expenses_infolistsrch = currentSearchForm = new ew.Form("f_t_expenses_infolistsrch");

// Filters
f_t_expenses_infolistsrch.filterList = <?php echo $_t_expenses_info_list->getFilterList() ?>;

// Init search panel as collapsed
f_t_expenses_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$_t_expenses_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($_t_expenses_info_list->TotalRecs > 0 && $_t_expenses_info_list->ExportOptions->visible()) { ?>
<?php $_t_expenses_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($_t_expenses_info_list->ImportOptions->visible()) { ?>
<?php $_t_expenses_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($_t_expenses_info_list->SearchOptions->visible()) { ?>
<?php $_t_expenses_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($_t_expenses_info_list->FilterOptions->visible()) { ?>
<?php $_t_expenses_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$_t_expenses_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$_t_expenses_info->isExport() && !$_t_expenses_info->CurrentAction) { ?>
<form name="f_t_expenses_infolistsrch" id="f_t_expenses_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($_t_expenses_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="f_t_expenses_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="_t_expenses_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($_t_expenses_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($_t_expenses_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $_t_expenses_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($_t_expenses_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($_t_expenses_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($_t_expenses_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($_t_expenses_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $_t_expenses_info_list->showPageHeader(); ?>
<?php
$_t_expenses_info_list->showMessage();
?>
<?php if ($_t_expenses_info_list->TotalRecs > 0 || $_t_expenses_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($_t_expenses_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> _t_expenses_info">
<?php if (!$_t_expenses_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$_t_expenses_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_t_expenses_info_list->Pager)) $_t_expenses_info_list->Pager = new PrevNextPager($_t_expenses_info_list->StartRec, $_t_expenses_info_list->DisplayRecs, $_t_expenses_info_list->TotalRecs, $_t_expenses_info_list->AutoHidePager) ?>
<?php if ($_t_expenses_info_list->Pager->RecordCount > 0 && $_t_expenses_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_t_expenses_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_t_expenses_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_t_expenses_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_t_expenses_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_t_expenses_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_t_expenses_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_t_expenses_info_list->TotalRecs > 0 && (!$_t_expenses_info_list->AutoHidePageSizeSelector || $_t_expenses_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_t_expenses_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_t_expenses_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_t_expenses_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_t_expenses_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_t_expenses_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_t_expenses_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_t_expenses_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_t_expenses_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="f_t_expenses_infolist" id="f_t_expenses_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($_t_expenses_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $_t_expenses_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="_t_expenses_info">
<div id="gmp__t_expenses_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($_t_expenses_info_list->TotalRecs > 0 || $_t_expenses_info->isGridEdit()) { ?>
<table id="tbl__t_expenses_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$_t_expenses_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$_t_expenses_info_list->renderListOptions();

// Render list options (header, left)
$_t_expenses_info_list->ListOptions->render("header", "left");
?>
<?php if ($_t_expenses_info->id->Visible) { // id ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $_t_expenses_info->id->headerCellClass() ?>"><div id="elh__t_expenses_info_id" class="_t_expenses_info_id"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $_t_expenses_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->id) ?>',2);"><div id="elh__t_expenses_info_id" class="_t_expenses_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_t_expenses_info->grp->Visible) { // grp ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $_t_expenses_info->grp->headerCellClass() ?>"><div id="elh__t_expenses_info_grp" class="_t_expenses_info_grp"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $_t_expenses_info->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->grp) ?>',2);"><div id="elh__t_expenses_info_grp" class="_t_expenses_info_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_t_expenses_info->expense->Visible) { // expense ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->expense) == "") { ?>
		<th data-name="expense" class="<?php echo $_t_expenses_info->expense->headerCellClass() ?>"><div id="elh__t_expenses_info_expense" class="_t_expenses_info_expense"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->expense->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="expense" class="<?php echo $_t_expenses_info->expense->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->expense) ?>',2);"><div id="elh__t_expenses_info_expense" class="_t_expenses_info_expense">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->expense->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->expense->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->expense->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_t_expenses_info->image->Visible) { // image ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->image) == "") { ?>
		<th data-name="image" class="<?php echo $_t_expenses_info->image->headerCellClass() ?>"><div id="elh__t_expenses_info_image" class="_t_expenses_info_image"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->image->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="image" class="<?php echo $_t_expenses_info->image->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->image) ?>',2);"><div id="elh__t_expenses_info_image" class="_t_expenses_info_image">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->image->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->image->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->image->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_t_expenses_info->status->Visible) { // status ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $_t_expenses_info->status->headerCellClass() ?>"><div id="elh__t_expenses_info_status" class="_t_expenses_info_status"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $_t_expenses_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->status) ?>',2);"><div id="elh__t_expenses_info_status" class="_t_expenses_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_t_expenses_info->operator->Visible) { // operator ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $_t_expenses_info->operator->headerCellClass() ?>"><div id="elh__t_expenses_info_operator" class="_t_expenses_info_operator"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $_t_expenses_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->operator) ?>',2);"><div id="elh__t_expenses_info_operator" class="_t_expenses_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($_t_expenses_info->datetime->Visible) { // datetime ?>
	<?php if ($_t_expenses_info->sortUrl($_t_expenses_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $_t_expenses_info->datetime->headerCellClass() ?>"><div id="elh__t_expenses_info_datetime" class="_t_expenses_info_datetime"><div class="ew-table-header-caption"><?php echo $_t_expenses_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $_t_expenses_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $_t_expenses_info->SortUrl($_t_expenses_info->datetime) ?>',2);"><div id="elh__t_expenses_info_datetime" class="_t_expenses_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $_t_expenses_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($_t_expenses_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($_t_expenses_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$_t_expenses_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($_t_expenses_info->ExportAll && $_t_expenses_info->isExport()) {
	$_t_expenses_info_list->StopRec = $_t_expenses_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($_t_expenses_info_list->TotalRecs > $_t_expenses_info_list->StartRec + $_t_expenses_info_list->DisplayRecs - 1)
		$_t_expenses_info_list->StopRec = $_t_expenses_info_list->StartRec + $_t_expenses_info_list->DisplayRecs - 1;
	else
		$_t_expenses_info_list->StopRec = $_t_expenses_info_list->TotalRecs;
}
$_t_expenses_info_list->RecCnt = $_t_expenses_info_list->StartRec - 1;
if ($_t_expenses_info_list->Recordset && !$_t_expenses_info_list->Recordset->EOF) {
	$_t_expenses_info_list->Recordset->moveFirst();
	$selectLimit = $_t_expenses_info_list->UseSelectLimit;
	if (!$selectLimit && $_t_expenses_info_list->StartRec > 1)
		$_t_expenses_info_list->Recordset->move($_t_expenses_info_list->StartRec - 1);
} elseif (!$_t_expenses_info->AllowAddDeleteRow && $_t_expenses_info_list->StopRec == 0) {
	$_t_expenses_info_list->StopRec = $_t_expenses_info->GridAddRowCount;
}

// Initialize aggregate
$_t_expenses_info->RowType = ROWTYPE_AGGREGATEINIT;
$_t_expenses_info->resetAttributes();
$_t_expenses_info_list->renderRow();
while ($_t_expenses_info_list->RecCnt < $_t_expenses_info_list->StopRec) {
	$_t_expenses_info_list->RecCnt++;
	if ($_t_expenses_info_list->RecCnt >= $_t_expenses_info_list->StartRec) {
		$_t_expenses_info_list->RowCnt++;

		// Set up key count
		$_t_expenses_info_list->KeyCount = $_t_expenses_info_list->RowIndex;

		// Init row class and style
		$_t_expenses_info->resetAttributes();
		$_t_expenses_info->CssClass = "";
		if ($_t_expenses_info->isGridAdd()) {
		} else {
			$_t_expenses_info_list->loadRowValues($_t_expenses_info_list->Recordset); // Load row values
		}
		$_t_expenses_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$_t_expenses_info->RowAttrs = array_merge($_t_expenses_info->RowAttrs, array('data-rowindex'=>$_t_expenses_info_list->RowCnt, 'id'=>'r' . $_t_expenses_info_list->RowCnt . '__t_expenses_info', 'data-rowtype'=>$_t_expenses_info->RowType));

		// Render row
		$_t_expenses_info_list->renderRow();

		// Render list options
		$_t_expenses_info_list->renderListOptions();
?>
	<tr<?php echo $_t_expenses_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$_t_expenses_info_list->ListOptions->render("body", "left", $_t_expenses_info_list->RowCnt);
?>
	<?php if ($_t_expenses_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $_t_expenses_info->id->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_id" class="_t_expenses_info_id">
<span<?php echo $_t_expenses_info->id->viewAttributes() ?>>
<?php echo $_t_expenses_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_t_expenses_info->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $_t_expenses_info->grp->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_grp" class="_t_expenses_info_grp">
<span<?php echo $_t_expenses_info->grp->viewAttributes() ?>>
<?php echo $_t_expenses_info->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_t_expenses_info->expense->Visible) { // expense ?>
		<td data-name="expense"<?php echo $_t_expenses_info->expense->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_expense" class="_t_expenses_info_expense">
<span<?php echo $_t_expenses_info->expense->viewAttributes() ?>>
<?php echo $_t_expenses_info->expense->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_t_expenses_info->image->Visible) { // image ?>
		<td data-name="image"<?php echo $_t_expenses_info->image->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_image" class="_t_expenses_info_image">
<span>
<?php echo GetFileViewTag($_t_expenses_info->image, $_t_expenses_info->image->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($_t_expenses_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $_t_expenses_info->status->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_status" class="_t_expenses_info_status">
<span<?php echo $_t_expenses_info->status->viewAttributes() ?>>
<?php echo $_t_expenses_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_t_expenses_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $_t_expenses_info->operator->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_operator" class="_t_expenses_info_operator">
<span<?php echo $_t_expenses_info->operator->viewAttributes() ?>>
<?php echo $_t_expenses_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($_t_expenses_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $_t_expenses_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $_t_expenses_info_list->RowCnt ?>__t_expenses_info_datetime" class="_t_expenses_info_datetime">
<span<?php echo $_t_expenses_info->datetime->viewAttributes() ?>>
<?php echo $_t_expenses_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$_t_expenses_info_list->ListOptions->render("body", "right", $_t_expenses_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$_t_expenses_info->isGridAdd())
		$_t_expenses_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$_t_expenses_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($_t_expenses_info_list->Recordset)
	$_t_expenses_info_list->Recordset->Close();
?>
<?php if (!$_t_expenses_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$_t_expenses_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($_t_expenses_info_list->Pager)) $_t_expenses_info_list->Pager = new PrevNextPager($_t_expenses_info_list->StartRec, $_t_expenses_info_list->DisplayRecs, $_t_expenses_info_list->TotalRecs, $_t_expenses_info_list->AutoHidePager) ?>
<?php if ($_t_expenses_info_list->Pager->RecordCount > 0 && $_t_expenses_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($_t_expenses_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($_t_expenses_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $_t_expenses_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($_t_expenses_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($_t_expenses_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $_t_expenses_info_list->pageUrl() ?>start=<?php echo $_t_expenses_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($_t_expenses_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $_t_expenses_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($_t_expenses_info_list->TotalRecs > 0 && (!$_t_expenses_info_list->AutoHidePageSizeSelector || $_t_expenses_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="_t_expenses_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($_t_expenses_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($_t_expenses_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($_t_expenses_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($_t_expenses_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($_t_expenses_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($_t_expenses_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $_t_expenses_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($_t_expenses_info_list->TotalRecs == 0 && !$_t_expenses_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $_t_expenses_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$_t_expenses_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$_t_expenses_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$_t_expenses_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp__t_expenses_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$_t_expenses_info_list->terminate();
?>