<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_grp_list = new account_grp_list();

// Run the page
$account_grp_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_grp_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$account_grp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var faccount_grplist = currentForm = new ew.Form("faccount_grplist", "list");
faccount_grplist.formKeyCountName = '<?php echo $account_grp_list->FormKeyCountName ?>';

// Form_CustomValidate event
faccount_grplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_grplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_grplist.lists["x_grp"] = <?php echo $account_grp_list->grp->Lookup->toClientList() ?>;
faccount_grplist.lists["x_grp"].options = <?php echo JsonEncode($account_grp_list->grp->lookupOptions()) ?>;
faccount_grplist.lists["x_status"] = <?php echo $account_grp_list->status->Lookup->toClientList() ?>;
faccount_grplist.lists["x_status"].options = <?php echo JsonEncode($account_grp_list->status->options(FALSE, TRUE)) ?>;
faccount_grplist.lists["x_operator"] = <?php echo $account_grp_list->operator->Lookup->toClientList() ?>;
faccount_grplist.lists["x_operator"].options = <?php echo JsonEncode($account_grp_list->operator->lookupOptions()) ?>;

// Form object for search
var faccount_grplistsrch = currentSearchForm = new ew.Form("faccount_grplistsrch");

// Validate function for search
faccount_grplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_grp->balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
faccount_grplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_grplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_grplistsrch.lists["x_grp"] = <?php echo $account_grp_list->grp->Lookup->toClientList() ?>;
faccount_grplistsrch.lists["x_grp"].options = <?php echo JsonEncode($account_grp_list->grp->lookupOptions()) ?>;

// Filters
faccount_grplistsrch.filterList = <?php echo $account_grp_list->getFilterList() ?>;

// Init search panel as collapsed
faccount_grplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$account_grp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($account_grp_list->TotalRecs > 0 && $account_grp_list->ExportOptions->visible()) { ?>
<?php $account_grp_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($account_grp_list->ImportOptions->visible()) { ?>
<?php $account_grp_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($account_grp_list->SearchOptions->visible()) { ?>
<?php $account_grp_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($account_grp_list->FilterOptions->visible()) { ?>
<?php $account_grp_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$account_grp->isExport() || EXPORT_MASTER_RECORD && $account_grp->isExport("print")) { ?>
<?php
if ($account_grp_list->DbMasterFilter <> "" && $account_grp->getCurrentMasterTable() == "account_grp") {
	if ($account_grp_list->MasterRecordExists) {
		include_once "account_grpmaster.php";
	}
}
?>
<?php } ?>
<?php
$account_grp_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$account_grp->isExport() && !$account_grp->CurrentAction) { ?>
<form name="faccount_grplistsrch" id="faccount_grplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($account_grp_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="faccount_grplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="account_grp">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$account_grp_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$account_grp->RowType = ROWTYPE_SEARCH;

// Render row
$account_grp->resetAttributes();
$account_grp_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($account_grp->item->Visible) { // item ?>
	<div id="xsc_item" class="ew-cell form-group">
		<label for="x_item" class="ew-search-caption ew-label"><?php echo $account_grp->item->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="account_grp" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($account_grp->item->getPlaceHolder()) ?>" value="<?php echo $account_grp->item->EditValue ?>"<?php echo $account_grp->item->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($account_grp->balance->Visible) { // balance ?>
	<div id="xsc_balance" class="ew-cell form-group">
		<label for="x_balance" class="ew-search-caption ew-label"><?php echo $account_grp->balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="account_grp" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($account_grp->balance->getPlaceHolder()) ?>" value="<?php echo $account_grp->balance->EditValue ?>"<?php echo $account_grp->balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_balance style="d-none"">
<input type="text" data-table="account_grp" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($account_grp->balance->getPlaceHolder()) ?>" value="<?php echo $account_grp->balance->EditValue2 ?>"<?php echo $account_grp->balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($account_grp->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label for="x_grp" class="ew-search-caption ew-label"><?php echo $account_grp->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_grp" data-field="x_grp" data-value-separator="<?php echo $account_grp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $account_grp->grp->editAttributes() ?>>
		<?php echo $account_grp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $account_grp->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($account_grp_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($account_grp_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $account_grp_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($account_grp_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($account_grp_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($account_grp_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($account_grp_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $account_grp_list->showPageHeader(); ?>
<?php
$account_grp_list->showMessage();
?>
<?php if ($account_grp_list->TotalRecs > 0 || $account_grp->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($account_grp_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> account_grp">
<?php if (!$account_grp->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$account_grp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($account_grp_list->Pager)) $account_grp_list->Pager = new PrevNextPager($account_grp_list->StartRec, $account_grp_list->DisplayRecs, $account_grp_list->TotalRecs, $account_grp_list->AutoHidePager) ?>
<?php if ($account_grp_list->Pager->RecordCount > 0 && $account_grp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($account_grp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($account_grp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $account_grp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($account_grp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($account_grp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $account_grp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($account_grp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $account_grp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $account_grp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $account_grp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($account_grp_list->TotalRecs > 0 && (!$account_grp_list->AutoHidePageSizeSelector || $account_grp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="account_grp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($account_grp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($account_grp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($account_grp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($account_grp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($account_grp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($account_grp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $account_grp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="faccount_grplist" id="faccount_grplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_grp_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_grp_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_grp">
<?php if ($account_grp->getCurrentMasterTable() == "account_grp" && $account_grp->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="account_grp">
<input type="hidden" name="fk_id" value="<?php echo $account_grp->grp->getSessionValue() ?>">
<?php } ?>
<div id="gmp_account_grp" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($account_grp_list->TotalRecs > 0 || $account_grp->isGridEdit()) { ?>
<table id="tbl_account_grplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$account_grp_list->RowType = ROWTYPE_HEADER;

// Render list options
$account_grp_list->renderListOptions();

// Render list options (header, left)
$account_grp_list->ListOptions->render("header", "left");
?>
<?php if ($account_grp->id_s->Visible) { // id_s ?>
	<?php if ($account_grp->sortUrl($account_grp->id_s) == "") { ?>
		<th data-name="id_s" class="<?php echo $account_grp->id_s->headerCellClass() ?>"><div id="elh_account_grp_id_s" class="account_grp_id_s"><div class="ew-table-header-caption"><?php echo $account_grp->id_s->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id_s" class="<?php echo $account_grp->id_s->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->id_s) ?>',2);"><div id="elh_account_grp_id_s" class="account_grp_id_s">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->id_s->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_grp->id_s->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->id_s->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->item->Visible) { // item ?>
	<?php if ($account_grp->sortUrl($account_grp->item) == "") { ?>
		<th data-name="item" class="<?php echo $account_grp->item->headerCellClass() ?>"><div id="elh_account_grp_item" class="account_grp_item"><div class="ew-table-header-caption"><?php echo $account_grp->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $account_grp->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->item) ?>',2);"><div id="elh_account_grp_item" class="account_grp_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_grp->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->balance->Visible) { // balance ?>
	<?php if ($account_grp->sortUrl($account_grp->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $account_grp->balance->headerCellClass() ?>"><div id="elh_account_grp_balance" class="account_grp_balance"><div class="ew-table-header-caption"><?php echo $account_grp->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $account_grp->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->balance) ?>',2);"><div id="elh_account_grp_balance" class="account_grp_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->grp->Visible) { // grp ?>
	<?php if ($account_grp->sortUrl($account_grp->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $account_grp->grp->headerCellClass() ?>"><div id="elh_account_grp_grp" class="account_grp_grp"><div class="ew-table-header-caption"><?php echo $account_grp->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $account_grp->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->grp) ?>',2);"><div id="elh_account_grp_grp" class="account_grp_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->status->Visible) { // status ?>
	<?php if ($account_grp->sortUrl($account_grp->status) == "") { ?>
		<th data-name="status" class="<?php echo $account_grp->status->headerCellClass() ?>"><div id="elh_account_grp_status" class="account_grp_status"><div class="ew-table-header-caption"><?php echo $account_grp->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $account_grp->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->status) ?>',2);"><div id="elh_account_grp_status" class="account_grp_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->operator->Visible) { // operator ?>
	<?php if ($account_grp->sortUrl($account_grp->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $account_grp->operator->headerCellClass() ?>"><div id="elh_account_grp_operator" class="account_grp_operator"><div class="ew-table-header-caption"><?php echo $account_grp->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $account_grp->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->operator) ?>',2);"><div id="elh_account_grp_operator" class="account_grp_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->datetime->Visible) { // datetime ?>
	<?php if ($account_grp->sortUrl($account_grp->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $account_grp->datetime->headerCellClass() ?>"><div id="elh_account_grp_datetime" class="account_grp_datetime"><div class="ew-table-header-caption"><?php echo $account_grp->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $account_grp->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_grp->SortUrl($account_grp->datetime) ?>',2);"><div id="elh_account_grp_datetime" class="account_grp_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$account_grp_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($account_grp->ExportAll && $account_grp->isExport()) {
	$account_grp_list->StopRec = $account_grp_list->TotalRecs;
} else {

	// Set the last record to display
	if ($account_grp_list->TotalRecs > $account_grp_list->StartRec + $account_grp_list->DisplayRecs - 1)
		$account_grp_list->StopRec = $account_grp_list->StartRec + $account_grp_list->DisplayRecs - 1;
	else
		$account_grp_list->StopRec = $account_grp_list->TotalRecs;
}
$account_grp_list->RecCnt = $account_grp_list->StartRec - 1;
if ($account_grp_list->Recordset && !$account_grp_list->Recordset->EOF) {
	$account_grp_list->Recordset->moveFirst();
	$selectLimit = $account_grp_list->UseSelectLimit;
	if (!$selectLimit && $account_grp_list->StartRec > 1)
		$account_grp_list->Recordset->move($account_grp_list->StartRec - 1);
} elseif (!$account_grp->AllowAddDeleteRow && $account_grp_list->StopRec == 0) {
	$account_grp_list->StopRec = $account_grp->GridAddRowCount;
}

// Initialize aggregate
$account_grp->RowType = ROWTYPE_AGGREGATEINIT;
$account_grp->resetAttributes();
$account_grp_list->renderRow();
while ($account_grp_list->RecCnt < $account_grp_list->StopRec) {
	$account_grp_list->RecCnt++;
	if ($account_grp_list->RecCnt >= $account_grp_list->StartRec) {
		$account_grp_list->RowCnt++;

		// Set up key count
		$account_grp_list->KeyCount = $account_grp_list->RowIndex;

		// Init row class and style
		$account_grp->resetAttributes();
		$account_grp->CssClass = "";
		if ($account_grp->isGridAdd()) {
		} else {
			$account_grp_list->loadRowValues($account_grp_list->Recordset); // Load row values
		}
		$account_grp->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$account_grp->RowAttrs = array_merge($account_grp->RowAttrs, array('data-rowindex'=>$account_grp_list->RowCnt, 'id'=>'r' . $account_grp_list->RowCnt . '_account_grp', 'data-rowtype'=>$account_grp->RowType));

		// Render row
		$account_grp_list->renderRow();

		// Render list options
		$account_grp_list->renderListOptions();
?>
	<tr<?php echo $account_grp->rowAttributes() ?>>
<?php

// Render list options (body, left)
$account_grp_list->ListOptions->render("body", "left", $account_grp_list->RowCnt);
?>
	<?php if ($account_grp->id_s->Visible) { // id_s ?>
		<td data-name="id_s"<?php echo $account_grp->id_s->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_id_s" class="account_grp_id_s">
<span<?php echo $account_grp->id_s->viewAttributes() ?>>
<?php echo $account_grp->id_s->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_grp->item->Visible) { // item ?>
		<td data-name="item"<?php echo $account_grp->item->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_item" class="account_grp_item">
<span<?php echo $account_grp->item->viewAttributes() ?>>
<?php echo $account_grp->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_grp->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $account_grp->balance->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_balance" class="account_grp_balance">
<span<?php echo $account_grp->balance->viewAttributes() ?>>
<?php echo $account_grp->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_grp->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $account_grp->grp->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_grp" class="account_grp_grp">
<span<?php echo $account_grp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($account_grp->grp->getViewValue())) && $account_grp->grp->linkAttributes() <> "") { ?>
<a<?php echo $account_grp->grp->linkAttributes() ?>><?php echo $account_grp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $account_grp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($account_grp->status->Visible) { // status ?>
		<td data-name="status"<?php echo $account_grp->status->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_status" class="account_grp_status">
<span<?php echo $account_grp->status->viewAttributes() ?>>
<?php echo $account_grp->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_grp->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $account_grp->operator->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_operator" class="account_grp_operator">
<span<?php echo $account_grp->operator->viewAttributes() ?>>
<?php echo $account_grp->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_grp->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $account_grp->datetime->cellAttributes() ?>>
<span id="el<?php echo $account_grp_list->RowCnt ?>_account_grp_datetime" class="account_grp_datetime">
<span<?php echo $account_grp->datetime->viewAttributes() ?>>
<?php echo $account_grp->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$account_grp_list->ListOptions->render("body", "right", $account_grp_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$account_grp->isGridAdd())
		$account_grp_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$account_grp->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($account_grp_list->Recordset)
	$account_grp_list->Recordset->Close();
?>
<?php if (!$account_grp->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$account_grp->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($account_grp_list->Pager)) $account_grp_list->Pager = new PrevNextPager($account_grp_list->StartRec, $account_grp_list->DisplayRecs, $account_grp_list->TotalRecs, $account_grp_list->AutoHidePager) ?>
<?php if ($account_grp_list->Pager->RecordCount > 0 && $account_grp_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($account_grp_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($account_grp_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $account_grp_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($account_grp_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($account_grp_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $account_grp_list->pageUrl() ?>start=<?php echo $account_grp_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $account_grp_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($account_grp_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $account_grp_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $account_grp_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $account_grp_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($account_grp_list->TotalRecs > 0 && (!$account_grp_list->AutoHidePageSizeSelector || $account_grp_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="account_grp">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($account_grp_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($account_grp_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($account_grp_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($account_grp_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($account_grp_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($account_grp->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $account_grp_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($account_grp_list->TotalRecs == 0 && !$account_grp->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $account_grp_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$account_grp_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$account_grp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$account_grp->isExport()) { ?>
<script>
ew.scrollableTable("gmp_account_grp", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$account_grp_list->terminate();
?>