<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$account_grp_preview = new account_grp_preview();

// Run the page
$account_grp_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_grp_preview->Page_Render();
?>
<?php $account_grp_preview->showPageHeader(); ?>
<div class="card ew-grid account_grp"><!-- .card -->
<?php if ($account_grp_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$account_grp_preview->renderListOptions();

// Render list options (header, left)
$account_grp_preview->ListOptions->render("header", "left");
?>
<?php if ($account_grp->id_s->Visible) { // id_s ?>
	<?php if ($account_grp->SortUrl($account_grp->id_s) == "") { ?>
		<th class="<?php echo $account_grp->id_s->headerCellClass() ?>"><?php echo $account_grp->id_s->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->id_s->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->id_s->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->id_s->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->id_s->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->id_s->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->item->Visible) { // item ?>
	<?php if ($account_grp->SortUrl($account_grp->item) == "") { ?>
		<th class="<?php echo $account_grp->item->headerCellClass() ?>"><?php echo $account_grp->item->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->item->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->item->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->item->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->item->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->item->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->balance->Visible) { // balance ?>
	<?php if ($account_grp->SortUrl($account_grp->balance) == "") { ?>
		<th class="<?php echo $account_grp->balance->headerCellClass() ?>"><?php echo $account_grp->balance->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->balance->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->balance->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->balance->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->balance->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->grp->Visible) { // grp ?>
	<?php if ($account_grp->SortUrl($account_grp->grp) == "") { ?>
		<th class="<?php echo $account_grp->grp->headerCellClass() ?>"><?php echo $account_grp->grp->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->grp->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->grp->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->grp->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->grp->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->status->Visible) { // status ?>
	<?php if ($account_grp->SortUrl($account_grp->status) == "") { ?>
		<th class="<?php echo $account_grp->status->headerCellClass() ?>"><?php echo $account_grp->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->status->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->status->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->status->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->operator->Visible) { // operator ?>
	<?php if ($account_grp->SortUrl($account_grp->operator) == "") { ?>
		<th class="<?php echo $account_grp->operator->headerCellClass() ?>"><?php echo $account_grp->operator->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->operator->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->operator->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->operator->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->operator->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_grp->datetime->Visible) { // datetime ?>
	<?php if ($account_grp->SortUrl($account_grp->datetime) == "") { ?>
		<th class="<?php echo $account_grp->datetime->headerCellClass() ?>"><?php echo $account_grp->datetime->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_grp->datetime->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_grp->datetime->Name) ?>" data-sort-order="<?php echo $account_grp_preview->SortField == $account_grp->datetime->Name && $account_grp_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_grp->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_grp_preview->SortField == $account_grp->datetime->Name) { ?><?php if ($account_grp_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_grp_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$account_grp_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$account_grp_preview->RecCount = 0;
$account_grp_preview->RowCnt = 0;
while ($account_grp_preview->Recordset && !$account_grp_preview->Recordset->EOF) {

	// Init row class and style
	$account_grp_preview->RecCount++;
	$account_grp_preview->RowCnt++;
	$account_grp_preview->CssStyle = "";
	$account_grp_preview->loadListRowValues($account_grp_preview->Recordset);

	// Render row
	$account_grp_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$account_grp_preview->resetAttributes();
	$account_grp_preview->renderListRow();

	// Render list options
	$account_grp_preview->renderListOptions();
?>
	<tr<?php echo $account_grp_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$account_grp_preview->ListOptions->render("body", "left", $account_grp_preview->RowCnt);
?>
<?php if ($account_grp->id_s->Visible) { // id_s ?>
		<!-- id_s -->
		<td<?php echo $account_grp->id_s->cellAttributes() ?>>
<span<?php echo $account_grp->id_s->viewAttributes() ?>>
<?php echo $account_grp->id_s->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_grp->item->Visible) { // item ?>
		<!-- item -->
		<td<?php echo $account_grp->item->cellAttributes() ?>>
<span<?php echo $account_grp->item->viewAttributes() ?>>
<?php echo $account_grp->item->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_grp->balance->Visible) { // balance ?>
		<!-- balance -->
		<td<?php echo $account_grp->balance->cellAttributes() ?>>
<span<?php echo $account_grp->balance->viewAttributes() ?>>
<?php echo $account_grp->balance->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_grp->grp->Visible) { // grp ?>
		<!-- grp -->
		<td<?php echo $account_grp->grp->cellAttributes() ?>>
<span<?php echo $account_grp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($account_grp->grp->getViewValue())) && $account_grp->grp->linkAttributes() <> "") { ?>
<a<?php echo $account_grp->grp->linkAttributes() ?>><?php echo $account_grp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $account_grp->grp->getViewValue() ?>
<?php } ?>
</span>
</td>
<?php } ?>
<?php if ($account_grp->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $account_grp->status->cellAttributes() ?>>
<span<?php echo $account_grp->status->viewAttributes() ?>>
<?php echo $account_grp->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_grp->operator->Visible) { // operator ?>
		<!-- operator -->
		<td<?php echo $account_grp->operator->cellAttributes() ?>>
<span<?php echo $account_grp->operator->viewAttributes() ?>>
<?php echo $account_grp->operator->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_grp->datetime->Visible) { // datetime ?>
		<!-- datetime -->
		<td<?php echo $account_grp->datetime->cellAttributes() ?>>
<span<?php echo $account_grp->datetime->viewAttributes() ?>>
<?php echo $account_grp->datetime->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$account_grp_preview->ListOptions->render("body", "right", $account_grp_preview->RowCnt);
?>
	</tr>
<?php
	$account_grp_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($account_grp_preview->TotalRecs > 0) { ?>
<?php if (!isset($account_grp_preview->Pager)) $account_grp_preview->Pager = new PrevNextPager($account_grp_preview->StartRec, $account_grp_preview->DisplayRecs, $account_grp_preview->TotalRecs) ?>
<?php if ($account_grp_preview->Pager->RecordCount > 0 && $account_grp_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($account_grp_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $account_grp_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($account_grp_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $account_grp_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($account_grp_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $account_grp_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($account_grp_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $account_grp_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $account_grp_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $account_grp_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $account_grp_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($account_grp_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$account_grp_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($account_grp_preview->Recordset)
	$account_grp_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$account_grp_preview->terminate();
?>