<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_grp_search = new account_grp_search();

// Run the page
$account_grp_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_grp_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($account_grp_search->IsModal) { ?>
var faccount_grpsearch = currentAdvancedSearchForm = new ew.Form("faccount_grpsearch", "search");
<?php } else { ?>
var faccount_grpsearch = currentForm = new ew.Form("faccount_grpsearch", "search");
<?php } ?>

// Form_CustomValidate event
faccount_grpsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_grpsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_grpsearch.lists["x_grp"] = <?php echo $account_grp_search->grp->Lookup->toClientList() ?>;
faccount_grpsearch.lists["x_grp"].options = <?php echo JsonEncode($account_grp_search->grp->lookupOptions()) ?>;
faccount_grpsearch.lists["x_status"] = <?php echo $account_grp_search->status->Lookup->toClientList() ?>;
faccount_grpsearch.lists["x_status"].options = <?php echo JsonEncode($account_grp_search->status->options(FALSE, TRUE)) ?>;
faccount_grpsearch.lists["x_operator"] = <?php echo $account_grp_search->operator->Lookup->toClientList() ?>;
faccount_grpsearch.lists["x_operator"].options = <?php echo JsonEncode($account_grp_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

faccount_grpsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_grp->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_grp->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_grp->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $account_grp_search->showPageHeader(); ?>
<?php
$account_grp_search->showMessage();
?>
<form name="faccount_grpsearch" id="faccount_grpsearch" class="<?php echo $account_grp_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_grp_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_grp_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_grp">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$account_grp_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($account_grp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_id"><?php echo $account_grp->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->id->cellAttributes() ?>>
			<span id="el_account_grp_id">
<input type="text" data-table="account_grp" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($account_grp->id->getPlaceHolder()) ?>" value="<?php echo $account_grp->id->EditValue ?>"<?php echo $account_grp->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_grp->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_item"><?php echo $account_grp->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->item->cellAttributes() ?>>
			<span id="el_account_grp_item">
<input type="text" data-table="account_grp" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($account_grp->item->getPlaceHolder()) ?>" value="<?php echo $account_grp->item->EditValue ?>"<?php echo $account_grp->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_grp->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_balance"><?php echo $account_grp->balance->caption() ?></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($account_grp->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_account_grp_balance">
<input type="text" data-table="account_grp" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($account_grp->balance->getPlaceHolder()) ?>" value="<?php echo $account_grp->balance->EditValue ?>"<?php echo $account_grp->balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_account_grp_balance" class="btw1_balance d-none">
<input type="text" data-table="account_grp" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($account_grp->balance->getPlaceHolder()) ?>" value="<?php echo $account_grp->balance->EditValue2 ?>"<?php echo $account_grp->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_grp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_grp"><?php echo $account_grp->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->grp->cellAttributes() ?>>
			<span id="el_account_grp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_grp" data-field="x_grp" data-value-separator="<?php echo $account_grp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $account_grp->grp->editAttributes() ?>>
		<?php echo $account_grp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $account_grp->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_grp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_status"><?php echo $account_grp->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->status->cellAttributes() ?>>
			<span id="el_account_grp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_grp" data-field="x_status" data-value-separator="<?php echo $account_grp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $account_grp->status->editAttributes() ?>>
		<?php echo $account_grp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_grp->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_operator"><?php echo $account_grp->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->operator->cellAttributes() ?>>
			<span id="el_account_grp_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_grp" data-field="x_operator" data-value-separator="<?php echo $account_grp->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $account_grp->operator->editAttributes() ?>>
		<?php echo $account_grp->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $account_grp->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_grp->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $account_grp_search->LeftColumnClass ?>"><span id="elh_account_grp_datetime"><?php echo $account_grp->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $account_grp_search->RightColumnClass ?>"><div<?php echo $account_grp->datetime->cellAttributes() ?>>
			<span id="el_account_grp_datetime">
<input type="text" data-table="account_grp" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($account_grp->datetime->getPlaceHolder()) ?>" value="<?php echo $account_grp->datetime->EditValue ?>"<?php echo $account_grp->datetime->editAttributes() ?>>
<?php if (!$account_grp->datetime->ReadOnly && !$account_grp->datetime->Disabled && !isset($account_grp->datetime->EditAttrs["readonly"]) && !isset($account_grp->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("faccount_grpsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$account_grp_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $account_grp_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$account_grp_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$account_grp_search->terminate();
?>