<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_grp_view = new account_grp_view();

// Run the page
$account_grp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_grp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$account_grp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var faccount_grpview = currentForm = new ew.Form("faccount_grpview", "view");

// Form_CustomValidate event
faccount_grpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_grpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_grpview.lists["x_grp"] = <?php echo $account_grp_view->grp->Lookup->toClientList() ?>;
faccount_grpview.lists["x_grp"].options = <?php echo JsonEncode($account_grp_view->grp->lookupOptions()) ?>;
faccount_grpview.lists["x_status"] = <?php echo $account_grp_view->status->Lookup->toClientList() ?>;
faccount_grpview.lists["x_status"].options = <?php echo JsonEncode($account_grp_view->status->options(FALSE, TRUE)) ?>;
faccount_grpview.lists["x_operator"] = <?php echo $account_grp_view->operator->Lookup->toClientList() ?>;
faccount_grpview.lists["x_operator"].options = <?php echo JsonEncode($account_grp_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$account_grp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $account_grp_view->ExportOptions->render("body") ?>
<?php $account_grp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $account_grp_view->showPageHeader(); ?>
<?php
$account_grp_view->showMessage();
?>
<form name="faccount_grpview" id="faccount_grpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_grp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_grp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_grp">
<input type="hidden" name="modal" value="<?php echo (int)$account_grp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($account_grp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_id"><?php echo $account_grp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $account_grp->id->cellAttributes() ?>>
<span id="el_account_grp_id">
<span<?php echo $account_grp->id->viewAttributes() ?>>
<?php echo $account_grp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_grp->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_item"><?php echo $account_grp->item->caption() ?></span></td>
		<td data-name="item"<?php echo $account_grp->item->cellAttributes() ?>>
<span id="el_account_grp_item">
<span<?php echo $account_grp->item->viewAttributes() ?>>
<?php echo $account_grp->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_grp->balance->Visible) { // balance ?>
	<tr id="r_balance">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_balance"><?php echo $account_grp->balance->caption() ?></span></td>
		<td data-name="balance"<?php echo $account_grp->balance->cellAttributes() ?>>
<span id="el_account_grp_balance">
<span<?php echo $account_grp->balance->viewAttributes() ?>>
<?php echo $account_grp->balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_grp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_grp"><?php echo $account_grp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $account_grp->grp->cellAttributes() ?>>
<span id="el_account_grp_grp">
<span<?php echo $account_grp->grp->viewAttributes() ?>>
<?php if ((!EmptyString($account_grp->grp->getViewValue())) && $account_grp->grp->linkAttributes() <> "") { ?>
<a<?php echo $account_grp->grp->linkAttributes() ?>><?php echo $account_grp->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $account_grp->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_grp->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_status"><?php echo $account_grp->status->caption() ?></span></td>
		<td data-name="status"<?php echo $account_grp->status->cellAttributes() ?>>
<span id="el_account_grp_status">
<span<?php echo $account_grp->status->viewAttributes() ?>>
<?php echo $account_grp->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_grp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_operator"><?php echo $account_grp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $account_grp->operator->cellAttributes() ?>>
<span id="el_account_grp_operator">
<span<?php echo $account_grp->operator->viewAttributes() ?>>
<?php echo $account_grp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_grp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $account_grp_view->TableLeftColumnClass ?>"><span id="elh_account_grp_datetime"><?php echo $account_grp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $account_grp->datetime->cellAttributes() ?>>
<span id="el_account_grp_datetime">
<span<?php echo $account_grp->datetime->viewAttributes() ?>>
<?php echo $account_grp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php
	if (in_array("account_grp", explode(",", $account_grp->getCurrentDetailTable())) && $account_grp->DetailView) {
?>
<?php if ($account_grp->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("account_grp", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "account_grpgrid.php" ?>
<?php } ?>
<?php
	if (in_array("account_info", explode(",", $account_grp->getCurrentDetailTable())) && $account_info->DetailView) {
?>
<?php if ($account_grp->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("account_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "account_infogrid.php" ?>
<?php } ?>
</form>
<?php
$account_grp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$account_grp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$account_grp_view->terminate();
?>