<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_info_edit = new account_info_edit();

// Run the page
$account_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var faccount_infoedit = currentForm = new ew.Form("faccount_infoedit", "edit");

// Validate form
faccount_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($account_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->id->caption(), $account_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_info_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->type->caption(), $account_info->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_info_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->grp->caption(), $account_info->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_info_edit->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->formal_name->caption(), $account_info->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_info_edit->balance->Required) { ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->balance->caption(), $account_info->balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($account_info->balance->errorMessage()) ?>");
		<?php if ($account_info_edit->reference->Required) { ?>
			elm = this.getElements("x" + infix + "_reference");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->reference->caption(), $account_info->reference->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_info_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_info->status->caption(), $account_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
faccount_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_infoedit.lists["x_type"] = <?php echo $account_info_edit->type->Lookup->toClientList() ?>;
faccount_infoedit.lists["x_type"].options = <?php echo JsonEncode($account_info_edit->type->lookupOptions()) ?>;
faccount_infoedit.lists["x_grp"] = <?php echo $account_info_edit->grp->Lookup->toClientList() ?>;
faccount_infoedit.lists["x_grp"].options = <?php echo JsonEncode($account_info_edit->grp->lookupOptions()) ?>;
faccount_infoedit.lists["x_status"] = <?php echo $account_info_edit->status->Lookup->toClientList() ?>;
faccount_infoedit.lists["x_status"].options = <?php echo JsonEncode($account_info_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $account_info_edit->showPageHeader(); ?>
<?php
$account_info_edit->showMessage();
?>
<form name="faccount_infoedit" id="faccount_infoedit" class="<?php echo $account_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$account_info_edit->IsModal ?>">
<?php if ($account_info->getCurrentMasterTable() == "account_grp") { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="account_grp">
<input type="hidden" name="fk_id" value="<?php echo $account_info->grp->getSessionValue() ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($account_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_account_info_id" for="x_id" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->id->caption() ?><?php echo ($account_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->id->cellAttributes() ?>>
<span id="el_account_info_id">
<span<?php echo $account_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($account_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="account_info" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($account_info->id->CurrentValue) ?>">
<?php echo $account_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_account_info_type" for="x_type" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->type->caption() ?><?php echo ($account_info->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->type->cellAttributes() ?>>
<span id="el_account_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_info" data-field="x_type" data-value-separator="<?php echo $account_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $account_info->type->editAttributes() ?>>
		<?php echo $account_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $account_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
<?php echo $account_info->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_info->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_account_info_grp" for="x_grp" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->grp->caption() ?><?php echo ($account_info->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->grp->cellAttributes() ?>>
<?php if ($account_info->grp->getSessionValue() <> "") { ?>
<span id="el_account_info_grp">
<span<?php echo $account_info->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($account_info->grp->ViewValue) ?>"></span>
</span>
<input type="hidden" id="x_grp" name="x_grp" value="<?php echo HtmlEncode($account_info->grp->CurrentValue) ?>">
<?php } else { ?>
<span id="el_account_info_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_info" data-field="x_grp" data-value-separator="<?php echo $account_info->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $account_info->grp->editAttributes() ?>>
		<?php echo $account_info->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $account_info->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php } ?>
<?php echo $account_info->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_account_info_formal_name" for="x_formal_name" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->formal_name->caption() ?><?php echo ($account_info->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->formal_name->cellAttributes() ?>>
<span id="el_account_info_formal_name">
<input type="text" data-table="account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $account_info->formal_name->EditValue ?>"<?php echo $account_info->formal_name->editAttributes() ?>>
</span>
<?php echo $account_info->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label id="elh_account_info_balance" for="x_balance" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->balance->caption() ?><?php echo ($account_info->balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->balance->cellAttributes() ?>>
<span id="el_account_info_balance">
<input type="text" data-table="account_info" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($account_info->balance->getPlaceHolder()) ?>" value="<?php echo $account_info->balance->EditValue ?>"<?php echo $account_info->balance->editAttributes() ?>>
</span>
<?php echo $account_info->balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_info->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label id="elh_account_info_reference" for="x_reference" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->reference->caption() ?><?php echo ($account_info->reference->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->reference->cellAttributes() ?>>
<span id="el_account_info_reference">
<span<?php echo $account_info->reference->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($account_info->reference->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="account_info" data-field="x_reference" name="x_reference" id="x_reference" value="<?php echo HtmlEncode($account_info->reference->CurrentValue) ?>">
<?php echo $account_info->reference->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_account_info_status" for="x_status" class="<?php echo $account_info_edit->LeftColumnClass ?>"><?php echo $account_info->status->caption() ?><?php echo ($account_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_info_edit->RightColumnClass ?>"><div<?php echo $account_info->status->cellAttributes() ?>>
<span id="el_account_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_info" data-field="x_status" data-value-separator="<?php echo $account_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $account_info->status->editAttributes() ?>>
		<?php echo $account_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $account_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$account_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $account_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $account_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$account_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$account_info_edit->terminate();
?>