<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_info_list = new account_info_list();

// Run the page
$account_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$account_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var faccount_infolist = currentForm = new ew.Form("faccount_infolist", "list");
faccount_infolist.formKeyCountName = '<?php echo $account_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
faccount_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_infolist.lists["x_type"] = <?php echo $account_info_list->type->Lookup->toClientList() ?>;
faccount_infolist.lists["x_type"].options = <?php echo JsonEncode($account_info_list->type->lookupOptions()) ?>;
faccount_infolist.lists["x_status"] = <?php echo $account_info_list->status->Lookup->toClientList() ?>;
faccount_infolist.lists["x_status"].options = <?php echo JsonEncode($account_info_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var faccount_infolistsrch = currentSearchForm = new ew.Form("faccount_infolistsrch");

// Validate function for search
faccount_infolistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_info->balance->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
faccount_infolistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_infolistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

faccount_infolistsrch.filterList = <?php echo $account_info_list->getFilterList() ?>;

// Init search panel as collapsed
faccount_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$account_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($account_info_list->TotalRecs > 0 && $account_info_list->ExportOptions->visible()) { ?>
<?php $account_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($account_info_list->ImportOptions->visible()) { ?>
<?php $account_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($account_info_list->SearchOptions->visible()) { ?>
<?php $account_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($account_info_list->FilterOptions->visible()) { ?>
<?php $account_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if (!$account_info->isExport() || EXPORT_MASTER_RECORD && $account_info->isExport("print")) { ?>
<?php
if ($account_info_list->DbMasterFilter <> "" && $account_info->getCurrentMasterTable() == "account_grp") {
	if ($account_info_list->MasterRecordExists) {
		include_once "account_grpmaster.php";
	}
}
?>
<?php } ?>
<?php
$account_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$account_info->isExport() && !$account_info->CurrentAction) { ?>
<form name="faccount_infolistsrch" id="faccount_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($account_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="faccount_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="account_info">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$account_info_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$account_info->RowType = ROWTYPE_SEARCH;

// Render row
$account_info->resetAttributes();
$account_info_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
	<div id="xsc_formal_name" class="ew-cell form-group">
		<label for="x_formal_name" class="ew-search-caption ew-label"><?php echo $account_info->formal_name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $account_info->formal_name->EditValue ?>"<?php echo $account_info->formal_name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
	<div id="xsc_balance" class="ew-cell form-group">
		<label for="x_balance" class="ew-search-caption ew-label"><?php echo $account_info->balance->caption() ?></label>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="account_info" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($account_info->balance->getPlaceHolder()) ?>" value="<?php echo $account_info->balance->EditValue ?>"<?php echo $account_info->balance->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_balance style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_balance style="d-none"">
<input type="text" data-table="account_info" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($account_info->balance->getPlaceHolder()) ?>" value="<?php echo $account_info->balance->EditValue2 ?>"<?php echo $account_info->balance->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($account_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($account_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $account_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($account_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($account_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($account_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($account_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $account_info_list->showPageHeader(); ?>
<?php
$account_info_list->showMessage();
?>
<?php if ($account_info_list->TotalRecs > 0 || $account_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($account_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> account_info">
<?php if (!$account_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$account_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($account_info_list->Pager)) $account_info_list->Pager = new PrevNextPager($account_info_list->StartRec, $account_info_list->DisplayRecs, $account_info_list->TotalRecs, $account_info_list->AutoHidePager) ?>
<?php if ($account_info_list->Pager->RecordCount > 0 && $account_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($account_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($account_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $account_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($account_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($account_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $account_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($account_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $account_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $account_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $account_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($account_info_list->TotalRecs > 0 && (!$account_info_list->AutoHidePageSizeSelector || $account_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="account_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($account_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($account_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($account_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($account_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($account_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($account_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $account_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="faccount_infolist" id="faccount_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_info">
<?php if ($account_info->getCurrentMasterTable() == "account_grp" && $account_info->CurrentAction) { ?>
<input type="hidden" name="<?php echo TABLE_SHOW_MASTER ?>" value="account_grp">
<input type="hidden" name="fk_id" value="<?php echo $account_info->grp->getSessionValue() ?>">
<?php } ?>
<div id="gmp_account_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($account_info_list->TotalRecs > 0 || $account_info->isGridEdit()) { ?>
<table id="tbl_account_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$account_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$account_info_list->renderListOptions();

// Render list options (header, left)
$account_info_list->ListOptions->render("header", "left");
?>
<?php if ($account_info->id->Visible) { // id ?>
	<?php if ($account_info->sortUrl($account_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $account_info->id->headerCellClass() ?>"><div id="elh_account_info_id" class="account_info_id"><div class="ew-table-header-caption"><?php echo $account_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $account_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_info->SortUrl($account_info->id) ?>',2);"><div id="elh_account_info_id" class="account_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->type->Visible) { // type ?>
	<?php if ($account_info->sortUrl($account_info->type) == "") { ?>
		<th data-name="type" class="<?php echo $account_info->type->headerCellClass() ?>"><div id="elh_account_info_type" class="account_info_type"><div class="ew-table-header-caption"><?php echo $account_info->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $account_info->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_info->SortUrl($account_info->type) ?>',2);"><div id="elh_account_info_type" class="account_info_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
	<?php if ($account_info->sortUrl($account_info->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $account_info->formal_name->headerCellClass() ?>"><div id="elh_account_info_formal_name" class="account_info_formal_name"><div class="ew-table-header-caption"><?php echo $account_info->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $account_info->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_info->SortUrl($account_info->formal_name) ?>',2);"><div id="elh_account_info_formal_name" class="account_info_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_info->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
	<?php if ($account_info->sortUrl($account_info->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $account_info->balance->headerCellClass() ?>"><div id="elh_account_info_balance" class="account_info_balance"><div class="ew-table-header-caption"><?php echo $account_info->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $account_info->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_info->SortUrl($account_info->balance) ?>',2);"><div id="elh_account_info_balance" class="account_info_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_info->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->reference->Visible) { // reference ?>
	<?php if ($account_info->sortUrl($account_info->reference) == "") { ?>
		<th data-name="reference" class="<?php echo $account_info->reference->headerCellClass() ?>"><div id="elh_account_info_reference" class="account_info_reference"><div class="ew-table-header-caption"><?php echo $account_info->reference->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reference" class="<?php echo $account_info->reference->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_info->SortUrl($account_info->reference) ?>',2);"><div id="elh_account_info_reference" class="account_info_reference">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->reference->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_info->reference->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info->reference->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->status->Visible) { // status ?>
	<?php if ($account_info->sortUrl($account_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $account_info->status->headerCellClass() ?>"><div id="elh_account_info_status" class="account_info_status"><div class="ew-table-header-caption"><?php echo $account_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $account_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_info->SortUrl($account_info->status) ?>',2);"><div id="elh_account_info_status" class="account_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$account_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($account_info->ExportAll && $account_info->isExport()) {
	$account_info_list->StopRec = $account_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($account_info_list->TotalRecs > $account_info_list->StartRec + $account_info_list->DisplayRecs - 1)
		$account_info_list->StopRec = $account_info_list->StartRec + $account_info_list->DisplayRecs - 1;
	else
		$account_info_list->StopRec = $account_info_list->TotalRecs;
}
$account_info_list->RecCnt = $account_info_list->StartRec - 1;
if ($account_info_list->Recordset && !$account_info_list->Recordset->EOF) {
	$account_info_list->Recordset->moveFirst();
	$selectLimit = $account_info_list->UseSelectLimit;
	if (!$selectLimit && $account_info_list->StartRec > 1)
		$account_info_list->Recordset->move($account_info_list->StartRec - 1);
} elseif (!$account_info->AllowAddDeleteRow && $account_info_list->StopRec == 0) {
	$account_info_list->StopRec = $account_info->GridAddRowCount;
}

// Initialize aggregate
$account_info->RowType = ROWTYPE_AGGREGATEINIT;
$account_info->resetAttributes();
$account_info_list->renderRow();
while ($account_info_list->RecCnt < $account_info_list->StopRec) {
	$account_info_list->RecCnt++;
	if ($account_info_list->RecCnt >= $account_info_list->StartRec) {
		$account_info_list->RowCnt++;

		// Set up key count
		$account_info_list->KeyCount = $account_info_list->RowIndex;

		// Init row class and style
		$account_info->resetAttributes();
		$account_info->CssClass = "";
		if ($account_info->isGridAdd()) {
		} else {
			$account_info_list->loadRowValues($account_info_list->Recordset); // Load row values
		}
		$account_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$account_info->RowAttrs = array_merge($account_info->RowAttrs, array('data-rowindex'=>$account_info_list->RowCnt, 'id'=>'r' . $account_info_list->RowCnt . '_account_info', 'data-rowtype'=>$account_info->RowType));

		// Render row
		$account_info_list->renderRow();

		// Render list options
		$account_info_list->renderListOptions();
?>
	<tr<?php echo $account_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$account_info_list->ListOptions->render("body", "left", $account_info_list->RowCnt);
?>
	<?php if ($account_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $account_info->id->cellAttributes() ?>>
<span id="el<?php echo $account_info_list->RowCnt ?>_account_info_id" class="account_info_id">
<span<?php echo $account_info->id->viewAttributes() ?>>
<?php echo $account_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_info->type->Visible) { // type ?>
		<td data-name="type"<?php echo $account_info->type->cellAttributes() ?>>
<span id="el<?php echo $account_info_list->RowCnt ?>_account_info_type" class="account_info_type">
<span<?php echo $account_info->type->viewAttributes() ?>>
<?php echo $account_info->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_info->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $account_info->formal_name->cellAttributes() ?>>
<span id="el<?php echo $account_info_list->RowCnt ?>_account_info_formal_name" class="account_info_formal_name">
<span<?php echo $account_info->formal_name->viewAttributes() ?>>
<?php echo $account_info->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_info->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $account_info->balance->cellAttributes() ?>>
<span id="el<?php echo $account_info_list->RowCnt ?>_account_info_balance" class="account_info_balance">
<span<?php echo $account_info->balance->viewAttributes() ?>>
<?php echo $account_info->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_info->reference->Visible) { // reference ?>
		<td data-name="reference"<?php echo $account_info->reference->cellAttributes() ?>>
<span id="el<?php echo $account_info_list->RowCnt ?>_account_info_reference" class="account_info_reference">
<span<?php echo $account_info->reference->viewAttributes() ?>>
<?php echo $account_info->reference->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $account_info->status->cellAttributes() ?>>
<span id="el<?php echo $account_info_list->RowCnt ?>_account_info_status" class="account_info_status">
<span<?php echo $account_info->status->viewAttributes() ?>>
<?php echo $account_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$account_info_list->ListOptions->render("body", "right", $account_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$account_info->isGridAdd())
		$account_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$account_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($account_info_list->Recordset)
	$account_info_list->Recordset->Close();
?>
<?php if (!$account_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$account_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($account_info_list->Pager)) $account_info_list->Pager = new PrevNextPager($account_info_list->StartRec, $account_info_list->DisplayRecs, $account_info_list->TotalRecs, $account_info_list->AutoHidePager) ?>
<?php if ($account_info_list->Pager->RecordCount > 0 && $account_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($account_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($account_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $account_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($account_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($account_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $account_info_list->pageUrl() ?>start=<?php echo $account_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $account_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($account_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $account_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $account_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $account_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($account_info_list->TotalRecs > 0 && (!$account_info_list->AutoHidePageSizeSelector || $account_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="account_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($account_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($account_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($account_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($account_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($account_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($account_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $account_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($account_info_list->TotalRecs == 0 && !$account_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $account_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$account_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$account_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$account_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_account_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$account_info_list->terminate();
?>