<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$account_info_preview = new account_info_preview();

// Run the page
$account_info_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_info_preview->Page_Render();
?>
<?php $account_info_preview->showPageHeader(); ?>
<div class="card ew-grid account_info"><!-- .card -->
<?php if ($account_info_preview->TotalRecs > 0) { ?>
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$account_info_preview->renderListOptions();

// Render list options (header, left)
$account_info_preview->ListOptions->render("header", "left");
?>
<?php if ($account_info->id->Visible) { // id ?>
	<?php if ($account_info->SortUrl($account_info->id) == "") { ?>
		<th class="<?php echo $account_info->id->headerCellClass() ?>"><?php echo $account_info->id->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_info->id->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_info->id->Name) ?>" data-sort-order="<?php echo $account_info_preview->SortField == $account_info->id->Name && $account_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info_preview->SortField == $account_info->id->Name) { ?><?php if ($account_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->type->Visible) { // type ?>
	<?php if ($account_info->SortUrl($account_info->type) == "") { ?>
		<th class="<?php echo $account_info->type->headerCellClass() ?>"><?php echo $account_info->type->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_info->type->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_info->type->Name) ?>" data-sort-order="<?php echo $account_info_preview->SortField == $account_info->type->Name && $account_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info_preview->SortField == $account_info->type->Name) { ?><?php if ($account_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
	<?php if ($account_info->SortUrl($account_info->formal_name) == "") { ?>
		<th class="<?php echo $account_info->formal_name->headerCellClass() ?>"><?php echo $account_info->formal_name->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_info->formal_name->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_info->formal_name->Name) ?>" data-sort-order="<?php echo $account_info_preview->SortField == $account_info->formal_name->Name && $account_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->formal_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info_preview->SortField == $account_info->formal_name->Name) { ?><?php if ($account_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
	<?php if ($account_info->SortUrl($account_info->balance) == "") { ?>
		<th class="<?php echo $account_info->balance->headerCellClass() ?>"><?php echo $account_info->balance->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_info->balance->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_info->balance->Name) ?>" data-sort-order="<?php echo $account_info_preview->SortField == $account_info->balance->Name && $account_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info_preview->SortField == $account_info->balance->Name) { ?><?php if ($account_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->reference->Visible) { // reference ?>
	<?php if ($account_info->SortUrl($account_info->reference) == "") { ?>
		<th class="<?php echo $account_info->reference->headerCellClass() ?>"><?php echo $account_info->reference->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_info->reference->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_info->reference->Name) ?>" data-sort-order="<?php echo $account_info_preview->SortField == $account_info->reference->Name && $account_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->reference->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info_preview->SortField == $account_info->reference->Name) { ?><?php if ($account_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_info->status->Visible) { // status ?>
	<?php if ($account_info->SortUrl($account_info->status) == "") { ?>
		<th class="<?php echo $account_info->status->headerCellClass() ?>"><?php echo $account_info->status->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $account_info->status->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($account_info->status->Name) ?>" data-sort-order="<?php echo $account_info_preview->SortField == $account_info->status->Name && $account_info_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_info_preview->SortField == $account_info->status->Name) { ?><?php if ($account_info_preview->SortOrder == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_info_preview->SortOrder == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$account_info_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$account_info_preview->RecCount = 0;
$account_info_preview->RowCnt = 0;
while ($account_info_preview->Recordset && !$account_info_preview->Recordset->EOF) {

	// Init row class and style
	$account_info_preview->RecCount++;
	$account_info_preview->RowCnt++;
	$account_info_preview->CssStyle = "";
	$account_info_preview->loadListRowValues($account_info_preview->Recordset);

	// Render row
	$account_info_preview->RowType = ROWTYPE_PREVIEW; // Preview record
	$account_info_preview->resetAttributes();
	$account_info_preview->renderListRow();

	// Render list options
	$account_info_preview->renderListOptions();
?>
	<tr<?php echo $account_info_preview->rowAttributes() ?>>
<?php

// Render list options (body, left)
$account_info_preview->ListOptions->render("body", "left", $account_info_preview->RowCnt);
?>
<?php if ($account_info->id->Visible) { // id ?>
		<!-- id -->
		<td<?php echo $account_info->id->cellAttributes() ?>>
<span<?php echo $account_info->id->viewAttributes() ?>>
<?php echo $account_info->id->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_info->type->Visible) { // type ?>
		<!-- type -->
		<td<?php echo $account_info->type->cellAttributes() ?>>
<span<?php echo $account_info->type->viewAttributes() ?>>
<?php echo $account_info->type->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
		<!-- formal_name -->
		<td<?php echo $account_info->formal_name->cellAttributes() ?>>
<span<?php echo $account_info->formal_name->viewAttributes() ?>>
<?php echo $account_info->formal_name->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
		<!-- balance -->
		<td<?php echo $account_info->balance->cellAttributes() ?>>
<span<?php echo $account_info->balance->viewAttributes() ?>>
<?php echo $account_info->balance->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_info->reference->Visible) { // reference ?>
		<!-- reference -->
		<td<?php echo $account_info->reference->cellAttributes() ?>>
<span<?php echo $account_info->reference->viewAttributes() ?>>
<?php echo $account_info->reference->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($account_info->status->Visible) { // status ?>
		<!-- status -->
		<td<?php echo $account_info->status->cellAttributes() ?>>
<span<?php echo $account_info->status->viewAttributes() ?>>
<?php echo $account_info->status->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$account_info_preview->ListOptions->render("body", "right", $account_info_preview->RowCnt);
?>
	</tr>
<?php
	$account_info_preview->Recordset->MoveNext();
}
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<?php } ?>
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php if ($account_info_preview->TotalRecs > 0) { ?>
<?php if (!isset($account_info_preview->Pager)) $account_info_preview->Pager = new PrevNextPager($account_info_preview->StartRec, $account_info_preview->DisplayRecs, $account_info_preview->TotalRecs) ?>
<?php if ($account_info_preview->Pager->RecordCount > 0 && $account_info_preview->Pager->Visible) { ?>
<div class="ew-pager"><div class="ew-prev-next"><div class="btn-group btn-group-sm ew-btn-group">
<!--first page button-->
	<?php if ($account_info_preview->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" data-start="<?php echo $account_info_preview->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($account_info_preview->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" data-start="<?php echo $account_info_preview->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
<!--next page button-->
	<?php if ($account_info_preview->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" data-start="<?php echo $account_info_preview->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($account_info_preview->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" data-start="<?php echo $account_info_preview->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div></div></div>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->phrase("Record") ?>&nbsp;<?php echo $account_info_preview->Pager->FromIndex ?>&nbsp;<?php echo $Language->phrase("To") ?>&nbsp;<?php echo $account_info_preview->Pager->ToIndex ?>&nbsp;<?php echo $Language->phrase("Of") ?>&nbsp;<?php echo $account_info_preview->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php } else { ?>
<div class="ew-detail-count"><?php echo $Language->Phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($account_info_preview->OtherOptions as &$option)
		$option->render("body");
?>
</div>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
</div><!-- /.card -->
<?php
$account_info_preview->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php
if ($account_info_preview->Recordset)
	$account_info_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$account_info_preview->terminate();
?>