<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_info_search = new account_info_search();

// Run the page
$account_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($account_info_search->IsModal) { ?>
var faccount_infosearch = currentAdvancedSearchForm = new ew.Form("faccount_infosearch", "search");
<?php } else { ?>
var faccount_infosearch = currentForm = new ew.Form("faccount_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
faccount_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_infosearch.lists["x_type"] = <?php echo $account_info_search->type->Lookup->toClientList() ?>;
faccount_infosearch.lists["x_type"].options = <?php echo JsonEncode($account_info_search->type->lookupOptions()) ?>;
faccount_infosearch.lists["x_grp"] = <?php echo $account_info_search->grp->Lookup->toClientList() ?>;
faccount_infosearch.lists["x_grp"].options = <?php echo JsonEncode($account_info_search->grp->lookupOptions()) ?>;
faccount_infosearch.lists["x_status"] = <?php echo $account_info_search->status->Lookup->toClientList() ?>;
faccount_infosearch.lists["x_status"].options = <?php echo JsonEncode($account_info_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

faccount_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_info->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_info->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $account_info_search->showPageHeader(); ?>
<?php
$account_info_search->showMessage();
?>
<form name="faccount_infosearch" id="faccount_infosearch" class="<?php echo $account_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$account_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($account_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_type"><?php echo $account_info->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->type->cellAttributes() ?>>
			<span id="el_account_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_info" data-field="x_type" data-value-separator="<?php echo $account_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $account_info->type->editAttributes() ?>>
		<?php echo $account_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
<?php echo $account_info->type->Lookup->getParamTag("p_x_type") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_grp"><?php echo $account_info->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->grp->cellAttributes() ?>>
			<span id="el_account_info_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_info" data-field="x_grp" data-value-separator="<?php echo $account_info->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $account_info->grp->editAttributes() ?>>
		<?php echo $account_info->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $account_info->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_formal_name"><?php echo $account_info->formal_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->formal_name->cellAttributes() ?>>
			<span id="el_account_info_formal_name">
<input type="text" data-table="account_info" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($account_info->formal_name->getPlaceHolder()) ?>" value="<?php echo $account_info->formal_name->EditValue ?>"<?php echo $account_info->formal_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_balance"><?php echo $account_info->balance->caption() ?></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->balance->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_balance" id="z_balance" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($account_info->balance->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_account_info_balance">
<input type="text" data-table="account_info" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($account_info->balance->getPlaceHolder()) ?>" value="<?php echo $account_info->balance->EditValue ?>"<?php echo $account_info->balance->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_balance d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_account_info_balance" class="btw1_balance d-none">
<input type="text" data-table="account_info" data-field="x_balance" name="y_balance" id="y_balance" size="30" placeholder="<?php echo HtmlEncode($account_info->balance->getPlaceHolder()) ?>" value="<?php echo $account_info->balance->EditValue2 ?>"<?php echo $account_info->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->reference->Visible) { // reference ?>
	<div id="r_reference" class="form-group row">
		<label for="x_reference" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_reference"><?php echo $account_info->reference->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_reference" id="z_reference" value="LIKE"></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->reference->cellAttributes() ?>>
			<span id="el_account_info_reference">
<input type="text" data-table="account_info" data-field="x_reference" name="x_reference" id="x_reference" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($account_info->reference->getPlaceHolder()) ?>" value="<?php echo $account_info->reference->EditValue ?>"<?php echo $account_info->reference->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_status"><?php echo $account_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->status->cellAttributes() ?>>
			<span id="el_account_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_info" data-field="x_status" data-value-separator="<?php echo $account_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $account_info->status->editAttributes() ?>>
		<?php echo $account_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_operator"><?php echo $account_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->operator->cellAttributes() ?>>
			<span id="el_account_info_operator">
<input type="text" data-table="account_info" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($account_info->operator->getPlaceHolder()) ?>" value="<?php echo $account_info->operator->EditValue ?>"<?php echo $account_info->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $account_info_search->LeftColumnClass ?>"><span id="elh_account_info_datetime"><?php echo $account_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $account_info_search->RightColumnClass ?>"><div<?php echo $account_info->datetime->cellAttributes() ?>>
			<span id="el_account_info_datetime">
<input type="text" data-table="account_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($account_info->datetime->getPlaceHolder()) ?>" value="<?php echo $account_info->datetime->EditValue ?>"<?php echo $account_info->datetime->editAttributes() ?>>
<?php if (!$account_info->datetime->ReadOnly && !$account_info->datetime->Disabled && !isset($account_info->datetime->EditAttrs["readonly"]) && !isset($account_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("faccount_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$account_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $account_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$account_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$account_info_search->terminate();
?>