<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_info_view = new account_info_view();

// Run the page
$account_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$account_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var faccount_infoview = currentForm = new ew.Form("faccount_infoview", "view");

// Form_CustomValidate event
faccount_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_infoview.lists["x_type"] = <?php echo $account_info_view->type->Lookup->toClientList() ?>;
faccount_infoview.lists["x_type"].options = <?php echo JsonEncode($account_info_view->type->lookupOptions()) ?>;
faccount_infoview.lists["x_grp"] = <?php echo $account_info_view->grp->Lookup->toClientList() ?>;
faccount_infoview.lists["x_grp"].options = <?php echo JsonEncode($account_info_view->grp->lookupOptions()) ?>;
faccount_infoview.lists["x_status"] = <?php echo $account_info_view->status->Lookup->toClientList() ?>;
faccount_infoview.lists["x_status"].options = <?php echo JsonEncode($account_info_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$account_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $account_info_view->ExportOptions->render("body") ?>
<?php $account_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $account_info_view->showPageHeader(); ?>
<?php
$account_info_view->showMessage();
?>
<form name="faccount_infoview" id="faccount_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_info">
<input type="hidden" name="modal" value="<?php echo (int)$account_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($account_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_id"><?php echo $account_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $account_info->id->cellAttributes() ?>>
<span id="el_account_info_id">
<span<?php echo $account_info->id->viewAttributes() ?>>
<?php echo $account_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_type"><?php echo $account_info->type->caption() ?></span></td>
		<td data-name="type"<?php echo $account_info->type->cellAttributes() ?>>
<span id="el_account_info_type">
<span<?php echo $account_info->type->viewAttributes() ?>>
<?php echo $account_info->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_grp"><?php echo $account_info->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $account_info->grp->cellAttributes() ?>>
<span id="el_account_info_grp">
<span<?php echo $account_info->grp->viewAttributes() ?>>
<?php echo $account_info->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->formal_name->Visible) { // formal_name ?>
	<tr id="r_formal_name">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_formal_name"><?php echo $account_info->formal_name->caption() ?></span></td>
		<td data-name="formal_name"<?php echo $account_info->formal_name->cellAttributes() ?>>
<span id="el_account_info_formal_name">
<span<?php echo $account_info->formal_name->viewAttributes() ?>>
<?php echo $account_info->formal_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->balance->Visible) { // balance ?>
	<tr id="r_balance">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_balance"><?php echo $account_info->balance->caption() ?></span></td>
		<td data-name="balance"<?php echo $account_info->balance->cellAttributes() ?>>
<span id="el_account_info_balance">
<span<?php echo $account_info->balance->viewAttributes() ?>>
<?php echo $account_info->balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->reference->Visible) { // reference ?>
	<tr id="r_reference">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_reference"><?php echo $account_info->reference->caption() ?></span></td>
		<td data-name="reference"<?php echo $account_info->reference->cellAttributes() ?>>
<span id="el_account_info_reference">
<span<?php echo $account_info->reference->viewAttributes() ?>>
<?php echo $account_info->reference->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_status"><?php echo $account_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $account_info->status->cellAttributes() ?>>
<span id="el_account_info_status">
<span<?php echo $account_info->status->viewAttributes() ?>>
<?php echo $account_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_operator"><?php echo $account_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $account_info->operator->cellAttributes() ?>>
<span id="el_account_info_operator">
<span<?php echo $account_info->operator->viewAttributes() ?>>
<?php echo $account_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $account_info_view->TableLeftColumnClass ?>"><span id="elh_account_info_datetime"><?php echo $account_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $account_info->datetime->cellAttributes() ?>>
<span id="el_account_info_datetime">
<span<?php echo $account_info->datetime->viewAttributes() ?>>
<?php echo $account_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$account_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$account_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$account_info_view->terminate();
?>