<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_type_edit = new account_type_edit();

// Run the page
$account_type_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_type_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var faccount_typeedit = currentForm = new ew.Form("faccount_typeedit", "edit");

// Validate form
faccount_typeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($account_type_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_type->id->caption(), $account_type->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_type_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_type->item->caption(), $account_type->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_type_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_type->status->caption(), $account_type->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_type_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_type->operator->caption(), $account_type->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($account_type_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $account_type->datetime->caption(), $account_type->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
faccount_typeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_typeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_typeedit.lists["x_status"] = <?php echo $account_type_edit->status->Lookup->toClientList() ?>;
faccount_typeedit.lists["x_status"].options = <?php echo JsonEncode($account_type_edit->status->options(FALSE, TRUE)) ?>;
faccount_typeedit.lists["x_operator"] = <?php echo $account_type_edit->operator->Lookup->toClientList() ?>;
faccount_typeedit.lists["x_operator"].options = <?php echo JsonEncode($account_type_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $account_type_edit->showPageHeader(); ?>
<?php
$account_type_edit->showMessage();
?>
<form name="faccount_typeedit" id="faccount_typeedit" class="<?php echo $account_type_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_type_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_type_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_type">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$account_type_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($account_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_account_type_id" class="<?php echo $account_type_edit->LeftColumnClass ?>"><?php echo $account_type->id->caption() ?><?php echo ($account_type->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_type_edit->RightColumnClass ?>"><div<?php echo $account_type->id->cellAttributes() ?>>
<span id="el_account_type_id">
<span<?php echo $account_type->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($account_type->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="account_type" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($account_type->id->CurrentValue) ?>">
<?php echo $account_type->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_type->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_account_type_item" for="x_item" class="<?php echo $account_type_edit->LeftColumnClass ?>"><?php echo $account_type->item->caption() ?><?php echo ($account_type->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_type_edit->RightColumnClass ?>"><div<?php echo $account_type->item->cellAttributes() ?>>
<span id="el_account_type_item">
<input type="text" data-table="account_type" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($account_type->item->getPlaceHolder()) ?>" value="<?php echo $account_type->item->EditValue ?>"<?php echo $account_type->item->editAttributes() ?>>
</span>
<?php echo $account_type->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($account_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_account_type_status" for="x_status" class="<?php echo $account_type_edit->LeftColumnClass ?>"><?php echo $account_type->status->caption() ?><?php echo ($account_type->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $account_type_edit->RightColumnClass ?>"><div<?php echo $account_type->status->cellAttributes() ?>>
<span id="el_account_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_type" data-field="x_status" data-value-separator="<?php echo $account_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $account_type->status->editAttributes() ?>>
		<?php echo $account_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $account_type->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$account_type_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $account_type_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $account_type_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$account_type_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$account_type_edit->terminate();
?>