<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_type_list = new account_type_list();

// Run the page
$account_type_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_type_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$account_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var faccount_typelist = currentForm = new ew.Form("faccount_typelist", "list");
faccount_typelist.formKeyCountName = '<?php echo $account_type_list->FormKeyCountName ?>';

// Form_CustomValidate event
faccount_typelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_typelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_typelist.lists["x_status"] = <?php echo $account_type_list->status->Lookup->toClientList() ?>;
faccount_typelist.lists["x_status"].options = <?php echo JsonEncode($account_type_list->status->options(FALSE, TRUE)) ?>;
faccount_typelist.lists["x_operator"] = <?php echo $account_type_list->operator->Lookup->toClientList() ?>;
faccount_typelist.lists["x_operator"].options = <?php echo JsonEncode($account_type_list->operator->lookupOptions()) ?>;

// Form object for search
var faccount_typelistsrch = currentSearchForm = new ew.Form("faccount_typelistsrch");

// Filters
faccount_typelistsrch.filterList = <?php echo $account_type_list->getFilterList() ?>;

// Init search panel as collapsed
faccount_typelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$account_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($account_type_list->TotalRecs > 0 && $account_type_list->ExportOptions->visible()) { ?>
<?php $account_type_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($account_type_list->ImportOptions->visible()) { ?>
<?php $account_type_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($account_type_list->SearchOptions->visible()) { ?>
<?php $account_type_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($account_type_list->FilterOptions->visible()) { ?>
<?php $account_type_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$account_type_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$account_type->isExport() && !$account_type->CurrentAction) { ?>
<form name="faccount_typelistsrch" id="faccount_typelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($account_type_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="faccount_typelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="account_type">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($account_type_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($account_type_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $account_type_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($account_type_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($account_type_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($account_type_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($account_type_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $account_type_list->showPageHeader(); ?>
<?php
$account_type_list->showMessage();
?>
<?php if ($account_type_list->TotalRecs > 0 || $account_type->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($account_type_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> account_type">
<?php if (!$account_type->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$account_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($account_type_list->Pager)) $account_type_list->Pager = new PrevNextPager($account_type_list->StartRec, $account_type_list->DisplayRecs, $account_type_list->TotalRecs, $account_type_list->AutoHidePager) ?>
<?php if ($account_type_list->Pager->RecordCount > 0 && $account_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($account_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($account_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $account_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($account_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($account_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $account_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($account_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $account_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $account_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $account_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($account_type_list->TotalRecs > 0 && (!$account_type_list->AutoHidePageSizeSelector || $account_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="account_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($account_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($account_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($account_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($account_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($account_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($account_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $account_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="faccount_typelist" id="faccount_typelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_type_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_type_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_type">
<div id="gmp_account_type" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($account_type_list->TotalRecs > 0 || $account_type->isGridEdit()) { ?>
<table id="tbl_account_typelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$account_type_list->RowType = ROWTYPE_HEADER;

// Render list options
$account_type_list->renderListOptions();

// Render list options (header, left)
$account_type_list->ListOptions->render("header", "left");
?>
<?php if ($account_type->id->Visible) { // id ?>
	<?php if ($account_type->sortUrl($account_type->id) == "") { ?>
		<th data-name="id" class="<?php echo $account_type->id->headerCellClass() ?>"><div id="elh_account_type_id" class="account_type_id"><div class="ew-table-header-caption"><?php echo $account_type->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $account_type->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_type->SortUrl($account_type->id) ?>',2);"><div id="elh_account_type_id" class="account_type_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_type->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_type->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_type->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_type->item->Visible) { // item ?>
	<?php if ($account_type->sortUrl($account_type->item) == "") { ?>
		<th data-name="item" class="<?php echo $account_type->item->headerCellClass() ?>"><div id="elh_account_type_item" class="account_type_item"><div class="ew-table-header-caption"><?php echo $account_type->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $account_type->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_type->SortUrl($account_type->item) ?>',2);"><div id="elh_account_type_item" class="account_type_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_type->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($account_type->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_type->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_type->status->Visible) { // status ?>
	<?php if ($account_type->sortUrl($account_type->status) == "") { ?>
		<th data-name="status" class="<?php echo $account_type->status->headerCellClass() ?>"><div id="elh_account_type_status" class="account_type_status"><div class="ew-table-header-caption"><?php echo $account_type->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $account_type->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_type->SortUrl($account_type->status) ?>',2);"><div id="elh_account_type_status" class="account_type_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_type->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_type->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_type->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_type->operator->Visible) { // operator ?>
	<?php if ($account_type->sortUrl($account_type->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $account_type->operator->headerCellClass() ?>"><div id="elh_account_type_operator" class="account_type_operator"><div class="ew-table-header-caption"><?php echo $account_type->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $account_type->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_type->SortUrl($account_type->operator) ?>',2);"><div id="elh_account_type_operator" class="account_type_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_type->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_type->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_type->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($account_type->datetime->Visible) { // datetime ?>
	<?php if ($account_type->sortUrl($account_type->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $account_type->datetime->headerCellClass() ?>"><div id="elh_account_type_datetime" class="account_type_datetime"><div class="ew-table-header-caption"><?php echo $account_type->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $account_type->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $account_type->SortUrl($account_type->datetime) ?>',2);"><div id="elh_account_type_datetime" class="account_type_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $account_type->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($account_type->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($account_type->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$account_type_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($account_type->ExportAll && $account_type->isExport()) {
	$account_type_list->StopRec = $account_type_list->TotalRecs;
} else {

	// Set the last record to display
	if ($account_type_list->TotalRecs > $account_type_list->StartRec + $account_type_list->DisplayRecs - 1)
		$account_type_list->StopRec = $account_type_list->StartRec + $account_type_list->DisplayRecs - 1;
	else
		$account_type_list->StopRec = $account_type_list->TotalRecs;
}
$account_type_list->RecCnt = $account_type_list->StartRec - 1;
if ($account_type_list->Recordset && !$account_type_list->Recordset->EOF) {
	$account_type_list->Recordset->moveFirst();
	$selectLimit = $account_type_list->UseSelectLimit;
	if (!$selectLimit && $account_type_list->StartRec > 1)
		$account_type_list->Recordset->move($account_type_list->StartRec - 1);
} elseif (!$account_type->AllowAddDeleteRow && $account_type_list->StopRec == 0) {
	$account_type_list->StopRec = $account_type->GridAddRowCount;
}

// Initialize aggregate
$account_type->RowType = ROWTYPE_AGGREGATEINIT;
$account_type->resetAttributes();
$account_type_list->renderRow();
while ($account_type_list->RecCnt < $account_type_list->StopRec) {
	$account_type_list->RecCnt++;
	if ($account_type_list->RecCnt >= $account_type_list->StartRec) {
		$account_type_list->RowCnt++;

		// Set up key count
		$account_type_list->KeyCount = $account_type_list->RowIndex;

		// Init row class and style
		$account_type->resetAttributes();
		$account_type->CssClass = "";
		if ($account_type->isGridAdd()) {
		} else {
			$account_type_list->loadRowValues($account_type_list->Recordset); // Load row values
		}
		$account_type->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$account_type->RowAttrs = array_merge($account_type->RowAttrs, array('data-rowindex'=>$account_type_list->RowCnt, 'id'=>'r' . $account_type_list->RowCnt . '_account_type', 'data-rowtype'=>$account_type->RowType));

		// Render row
		$account_type_list->renderRow();

		// Render list options
		$account_type_list->renderListOptions();
?>
	<tr<?php echo $account_type->rowAttributes() ?>>
<?php

// Render list options (body, left)
$account_type_list->ListOptions->render("body", "left", $account_type_list->RowCnt);
?>
	<?php if ($account_type->id->Visible) { // id ?>
		<td data-name="id"<?php echo $account_type->id->cellAttributes() ?>>
<span id="el<?php echo $account_type_list->RowCnt ?>_account_type_id" class="account_type_id">
<span<?php echo $account_type->id->viewAttributes() ?>>
<?php echo $account_type->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_type->item->Visible) { // item ?>
		<td data-name="item"<?php echo $account_type->item->cellAttributes() ?>>
<span id="el<?php echo $account_type_list->RowCnt ?>_account_type_item" class="account_type_item">
<span<?php echo $account_type->item->viewAttributes() ?>>
<?php echo $account_type->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_type->status->Visible) { // status ?>
		<td data-name="status"<?php echo $account_type->status->cellAttributes() ?>>
<span id="el<?php echo $account_type_list->RowCnt ?>_account_type_status" class="account_type_status">
<span<?php echo $account_type->status->viewAttributes() ?>>
<?php echo $account_type->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_type->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $account_type->operator->cellAttributes() ?>>
<span id="el<?php echo $account_type_list->RowCnt ?>_account_type_operator" class="account_type_operator">
<span<?php echo $account_type->operator->viewAttributes() ?>>
<?php echo $account_type->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($account_type->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $account_type->datetime->cellAttributes() ?>>
<span id="el<?php echo $account_type_list->RowCnt ?>_account_type_datetime" class="account_type_datetime">
<span<?php echo $account_type->datetime->viewAttributes() ?>>
<?php echo $account_type->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$account_type_list->ListOptions->render("body", "right", $account_type_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$account_type->isGridAdd())
		$account_type_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$account_type->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($account_type_list->Recordset)
	$account_type_list->Recordset->Close();
?>
<?php if (!$account_type->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$account_type->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($account_type_list->Pager)) $account_type_list->Pager = new PrevNextPager($account_type_list->StartRec, $account_type_list->DisplayRecs, $account_type_list->TotalRecs, $account_type_list->AutoHidePager) ?>
<?php if ($account_type_list->Pager->RecordCount > 0 && $account_type_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($account_type_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($account_type_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $account_type_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($account_type_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($account_type_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $account_type_list->pageUrl() ?>start=<?php echo $account_type_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $account_type_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($account_type_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $account_type_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $account_type_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $account_type_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($account_type_list->TotalRecs > 0 && (!$account_type_list->AutoHidePageSizeSelector || $account_type_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="account_type">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($account_type_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($account_type_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($account_type_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($account_type_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($account_type_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($account_type->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $account_type_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($account_type_list->TotalRecs == 0 && !$account_type->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $account_type_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$account_type_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$account_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$account_type->isExport()) { ?>
<script>
ew.scrollableTable("gmp_account_type", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$account_type_list->terminate();
?>