<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_type_search = new account_type_search();

// Run the page
$account_type_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_type_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($account_type_search->IsModal) { ?>
var faccount_typesearch = currentAdvancedSearchForm = new ew.Form("faccount_typesearch", "search");
<?php } else { ?>
var faccount_typesearch = currentForm = new ew.Form("faccount_typesearch", "search");
<?php } ?>

// Form_CustomValidate event
faccount_typesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_typesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_typesearch.lists["x_status"] = <?php echo $account_type_search->status->Lookup->toClientList() ?>;
faccount_typesearch.lists["x_status"].options = <?php echo JsonEncode($account_type_search->status->options(FALSE, TRUE)) ?>;
faccount_typesearch.lists["x_operator"] = <?php echo $account_type_search->operator->Lookup->toClientList() ?>;
faccount_typesearch.lists["x_operator"].options = <?php echo JsonEncode($account_type_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

faccount_typesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_type->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($account_type->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $account_type_search->showPageHeader(); ?>
<?php
$account_type_search->showMessage();
?>
<form name="faccount_typesearch" id="faccount_typesearch" class="<?php echo $account_type_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_type_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_type_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_type">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$account_type_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($account_type->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $account_type_search->LeftColumnClass ?>"><span id="elh_account_type_id"><?php echo $account_type->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $account_type_search->RightColumnClass ?>"><div<?php echo $account_type->id->cellAttributes() ?>>
			<span id="el_account_type_id">
<input type="text" data-table="account_type" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($account_type->id->getPlaceHolder()) ?>" value="<?php echo $account_type->id->EditValue ?>"<?php echo $account_type->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_type->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label for="x_item" class="<?php echo $account_type_search->LeftColumnClass ?>"><span id="elh_account_type_item"><?php echo $account_type->item->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_item" id="z_item" value="LIKE"></span>
		</label>
		<div class="<?php echo $account_type_search->RightColumnClass ?>"><div<?php echo $account_type->item->cellAttributes() ?>>
			<span id="el_account_type_item">
<input type="text" data-table="account_type" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($account_type->item->getPlaceHolder()) ?>" value="<?php echo $account_type->item->EditValue ?>"<?php echo $account_type->item->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_type->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $account_type_search->LeftColumnClass ?>"><span id="elh_account_type_status"><?php echo $account_type->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $account_type_search->RightColumnClass ?>"><div<?php echo $account_type->status->cellAttributes() ?>>
			<span id="el_account_type_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_type" data-field="x_status" data-value-separator="<?php echo $account_type->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $account_type->status->editAttributes() ?>>
		<?php echo $account_type->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_type->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $account_type_search->LeftColumnClass ?>"><span id="elh_account_type_operator"><?php echo $account_type->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $account_type_search->RightColumnClass ?>"><div<?php echo $account_type->operator->cellAttributes() ?>>
			<span id="el_account_type_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="account_type" data-field="x_operator" data-value-separator="<?php echo $account_type->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $account_type->operator->editAttributes() ?>>
		<?php echo $account_type->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $account_type->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($account_type->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $account_type_search->LeftColumnClass ?>"><span id="elh_account_type_datetime"><?php echo $account_type->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $account_type_search->RightColumnClass ?>"><div<?php echo $account_type->datetime->cellAttributes() ?>>
			<span id="el_account_type_datetime">
<input type="text" data-table="account_type" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($account_type->datetime->getPlaceHolder()) ?>" value="<?php echo $account_type->datetime->EditValue ?>"<?php echo $account_type->datetime->editAttributes() ?>>
<?php if (!$account_type->datetime->ReadOnly && !$account_type->datetime->Disabled && !isset($account_type->datetime->EditAttrs["readonly"]) && !isset($account_type->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("faccount_typesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$account_type_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $account_type_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$account_type_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$account_type_search->terminate();
?>