<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$account_type_view = new account_type_view();

// Run the page
$account_type_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$account_type_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$account_type->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var faccount_typeview = currentForm = new ew.Form("faccount_typeview", "view");

// Form_CustomValidate event
faccount_typeview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faccount_typeview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
faccount_typeview.lists["x_status"] = <?php echo $account_type_view->status->Lookup->toClientList() ?>;
faccount_typeview.lists["x_status"].options = <?php echo JsonEncode($account_type_view->status->options(FALSE, TRUE)) ?>;
faccount_typeview.lists["x_operator"] = <?php echo $account_type_view->operator->Lookup->toClientList() ?>;
faccount_typeview.lists["x_operator"].options = <?php echo JsonEncode($account_type_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$account_type->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $account_type_view->ExportOptions->render("body") ?>
<?php $account_type_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $account_type_view->showPageHeader(); ?>
<?php
$account_type_view->showMessage();
?>
<form name="faccount_typeview" id="faccount_typeview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($account_type_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $account_type_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="account_type">
<input type="hidden" name="modal" value="<?php echo (int)$account_type_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($account_type->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $account_type_view->TableLeftColumnClass ?>"><span id="elh_account_type_id"><?php echo $account_type->id->caption() ?></span></td>
		<td data-name="id"<?php echo $account_type->id->cellAttributes() ?>>
<span id="el_account_type_id">
<span<?php echo $account_type->id->viewAttributes() ?>>
<?php echo $account_type->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_type->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $account_type_view->TableLeftColumnClass ?>"><span id="elh_account_type_item"><?php echo $account_type->item->caption() ?></span></td>
		<td data-name="item"<?php echo $account_type->item->cellAttributes() ?>>
<span id="el_account_type_item">
<span<?php echo $account_type->item->viewAttributes() ?>>
<?php echo $account_type->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_type->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $account_type_view->TableLeftColumnClass ?>"><span id="elh_account_type_status"><?php echo $account_type->status->caption() ?></span></td>
		<td data-name="status"<?php echo $account_type->status->cellAttributes() ?>>
<span id="el_account_type_status">
<span<?php echo $account_type->status->viewAttributes() ?>>
<?php echo $account_type->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_type->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $account_type_view->TableLeftColumnClass ?>"><span id="elh_account_type_operator"><?php echo $account_type->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $account_type->operator->cellAttributes() ?>>
<span id="el_account_type_operator">
<span<?php echo $account_type->operator->viewAttributes() ?>>
<?php echo $account_type->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($account_type->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $account_type_view->TableLeftColumnClass ?>"><span id="elh_account_type_datetime"><?php echo $account_type->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $account_type->datetime->cellAttributes() ?>>
<span id="el_account_type_datetime">
<span<?php echo $account_type->datetime->viewAttributes() ?>>
<?php echo $account_type->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$account_type_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$account_type->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$account_type_view->terminate();
?>