<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$admin_category_add = new admin_category_add();

// Run the page
$admin_category_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$admin_category_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fadmin_categoryadd = currentForm = new ew.Form("fadmin_categoryadd", "add");

// Validate form
fadmin_categoryadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($admin_category_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_category->item->caption(), $admin_category->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_category_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_category->status->caption(), $admin_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_category_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_category->operator->caption(), $admin_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_category->operator->errorMessage()) ?>");
		<?php if ($admin_category_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_category->datetime->caption(), $admin_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_category->datetime->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fadmin_categoryadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fadmin_categoryadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fadmin_categoryadd.lists["x_status"] = <?php echo $admin_category_add->status->Lookup->toClientList() ?>;
fadmin_categoryadd.lists["x_status"].options = <?php echo JsonEncode($admin_category_add->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $admin_category_add->showPageHeader(); ?>
<?php
$admin_category_add->showMessage();
?>
<form name="fadmin_categoryadd" id="fadmin_categoryadd" class="<?php echo $admin_category_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($admin_category_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $admin_category_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="admin_category">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$admin_category_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($admin_category->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_admin_category_item" for="x_item" class="<?php echo $admin_category_add->LeftColumnClass ?>"><?php echo $admin_category->item->caption() ?><?php echo ($admin_category->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_category_add->RightColumnClass ?>"><div<?php echo $admin_category->item->cellAttributes() ?>>
<span id="el_admin_category_item">
<input type="text" data-table="admin_category" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($admin_category->item->getPlaceHolder()) ?>" value="<?php echo $admin_category->item->EditValue ?>"<?php echo $admin_category->item->editAttributes() ?>>
</span>
<?php echo $admin_category->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_category->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_admin_category_status" for="x_status" class="<?php echo $admin_category_add->LeftColumnClass ?>"><?php echo $admin_category->status->caption() ?><?php echo ($admin_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_category_add->RightColumnClass ?>"><div<?php echo $admin_category->status->cellAttributes() ?>>
<span id="el_admin_category_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_category" data-field="x_status" data-value-separator="<?php echo $admin_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $admin_category->status->editAttributes() ?>>
		<?php echo $admin_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $admin_category->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_category->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label id="elh_admin_category_operator" for="x_operator" class="<?php echo $admin_category_add->LeftColumnClass ?>"><?php echo $admin_category->operator->caption() ?><?php echo ($admin_category->operator->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_category_add->RightColumnClass ?>"><div<?php echo $admin_category->operator->cellAttributes() ?>>
<span id="el_admin_category_operator">
<input type="text" data-table="admin_category" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($admin_category->operator->getPlaceHolder()) ?>" value="<?php echo $admin_category->operator->EditValue ?>"<?php echo $admin_category->operator->editAttributes() ?>>
</span>
<?php echo $admin_category->operator->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_category->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label id="elh_admin_category_datetime" for="x_datetime" class="<?php echo $admin_category_add->LeftColumnClass ?>"><?php echo $admin_category->datetime->caption() ?><?php echo ($admin_category->datetime->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_category_add->RightColumnClass ?>"><div<?php echo $admin_category->datetime->cellAttributes() ?>>
<span id="el_admin_category_datetime">
<input type="text" data-table="admin_category" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($admin_category->datetime->getPlaceHolder()) ?>" value="<?php echo $admin_category->datetime->EditValue ?>"<?php echo $admin_category->datetime->editAttributes() ?>>
<?php if (!$admin_category->datetime->ReadOnly && !$admin_category->datetime->Disabled && !isset($admin_category->datetime->EditAttrs["readonly"]) && !isset($admin_category->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fadmin_categoryadd", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $admin_category->datetime->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$admin_category_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $admin_category_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $admin_category_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$admin_category_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$admin_category_add->terminate();
?>