<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$admin_office_add = new admin_office_add();

// Run the page
$admin_office_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$admin_office_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fadmin_officeadd = currentForm = new ew.Form("fadmin_officeadd", "add");

// Validate form
fadmin_officeadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($admin_office_add->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->user_name->caption(), $admin_office->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->password->caption(), $admin_office->password->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && $(elm).hasClass("ew-password-strength") && !$(elm).data("validated"))
				return this.onError(elm, ew.language.phrase("PasswordTooSimple"));
		<?php if ($admin_office_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->address->caption(), $admin_office->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->mobile->caption(), $admin_office->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->mobile->errorMessage()) ?>");
		<?php if ($admin_office_add->userlevel->Required) { ?>
			elm = this.getElements("x" + infix + "_userlevel");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->userlevel->caption(), $admin_office->userlevel->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->_email->caption(), $admin_office->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->activated->Required) { ?>
			elm = this.getElements("x" + infix + "_activated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->activated->caption(), $admin_office->activated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->operator->caption(), $admin_office->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->datetime->caption(), $admin_office->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->reports_to->caption(), $admin_office->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->mobile_id->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->mobile_id->caption(), $admin_office->mobile_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->mobile_token_id->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_token_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->mobile_token_id->caption(), $admin_office->mobile_token_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->site->caption(), $admin_office->site->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_site");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->site->errorMessage()) ?>");
		<?php if ($admin_office_add->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->formal_name->caption(), $admin_office->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->company_id->caption(), $admin_office->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->company_id->errorMessage()) ?>");
		<?php if ($admin_office_add->reg_ip->Required) { ?>
			elm = this.getElements("x" + infix + "_reg_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->reg_ip->caption(), $admin_office->reg_ip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_add->pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->pp_id->caption(), $admin_office->pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->pp_id->errorMessage()) ?>");
		<?php if ($admin_office_add->profile_old->Required) { ?>
			elm = this.getElements("x" + infix + "_profile_old");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->profile_old->caption(), $admin_office->profile_old->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fadmin_officeadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fadmin_officeadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fadmin_officeadd.lists["x_userlevel"] = <?php echo $admin_office_add->userlevel->Lookup->toClientList() ?>;
fadmin_officeadd.lists["x_userlevel"].options = <?php echo JsonEncode($admin_office_add->userlevel->lookupOptions()) ?>;
fadmin_officeadd.lists["x_activated"] = <?php echo $admin_office_add->activated->Lookup->toClientList() ?>;
fadmin_officeadd.lists["x_activated"].options = <?php echo JsonEncode($admin_office_add->activated->options(FALSE, TRUE)) ?>;
fadmin_officeadd.lists["x_operator"] = <?php echo $admin_office_add->operator->Lookup->toClientList() ?>;
fadmin_officeadd.lists["x_operator"].options = <?php echo JsonEncode($admin_office_add->operator->lookupOptions()) ?>;
fadmin_officeadd.lists["x_reports_to"] = <?php echo $admin_office_add->reports_to->Lookup->toClientList() ?>;
fadmin_officeadd.lists["x_reports_to"].options = <?php echo JsonEncode($admin_office_add->reports_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $admin_office_add->showPageHeader(); ?>
<?php
$admin_office_add->showMessage();
?>
<form name="fadmin_officeadd" id="fadmin_officeadd" class="<?php echo $admin_office_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($admin_office_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $admin_office_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="admin_office">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$admin_office_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($admin_office->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_admin_office_user_name" for="x_user_name" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->user_name->caption() ?><?php echo ($admin_office->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->user_name->cellAttributes() ?>>
<span id="el_admin_office_user_name">
<input type="text" data-table="admin_office" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin_office->user_name->getPlaceHolder()) ?>" value="<?php echo $admin_office->user_name->EditValue ?>"<?php echo $admin_office->user_name->editAttributes() ?>>
</span>
<?php echo $admin_office->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label id="elh_admin_office_password" for="x_password" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->password->caption() ?><?php echo ($admin_office->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->password->cellAttributes() ?>>
<span id="el_admin_office_password">
<div class="input-group" id="ig_password">
<input type="password" data-password-strength="pst_password" data-password-generated="pgt_password" data-table="admin_office" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($admin_office->password->getPlaceHolder()) ?>"<?php echo $admin_office->password->editAttributes() ?>>
<div class="input-group-append">
	<button type="button" class="btn btn-default ew-password-generator" title="<?php echo HtmlTitle($Language->phrase("GeneratePassword")) ?>" data-password-field="x_password" data-password-confirm="c_password" data-password-strength="pst_password" data-password-generated="pgt_password"><?php echo $Language->phrase("GeneratePassword") ?></button>
</div>
</div>
<small class="form-text d-none" id="pgt_password"></small>
<div class="progress ew-password-strength-bar form-text mt-1 d-none" id="pst_password">
	<div class="progress-bar" role="progressbar"></div>
</div>
</span>
<?php echo $admin_office->password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_admin_office_address" for="x_address" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->address->caption() ?><?php echo ($admin_office->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->address->cellAttributes() ?>>
<span id="el_admin_office_address">
<textarea data-table="admin_office" data-field="x_address" name="x_address" id="x_address" cols="30" rows="3" placeholder="<?php echo HtmlEncode($admin_office->address->getPlaceHolder()) ?>"<?php echo $admin_office->address->editAttributes() ?>><?php echo $admin_office->address->EditValue ?></textarea>
</span>
<?php echo $admin_office->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_admin_office_mobile" for="x_mobile" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->mobile->caption() ?><?php echo ($admin_office->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->mobile->cellAttributes() ?>>
<span id="el_admin_office_mobile">
<input type="text" data-table="admin_office" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" placeholder="<?php echo HtmlEncode($admin_office->mobile->getPlaceHolder()) ?>" value="<?php echo $admin_office->mobile->EditValue ?>"<?php echo $admin_office->mobile->editAttributes() ?>>
</span>
<?php echo $admin_office->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->userlevel->Visible) { // userlevel ?>
	<div id="r_userlevel" class="form-group row">
		<label id="elh_admin_office_userlevel" for="x_userlevel" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->userlevel->caption() ?><?php echo ($admin_office->userlevel->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->userlevel->cellAttributes() ?>>
<span id="el_admin_office_userlevel">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_office" data-field="x_userlevel" data-value-separator="<?php echo $admin_office->userlevel->displayValueSeparatorAttribute() ?>" id="x_userlevel" name="x_userlevel"<?php echo $admin_office->userlevel->editAttributes() ?>>
		<?php echo $admin_office->userlevel->selectOptionListHtml("x_userlevel") ?>
	</select>
</div>
<?php echo $admin_office->userlevel->Lookup->getParamTag("p_x_userlevel") ?>
</span>
<?php echo $admin_office->userlevel->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_admin_office__email" for="x__email" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->_email->caption() ?><?php echo ($admin_office->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->_email->cellAttributes() ?>>
<span id="el_admin_office__email">
<input type="text" data-table="admin_office" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin_office->_email->getPlaceHolder()) ?>" value="<?php echo $admin_office->_email->EditValue ?>"<?php echo $admin_office->_email->editAttributes() ?>>
</span>
<?php echo $admin_office->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->activated->Visible) { // activated ?>
	<div id="r_activated" class="form-group row">
		<label id="elh_admin_office_activated" for="x_activated" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->activated->caption() ?><?php echo ($admin_office->activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->activated->cellAttributes() ?>>
<span id="el_admin_office_activated">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_office" data-field="x_activated" data-value-separator="<?php echo $admin_office->activated->displayValueSeparatorAttribute() ?>" id="x_activated" name="x_activated"<?php echo $admin_office->activated->editAttributes() ?>>
		<?php echo $admin_office->activated->selectOptionListHtml("x_activated") ?>
	</select>
</div>
</span>
<?php echo $admin_office->activated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_admin_office_reports_to" for="x_reports_to" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->reports_to->caption() ?><?php echo ($admin_office->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->reports_to->cellAttributes() ?>>
<span id="el_admin_office_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_office" data-field="x_reports_to" data-value-separator="<?php echo $admin_office->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $admin_office->reports_to->editAttributes() ?>>
		<?php echo $admin_office->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $admin_office->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $admin_office->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->mobile_id->Visible) { // mobile_id ?>
	<div id="r_mobile_id" class="form-group row">
		<label id="elh_admin_office_mobile_id" for="x_mobile_id" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->mobile_id->caption() ?><?php echo ($admin_office->mobile_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->mobile_id->cellAttributes() ?>>
<span id="el_admin_office_mobile_id">
<input type="text" data-table="admin_office" data-field="x_mobile_id" name="x_mobile_id" id="x_mobile_id" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($admin_office->mobile_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->mobile_id->EditValue ?>"<?php echo $admin_office->mobile_id->editAttributes() ?>>
</span>
<?php echo $admin_office->mobile_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->mobile_token_id->Visible) { // mobile_token_id ?>
	<div id="r_mobile_token_id" class="form-group row">
		<label id="elh_admin_office_mobile_token_id" for="x_mobile_token_id" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->mobile_token_id->caption() ?><?php echo ($admin_office->mobile_token_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->mobile_token_id->cellAttributes() ?>>
<span id="el_admin_office_mobile_token_id">
<input type="text" data-table="admin_office" data-field="x_mobile_token_id" name="x_mobile_token_id" id="x_mobile_token_id" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($admin_office->mobile_token_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->mobile_token_id->EditValue ?>"<?php echo $admin_office->mobile_token_id->editAttributes() ?>>
</span>
<?php echo $admin_office->mobile_token_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->site->Visible) { // site ?>
	<div id="r_site" class="form-group row">
		<label id="elh_admin_office_site" for="x_site" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->site->caption() ?><?php echo ($admin_office->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->site->cellAttributes() ?>>
<span id="el_admin_office_site">
<input type="text" data-table="admin_office" data-field="x_site" name="x_site" id="x_site" size="30" placeholder="<?php echo HtmlEncode($admin_office->site->getPlaceHolder()) ?>" value="<?php echo $admin_office->site->EditValue ?>"<?php echo $admin_office->site->editAttributes() ?>>
</span>
<?php echo $admin_office->site->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_admin_office_formal_name" for="x_formal_name" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->formal_name->caption() ?><?php echo ($admin_office->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->formal_name->cellAttributes() ?>>
<span id="el_admin_office_formal_name">
<input type="text" data-table="admin_office" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin_office->formal_name->getPlaceHolder()) ?>" value="<?php echo $admin_office->formal_name->EditValue ?>"<?php echo $admin_office->formal_name->editAttributes() ?>>
</span>
<?php echo $admin_office->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_admin_office_company_id" for="x_company_id" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->company_id->caption() ?><?php echo ($admin_office->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->company_id->cellAttributes() ?>>
<span id="el_admin_office_company_id">
<input type="text" data-table="admin_office" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($admin_office->company_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->company_id->EditValue ?>"<?php echo $admin_office->company_id->editAttributes() ?>>
</span>
<?php echo $admin_office->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->reg_ip->Visible) { // reg_ip ?>
	<div id="r_reg_ip" class="form-group row">
		<label id="elh_admin_office_reg_ip" for="x_reg_ip" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->reg_ip->caption() ?><?php echo ($admin_office->reg_ip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->reg_ip->cellAttributes() ?>>
<span id="el_admin_office_reg_ip">
<input type="text" data-table="admin_office" data-field="x_reg_ip" name="x_reg_ip" id="x_reg_ip" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($admin_office->reg_ip->getPlaceHolder()) ?>" value="<?php echo $admin_office->reg_ip->EditValue ?>"<?php echo $admin_office->reg_ip->editAttributes() ?>>
</span>
<?php echo $admin_office->reg_ip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label id="elh_admin_office_pp_id" for="x_pp_id" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->pp_id->caption() ?><?php echo ($admin_office->pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->pp_id->cellAttributes() ?>>
<span id="el_admin_office_pp_id">
<input type="text" data-table="admin_office" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($admin_office->pp_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->pp_id->EditValue ?>"<?php echo $admin_office->pp_id->editAttributes() ?>>
</span>
<?php echo $admin_office->pp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin_office->profile_old->Visible) { // profile_old ?>
	<div id="r_profile_old" class="form-group row">
		<label id="elh_admin_office_profile_old" for="x_profile_old" class="<?php echo $admin_office_add->LeftColumnClass ?>"><?php echo $admin_office->profile_old->caption() ?><?php echo ($admin_office->profile_old->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_office_add->RightColumnClass ?>"><div<?php echo $admin_office->profile_old->cellAttributes() ?>>
<span id="el_admin_office_profile_old">
<textarea data-table="admin_office" data-field="x_profile_old" name="x_profile_old" id="x_profile_old" cols="35" rows="4" placeholder="<?php echo HtmlEncode($admin_office->profile_old->getPlaceHolder()) ?>"<?php echo $admin_office->profile_old->editAttributes() ?>><?php echo $admin_office->profile_old->EditValue ?></textarea>
</span>
<?php echo $admin_office->profile_old->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$admin_office_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $admin_office_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $admin_office_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$admin_office_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$admin_office_add->terminate();
?>