<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$admin_office_addopt = new admin_office_addopt();

// Run the page
$admin_office_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$admin_office_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fadmin_officeaddopt = currentForm = new ew.Form("fadmin_officeaddopt", "addopt");

// Validate form
fadmin_officeaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($admin_office_addopt->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->user_name->caption(), $admin_office->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->password->caption(), $admin_office->password->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && $(elm).hasClass("ew-password-strength") && !$(elm).data("validated"))
				return this.onError(elm, ew.language.phrase("PasswordTooSimple"));
		<?php if ($admin_office_addopt->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->address->caption(), $admin_office->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->mobile->caption(), $admin_office->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->mobile->errorMessage()) ?>");
		<?php if ($admin_office_addopt->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->category->caption(), $admin_office->category->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->category->errorMessage()) ?>");
		<?php if ($admin_office_addopt->userlevel->Required) { ?>
			elm = this.getElements("x" + infix + "_userlevel");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->userlevel->caption(), $admin_office->userlevel->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->_email->caption(), $admin_office->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->activated->Required) { ?>
			elm = this.getElements("x" + infix + "_activated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->activated->caption(), $admin_office->activated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->operator->caption(), $admin_office->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->datetime->caption(), $admin_office->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->reports_to->caption(), $admin_office->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->profile->Required) { ?>
			elm = this.getElements("x" + infix + "_profile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->profile->caption(), $admin_office->profile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->mobile_id->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->mobile_id->caption(), $admin_office->mobile_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->mobile_token_id->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile_token_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->mobile_token_id->caption(), $admin_office->mobile_token_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->site->caption(), $admin_office->site->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_site");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->site->errorMessage()) ?>");
		<?php if ($admin_office_addopt->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->formal_name->caption(), $admin_office->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->company_id->caption(), $admin_office->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->company_id->errorMessage()) ?>");
		<?php if ($admin_office_addopt->reg_ip->Required) { ?>
			elm = this.getElements("x" + infix + "_reg_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->reg_ip->caption(), $admin_office->reg_ip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_office_addopt->pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->pp_id->caption(), $admin_office->pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin_office->pp_id->errorMessage()) ?>");
		<?php if ($admin_office_addopt->profile_old->Required) { ?>
			elm = this.getElements("x" + infix + "_profile_old");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin_office->profile_old->caption(), $admin_office->profile_old->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fadmin_officeaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fadmin_officeaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fadmin_officeaddopt.lists["x_userlevel"] = <?php echo $admin_office_addopt->userlevel->Lookup->toClientList() ?>;
fadmin_officeaddopt.lists["x_userlevel"].options = <?php echo JsonEncode($admin_office_addopt->userlevel->lookupOptions()) ?>;
fadmin_officeaddopt.lists["x_activated"] = <?php echo $admin_office_addopt->activated->Lookup->toClientList() ?>;
fadmin_officeaddopt.lists["x_activated"].options = <?php echo JsonEncode($admin_office_addopt->activated->options(FALSE, TRUE)) ?>;
fadmin_officeaddopt.lists["x_operator"] = <?php echo $admin_office_addopt->operator->Lookup->toClientList() ?>;
fadmin_officeaddopt.lists["x_operator"].options = <?php echo JsonEncode($admin_office_addopt->operator->lookupOptions()) ?>;
fadmin_officeaddopt.lists["x_reports_to"] = <?php echo $admin_office_addopt->reports_to->Lookup->toClientList() ?>;
fadmin_officeaddopt.lists["x_reports_to"].options = <?php echo JsonEncode($admin_office_addopt->reports_to->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $admin_office_addopt->showPageHeader(); ?>
<?php
$admin_office_addopt->showMessage();
?>
<form name="fadmin_officeaddopt" id="fadmin_officeaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($admin_office_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $admin_office_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $admin_office_addopt->TableVar ?>">
<?php if ($admin_office->user_name->Visible) { // user_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_user_name"><?php echo $admin_office->user_name->caption() ?><?php echo ($admin_office->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin_office->user_name->getPlaceHolder()) ?>" value="<?php echo $admin_office->user_name->EditValue ?>"<?php echo $admin_office->user_name->editAttributes() ?>>
<?php echo $admin_office->user_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->password->Visible) { // password ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_password"><?php echo $admin_office->password->caption() ?><?php echo ($admin_office->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group" id="ig_password">
<input type="password" data-password-strength="pst_password" data-password-generated="pgt_password" data-table="admin_office" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($admin_office->password->getPlaceHolder()) ?>"<?php echo $admin_office->password->editAttributes() ?>>
<div class="input-group-append">
	<button type="button" class="btn btn-default ew-password-generator" title="<?php echo HtmlTitle($Language->phrase("GeneratePassword")) ?>" data-password-field="x_password" data-password-confirm="c_password" data-password-strength="pst_password" data-password-generated="pgt_password"><?php echo $Language->phrase("GeneratePassword") ?></button>
</div>
</div>
<small class="form-text d-none" id="pgt_password"></small>
<div class="progress ew-password-strength-bar form-text mt-1 d-none" id="pst_password">
	<div class="progress-bar" role="progressbar"></div>
</div>
<?php echo $admin_office->password->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->address->Visible) { // address ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_address"><?php echo $admin_office->address->caption() ?><?php echo ($admin_office->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="admin_office" data-field="x_address" name="x_address" id="x_address" cols="30" rows="3" placeholder="<?php echo HtmlEncode($admin_office->address->getPlaceHolder()) ?>"<?php echo $admin_office->address->editAttributes() ?>><?php echo $admin_office->address->EditValue ?></textarea>
<?php echo $admin_office->address->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->mobile->Visible) { // mobile ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile"><?php echo $admin_office->mobile->caption() ?><?php echo ($admin_office->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" placeholder="<?php echo HtmlEncode($admin_office->mobile->getPlaceHolder()) ?>" value="<?php echo $admin_office->mobile->EditValue ?>"<?php echo $admin_office->mobile->editAttributes() ?>>
<?php echo $admin_office->mobile->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->category->Visible) { // category ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_category"><?php echo $admin_office->category->caption() ?><?php echo ($admin_office->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_category" name="x_category" id="x_category" size="30" placeholder="<?php echo HtmlEncode($admin_office->category->getPlaceHolder()) ?>" value="<?php echo $admin_office->category->EditValue ?>"<?php echo $admin_office->category->editAttributes() ?>>
<?php echo $admin_office->category->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->userlevel->Visible) { // userlevel ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_userlevel"><?php echo $admin_office->userlevel->caption() ?><?php echo ($admin_office->userlevel->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_office" data-field="x_userlevel" data-value-separator="<?php echo $admin_office->userlevel->displayValueSeparatorAttribute() ?>" id="x_userlevel" name="x_userlevel"<?php echo $admin_office->userlevel->editAttributes() ?>>
		<?php echo $admin_office->userlevel->selectOptionListHtml("x_userlevel") ?>
	</select>
</div>
<?php echo $admin_office->userlevel->Lookup->getParamTag("p_x_userlevel") ?>
<?php echo $admin_office->userlevel->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->_email->Visible) { // email ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x__email"><?php echo $admin_office->_email->caption() ?><?php echo ($admin_office->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin_office->_email->getPlaceHolder()) ?>" value="<?php echo $admin_office->_email->EditValue ?>"<?php echo $admin_office->_email->editAttributes() ?>>
<?php echo $admin_office->_email->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->activated->Visible) { // activated ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_activated"><?php echo $admin_office->activated->caption() ?><?php echo ($admin_office->activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_office" data-field="x_activated" data-value-separator="<?php echo $admin_office->activated->displayValueSeparatorAttribute() ?>" id="x_activated" name="x_activated"<?php echo $admin_office->activated->editAttributes() ?>>
		<?php echo $admin_office->activated->selectOptionListHtml("x_activated") ?>
	</select>
</div>
<?php echo $admin_office->activated->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->operator->Visible) { // operator ?>
	<input type="hidden" data-table="admin_office" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($admin_office->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($admin_office->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="admin_office" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($admin_office->datetime->CurrentValue) ?>">
	<?php if (!$admin_office->datetime->ReadOnly && !$admin_office->datetime->Disabled && !isset($admin_office->datetime->EditAttrs["readonly"]) && !isset($admin_office->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fadmin_officeaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
<?php if ($admin_office->reports_to->Visible) { // reports_to ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_reports_to"><?php echo $admin_office->reports_to->caption() ?><?php echo ($admin_office->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin_office" data-field="x_reports_to" data-value-separator="<?php echo $admin_office->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $admin_office->reports_to->editAttributes() ?>>
		<?php echo $admin_office->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $admin_office->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
<?php echo $admin_office->reports_to->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->profile->Visible) { // profile ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_profile"><?php echo $admin_office->profile->caption() ?><?php echo ($admin_office->profile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="admin_office" data-field="x_profile" name="x_profile" id="x_profile" cols="35" rows="4" placeholder="<?php echo HtmlEncode($admin_office->profile->getPlaceHolder()) ?>"<?php echo $admin_office->profile->editAttributes() ?>><?php echo $admin_office->profile->EditValue ?></textarea>
<?php echo $admin_office->profile->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->mobile_id->Visible) { // mobile_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile_id"><?php echo $admin_office->mobile_id->caption() ?><?php echo ($admin_office->mobile_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_mobile_id" name="x_mobile_id" id="x_mobile_id" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($admin_office->mobile_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->mobile_id->EditValue ?>"<?php echo $admin_office->mobile_id->editAttributes() ?>>
<?php echo $admin_office->mobile_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->mobile_token_id->Visible) { // mobile_token_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_mobile_token_id"><?php echo $admin_office->mobile_token_id->caption() ?><?php echo ($admin_office->mobile_token_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_mobile_token_id" name="x_mobile_token_id" id="x_mobile_token_id" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($admin_office->mobile_token_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->mobile_token_id->EditValue ?>"<?php echo $admin_office->mobile_token_id->editAttributes() ?>>
<?php echo $admin_office->mobile_token_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->site->Visible) { // site ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_site"><?php echo $admin_office->site->caption() ?><?php echo ($admin_office->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_site" name="x_site" id="x_site" size="30" placeholder="<?php echo HtmlEncode($admin_office->site->getPlaceHolder()) ?>" value="<?php echo $admin_office->site->EditValue ?>"<?php echo $admin_office->site->editAttributes() ?>>
<?php echo $admin_office->site->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->formal_name->Visible) { // formal_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_formal_name"><?php echo $admin_office->formal_name->caption() ?><?php echo ($admin_office->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin_office->formal_name->getPlaceHolder()) ?>" value="<?php echo $admin_office->formal_name->EditValue ?>"<?php echo $admin_office->formal_name->editAttributes() ?>>
<?php echo $admin_office->formal_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->company_id->Visible) { // company_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_company_id"><?php echo $admin_office->company_id->caption() ?><?php echo ($admin_office->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_company_id" name="x_company_id" id="x_company_id" size="30" placeholder="<?php echo HtmlEncode($admin_office->company_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->company_id->EditValue ?>"<?php echo $admin_office->company_id->editAttributes() ?>>
<?php echo $admin_office->company_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->reg_ip->Visible) { // reg_ip ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_reg_ip"><?php echo $admin_office->reg_ip->caption() ?><?php echo ($admin_office->reg_ip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_reg_ip" name="x_reg_ip" id="x_reg_ip" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($admin_office->reg_ip->getPlaceHolder()) ?>" value="<?php echo $admin_office->reg_ip->EditValue ?>"<?php echo $admin_office->reg_ip->editAttributes() ?>>
<?php echo $admin_office->reg_ip->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->pp_id->Visible) { // pp_id ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_pp_id"><?php echo $admin_office->pp_id->caption() ?><?php echo ($admin_office->pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="admin_office" data-field="x_pp_id" name="x_pp_id" id="x_pp_id" size="30" placeholder="<?php echo HtmlEncode($admin_office->pp_id->getPlaceHolder()) ?>" value="<?php echo $admin_office->pp_id->EditValue ?>"<?php echo $admin_office->pp_id->editAttributes() ?>>
<?php echo $admin_office->pp_id->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($admin_office->profile_old->Visible) { // profile_old ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_profile_old"><?php echo $admin_office->profile_old->caption() ?><?php echo ($admin_office->profile_old->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<textarea data-table="admin_office" data-field="x_profile_old" name="x_profile_old" id="x_profile_old" cols="35" rows="4" placeholder="<?php echo HtmlEncode($admin_office->profile_old->getPlaceHolder()) ?>"<?php echo $admin_office->profile_old->editAttributes() ?>><?php echo $admin_office->profile_old->EditValue ?></textarea>
<?php echo $admin_office->profile_old->CustomMsg ?></div>
	</div>
<?php } ?>
</form>
<?php
$admin_office_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$admin_office_addopt->terminate();
?>