<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$admin_add = new admin_add();

// Run the page
$admin_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$admin_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fadminadd = currentForm = new ew.Form("fadminadd", "add");

// Validate form
fadminadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($admin_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->mobile->caption(), $admin->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->formal_name->caption(), $admin->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->password->caption(), $admin->password->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && $(elm).hasClass("ew-password-strength") && !$(elm).data("validated"))
				return this.onError(elm, ew.language.phrase("PasswordTooSimple"));
		<?php if ($admin_add->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->user_name->caption(), $admin->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->address->Required) { ?>
			elm = this.getElements("x" + infix + "_address");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->address->caption(), $admin->address->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->category->caption(), $admin->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->_email->caption(), $admin->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin->_email->errorMessage()) ?>");
		<?php if ($admin_add->company_id->Required) { ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->company_id->caption(), $admin->company_id->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_company_id");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($admin->company_id->errorMessage()) ?>");
		<?php if ($admin_add->pp_id->Required) { ?>
			elm = this.getElements("x" + infix + "_pp_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->pp_id->caption(), $admin->pp_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->site->Required) { ?>
			elm = this.getElements("x" + infix + "_site[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->site->caption(), $admin->site->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->reports_to->caption(), $admin->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->userlevel->Required) { ?>
			elm = this.getElements("x" + infix + "_userlevel");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->userlevel->caption(), $admin->userlevel->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->activated->Required) { ?>
			elm = this.getElements("x" + infix + "_activated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->activated->caption(), $admin->activated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->operator->caption(), $admin->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->datetime->caption(), $admin->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->reg_ip->Required) { ?>
			elm = this.getElements("x" + infix + "_reg_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->reg_ip->caption(), $admin->reg_ip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($admin_add->profile_old->Required) { ?>
			elm = this.getElements("x" + infix + "_profile_old");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $admin->profile_old->caption(), $admin->profile_old->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fadminadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fadminadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fadminadd.lists["x_category"] = <?php echo $admin_add->category->Lookup->toClientList() ?>;
fadminadd.lists["x_category"].options = <?php echo JsonEncode($admin_add->category->lookupOptions()) ?>;
fadminadd.lists["x_company_id"] = <?php echo $admin_add->company_id->Lookup->toClientList() ?>;
fadminadd.lists["x_company_id"].options = <?php echo JsonEncode($admin_add->company_id->lookupOptions()) ?>;
fadminadd.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fadminadd.lists["x_pp_id"] = <?php echo $admin_add->pp_id->Lookup->toClientList() ?>;
fadminadd.lists["x_pp_id"].options = <?php echo JsonEncode($admin_add->pp_id->lookupOptions()) ?>;
fadminadd.lists["x_site[]"] = <?php echo $admin_add->site->Lookup->toClientList() ?>;
fadminadd.lists["x_site[]"].options = <?php echo JsonEncode($admin_add->site->lookupOptions()) ?>;
fadminadd.lists["x_reports_to"] = <?php echo $admin_add->reports_to->Lookup->toClientList() ?>;
fadminadd.lists["x_reports_to"].options = <?php echo JsonEncode($admin_add->reports_to->lookupOptions()) ?>;
fadminadd.lists["x_userlevel"] = <?php echo $admin_add->userlevel->Lookup->toClientList() ?>;
fadminadd.lists["x_userlevel"].options = <?php echo JsonEncode($admin_add->userlevel->lookupOptions()) ?>;
fadminadd.lists["x_activated"] = <?php echo $admin_add->activated->Lookup->toClientList() ?>;
fadminadd.lists["x_activated"].options = <?php echo JsonEncode($admin_add->activated->options(FALSE, TRUE)) ?>;
fadminadd.lists["x_operator"] = <?php echo $admin_add->operator->Lookup->toClientList() ?>;
fadminadd.lists["x_operator"].options = <?php echo JsonEncode($admin_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $admin_add->showPageHeader(); ?>
<?php
$admin_add->showMessage();
?>
<form name="fadminadd" id="fadminadd" class="<?php echo $admin_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($admin_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $admin_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="admin">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$admin_add->IsModal ?>">
<!-- Fields to prevent google autofill -->
<input class="d-none" type="text" name="<?php echo Encrypt(Random()) ?>">
<input class="d-none" type="password" name="<?php echo Encrypt(Random()) ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($admin->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_admin_mobile" for="x_mobile" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->mobile->caption() ?><?php echo ($admin->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->mobile->cellAttributes() ?>>
<span id="el_admin_mobile">
<input type="text" data-table="admin" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" placeholder="<?php echo HtmlEncode($admin->mobile->getPlaceHolder()) ?>" value="<?php echo $admin->mobile->EditValue ?>"<?php echo $admin->mobile->editAttributes() ?>>
</span>
<?php echo $admin->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_admin_formal_name" for="x_formal_name" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->formal_name->caption() ?><?php echo ($admin->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->formal_name->cellAttributes() ?>>
<span id="el_admin_formal_name">
<input type="text" data-table="admin" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin->formal_name->getPlaceHolder()) ?>" value="<?php echo $admin->formal_name->EditValue ?>"<?php echo $admin->formal_name->editAttributes() ?>>
</span>
<?php echo $admin->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label id="elh_admin_password" for="x_password" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->password->caption() ?><?php echo ($admin->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->password->cellAttributes() ?>>
<span id="el_admin_password">
<div class="input-group" id="ig_password">
<input type="password" data-password-strength="pst_password" data-password-generated="pgt_password" data-table="admin" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($admin->password->getPlaceHolder()) ?>"<?php echo $admin->password->editAttributes() ?>>
<div class="input-group-append">
	<button type="button" class="btn btn-default ew-password-generator" title="<?php echo HtmlTitle($Language->phrase("GeneratePassword")) ?>" data-password-field="x_password" data-password-confirm="c_password" data-password-strength="pst_password" data-password-generated="pgt_password"><?php echo $Language->phrase("GeneratePassword") ?></button>
</div>
</div>
<small class="form-text d-none" id="pgt_password"></small>
<div class="progress ew-password-strength-bar form-text mt-1 d-none" id="pst_password">
	<div class="progress-bar" role="progressbar"></div>
</div>
</span>
<?php echo $admin->password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_admin_user_name" for="x_user_name" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->user_name->caption() ?><?php echo ($admin->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->user_name->cellAttributes() ?>>
<span id="el_admin_user_name">
<input type="text" data-table="admin" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin->user_name->getPlaceHolder()) ?>" value="<?php echo $admin->user_name->EditValue ?>"<?php echo $admin->user_name->editAttributes() ?>>
</span>
<?php echo $admin->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->address->Visible) { // address ?>
	<div id="r_address" class="form-group row">
		<label id="elh_admin_address" for="x_address" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->address->caption() ?><?php echo ($admin->address->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->address->cellAttributes() ?>>
<span id="el_admin_address">
<textarea data-table="admin" data-field="x_address" name="x_address" id="x_address" cols="30" rows="3" placeholder="<?php echo HtmlEncode($admin->address->getPlaceHolder()) ?>"<?php echo $admin->address->editAttributes() ?>><?php echo $admin->address->EditValue ?></textarea>
</span>
<?php echo $admin->address->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_admin_category" for="x_category" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->category->caption() ?><?php echo ($admin->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->category->cellAttributes() ?>>
<span id="el_admin_category">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_category" data-value-separator="<?php echo $admin->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $admin->category->editAttributes() ?>>
		<?php echo $admin->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $admin->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $admin->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_admin__email" for="x__email" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->_email->caption() ?><?php echo ($admin->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->_email->cellAttributes() ?>>
<span id="el_admin__email">
<input type="text" data-table="admin" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($admin->_email->getPlaceHolder()) ?>" value="<?php echo $admin->_email->EditValue ?>"<?php echo $admin->_email->editAttributes() ?>>
</span>
<?php echo $admin->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->company_id->Visible) { // company_id ?>
	<div id="r_company_id" class="form-group row">
		<label id="elh_admin_company_id" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->company_id->caption() ?><?php echo ($admin->company_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->company_id->cellAttributes() ?>>
<span id="el_admin_company_id">
<?php
$wrkonchange = "" . trim(@$admin->company_id->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$admin->company_id->EditAttrs["onchange"] = "";
?>
<span id="as_x_company_id" class="text-nowrap" style="z-index: 8910">
	<input type="text" class="form-control" name="sv_x_company_id" id="sv_x_company_id" value="<?php echo RemoveHtml($admin->company_id->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($admin->company_id->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($admin->company_id->getPlaceHolder()) ?>"<?php echo $admin->company_id->editAttributes() ?>>
</span>
<input type="hidden" data-table="admin" data-field="x_company_id" data-value-separator="<?php echo $admin->company_id->displayValueSeparatorAttribute() ?>" name="x_company_id" id="x_company_id" value="<?php echo HtmlEncode($admin->company_id->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fadminadd.createAutoSuggest({"id":"x_company_id","forceSelect":false});
</script>
<?php echo $admin->company_id->Lookup->getParamTag("p_x_company_id") ?>
</span>
<?php echo $admin->company_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->pp_id->Visible) { // pp_id ?>
	<div id="r_pp_id" class="form-group row">
		<label id="elh_admin_pp_id" for="x_pp_id" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->pp_id->caption() ?><?php echo ($admin->pp_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->pp_id->cellAttributes() ?>>
<span id="el_admin_pp_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_pp_id" data-value-separator="<?php echo $admin->pp_id->displayValueSeparatorAttribute() ?>" id="x_pp_id" name="x_pp_id"<?php echo $admin->pp_id->editAttributes() ?>>
		<?php echo $admin->pp_id->selectOptionListHtml("x_pp_id") ?>
	</select>
</div>
<?php echo $admin->pp_id->Lookup->getParamTag("p_x_pp_id") ?>
</span>
<?php echo $admin->pp_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->site->Visible) { // site ?>
	<div id="r_site" class="form-group row">
		<label id="elh_admin_site" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->site->caption() ?><?php echo ($admin->site->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->site->cellAttributes() ?>>
<span id="el_admin_site">
<div id="tp_x_site" class="ew-template"><input type="checkbox" class="form-check-input" data-table="admin" data-field="x_site" data-value-separator="<?php echo $admin->site->displayValueSeparatorAttribute() ?>" name="x_site[]" id="x_site[]" value="{value}"<?php echo $admin->site->editAttributes() ?>></div>
<div id="dsl_x_site" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $admin->site->checkBoxListHtml(FALSE, "x_site[]") ?>
</div></div>
<?php echo $admin->site->Lookup->getParamTag("p_x_site") ?>
</span>
<?php echo $admin->site->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_admin_reports_to" for="x_reports_to" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->reports_to->caption() ?><?php echo ($admin->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->reports_to->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span id="el_admin_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_reports_to" data-value-separator="<?php echo $admin->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $admin->reports_to->editAttributes() ?>>
		<?php echo $admin->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $admin->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php } else { ?>
<span id="el_admin_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_reports_to" data-value-separator="<?php echo $admin->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $admin->reports_to->editAttributes() ?>>
		<?php echo $admin->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $admin->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php } ?>
<?php echo $admin->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->userlevel->Visible) { // userlevel ?>
	<div id="r_userlevel" class="form-group row">
		<label id="elh_admin_userlevel" for="x_userlevel" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->userlevel->caption() ?><?php echo ($admin->userlevel->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->userlevel->cellAttributes() ?>>
<?php if (!$Security->isAdmin() && $Security->isLoggedIn()) { // Non system admin ?>
<span id="el_admin_userlevel">
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($admin->userlevel->EditValue) ?>">
</span>
<?php } else { ?>
<span id="el_admin_userlevel">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_userlevel" data-value-separator="<?php echo $admin->userlevel->displayValueSeparatorAttribute() ?>" id="x_userlevel" name="x_userlevel"<?php echo $admin->userlevel->editAttributes() ?>>
		<?php echo $admin->userlevel->selectOptionListHtml("x_userlevel") ?>
	</select>
</div>
<?php echo $admin->userlevel->Lookup->getParamTag("p_x_userlevel") ?>
</span>
<?php } ?>
<?php echo $admin->userlevel->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->activated->Visible) { // activated ?>
	<div id="r_activated" class="form-group row">
		<label id="elh_admin_activated" for="x_activated" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->activated->caption() ?><?php echo ($admin->activated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->activated->cellAttributes() ?>>
<span id="el_admin_activated">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_activated" data-value-separator="<?php echo $admin->activated->displayValueSeparatorAttribute() ?>" id="x_activated" name="x_activated"<?php echo $admin->activated->editAttributes() ?>>
		<?php echo $admin->activated->selectOptionListHtml("x_activated") ?>
	</select>
</div>
</span>
<?php echo $admin->activated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($admin->profile_old->Visible) { // profile_old ?>
	<div id="r_profile_old" class="form-group row">
		<label id="elh_admin_profile_old" for="x_profile_old" class="<?php echo $admin_add->LeftColumnClass ?>"><?php echo $admin->profile_old->caption() ?><?php echo ($admin->profile_old->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $admin_add->RightColumnClass ?>"><div<?php echo $admin->profile_old->cellAttributes() ?>>
<span id="el_admin_profile_old">
<textarea data-table="admin" data-field="x_profile_old" name="x_profile_old" id="x_profile_old" cols="35" rows="4" placeholder="<?php echo HtmlEncode($admin->profile_old->getPlaceHolder()) ?>"<?php echo $admin->profile_old->editAttributes() ?>><?php echo $admin->profile_old->EditValue ?></textarea>
</span>
<?php echo $admin->profile_old->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$admin_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $admin_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $admin_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$admin_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$admin_add->terminate();
?>