<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$admin_list = new admin_list();

// Run the page
$admin_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$admin_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$admin->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fadminlist = currentForm = new ew.Form("fadminlist", "list");
fadminlist.formKeyCountName = '<?php echo $admin_list->FormKeyCountName ?>';

// Form_CustomValidate event
fadminlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fadminlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fadminlist.lists["x_category"] = <?php echo $admin_list->category->Lookup->toClientList() ?>;
fadminlist.lists["x_category"].options = <?php echo JsonEncode($admin_list->category->lookupOptions()) ?>;
fadminlist.lists["x_company_id"] = <?php echo $admin_list->company_id->Lookup->toClientList() ?>;
fadminlist.lists["x_company_id"].options = <?php echo JsonEncode($admin_list->company_id->lookupOptions()) ?>;
fadminlist.autoSuggests["x_company_id"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fadminlist.lists["x_pp_id"] = <?php echo $admin_list->pp_id->Lookup->toClientList() ?>;
fadminlist.lists["x_pp_id"].options = <?php echo JsonEncode($admin_list->pp_id->lookupOptions()) ?>;
fadminlist.lists["x_site[]"] = <?php echo $admin_list->site->Lookup->toClientList() ?>;
fadminlist.lists["x_site[]"].options = <?php echo JsonEncode($admin_list->site->lookupOptions()) ?>;
fadminlist.lists["x_reports_to"] = <?php echo $admin_list->reports_to->Lookup->toClientList() ?>;
fadminlist.lists["x_reports_to"].options = <?php echo JsonEncode($admin_list->reports_to->lookupOptions()) ?>;
fadminlist.lists["x_userlevel"] = <?php echo $admin_list->userlevel->Lookup->toClientList() ?>;
fadminlist.lists["x_userlevel"].options = <?php echo JsonEncode($admin_list->userlevel->lookupOptions()) ?>;
fadminlist.lists["x_activated"] = <?php echo $admin_list->activated->Lookup->toClientList() ?>;
fadminlist.lists["x_activated"].options = <?php echo JsonEncode($admin_list->activated->options(FALSE, TRUE)) ?>;
fadminlist.lists["x_operator"] = <?php echo $admin_list->operator->Lookup->toClientList() ?>;
fadminlist.lists["x_operator"].options = <?php echo JsonEncode($admin_list->operator->lookupOptions()) ?>;

// Form object for search
var fadminlistsrch = currentSearchForm = new ew.Form("fadminlistsrch");

// Validate function for search
fadminlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fadminlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fadminlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fadminlistsrch.lists["x_category"] = <?php echo $admin_list->category->Lookup->toClientList() ?>;
fadminlistsrch.lists["x_category"].options = <?php echo JsonEncode($admin_list->category->lookupOptions()) ?>;

// Filters
fadminlistsrch.filterList = <?php echo $admin_list->getFilterList() ?>;

// Init search panel as collapsed
fadminlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$admin->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($admin_list->TotalRecs > 0 && $admin_list->ExportOptions->visible()) { ?>
<?php $admin_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($admin_list->ImportOptions->visible()) { ?>
<?php $admin_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($admin_list->SearchOptions->visible()) { ?>
<?php $admin_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($admin_list->FilterOptions->visible()) { ?>
<?php $admin_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$admin_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$admin->isExport() && !$admin->CurrentAction) { ?>
<form name="fadminlistsrch" id="fadminlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($admin_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fadminlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="admin">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$admin_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$admin->RowType = ROWTYPE_SEARCH;

// Render row
$admin->resetAttributes();
$admin_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($admin->category->Visible) { // category ?>
	<div id="xsc_category" class="ew-cell form-group">
		<label for="x_category" class="ew-search-caption ew-label"><?php echo $admin->category->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="admin" data-field="x_category" data-value-separator="<?php echo $admin->category->displayValueSeparatorAttribute() ?>" id="x_category" name="x_category"<?php echo $admin->category->editAttributes() ?>>
		<?php echo $admin->category->selectOptionListHtml("x_category") ?>
	</select>
</div>
<?php echo $admin->category->Lookup->getParamTag("p_x_category") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($admin_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($admin_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $admin_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($admin_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($admin_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($admin_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($admin_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $admin_list->showPageHeader(); ?>
<?php
$admin_list->showMessage();
?>
<?php if ($admin_list->TotalRecs > 0 || $admin->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($admin_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> admin">
<?php if (!$admin->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$admin->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($admin_list->Pager)) $admin_list->Pager = new PrevNextPager($admin_list->StartRec, $admin_list->DisplayRecs, $admin_list->TotalRecs, $admin_list->AutoHidePager) ?>
<?php if ($admin_list->Pager->RecordCount > 0 && $admin_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($admin_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($admin_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $admin_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($admin_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($admin_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $admin_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($admin_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $admin_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $admin_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $admin_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($admin_list->TotalRecs > 0 && (!$admin_list->AutoHidePageSizeSelector || $admin_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="admin">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($admin_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($admin_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($admin_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($admin_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($admin_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($admin->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $admin_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fadminlist" id="fadminlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($admin_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $admin_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="admin">
<div id="gmp_admin" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($admin_list->TotalRecs > 0 || $admin->isGridEdit()) { ?>
<table id="tbl_adminlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$admin_list->RowType = ROWTYPE_HEADER;

// Render list options
$admin_list->renderListOptions();

// Render list options (header, left)
$admin_list->ListOptions->render("header", "left");
?>
<?php if ($admin->id->Visible) { // id ?>
	<?php if ($admin->sortUrl($admin->id) == "") { ?>
		<th data-name="id" class="<?php echo $admin->id->headerCellClass() ?>"><div id="elh_admin_id" class="admin_id"><div class="ew-table-header-caption"><?php echo $admin->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $admin->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->id) ?>',2);"><div id="elh_admin_id" class="admin_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->mobile->Visible) { // mobile ?>
	<?php if ($admin->sortUrl($admin->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $admin->mobile->headerCellClass() ?>"><div id="elh_admin_mobile" class="admin_mobile"><div class="ew-table-header-caption"><?php echo $admin->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $admin->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->mobile) ?>',2);"><div id="elh_admin_mobile" class="admin_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->formal_name->Visible) { // formal_name ?>
	<?php if ($admin->sortUrl($admin->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $admin->formal_name->headerCellClass() ?>"><div id="elh_admin_formal_name" class="admin_formal_name"><div class="ew-table-header-caption"><?php echo $admin->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $admin->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->formal_name) ?>',2);"><div id="elh_admin_formal_name" class="admin_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($admin->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->password->Visible) { // password ?>
	<?php if ($admin->sortUrl($admin->password) == "") { ?>
		<th data-name="password" class="<?php echo $admin->password->headerCellClass() ?>"><div id="elh_admin_password" class="admin_password"><div class="ew-table-header-caption"><?php echo $admin->password->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="password" class="<?php echo $admin->password->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->password) ?>',2);"><div id="elh_admin_password" class="admin_password">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->password->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->password->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->password->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->user_name->Visible) { // user_name ?>
	<?php if ($admin->sortUrl($admin->user_name) == "") { ?>
		<th data-name="user_name" class="<?php echo $admin->user_name->headerCellClass() ?>"><div id="elh_admin_user_name" class="admin_user_name"><div class="ew-table-header-caption"><?php echo $admin->user_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_name" class="<?php echo $admin->user_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->user_name) ?>',2);"><div id="elh_admin_user_name" class="admin_user_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->user_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($admin->user_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->user_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->category->Visible) { // category ?>
	<?php if ($admin->sortUrl($admin->category) == "") { ?>
		<th data-name="category" class="<?php echo $admin->category->headerCellClass() ?>"><div id="elh_admin_category" class="admin_category"><div class="ew-table-header-caption"><?php echo $admin->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $admin->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->category) ?>',2);"><div id="elh_admin_category" class="admin_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->_email->Visible) { // email ?>
	<?php if ($admin->sortUrl($admin->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $admin->_email->headerCellClass() ?>"><div id="elh_admin__email" class="admin__email"><div class="ew-table-header-caption"><?php echo $admin->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $admin->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->_email) ?>',2);"><div id="elh_admin__email" class="admin__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($admin->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->company_id->Visible) { // company_id ?>
	<?php if ($admin->sortUrl($admin->company_id) == "") { ?>
		<th data-name="company_id" class="<?php echo $admin->company_id->headerCellClass() ?>"><div id="elh_admin_company_id" class="admin_company_id"><div class="ew-table-header-caption"><?php echo $admin->company_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company_id" class="<?php echo $admin->company_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->company_id) ?>',2);"><div id="elh_admin_company_id" class="admin_company_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->company_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->company_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->company_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->pp_id->Visible) { // pp_id ?>
	<?php if ($admin->sortUrl($admin->pp_id) == "") { ?>
		<th data-name="pp_id" class="<?php echo $admin->pp_id->headerCellClass() ?>"><div id="elh_admin_pp_id" class="admin_pp_id"><div class="ew-table-header-caption"><?php echo $admin->pp_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pp_id" class="<?php echo $admin->pp_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->pp_id) ?>',2);"><div id="elh_admin_pp_id" class="admin_pp_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->pp_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->pp_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->pp_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->site->Visible) { // site ?>
	<?php if ($admin->sortUrl($admin->site) == "") { ?>
		<th data-name="site" class="<?php echo $admin->site->headerCellClass() ?>"><div id="elh_admin_site" class="admin_site"><div class="ew-table-header-caption"><?php echo $admin->site->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="site" class="<?php echo $admin->site->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->site) ?>',2);"><div id="elh_admin_site" class="admin_site">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->site->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->site->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->site->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->reports_to->Visible) { // reports_to ?>
	<?php if ($admin->sortUrl($admin->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $admin->reports_to->headerCellClass() ?>"><div id="elh_admin_reports_to" class="admin_reports_to"><div class="ew-table-header-caption"><?php echo $admin->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $admin->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->reports_to) ?>',2);"><div id="elh_admin_reports_to" class="admin_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->userlevel->Visible) { // userlevel ?>
	<?php if ($admin->sortUrl($admin->userlevel) == "") { ?>
		<th data-name="userlevel" class="<?php echo $admin->userlevel->headerCellClass() ?>"><div id="elh_admin_userlevel" class="admin_userlevel"><div class="ew-table-header-caption"><?php echo $admin->userlevel->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="userlevel" class="<?php echo $admin->userlevel->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->userlevel) ?>',2);"><div id="elh_admin_userlevel" class="admin_userlevel">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->userlevel->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->userlevel->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->userlevel->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->activated->Visible) { // activated ?>
	<?php if ($admin->sortUrl($admin->activated) == "") { ?>
		<th data-name="activated" class="<?php echo $admin->activated->headerCellClass() ?>"><div id="elh_admin_activated" class="admin_activated"><div class="ew-table-header-caption"><?php echo $admin->activated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="activated" class="<?php echo $admin->activated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->activated) ?>',2);"><div id="elh_admin_activated" class="admin_activated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->activated->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->activated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->activated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->operator->Visible) { // operator ?>
	<?php if ($admin->sortUrl($admin->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $admin->operator->headerCellClass() ?>"><div id="elh_admin_operator" class="admin_operator"><div class="ew-table-header-caption"><?php echo $admin->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $admin->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->operator) ?>',2);"><div id="elh_admin_operator" class="admin_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->datetime->Visible) { // datetime ?>
	<?php if ($admin->sortUrl($admin->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $admin->datetime->headerCellClass() ?>"><div id="elh_admin_datetime" class="admin_datetime"><div class="ew-table-header-caption"><?php echo $admin->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $admin->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->datetime) ?>',2);"><div id="elh_admin_datetime" class="admin_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($admin->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($admin->reg_ip->Visible) { // reg_ip ?>
	<?php if ($admin->sortUrl($admin->reg_ip) == "") { ?>
		<th data-name="reg_ip" class="<?php echo $admin->reg_ip->headerCellClass() ?>"><div id="elh_admin_reg_ip" class="admin_reg_ip"><div class="ew-table-header-caption"><?php echo $admin->reg_ip->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reg_ip" class="<?php echo $admin->reg_ip->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $admin->SortUrl($admin->reg_ip) ?>',2);"><div id="elh_admin_reg_ip" class="admin_reg_ip">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $admin->reg_ip->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($admin->reg_ip->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($admin->reg_ip->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$admin_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($admin->ExportAll && $admin->isExport()) {
	$admin_list->StopRec = $admin_list->TotalRecs;
} else {

	// Set the last record to display
	if ($admin_list->TotalRecs > $admin_list->StartRec + $admin_list->DisplayRecs - 1)
		$admin_list->StopRec = $admin_list->StartRec + $admin_list->DisplayRecs - 1;
	else
		$admin_list->StopRec = $admin_list->TotalRecs;
}
$admin_list->RecCnt = $admin_list->StartRec - 1;
if ($admin_list->Recordset && !$admin_list->Recordset->EOF) {
	$admin_list->Recordset->moveFirst();
	$selectLimit = $admin_list->UseSelectLimit;
	if (!$selectLimit && $admin_list->StartRec > 1)
		$admin_list->Recordset->move($admin_list->StartRec - 1);
} elseif (!$admin->AllowAddDeleteRow && $admin_list->StopRec == 0) {
	$admin_list->StopRec = $admin->GridAddRowCount;
}

// Initialize aggregate
$admin->RowType = ROWTYPE_AGGREGATEINIT;
$admin->resetAttributes();
$admin_list->renderRow();
while ($admin_list->RecCnt < $admin_list->StopRec) {
	$admin_list->RecCnt++;
	if ($admin_list->RecCnt >= $admin_list->StartRec) {
		$admin_list->RowCnt++;

		// Set up key count
		$admin_list->KeyCount = $admin_list->RowIndex;

		// Init row class and style
		$admin->resetAttributes();
		$admin->CssClass = "";
		if ($admin->isGridAdd()) {
		} else {
			$admin_list->loadRowValues($admin_list->Recordset); // Load row values
		}
		$admin->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$admin->RowAttrs = array_merge($admin->RowAttrs, array('data-rowindex'=>$admin_list->RowCnt, 'id'=>'r' . $admin_list->RowCnt . '_admin', 'data-rowtype'=>$admin->RowType));

		// Render row
		$admin_list->renderRow();

		// Render list options
		$admin_list->renderListOptions();
?>
	<tr<?php echo $admin->rowAttributes() ?>>
<?php

// Render list options (body, left)
$admin_list->ListOptions->render("body", "left", $admin_list->RowCnt);
?>
	<?php if ($admin->id->Visible) { // id ?>
		<td data-name="id"<?php echo $admin->id->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_id" class="admin_id">
<span<?php echo $admin->id->viewAttributes() ?>>
<?php echo $admin->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $admin->mobile->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_mobile" class="admin_mobile">
<span<?php echo $admin->mobile->viewAttributes() ?>>
<?php echo $admin->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $admin->formal_name->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_formal_name" class="admin_formal_name">
<span<?php echo $admin->formal_name->viewAttributes() ?>>
<?php echo $admin->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->password->Visible) { // password ?>
		<td data-name="password"<?php echo $admin->password->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_password" class="admin_password">
<span<?php echo $admin->password->viewAttributes() ?>>
<?php echo $admin->password->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->user_name->Visible) { // user_name ?>
		<td data-name="user_name"<?php echo $admin->user_name->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_user_name" class="admin_user_name">
<span<?php echo $admin->user_name->viewAttributes() ?>>
<?php echo $admin->user_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->category->Visible) { // category ?>
		<td data-name="category"<?php echo $admin->category->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_category" class="admin_category">
<span<?php echo $admin->category->viewAttributes() ?>>
<?php echo $admin->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $admin->_email->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin__email" class="admin__email">
<span<?php echo $admin->_email->viewAttributes() ?>>
<?php echo $admin->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->company_id->Visible) { // company_id ?>
		<td data-name="company_id"<?php echo $admin->company_id->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_company_id" class="admin_company_id">
<span<?php echo $admin->company_id->viewAttributes() ?>>
<?php echo $admin->company_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->pp_id->Visible) { // pp_id ?>
		<td data-name="pp_id"<?php echo $admin->pp_id->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_pp_id" class="admin_pp_id">
<span<?php echo $admin->pp_id->viewAttributes() ?>>
<?php echo $admin->pp_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->site->Visible) { // site ?>
		<td data-name="site"<?php echo $admin->site->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_site" class="admin_site">
<span<?php echo $admin->site->viewAttributes() ?>>
<?php echo $admin->site->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $admin->reports_to->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_reports_to" class="admin_reports_to">
<span<?php echo $admin->reports_to->viewAttributes() ?>>
<?php echo $admin->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->userlevel->Visible) { // userlevel ?>
		<td data-name="userlevel"<?php echo $admin->userlevel->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_userlevel" class="admin_userlevel">
<span<?php echo $admin->userlevel->viewAttributes() ?>>
<?php echo $admin->userlevel->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->activated->Visible) { // activated ?>
		<td data-name="activated"<?php echo $admin->activated->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_activated" class="admin_activated">
<span<?php echo $admin->activated->viewAttributes() ?>>
<?php echo $admin->activated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $admin->operator->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_operator" class="admin_operator">
<span<?php echo $admin->operator->viewAttributes() ?>>
<?php echo $admin->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $admin->datetime->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_datetime" class="admin_datetime">
<span<?php echo $admin->datetime->viewAttributes() ?>>
<?php echo $admin->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($admin->reg_ip->Visible) { // reg_ip ?>
		<td data-name="reg_ip"<?php echo $admin->reg_ip->cellAttributes() ?>>
<span id="el<?php echo $admin_list->RowCnt ?>_admin_reg_ip" class="admin_reg_ip">
<span<?php echo $admin->reg_ip->viewAttributes() ?>>
<?php echo $admin->reg_ip->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$admin_list->ListOptions->render("body", "right", $admin_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$admin->isGridAdd())
		$admin_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$admin->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($admin_list->Recordset)
	$admin_list->Recordset->Close();
?>
<?php if (!$admin->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$admin->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($admin_list->Pager)) $admin_list->Pager = new PrevNextPager($admin_list->StartRec, $admin_list->DisplayRecs, $admin_list->TotalRecs, $admin_list->AutoHidePager) ?>
<?php if ($admin_list->Pager->RecordCount > 0 && $admin_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($admin_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($admin_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $admin_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($admin_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($admin_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $admin_list->pageUrl() ?>start=<?php echo $admin_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $admin_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($admin_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $admin_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $admin_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $admin_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($admin_list->TotalRecs > 0 && (!$admin_list->AutoHidePageSizeSelector || $admin_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="admin">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($admin_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($admin_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($admin_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($admin_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($admin_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($admin->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $admin_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($admin_list->TotalRecs == 0 && !$admin->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $admin_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$admin_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$admin->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$admin->isExport()) { ?>
<script>
ew.scrollableTable("gmp_admin", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$admin_list->terminate();
?>