<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$agent_add = new agent_add();

// Run the page
$agent_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$agent_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fagentadd = currentForm = new ew.Form("fagentadd", "add");

// Validate form
fagentadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($agent_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->grp->caption(), $agent->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->name->caption(), $agent->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->code->caption(), $agent->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($agent->code->errorMessage()) ?>");
		<?php if ($agent_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->status->caption(), $agent->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->operator->caption(), $agent->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->datetime->caption(), $agent->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fagentadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fagentadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fagentadd.lists["x_grp"] = <?php echo $agent_add->grp->Lookup->toClientList() ?>;
fagentadd.lists["x_grp"].options = <?php echo JsonEncode($agent_add->grp->options(FALSE, TRUE)) ?>;
fagentadd.lists["x_status"] = <?php echo $agent_add->status->Lookup->toClientList() ?>;
fagentadd.lists["x_status"].options = <?php echo JsonEncode($agent_add->status->options(FALSE, TRUE)) ?>;
fagentadd.lists["x_operator"] = <?php echo $agent_add->operator->Lookup->toClientList() ?>;
fagentadd.lists["x_operator"].options = <?php echo JsonEncode($agent_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $agent_add->showPageHeader(); ?>
<?php
$agent_add->showMessage();
?>
<form name="fagentadd" id="fagentadd" class="<?php echo $agent_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($agent_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $agent_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="agent">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$agent_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($agent->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_agent_grp" for="x_grp" class="<?php echo $agent_add->LeftColumnClass ?>"><?php echo $agent->grp->caption() ?><?php echo ($agent->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $agent_add->RightColumnClass ?>"><div<?php echo $agent->grp->cellAttributes() ?>>
<span id="el_agent_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="agent" data-field="x_grp" data-value-separator="<?php echo $agent->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $agent->grp->editAttributes() ?>>
		<?php echo $agent->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
</span>
<?php echo $agent->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($agent->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_agent_name" for="x_name" class="<?php echo $agent_add->LeftColumnClass ?>"><?php echo $agent->name->caption() ?><?php echo ($agent->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $agent_add->RightColumnClass ?>"><div<?php echo $agent->name->cellAttributes() ?>>
<span id="el_agent_name">
<input type="text" data-table="agent" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($agent->name->getPlaceHolder()) ?>" value="<?php echo $agent->name->EditValue ?>"<?php echo $agent->name->editAttributes() ?>>
</span>
<?php echo $agent->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($agent->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_agent_code" for="x_code" class="<?php echo $agent_add->LeftColumnClass ?>"><?php echo $agent->code->caption() ?><?php echo ($agent->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $agent_add->RightColumnClass ?>"><div<?php echo $agent->code->cellAttributes() ?>>
<span id="el_agent_code">
<input type="text" data-table="agent" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($agent->code->getPlaceHolder()) ?>" value="<?php echo $agent->code->EditValue ?>"<?php echo $agent->code->editAttributes() ?>>
</span>
<?php echo $agent->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($agent->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_agent_status" for="x_status" class="<?php echo $agent_add->LeftColumnClass ?>"><?php echo $agent->status->caption() ?><?php echo ($agent->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $agent_add->RightColumnClass ?>"><div<?php echo $agent->status->cellAttributes() ?>>
<span id="el_agent_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="agent" data-field="x_status" data-value-separator="<?php echo $agent->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $agent->status->editAttributes() ?>>
		<?php echo $agent->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $agent->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$agent_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $agent_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $agent_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$agent_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$agent_add->terminate();
?>