<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$agent_addopt = new agent_addopt();

// Run the page
$agent_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$agent_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fagentaddopt = currentForm = new ew.Form("fagentaddopt", "addopt");

// Validate form
fagentaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($agent_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->grp->caption(), $agent->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_addopt->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->name->caption(), $agent->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_addopt->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->code->caption(), $agent->code->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.checkByRegEx(elm.value, /^([a-zA-Z0-9_-]){3,3}$/))
				return this.onError(elm, "<?php echo JsEncode($agent->code->errorMessage()) ?>");
		<?php if ($agent_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->status->caption(), $agent->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->operator->caption(), $agent->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($agent_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $agent->datetime->caption(), $agent->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fagentaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fagentaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fagentaddopt.lists["x_grp"] = <?php echo $agent_addopt->grp->Lookup->toClientList() ?>;
fagentaddopt.lists["x_grp"].options = <?php echo JsonEncode($agent_addopt->grp->options(FALSE, TRUE)) ?>;
fagentaddopt.lists["x_status"] = <?php echo $agent_addopt->status->Lookup->toClientList() ?>;
fagentaddopt.lists["x_status"].options = <?php echo JsonEncode($agent_addopt->status->options(FALSE, TRUE)) ?>;
fagentaddopt.lists["x_operator"] = <?php echo $agent_addopt->operator->Lookup->toClientList() ?>;
fagentaddopt.lists["x_operator"].options = <?php echo JsonEncode($agent_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $agent_addopt->showPageHeader(); ?>
<?php
$agent_addopt->showMessage();
?>
<form name="fagentaddopt" id="fagentaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($agent_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $agent_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $agent_addopt->TableVar ?>">
<?php if ($agent->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $agent->grp->caption() ?><?php echo ($agent->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="agent" data-field="x_grp" data-value-separator="<?php echo $agent->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $agent->grp->editAttributes() ?>>
		<?php echo $agent->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $agent->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($agent->name->Visible) { // name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_name"><?php echo $agent->name->caption() ?><?php echo ($agent->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="agent" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($agent->name->getPlaceHolder()) ?>" value="<?php echo $agent->name->EditValue ?>"<?php echo $agent->name->editAttributes() ?>>
<?php echo $agent->name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($agent->code->Visible) { // code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_code"><?php echo $agent->code->caption() ?><?php echo ($agent->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="agent" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($agent->code->getPlaceHolder()) ?>" value="<?php echo $agent->code->EditValue ?>"<?php echo $agent->code->editAttributes() ?>>
<?php echo $agent->code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($agent->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $agent->status->caption() ?><?php echo ($agent->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="agent" data-field="x_status" data-value-separator="<?php echo $agent->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $agent->status->editAttributes() ?>>
		<?php echo $agent->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $agent->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($agent->operator->Visible) { // operator ?>
	<input type="hidden" data-table="agent" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($agent->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($agent->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="agent" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($agent->datetime->CurrentValue) ?>">
	<?php if (!$agent->datetime->ReadOnly && !$agent->datetime->Disabled && !isset($agent->datetime->EditAttrs["readonly"]) && !isset($agent->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fagentaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$agent_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$agent_addopt->terminate();
?>