<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$agent_list = new agent_list();

// Run the page
$agent_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$agent_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$agent->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fagentlist = currentForm = new ew.Form("fagentlist", "list");
fagentlist.formKeyCountName = '<?php echo $agent_list->FormKeyCountName ?>';

// Form_CustomValidate event
fagentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fagentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fagentlist.lists["x_grp"] = <?php echo $agent_list->grp->Lookup->toClientList() ?>;
fagentlist.lists["x_grp"].options = <?php echo JsonEncode($agent_list->grp->options(FALSE, TRUE)) ?>;
fagentlist.lists["x_status"] = <?php echo $agent_list->status->Lookup->toClientList() ?>;
fagentlist.lists["x_status"].options = <?php echo JsonEncode($agent_list->status->options(FALSE, TRUE)) ?>;
fagentlist.lists["x_operator"] = <?php echo $agent_list->operator->Lookup->toClientList() ?>;
fagentlist.lists["x_operator"].options = <?php echo JsonEncode($agent_list->operator->lookupOptions()) ?>;

// Form object for search
var fagentlistsrch = currentSearchForm = new ew.Form("fagentlistsrch");

// Filters
fagentlistsrch.filterList = <?php echo $agent_list->getFilterList() ?>;

// Init search panel as collapsed
fagentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$agent->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($agent_list->TotalRecs > 0 && $agent_list->ExportOptions->visible()) { ?>
<?php $agent_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($agent_list->ImportOptions->visible()) { ?>
<?php $agent_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($agent_list->SearchOptions->visible()) { ?>
<?php $agent_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($agent_list->FilterOptions->visible()) { ?>
<?php $agent_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$agent_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$agent->isExport() && !$agent->CurrentAction) { ?>
<form name="fagentlistsrch" id="fagentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($agent_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fagentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="agent">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($agent_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($agent_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $agent_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($agent_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($agent_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($agent_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($agent_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $agent_list->showPageHeader(); ?>
<?php
$agent_list->showMessage();
?>
<?php if ($agent_list->TotalRecs > 0 || $agent->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($agent_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> agent">
<?php if (!$agent->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$agent->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($agent_list->Pager)) $agent_list->Pager = new PrevNextPager($agent_list->StartRec, $agent_list->DisplayRecs, $agent_list->TotalRecs, $agent_list->AutoHidePager) ?>
<?php if ($agent_list->Pager->RecordCount > 0 && $agent_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($agent_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($agent_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $agent_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($agent_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($agent_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $agent_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($agent_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $agent_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $agent_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $agent_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($agent_list->TotalRecs > 0 && (!$agent_list->AutoHidePageSizeSelector || $agent_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="agent">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($agent_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($agent_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($agent_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($agent_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($agent_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($agent->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $agent_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fagentlist" id="fagentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($agent_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $agent_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="agent">
<div id="gmp_agent" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($agent_list->TotalRecs > 0 || $agent->isGridEdit()) { ?>
<table id="tbl_agentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$agent_list->RowType = ROWTYPE_HEADER;

// Render list options
$agent_list->renderListOptions();

// Render list options (header, left)
$agent_list->ListOptions->render("header", "left");
?>
<?php if ($agent->id->Visible) { // id ?>
	<?php if ($agent->sortUrl($agent->id) == "") { ?>
		<th data-name="id" class="<?php echo $agent->id->headerCellClass() ?>"><div id="elh_agent_id" class="agent_id"><div class="ew-table-header-caption"><?php echo $agent->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $agent->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->id) ?>',2);"><div id="elh_agent_id" class="agent_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($agent->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($agent->grp->Visible) { // grp ?>
	<?php if ($agent->sortUrl($agent->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $agent->grp->headerCellClass() ?>"><div id="elh_agent_grp" class="agent_grp"><div class="ew-table-header-caption"><?php echo $agent->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $agent->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->grp) ?>',2);"><div id="elh_agent_grp" class="agent_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($agent->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($agent->name->Visible) { // name ?>
	<?php if ($agent->sortUrl($agent->name) == "") { ?>
		<th data-name="name" class="<?php echo $agent->name->headerCellClass() ?>"><div id="elh_agent_name" class="agent_name"><div class="ew-table-header-caption"><?php echo $agent->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $agent->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->name) ?>',2);"><div id="elh_agent_name" class="agent_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($agent->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($agent->code->Visible) { // code ?>
	<?php if ($agent->sortUrl($agent->code) == "") { ?>
		<th data-name="code" class="<?php echo $agent->code->headerCellClass() ?>"><div id="elh_agent_code" class="agent_code"><div class="ew-table-header-caption"><?php echo $agent->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $agent->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->code) ?>',2);"><div id="elh_agent_code" class="agent_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($agent->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($agent->status->Visible) { // status ?>
	<?php if ($agent->sortUrl($agent->status) == "") { ?>
		<th data-name="status" class="<?php echo $agent->status->headerCellClass() ?>"><div id="elh_agent_status" class="agent_status"><div class="ew-table-header-caption"><?php echo $agent->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $agent->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->status) ?>',2);"><div id="elh_agent_status" class="agent_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($agent->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($agent->operator->Visible) { // operator ?>
	<?php if ($agent->sortUrl($agent->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $agent->operator->headerCellClass() ?>"><div id="elh_agent_operator" class="agent_operator"><div class="ew-table-header-caption"><?php echo $agent->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $agent->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->operator) ?>',2);"><div id="elh_agent_operator" class="agent_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($agent->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($agent->datetime->Visible) { // datetime ?>
	<?php if ($agent->sortUrl($agent->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $agent->datetime->headerCellClass() ?>"><div id="elh_agent_datetime" class="agent_datetime"><div class="ew-table-header-caption"><?php echo $agent->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $agent->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $agent->SortUrl($agent->datetime) ?>',2);"><div id="elh_agent_datetime" class="agent_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $agent->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($agent->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($agent->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$agent_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($agent->ExportAll && $agent->isExport()) {
	$agent_list->StopRec = $agent_list->TotalRecs;
} else {

	// Set the last record to display
	if ($agent_list->TotalRecs > $agent_list->StartRec + $agent_list->DisplayRecs - 1)
		$agent_list->StopRec = $agent_list->StartRec + $agent_list->DisplayRecs - 1;
	else
		$agent_list->StopRec = $agent_list->TotalRecs;
}
$agent_list->RecCnt = $agent_list->StartRec - 1;
if ($agent_list->Recordset && !$agent_list->Recordset->EOF) {
	$agent_list->Recordset->moveFirst();
	$selectLimit = $agent_list->UseSelectLimit;
	if (!$selectLimit && $agent_list->StartRec > 1)
		$agent_list->Recordset->move($agent_list->StartRec - 1);
} elseif (!$agent->AllowAddDeleteRow && $agent_list->StopRec == 0) {
	$agent_list->StopRec = $agent->GridAddRowCount;
}

// Initialize aggregate
$agent->RowType = ROWTYPE_AGGREGATEINIT;
$agent->resetAttributes();
$agent_list->renderRow();
while ($agent_list->RecCnt < $agent_list->StopRec) {
	$agent_list->RecCnt++;
	if ($agent_list->RecCnt >= $agent_list->StartRec) {
		$agent_list->RowCnt++;

		// Set up key count
		$agent_list->KeyCount = $agent_list->RowIndex;

		// Init row class and style
		$agent->resetAttributes();
		$agent->CssClass = "";
		if ($agent->isGridAdd()) {
		} else {
			$agent_list->loadRowValues($agent_list->Recordset); // Load row values
		}
		$agent->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$agent->RowAttrs = array_merge($agent->RowAttrs, array('data-rowindex'=>$agent_list->RowCnt, 'id'=>'r' . $agent_list->RowCnt . '_agent', 'data-rowtype'=>$agent->RowType));

		// Render row
		$agent_list->renderRow();

		// Render list options
		$agent_list->renderListOptions();
?>
	<tr<?php echo $agent->rowAttributes() ?>>
<?php

// Render list options (body, left)
$agent_list->ListOptions->render("body", "left", $agent_list->RowCnt);
?>
	<?php if ($agent->id->Visible) { // id ?>
		<td data-name="id"<?php echo $agent->id->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_id" class="agent_id">
<span<?php echo $agent->id->viewAttributes() ?>>
<?php echo $agent->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($agent->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $agent->grp->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_grp" class="agent_grp">
<span<?php echo $agent->grp->viewAttributes() ?>>
<?php echo $agent->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($agent->name->Visible) { // name ?>
		<td data-name="name"<?php echo $agent->name->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_name" class="agent_name">
<span<?php echo $agent->name->viewAttributes() ?>>
<?php echo $agent->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($agent->code->Visible) { // code ?>
		<td data-name="code"<?php echo $agent->code->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_code" class="agent_code">
<span<?php echo $agent->code->viewAttributes() ?>>
<?php echo $agent->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($agent->status->Visible) { // status ?>
		<td data-name="status"<?php echo $agent->status->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_status" class="agent_status">
<span<?php echo $agent->status->viewAttributes() ?>>
<?php echo $agent->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($agent->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $agent->operator->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_operator" class="agent_operator">
<span<?php echo $agent->operator->viewAttributes() ?>>
<?php echo $agent->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($agent->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $agent->datetime->cellAttributes() ?>>
<span id="el<?php echo $agent_list->RowCnt ?>_agent_datetime" class="agent_datetime">
<span<?php echo $agent->datetime->viewAttributes() ?>>
<?php echo $agent->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$agent_list->ListOptions->render("body", "right", $agent_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$agent->isGridAdd())
		$agent_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$agent->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($agent_list->Recordset)
	$agent_list->Recordset->Close();
?>
<?php if (!$agent->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$agent->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($agent_list->Pager)) $agent_list->Pager = new PrevNextPager($agent_list->StartRec, $agent_list->DisplayRecs, $agent_list->TotalRecs, $agent_list->AutoHidePager) ?>
<?php if ($agent_list->Pager->RecordCount > 0 && $agent_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($agent_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($agent_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $agent_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($agent_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($agent_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $agent_list->pageUrl() ?>start=<?php echo $agent_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $agent_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($agent_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $agent_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $agent_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $agent_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($agent_list->TotalRecs > 0 && (!$agent_list->AutoHidePageSizeSelector || $agent_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="agent">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($agent_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($agent_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($agent_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($agent_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($agent_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($agent->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $agent_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($agent_list->TotalRecs == 0 && !$agent->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $agent_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$agent_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$agent->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$agent->isExport()) { ?>
<script>
ew.scrollableTable("gmp_agent", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$agent_list->terminate();
?>