<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$agent_view = new agent_view();

// Run the page
$agent_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$agent_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$agent->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fagentview = currentForm = new ew.Form("fagentview", "view");

// Form_CustomValidate event
fagentview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fagentview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fagentview.lists["x_grp"] = <?php echo $agent_view->grp->Lookup->toClientList() ?>;
fagentview.lists["x_grp"].options = <?php echo JsonEncode($agent_view->grp->options(FALSE, TRUE)) ?>;
fagentview.lists["x_status"] = <?php echo $agent_view->status->Lookup->toClientList() ?>;
fagentview.lists["x_status"].options = <?php echo JsonEncode($agent_view->status->options(FALSE, TRUE)) ?>;
fagentview.lists["x_operator"] = <?php echo $agent_view->operator->Lookup->toClientList() ?>;
fagentview.lists["x_operator"].options = <?php echo JsonEncode($agent_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$agent->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $agent_view->ExportOptions->render("body") ?>
<?php $agent_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $agent_view->showPageHeader(); ?>
<?php
$agent_view->showMessage();
?>
<form name="fagentview" id="fagentview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($agent_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $agent_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="agent">
<input type="hidden" name="modal" value="<?php echo (int)$agent_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($agent->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_id"><?php echo $agent->id->caption() ?></span></td>
		<td data-name="id"<?php echo $agent->id->cellAttributes() ?>>
<span id="el_agent_id">
<span<?php echo $agent->id->viewAttributes() ?>>
<?php echo $agent->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($agent->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_grp"><?php echo $agent->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $agent->grp->cellAttributes() ?>>
<span id="el_agent_grp">
<span<?php echo $agent->grp->viewAttributes() ?>>
<?php echo $agent->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($agent->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_name"><?php echo $agent->name->caption() ?></span></td>
		<td data-name="name"<?php echo $agent->name->cellAttributes() ?>>
<span id="el_agent_name">
<span<?php echo $agent->name->viewAttributes() ?>>
<?php echo $agent->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($agent->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_code"><?php echo $agent->code->caption() ?></span></td>
		<td data-name="code"<?php echo $agent->code->cellAttributes() ?>>
<span id="el_agent_code">
<span<?php echo $agent->code->viewAttributes() ?>>
<?php echo $agent->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($agent->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_status"><?php echo $agent->status->caption() ?></span></td>
		<td data-name="status"<?php echo $agent->status->cellAttributes() ?>>
<span id="el_agent_status">
<span<?php echo $agent->status->viewAttributes() ?>>
<?php echo $agent->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($agent->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_operator"><?php echo $agent->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $agent->operator->cellAttributes() ?>>
<span id="el_agent_operator">
<span<?php echo $agent->operator->viewAttributes() ?>>
<?php echo $agent->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($agent->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $agent_view->TableLeftColumnClass ?>"><span id="elh_agent_datetime"><?php echo $agent->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $agent->datetime->cellAttributes() ?>>
<span id="el_agent_datetime">
<span<?php echo $agent->datetime->viewAttributes() ?>>
<?php echo $agent->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$agent_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$agent->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$agent_view->terminate();
?>