<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_grp_edit = new apc_grp_edit();

// Run the page
$apc_grp_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_grp_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fapc_grpedit = currentForm = new ew.Form("fapc_grpedit", "edit");

// Validate form
fapc_grpedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($apc_grp_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_grp->id->caption(), $apc_grp->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_grp_edit->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_grp->item->caption(), $apc_grp->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_grp_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_grp->grp->caption(), $apc_grp->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_grp_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_grp->status->caption(), $apc_grp->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_grp_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_grp->operator->caption(), $apc_grp->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_grp_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_grp->datetime->caption(), $apc_grp->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fapc_grpedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapc_grpedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapc_grpedit.lists["x_grp"] = <?php echo $apc_grp_edit->grp->Lookup->toClientList() ?>;
fapc_grpedit.lists["x_grp"].options = <?php echo JsonEncode($apc_grp_edit->grp->lookupOptions()) ?>;
fapc_grpedit.lists["x_status"] = <?php echo $apc_grp_edit->status->Lookup->toClientList() ?>;
fapc_grpedit.lists["x_status"].options = <?php echo JsonEncode($apc_grp_edit->status->options(FALSE, TRUE)) ?>;
fapc_grpedit.lists["x_operator"] = <?php echo $apc_grp_edit->operator->Lookup->toClientList() ?>;
fapc_grpedit.lists["x_operator"].options = <?php echo JsonEncode($apc_grp_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $apc_grp_edit->showPageHeader(); ?>
<?php
$apc_grp_edit->showMessage();
?>
<form name="fapc_grpedit" id="fapc_grpedit" class="<?php echo $apc_grp_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_grp_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_grp_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc_grp">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$apc_grp_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($apc_grp->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_apc_grp_id" class="<?php echo $apc_grp_edit->LeftColumnClass ?>"><?php echo $apc_grp->id->caption() ?><?php echo ($apc_grp->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_grp_edit->RightColumnClass ?>"><div<?php echo $apc_grp->id->cellAttributes() ?>>
<span id="el_apc_grp_id">
<span<?php echo $apc_grp->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($apc_grp->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="apc_grp" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($apc_grp->id->CurrentValue) ?>">
<?php echo $apc_grp->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc_grp->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_apc_grp_item" for="x_item" class="<?php echo $apc_grp_edit->LeftColumnClass ?>"><?php echo $apc_grp->item->caption() ?><?php echo ($apc_grp->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_grp_edit->RightColumnClass ?>"><div<?php echo $apc_grp->item->cellAttributes() ?>>
<span id="el_apc_grp_item">
<input type="text" data-table="apc_grp" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="36" placeholder="<?php echo HtmlEncode($apc_grp->item->getPlaceHolder()) ?>" value="<?php echo $apc_grp->item->EditValue ?>"<?php echo $apc_grp->item->editAttributes() ?>>
</span>
<?php echo $apc_grp->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc_grp->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_apc_grp_grp" for="x_grp" class="<?php echo $apc_grp_edit->LeftColumnClass ?>"><?php echo $apc_grp->grp->caption() ?><?php echo ($apc_grp->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_grp_edit->RightColumnClass ?>"><div<?php echo $apc_grp->grp->cellAttributes() ?>>
<span id="el_apc_grp_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc_grp" data-field="x_grp" data-value-separator="<?php echo $apc_grp->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $apc_grp->grp->editAttributes() ?>>
		<?php echo $apc_grp->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $apc_grp->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $apc_grp->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc_grp->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_apc_grp_status" for="x_status" class="<?php echo $apc_grp_edit->LeftColumnClass ?>"><?php echo $apc_grp->status->caption() ?><?php echo ($apc_grp->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_grp_edit->RightColumnClass ?>"><div<?php echo $apc_grp->status->cellAttributes() ?>>
<span id="el_apc_grp_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc_grp" data-field="x_status" data-value-separator="<?php echo $apc_grp->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $apc_grp->status->editAttributes() ?>>
		<?php echo $apc_grp->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $apc_grp->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$apc_grp_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $apc_grp_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $apc_grp_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$apc_grp_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$apc_grp_edit->terminate();
?>