<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_grp_view = new apc_grp_view();

// Run the page
$apc_grp_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_grp_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$apc_grp->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fapc_grpview = currentForm = new ew.Form("fapc_grpview", "view");

// Form_CustomValidate event
fapc_grpview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapc_grpview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapc_grpview.lists["x_grp"] = <?php echo $apc_grp_view->grp->Lookup->toClientList() ?>;
fapc_grpview.lists["x_grp"].options = <?php echo JsonEncode($apc_grp_view->grp->lookupOptions()) ?>;
fapc_grpview.lists["x_status"] = <?php echo $apc_grp_view->status->Lookup->toClientList() ?>;
fapc_grpview.lists["x_status"].options = <?php echo JsonEncode($apc_grp_view->status->options(FALSE, TRUE)) ?>;
fapc_grpview.lists["x_operator"] = <?php echo $apc_grp_view->operator->Lookup->toClientList() ?>;
fapc_grpview.lists["x_operator"].options = <?php echo JsonEncode($apc_grp_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$apc_grp->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $apc_grp_view->ExportOptions->render("body") ?>
<?php $apc_grp_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $apc_grp_view->showPageHeader(); ?>
<?php
$apc_grp_view->showMessage();
?>
<form name="fapc_grpview" id="fapc_grpview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_grp_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_grp_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc_grp">
<input type="hidden" name="modal" value="<?php echo (int)$apc_grp_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($apc_grp->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $apc_grp_view->TableLeftColumnClass ?>"><span id="elh_apc_grp_id"><?php echo $apc_grp->id->caption() ?></span></td>
		<td data-name="id"<?php echo $apc_grp->id->cellAttributes() ?>>
<span id="el_apc_grp_id">
<span<?php echo $apc_grp->id->viewAttributes() ?>>
<?php echo $apc_grp->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc_grp->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $apc_grp_view->TableLeftColumnClass ?>"><span id="elh_apc_grp_item"><?php echo $apc_grp->item->caption() ?></span></td>
		<td data-name="item"<?php echo $apc_grp->item->cellAttributes() ?>>
<span id="el_apc_grp_item">
<span<?php echo $apc_grp->item->viewAttributes() ?>>
<?php echo $apc_grp->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc_grp->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $apc_grp_view->TableLeftColumnClass ?>"><span id="elh_apc_grp_grp"><?php echo $apc_grp->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $apc_grp->grp->cellAttributes() ?>>
<span id="el_apc_grp_grp">
<span<?php echo $apc_grp->grp->viewAttributes() ?>>
<?php echo $apc_grp->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc_grp->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $apc_grp_view->TableLeftColumnClass ?>"><span id="elh_apc_grp_status"><?php echo $apc_grp->status->caption() ?></span></td>
		<td data-name="status"<?php echo $apc_grp->status->cellAttributes() ?>>
<span id="el_apc_grp_status">
<span<?php echo $apc_grp->status->viewAttributes() ?>>
<?php echo $apc_grp->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc_grp->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $apc_grp_view->TableLeftColumnClass ?>"><span id="elh_apc_grp_operator"><?php echo $apc_grp->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $apc_grp->operator->cellAttributes() ?>>
<span id="el_apc_grp_operator">
<span<?php echo $apc_grp->operator->viewAttributes() ?>>
<?php echo $apc_grp->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc_grp->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $apc_grp_view->TableLeftColumnClass ?>"><span id="elh_apc_grp_datetime"><?php echo $apc_grp->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $apc_grp->datetime->cellAttributes() ?>>
<span id="el_apc_grp_datetime">
<span<?php echo $apc_grp->datetime->viewAttributes() ?>>
<?php echo $apc_grp->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$apc_grp_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$apc_grp->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$apc_grp_view->terminate();
?>