<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_pfv_edit = new apc_pfv_edit();

// Run the page
$apc_pfv_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_pfv_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fapc_pfvedit = currentForm = new ew.Form("fapc_pfvedit", "edit");

// Validate form
fapc_pfvedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($apc_pfv_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_pfv->code->caption(), $apc_pfv->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_pfv_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_pfv->operator->caption(), $apc_pfv->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_pfv_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc_pfv->datetime->caption(), $apc_pfv->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fapc_pfvedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapc_pfvedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapc_pfvedit.lists["x_operator"] = <?php echo $apc_pfv_edit->operator->Lookup->toClientList() ?>;
fapc_pfvedit.lists["x_operator"].options = <?php echo JsonEncode($apc_pfv_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $apc_pfv_edit->showPageHeader(); ?>
<?php
$apc_pfv_edit->showMessage();
?>
<form name="fapc_pfvedit" id="fapc_pfvedit" class="<?php echo $apc_pfv_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_pfv_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_pfv_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc_pfv">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$apc_pfv_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($apc_pfv->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_apc_pfv_code" for="x_code" class="<?php echo $apc_pfv_edit->LeftColumnClass ?>"><?php echo $apc_pfv->code->caption() ?><?php echo ($apc_pfv->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_pfv_edit->RightColumnClass ?>"><div<?php echo $apc_pfv->code->cellAttributes() ?>>
<span id="el_apc_pfv_code">
<textarea data-table="apc_pfv" data-field="x_code" name="x_code" id="x_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($apc_pfv->code->getPlaceHolder()) ?>"<?php echo $apc_pfv->code->editAttributes() ?>><?php echo $apc_pfv->code->EditValue ?></textarea>
</span>
<?php echo $apc_pfv->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<input type="hidden" data-table="apc_pfv" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($apc_pfv->id->CurrentValue) ?>">
<?php if (!$apc_pfv_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $apc_pfv_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $apc_pfv_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$apc_pfv_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$apc_pfv_edit->terminate();
?>