<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_pfv_list = new apc_pfv_list();

// Run the page
$apc_pfv_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_pfv_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$apc_pfv->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fapc_pfvlist = currentForm = new ew.Form("fapc_pfvlist", "list");
fapc_pfvlist.formKeyCountName = '<?php echo $apc_pfv_list->FormKeyCountName ?>';

// Form_CustomValidate event
fapc_pfvlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapc_pfvlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapc_pfvlist.lists["x_operator"] = <?php echo $apc_pfv_list->operator->Lookup->toClientList() ?>;
fapc_pfvlist.lists["x_operator"].options = <?php echo JsonEncode($apc_pfv_list->operator->lookupOptions()) ?>;

// Form object for search
var fapc_pfvlistsrch = currentSearchForm = new ew.Form("fapc_pfvlistsrch");

// Filters
fapc_pfvlistsrch.filterList = <?php echo $apc_pfv_list->getFilterList() ?>;

// Init search panel as collapsed
fapc_pfvlistsrch.initSearchPanel = true;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$apc_pfv->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($apc_pfv_list->TotalRecs > 0 && $apc_pfv_list->ExportOptions->visible()) { ?>
<?php $apc_pfv_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($apc_pfv_list->ImportOptions->visible()) { ?>
<?php $apc_pfv_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($apc_pfv_list->SearchOptions->visible()) { ?>
<?php $apc_pfv_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($apc_pfv_list->FilterOptions->visible()) { ?>
<?php $apc_pfv_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$apc_pfv_list->renderOtherOptions();
?>
<?php $apc_pfv_list->showPageHeader(); ?>
<?php
$apc_pfv_list->showMessage();
?>
<?php if ($apc_pfv_list->TotalRecs > 0 || $apc_pfv->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($apc_pfv_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> apc_pfv">
<?php if (!$apc_pfv->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$apc_pfv->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($apc_pfv_list->Pager)) $apc_pfv_list->Pager = new PrevNextPager($apc_pfv_list->StartRec, $apc_pfv_list->DisplayRecs, $apc_pfv_list->TotalRecs, $apc_pfv_list->AutoHidePager) ?>
<?php if ($apc_pfv_list->Pager->RecordCount > 0 && $apc_pfv_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($apc_pfv_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($apc_pfv_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $apc_pfv_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($apc_pfv_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($apc_pfv_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $apc_pfv_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($apc_pfv_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $apc_pfv_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $apc_pfv_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $apc_pfv_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($apc_pfv_list->TotalRecs > 0 && (!$apc_pfv_list->AutoHidePageSizeSelector || $apc_pfv_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="apc_pfv">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($apc_pfv_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($apc_pfv_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($apc_pfv_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($apc_pfv_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($apc_pfv_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($apc_pfv->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $apc_pfv_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fapc_pfvlist" id="fapc_pfvlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_pfv_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_pfv_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc_pfv">
<div id="gmp_apc_pfv" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($apc_pfv_list->TotalRecs > 0 || $apc_pfv->isGridEdit()) { ?>
<table id="tbl_apc_pfvlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$apc_pfv_list->RowType = ROWTYPE_HEADER;

// Render list options
$apc_pfv_list->renderListOptions();

// Render list options (header, left)
$apc_pfv_list->ListOptions->render("header", "left");
?>
<?php if ($apc_pfv->operator->Visible) { // operator ?>
	<?php if ($apc_pfv->sortUrl($apc_pfv->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $apc_pfv->operator->headerCellClass() ?>"><div id="elh_apc_pfv_operator" class="apc_pfv_operator"><div class="ew-table-header-caption"><?php echo $apc_pfv->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $apc_pfv->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc_pfv->SortUrl($apc_pfv->operator) ?>',2);"><div id="elh_apc_pfv_operator" class="apc_pfv_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc_pfv->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc_pfv->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc_pfv->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc_pfv->datetime->Visible) { // datetime ?>
	<?php if ($apc_pfv->sortUrl($apc_pfv->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $apc_pfv->datetime->headerCellClass() ?>"><div id="elh_apc_pfv_datetime" class="apc_pfv_datetime"><div class="ew-table-header-caption"><?php echo $apc_pfv->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $apc_pfv->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc_pfv->SortUrl($apc_pfv->datetime) ?>',2);"><div id="elh_apc_pfv_datetime" class="apc_pfv_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc_pfv->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc_pfv->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc_pfv->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$apc_pfv_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($apc_pfv->ExportAll && $apc_pfv->isExport()) {
	$apc_pfv_list->StopRec = $apc_pfv_list->TotalRecs;
} else {

	// Set the last record to display
	if ($apc_pfv_list->TotalRecs > $apc_pfv_list->StartRec + $apc_pfv_list->DisplayRecs - 1)
		$apc_pfv_list->StopRec = $apc_pfv_list->StartRec + $apc_pfv_list->DisplayRecs - 1;
	else
		$apc_pfv_list->StopRec = $apc_pfv_list->TotalRecs;
}
$apc_pfv_list->RecCnt = $apc_pfv_list->StartRec - 1;
if ($apc_pfv_list->Recordset && !$apc_pfv_list->Recordset->EOF) {
	$apc_pfv_list->Recordset->moveFirst();
	$selectLimit = $apc_pfv_list->UseSelectLimit;
	if (!$selectLimit && $apc_pfv_list->StartRec > 1)
		$apc_pfv_list->Recordset->move($apc_pfv_list->StartRec - 1);
} elseif (!$apc_pfv->AllowAddDeleteRow && $apc_pfv_list->StopRec == 0) {
	$apc_pfv_list->StopRec = $apc_pfv->GridAddRowCount;
}

// Initialize aggregate
$apc_pfv->RowType = ROWTYPE_AGGREGATEINIT;
$apc_pfv->resetAttributes();
$apc_pfv_list->renderRow();
while ($apc_pfv_list->RecCnt < $apc_pfv_list->StopRec) {
	$apc_pfv_list->RecCnt++;
	if ($apc_pfv_list->RecCnt >= $apc_pfv_list->StartRec) {
		$apc_pfv_list->RowCnt++;

		// Set up key count
		$apc_pfv_list->KeyCount = $apc_pfv_list->RowIndex;

		// Init row class and style
		$apc_pfv->resetAttributes();
		$apc_pfv->CssClass = "";
		if ($apc_pfv->isGridAdd()) {
		} else {
			$apc_pfv_list->loadRowValues($apc_pfv_list->Recordset); // Load row values
		}
		$apc_pfv->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$apc_pfv->RowAttrs = array_merge($apc_pfv->RowAttrs, array('data-rowindex'=>$apc_pfv_list->RowCnt, 'id'=>'r' . $apc_pfv_list->RowCnt . '_apc_pfv', 'data-rowtype'=>$apc_pfv->RowType));

		// Render row
		$apc_pfv_list->renderRow();

		// Render list options
		$apc_pfv_list->renderListOptions();
?>
	<tr<?php echo $apc_pfv->rowAttributes() ?>>
<?php

// Render list options (body, left)
$apc_pfv_list->ListOptions->render("body", "left", $apc_pfv_list->RowCnt);
?>
	<?php if ($apc_pfv->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $apc_pfv->operator->cellAttributes() ?>>
<span id="el<?php echo $apc_pfv_list->RowCnt ?>_apc_pfv_operator" class="apc_pfv_operator">
<span<?php echo $apc_pfv->operator->viewAttributes() ?>>
<?php echo $apc_pfv->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc_pfv->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $apc_pfv->datetime->cellAttributes() ?>>
<span id="el<?php echo $apc_pfv_list->RowCnt ?>_apc_pfv_datetime" class="apc_pfv_datetime">
<span<?php echo $apc_pfv->datetime->viewAttributes() ?>>
<?php echo $apc_pfv->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$apc_pfv_list->ListOptions->render("body", "right", $apc_pfv_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$apc_pfv->isGridAdd())
		$apc_pfv_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$apc_pfv->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($apc_pfv_list->Recordset)
	$apc_pfv_list->Recordset->Close();
?>
<?php if (!$apc_pfv->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$apc_pfv->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($apc_pfv_list->Pager)) $apc_pfv_list->Pager = new PrevNextPager($apc_pfv_list->StartRec, $apc_pfv_list->DisplayRecs, $apc_pfv_list->TotalRecs, $apc_pfv_list->AutoHidePager) ?>
<?php if ($apc_pfv_list->Pager->RecordCount > 0 && $apc_pfv_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($apc_pfv_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($apc_pfv_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $apc_pfv_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($apc_pfv_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($apc_pfv_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $apc_pfv_list->pageUrl() ?>start=<?php echo $apc_pfv_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $apc_pfv_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($apc_pfv_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $apc_pfv_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $apc_pfv_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $apc_pfv_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($apc_pfv_list->TotalRecs > 0 && (!$apc_pfv_list->AutoHidePageSizeSelector || $apc_pfv_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="apc_pfv">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($apc_pfv_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($apc_pfv_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($apc_pfv_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($apc_pfv_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($apc_pfv_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($apc_pfv->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $apc_pfv_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($apc_pfv_list->TotalRecs == 0 && !$apc_pfv->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $apc_pfv_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$apc_pfv_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$apc_pfv->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$apc_pfv->isExport()) { ?>
<script>
ew.scrollableTable("gmp_apc_pfv", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$apc_pfv_list->terminate();
?>