<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_pfv_search = new apc_pfv_search();

// Run the page
$apc_pfv_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_pfv_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($apc_pfv_search->IsModal) { ?>
var fapc_pfvsearch = currentAdvancedSearchForm = new ew.Form("fapc_pfvsearch", "search");
<?php } else { ?>
var fapc_pfvsearch = currentForm = new ew.Form("fapc_pfvsearch", "search");
<?php } ?>

// Form_CustomValidate event
fapc_pfvsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapc_pfvsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapc_pfvsearch.lists["x_operator"] = <?php echo $apc_pfv_search->operator->Lookup->toClientList() ?>;
fapc_pfvsearch.lists["x_operator"].options = <?php echo JsonEncode($apc_pfv_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fapc_pfvsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $apc_pfv_search->showPageHeader(); ?>
<?php
$apc_pfv_search->showMessage();
?>
<form name="fapc_pfvsearch" id="fapc_pfvsearch" class="<?php echo $apc_pfv_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_pfv_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_pfv_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc_pfv">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$apc_pfv_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($apc_pfv->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $apc_pfv_search->LeftColumnClass ?>"><span id="elh_apc_pfv_code"><?php echo $apc_pfv->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $apc_pfv_search->RightColumnClass ?>"><div<?php echo $apc_pfv->code->cellAttributes() ?>>
			<span id="el_apc_pfv_code">
<input type="text" data-table="apc_pfv" data-field="x_code" name="x_code" id="x_code" size="35" placeholder="<?php echo HtmlEncode($apc_pfv->code->getPlaceHolder()) ?>" value="<?php echo $apc_pfv->code->EditValue ?>"<?php echo $apc_pfv->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc_pfv->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $apc_pfv_search->LeftColumnClass ?>"><span id="elh_apc_pfv_operator"><?php echo $apc_pfv->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $apc_pfv_search->RightColumnClass ?>"><div<?php echo $apc_pfv->operator->cellAttributes() ?>>
			<span id="el_apc_pfv_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc_pfv" data-field="x_operator" data-value-separator="<?php echo $apc_pfv->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $apc_pfv->operator->editAttributes() ?>>
		<?php echo $apc_pfv->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $apc_pfv->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc_pfv->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $apc_pfv_search->LeftColumnClass ?>"><span id="elh_apc_pfv_datetime"><?php echo $apc_pfv->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $apc_pfv_search->RightColumnClass ?>"><div<?php echo $apc_pfv->datetime->cellAttributes() ?>>
			<span id="el_apc_pfv_datetime">
<input type="text" data-table="apc_pfv" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($apc_pfv->datetime->getPlaceHolder()) ?>" value="<?php echo $apc_pfv->datetime->EditValue ?>"<?php echo $apc_pfv->datetime->editAttributes() ?>>
<?php if (!$apc_pfv->datetime->ReadOnly && !$apc_pfv->datetime->Disabled && !isset($apc_pfv->datetime->EditAttrs["readonly"]) && !isset($apc_pfv->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fapc_pfvsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$apc_pfv_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $apc_pfv_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$apc_pfv_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$apc_pfv_search->terminate();
?>