<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_add = new apc_add();

// Run the page
$apc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fapcadd = currentForm = new ew.Form("fapcadd", "add");

// Validate form
fapcadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($apc_add->apcid->Required) { ?>
			elm = this.getElements("x" + infix + "_apcid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->apcid->caption(), $apc->apcid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_apcid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->apcid->errorMessage()) ?>");
		<?php if ($apc_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->grp->caption(), $apc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_add->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->code->caption(), $apc->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_add->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->description->caption(), $apc->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_add->delay->Required) { ?>
			elm = this.getElements("x" + infix + "_delay");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->delay->caption(), $apc->delay->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_delay");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->delay->errorMessage()) ?>");
		<?php if ($apc_add->delay_method->Required) { ?>
			elm = this.getElements("x" + infix + "_delay_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->delay_method->caption(), $apc->delay_method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->datetime->caption(), $apc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->status->caption(), $apc->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_add->order_by->Required) { ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->order_by->caption(), $apc->order_by->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->order_by->errorMessage()) ?>");
		<?php if ($apc_add->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->url->caption(), $apc->url->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fapcadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapcadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapcadd.lists["x_grp[]"] = <?php echo $apc_add->grp->Lookup->toClientList() ?>;
fapcadd.lists["x_grp[]"].options = <?php echo JsonEncode($apc_add->grp->lookupOptions()) ?>;
fapcadd.lists["x_delay_method"] = <?php echo $apc_add->delay_method->Lookup->toClientList() ?>;
fapcadd.lists["x_delay_method"].options = <?php echo JsonEncode($apc_add->delay_method->options(FALSE, TRUE)) ?>;
fapcadd.lists["x_status"] = <?php echo $apc_add->status->Lookup->toClientList() ?>;
fapcadd.lists["x_status"].options = <?php echo JsonEncode($apc_add->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $apc_add->showPageHeader(); ?>
<?php
$apc_add->showMessage();
?>
<form name="fapcadd" id="fapcadd" class="<?php echo $apc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$apc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($apc->apcid->Visible) { // apcid ?>
	<div id="r_apcid" class="form-group row">
		<label id="elh_apc_apcid" for="x_apcid" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->apcid->caption() ?><?php echo ($apc->apcid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->apcid->cellAttributes() ?>>
<span id="el_apc_apcid">
<input type="text" data-table="apc" data-field="x_apcid" name="x_apcid" id="x_apcid" placeholder="<?php echo HtmlEncode($apc->apcid->getPlaceHolder()) ?>" value="<?php echo $apc->apcid->EditValue ?>"<?php echo $apc->apcid->editAttributes() ?>>
</span>
<?php echo $apc->apcid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_apc_grp" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->grp->caption() ?><?php echo ($apc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->grp->cellAttributes() ?>>
<span id="el_apc_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="apc" data-field="x_grp" data-value-separator="<?php echo $apc->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $apc->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $apc->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $apc->grp->Lookup->getParamTag("p_x_grp") ?>
<?php if (AllowAdd(CurrentProjectID() . "int_fibre_apc_grp") && !$apc->grp->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_grp" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $apc->grp->caption() ?>" data-title="<?php echo $apc->grp->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_grp[]',url:'int_fibre_apc_grpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</span>
<?php echo $apc->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_apc_code" for="x_code" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->code->caption() ?><?php echo ($apc->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->code->cellAttributes() ?>>
<span id="el_apc_code">
<textarea data-table="apc" data-field="x_code" name="x_code" id="x_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($apc->code->getPlaceHolder()) ?>"<?php echo $apc->code->editAttributes() ?>><?php echo $apc->code->EditValue ?></textarea>
</span>
<?php echo $apc->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_apc_description" for="x_description" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->description->caption() ?><?php echo ($apc->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->description->cellAttributes() ?>>
<span id="el_apc_description">
<input type="text" data-table="apc" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($apc->description->getPlaceHolder()) ?>" value="<?php echo $apc->description->EditValue ?>"<?php echo $apc->description->editAttributes() ?>>
</span>
<?php echo $apc->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->delay->Visible) { // delay ?>
	<div id="r_delay" class="form-group row">
		<label id="elh_apc_delay" for="x_delay" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->delay->caption() ?><?php echo ($apc->delay->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->delay->cellAttributes() ?>>
<span id="el_apc_delay">
<input type="text" data-table="apc" data-field="x_delay" name="x_delay" id="x_delay" size="30" placeholder="<?php echo HtmlEncode($apc->delay->getPlaceHolder()) ?>" value="<?php echo $apc->delay->EditValue ?>"<?php echo $apc->delay->editAttributes() ?>>
</span>
<?php echo $apc->delay->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->delay_method->Visible) { // delay_method ?>
	<div id="r_delay_method" class="form-group row">
		<label id="elh_apc_delay_method" for="x_delay_method" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->delay_method->caption() ?><?php echo ($apc->delay_method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->delay_method->cellAttributes() ?>>
<span id="el_apc_delay_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_delay_method" data-value-separator="<?php echo $apc->delay_method->displayValueSeparatorAttribute() ?>" id="x_delay_method" name="x_delay_method"<?php echo $apc->delay_method->editAttributes() ?>>
		<?php echo $apc->delay_method->selectOptionListHtml("x_delay_method") ?>
	</select>
</div>
</span>
<?php echo $apc->delay_method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_apc_status" for="x_status" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->status->caption() ?><?php echo ($apc->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->status->cellAttributes() ?>>
<span id="el_apc_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_status" data-value-separator="<?php echo $apc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $apc->status->editAttributes() ?>>
		<?php echo $apc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $apc->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label id="elh_apc_order_by" for="x_order_by" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->order_by->caption() ?><?php echo ($apc->order_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->order_by->cellAttributes() ?>>
<span id="el_apc_order_by">
<input type="text" data-table="apc" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($apc->order_by->getPlaceHolder()) ?>" value="<?php echo $apc->order_by->EditValue ?>"<?php echo $apc->order_by->editAttributes() ?>>
</span>
<?php echo $apc->order_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_apc_url" for="x_url" class="<?php echo $apc_add->LeftColumnClass ?>"><?php echo $apc->url->caption() ?><?php echo ($apc->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_add->RightColumnClass ?>"><div<?php echo $apc->url->cellAttributes() ?>>
<span id="el_apc_url">
<input type="text" data-table="apc" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($apc->url->getPlaceHolder()) ?>" value="<?php echo $apc->url->EditValue ?>"<?php echo $apc->url->editAttributes() ?>>
</span>
<?php echo $apc->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$apc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $apc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $apc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$apc_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$apc_add->terminate();
?>