<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_edit = new apc_edit();

// Run the page
$apc_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fapcedit = currentForm = new ew.Form("fapcedit", "edit");

// Validate form
fapcedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($apc_edit->apcid->Required) { ?>
			elm = this.getElements("x" + infix + "_apcid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->apcid->caption(), $apc->apcid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_apcid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->apcid->errorMessage()) ?>");
		<?php if ($apc_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->grp->caption(), $apc->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->code->Required) { ?>
			elm = this.getElements("x" + infix + "_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->code->caption(), $apc->code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->description->caption(), $apc->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->cron->Required) { ?>
			elm = this.getElements("x" + infix + "_cron");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->cron->caption(), $apc->cron->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->next_cycle->Required) { ?>
			elm = this.getElements("x" + infix + "_next_cycle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->next_cycle->caption(), $apc->next_cycle->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_next_cycle");
			if (elm && !ew.checkEuroDate(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->next_cycle->errorMessage()) ?>");
		<?php if ($apc_edit->delay->Required) { ?>
			elm = this.getElements("x" + infix + "_delay");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->delay->caption(), $apc->delay->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_delay");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->delay->errorMessage()) ?>");
		<?php if ($apc_edit->delay_method->Required) { ?>
			elm = this.getElements("x" + infix + "_delay_method");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->delay_method->caption(), $apc->delay_method->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->last_updated->Required) { ?>
			elm = this.getElements("x" + infix + "_last_updated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->last_updated->caption(), $apc->last_updated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->user_level->Required) { ?>
			elm = this.getElements("x" + infix + "_user_level[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->user_level->caption(), $apc->user_level->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->visible->Required) { ?>
			elm = this.getElements("x" + infix + "_visible");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->visible->caption(), $apc->visible->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->operator->caption(), $apc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->datetime->caption(), $apc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->status->caption(), $apc->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($apc_edit->order_by->Required) { ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->order_by->caption(), $apc->order_by->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_order_by");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($apc->order_by->errorMessage()) ?>");
		<?php if ($apc_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $apc->url->caption(), $apc->url->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fapcedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapcedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapcedit.lists["x_grp[]"] = <?php echo $apc_edit->grp->Lookup->toClientList() ?>;
fapcedit.lists["x_grp[]"].options = <?php echo JsonEncode($apc_edit->grp->lookupOptions()) ?>;
fapcedit.lists["x_cron"] = <?php echo $apc_edit->cron->Lookup->toClientList() ?>;
fapcedit.lists["x_cron"].options = <?php echo JsonEncode($apc_edit->cron->options(FALSE, TRUE)) ?>;
fapcedit.lists["x_delay_method"] = <?php echo $apc_edit->delay_method->Lookup->toClientList() ?>;
fapcedit.lists["x_delay_method"].options = <?php echo JsonEncode($apc_edit->delay_method->options(FALSE, TRUE)) ?>;
fapcedit.lists["x_user_level[]"] = <?php echo $apc_edit->user_level->Lookup->toClientList() ?>;
fapcedit.lists["x_user_level[]"].options = <?php echo JsonEncode($apc_edit->user_level->lookupOptions()) ?>;
fapcedit.lists["x_visible"] = <?php echo $apc_edit->visible->Lookup->toClientList() ?>;
fapcedit.lists["x_visible"].options = <?php echo JsonEncode($apc_edit->visible->options(FALSE, TRUE)) ?>;
fapcedit.lists["x_operator"] = <?php echo $apc_edit->operator->Lookup->toClientList() ?>;
fapcedit.lists["x_operator"].options = <?php echo JsonEncode($apc_edit->operator->lookupOptions()) ?>;
fapcedit.lists["x_status"] = <?php echo $apc_edit->status->Lookup->toClientList() ?>;
fapcedit.lists["x_status"].options = <?php echo JsonEncode($apc_edit->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $apc_edit->showPageHeader(); ?>
<?php
$apc_edit->showMessage();
?>
<form name="fapcedit" id="fapcedit" class="<?php echo $apc_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$apc_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($apc->apcid->Visible) { // apcid ?>
	<div id="r_apcid" class="form-group row">
		<label id="elh_apc_apcid" for="x_apcid" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->apcid->caption() ?><?php echo ($apc->apcid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->apcid->cellAttributes() ?>>
<span id="el_apc_apcid">
<span<?php echo $apc->apcid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($apc->apcid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="apc" data-field="x_apcid" name="x_apcid" id="x_apcid" value="<?php echo HtmlEncode($apc->apcid->CurrentValue) ?>">
<?php echo $apc->apcid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_apc_grp" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->grp->caption() ?><?php echo ($apc->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->grp->cellAttributes() ?>>
<span id="el_apc_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="apc" data-field="x_grp" data-value-separator="<?php echo $apc->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $apc->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $apc->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $apc->grp->Lookup->getParamTag("p_x_grp") ?>
<?php if (AllowAdd(CurrentProjectID() . "int_fibre_apc_grp") && !$apc->grp->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_grp" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $apc->grp->caption() ?>" data-title="<?php echo $apc->grp->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_grp[]',url:'int_fibre_apc_grpaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</span>
<?php echo $apc->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label id="elh_apc_code" for="x_code" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->code->caption() ?><?php echo ($apc->code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->code->cellAttributes() ?>>
<span id="el_apc_code">
<textarea data-table="apc" data-field="x_code" name="x_code" id="x_code" cols="35" rows="4" placeholder="<?php echo HtmlEncode($apc->code->getPlaceHolder()) ?>"<?php echo $apc->code->editAttributes() ?>><?php echo $apc->code->EditValue ?></textarea>
</span>
<?php echo $apc->code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_apc_description" for="x_description" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->description->caption() ?><?php echo ($apc->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->description->cellAttributes() ?>>
<span id="el_apc_description">
<input type="text" data-table="apc" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($apc->description->getPlaceHolder()) ?>" value="<?php echo $apc->description->EditValue ?>"<?php echo $apc->description->editAttributes() ?>>
</span>
<?php echo $apc->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->cron->Visible) { // cron ?>
	<div id="r_cron" class="form-group row">
		<label id="elh_apc_cron" for="x_cron" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->cron->caption() ?><?php echo ($apc->cron->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->cron->cellAttributes() ?>>
<span id="el_apc_cron">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_cron" data-value-separator="<?php echo $apc->cron->displayValueSeparatorAttribute() ?>" id="x_cron" name="x_cron"<?php echo $apc->cron->editAttributes() ?>>
		<?php echo $apc->cron->selectOptionListHtml("x_cron") ?>
	</select>
</div>
</span>
<?php echo $apc->cron->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->next_cycle->Visible) { // next_cycle ?>
	<div id="r_next_cycle" class="form-group row">
		<label id="elh_apc_next_cycle" for="x_next_cycle" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->next_cycle->caption() ?><?php echo ($apc->next_cycle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->next_cycle->cellAttributes() ?>>
<span id="el_apc_next_cycle">
<input type="text" data-table="apc" data-field="x_next_cycle" data-format="11" name="x_next_cycle" id="x_next_cycle" placeholder="<?php echo HtmlEncode($apc->next_cycle->getPlaceHolder()) ?>" value="<?php echo $apc->next_cycle->EditValue ?>"<?php echo $apc->next_cycle->editAttributes() ?>>
<?php if (!$apc->next_cycle->ReadOnly && !$apc->next_cycle->Disabled && !isset($apc->next_cycle->EditAttrs["readonly"]) && !isset($apc->next_cycle->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fapcedit", "x_next_cycle", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
<?php echo $apc->next_cycle->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->delay->Visible) { // delay ?>
	<div id="r_delay" class="form-group row">
		<label id="elh_apc_delay" for="x_delay" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->delay->caption() ?><?php echo ($apc->delay->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->delay->cellAttributes() ?>>
<span id="el_apc_delay">
<input type="text" data-table="apc" data-field="x_delay" name="x_delay" id="x_delay" size="30" placeholder="<?php echo HtmlEncode($apc->delay->getPlaceHolder()) ?>" value="<?php echo $apc->delay->EditValue ?>"<?php echo $apc->delay->editAttributes() ?>>
</span>
<?php echo $apc->delay->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->delay_method->Visible) { // delay_method ?>
	<div id="r_delay_method" class="form-group row">
		<label id="elh_apc_delay_method" for="x_delay_method" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->delay_method->caption() ?><?php echo ($apc->delay_method->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->delay_method->cellAttributes() ?>>
<span id="el_apc_delay_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_delay_method" data-value-separator="<?php echo $apc->delay_method->displayValueSeparatorAttribute() ?>" id="x_delay_method" name="x_delay_method"<?php echo $apc->delay_method->editAttributes() ?>>
		<?php echo $apc->delay_method->selectOptionListHtml("x_delay_method") ?>
	</select>
</div>
</span>
<?php echo $apc->delay_method->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->last_updated->Visible) { // last_updated ?>
	<div id="r_last_updated" class="form-group row">
		<label id="elh_apc_last_updated" for="x_last_updated" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->last_updated->caption() ?><?php echo ($apc->last_updated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->last_updated->cellAttributes() ?>>
<span id="el_apc_last_updated">
<span<?php echo $apc->last_updated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($apc->last_updated->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="apc" data-field="x_last_updated" name="x_last_updated" id="x_last_updated" value="<?php echo HtmlEncode($apc->last_updated->CurrentValue) ?>">
<?php echo $apc->last_updated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->user_level->Visible) { // user_level ?>
	<div id="r_user_level" class="form-group row">
		<label id="elh_apc_user_level" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->user_level->caption() ?><?php echo ($apc->user_level->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->user_level->cellAttributes() ?>>
<span id="el_apc_user_level">
<div id="tp_x_user_level" class="ew-template"><input type="checkbox" class="form-check-input" data-table="apc" data-field="x_user_level" data-value-separator="<?php echo $apc->user_level->displayValueSeparatorAttribute() ?>" name="x_user_level[]" id="x_user_level[]" value="{value}"<?php echo $apc->user_level->editAttributes() ?>></div>
<div id="dsl_x_user_level" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $apc->user_level->checkBoxListHtml(FALSE, "x_user_level[]") ?>
</div></div>
<?php echo $apc->user_level->Lookup->getParamTag("p_x_user_level") ?>
</span>
<?php echo $apc->user_level->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->visible->Visible) { // visible ?>
	<div id="r_visible" class="form-group row">
		<label id="elh_apc_visible" for="x_visible" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->visible->caption() ?><?php echo ($apc->visible->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->visible->cellAttributes() ?>>
<span id="el_apc_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_visible" data-value-separator="<?php echo $apc->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $apc->visible->editAttributes() ?>>
		<?php echo $apc->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
<?php echo $apc->visible->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_apc_status" for="x_status" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->status->caption() ?><?php echo ($apc->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->status->cellAttributes() ?>>
<span id="el_apc_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_status" data-value-separator="<?php echo $apc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $apc->status->editAttributes() ?>>
		<?php echo $apc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $apc->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label id="elh_apc_order_by" for="x_order_by" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->order_by->caption() ?><?php echo ($apc->order_by->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->order_by->cellAttributes() ?>>
<span id="el_apc_order_by">
<input type="text" data-table="apc" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($apc->order_by->getPlaceHolder()) ?>" value="<?php echo $apc->order_by->EditValue ?>"<?php echo $apc->order_by->editAttributes() ?>>
</span>
<?php echo $apc->order_by->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($apc->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_apc_url" for="x_url" class="<?php echo $apc_edit->LeftColumnClass ?>"><?php echo $apc->url->caption() ?><?php echo ($apc->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $apc_edit->RightColumnClass ?>"><div<?php echo $apc->url->cellAttributes() ?>>
<span id="el_apc_url">
<input type="text" data-table="apc" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($apc->url->getPlaceHolder()) ?>" value="<?php echo $apc->url->EditValue ?>"<?php echo $apc->url->editAttributes() ?>>
</span>
<?php echo $apc->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$apc_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $apc_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $apc_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$apc_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$apc_edit->terminate();
?>