<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_list = new apc_list();

// Run the page
$apc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$apc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fapclist = currentForm = new ew.Form("fapclist", "list");
fapclist.formKeyCountName = '<?php echo $apc_list->FormKeyCountName ?>';

// Form_CustomValidate event
fapclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapclist.lists["x_grp[]"] = <?php echo $apc_list->grp->Lookup->toClientList() ?>;
fapclist.lists["x_grp[]"].options = <?php echo JsonEncode($apc_list->grp->lookupOptions()) ?>;
fapclist.lists["x_cron"] = <?php echo $apc_list->cron->Lookup->toClientList() ?>;
fapclist.lists["x_cron"].options = <?php echo JsonEncode($apc_list->cron->options(FALSE, TRUE)) ?>;
fapclist.lists["x_delay_method"] = <?php echo $apc_list->delay_method->Lookup->toClientList() ?>;
fapclist.lists["x_delay_method"].options = <?php echo JsonEncode($apc_list->delay_method->options(FALSE, TRUE)) ?>;
fapclist.lists["x_user_level[]"] = <?php echo $apc_list->user_level->Lookup->toClientList() ?>;
fapclist.lists["x_user_level[]"].options = <?php echo JsonEncode($apc_list->user_level->lookupOptions()) ?>;
fapclist.lists["x_visible"] = <?php echo $apc_list->visible->Lookup->toClientList() ?>;
fapclist.lists["x_visible"].options = <?php echo JsonEncode($apc_list->visible->options(FALSE, TRUE)) ?>;
fapclist.lists["x_operator"] = <?php echo $apc_list->operator->Lookup->toClientList() ?>;
fapclist.lists["x_operator"].options = <?php echo JsonEncode($apc_list->operator->lookupOptions()) ?>;
fapclist.lists["x_status"] = <?php echo $apc_list->status->Lookup->toClientList() ?>;
fapclist.lists["x_status"].options = <?php echo JsonEncode($apc_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fapclistsrch = currentSearchForm = new ew.Form("fapclistsrch");

// Validate function for search
fapclistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_apcid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($apc->apcid->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fapclistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapclistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapclistsrch.lists["x_grp[]"] = <?php echo $apc_list->grp->Lookup->toClientList() ?>;
fapclistsrch.lists["x_grp[]"].options = <?php echo JsonEncode($apc_list->grp->lookupOptions()) ?>;
fapclistsrch.lists["x_visible"] = <?php echo $apc_list->visible->Lookup->toClientList() ?>;
fapclistsrch.lists["x_visible"].options = <?php echo JsonEncode($apc_list->visible->options(FALSE, TRUE)) ?>;
fapclistsrch.lists["x_status"] = <?php echo $apc_list->status->Lookup->toClientList() ?>;
fapclistsrch.lists["x_status"].options = <?php echo JsonEncode($apc_list->status->options(FALSE, TRUE)) ?>;

// Filters
fapclistsrch.filterList = <?php echo $apc_list->getFilterList() ?>;

// Init search panel as collapsed
fapclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$apc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($apc_list->TotalRecs > 0 && $apc_list->ExportOptions->visible()) { ?>
<?php $apc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($apc_list->ImportOptions->visible()) { ?>
<?php $apc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($apc_list->SearchOptions->visible()) { ?>
<?php $apc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($apc_list->FilterOptions->visible()) { ?>
<?php $apc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$apc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$apc->isExport() && !$apc->CurrentAction) { ?>
<form name="fapclistsrch" id="fapclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($apc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fapclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="apc">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$apc_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$apc->RowType = ROWTYPE_SEARCH;

// Render row
$apc->resetAttributes();
$apc_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($apc->apcid->Visible) { // apcid ?>
	<div id="xsc_apcid" class="ew-cell form-group">
		<label for="x_apcid" class="ew-search-caption ew-label"><?php echo $apc->apcid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_apcid" id="z_apcid" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="apc" data-field="x_apcid" name="x_apcid" id="x_apcid" placeholder="<?php echo HtmlEncode($apc->apcid->getPlaceHolder()) ?>" value="<?php echo $apc->apcid->EditValue ?>"<?php echo $apc->apcid->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($apc->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $apc->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="apc" data-field="x_grp" data-value-separator="<?php echo $apc->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $apc->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $apc->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $apc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($apc->description->Visible) { // description ?>
	<div id="xsc_description" class="ew-cell form-group">
		<label for="x_description" class="ew-search-caption ew-label"><?php echo $apc->description->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="apc" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($apc->description->getPlaceHolder()) ?>" value="<?php echo $apc->description->EditValue ?>"<?php echo $apc->description->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($apc->visible->Visible) { // visible ?>
	<div id="xsc_visible" class="ew-cell form-group">
		<label for="x_visible" class="ew-search-caption ew-label"><?php echo $apc->visible->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_visible" id="z_visible" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_visible" data-value-separator="<?php echo $apc->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $apc->visible->editAttributes() ?>>
		<?php echo $apc->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($apc->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $apc->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_status" data-value-separator="<?php echo $apc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $apc->status->editAttributes() ?>>
		<?php echo $apc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($apc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($apc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $apc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($apc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($apc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($apc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($apc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $apc_list->showPageHeader(); ?>
<?php
$apc_list->showMessage();
?>
<?php if ($apc_list->TotalRecs > 0 || $apc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($apc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> apc">
<?php if (!$apc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$apc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($apc_list->Pager)) $apc_list->Pager = new PrevNextPager($apc_list->StartRec, $apc_list->DisplayRecs, $apc_list->TotalRecs, $apc_list->AutoHidePager) ?>
<?php if ($apc_list->Pager->RecordCount > 0 && $apc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($apc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($apc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $apc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($apc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($apc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $apc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($apc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $apc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $apc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $apc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($apc_list->TotalRecs > 0 && (!$apc_list->AutoHidePageSizeSelector || $apc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="apc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($apc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($apc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($apc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($apc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $apc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fapclist" id="fapclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc">
<div id="gmp_apc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($apc_list->TotalRecs > 0 || $apc->isGridEdit()) { ?>
<table id="tbl_apclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$apc_list->RowType = ROWTYPE_HEADER;

// Render list options
$apc_list->renderListOptions();

// Render list options (header, left)
$apc_list->ListOptions->render("header", "left");
?>
<?php if ($apc->apcid->Visible) { // apcid ?>
	<?php if ($apc->sortUrl($apc->apcid) == "") { ?>
		<th data-name="apcid" class="<?php echo $apc->apcid->headerCellClass() ?>"><div id="elh_apc_apcid" class="apc_apcid"><div class="ew-table-header-caption"><?php echo $apc->apcid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="apcid" class="<?php echo $apc->apcid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->apcid) ?>',1);"><div id="elh_apc_apcid" class="apc_apcid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->apcid->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->apcid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->apcid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->grp->Visible) { // grp ?>
	<?php if ($apc->sortUrl($apc->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $apc->grp->headerCellClass() ?>"><div id="elh_apc_grp" class="apc_grp"><div class="ew-table-header-caption"><?php echo $apc->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $apc->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->grp) ?>',1);"><div id="elh_apc_grp" class="apc_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->description->Visible) { // description ?>
	<?php if ($apc->sortUrl($apc->description) == "") { ?>
		<th data-name="description" class="<?php echo $apc->description->headerCellClass() ?>"><div id="elh_apc_description" class="apc_description"><div class="ew-table-header-caption"><?php echo $apc->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $apc->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->description) ?>',1);"><div id="elh_apc_description" class="apc_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($apc->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->cron->Visible) { // cron ?>
	<?php if ($apc->sortUrl($apc->cron) == "") { ?>
		<th data-name="cron" class="<?php echo $apc->cron->headerCellClass() ?>"><div id="elh_apc_cron" class="apc_cron"><div class="ew-table-header-caption"><?php echo $apc->cron->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cron" class="<?php echo $apc->cron->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->cron) ?>',1);"><div id="elh_apc_cron" class="apc_cron">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->cron->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->cron->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->cron->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->next_cycle->Visible) { // next_cycle ?>
	<?php if ($apc->sortUrl($apc->next_cycle) == "") { ?>
		<th data-name="next_cycle" class="<?php echo $apc->next_cycle->headerCellClass() ?>"><div id="elh_apc_next_cycle" class="apc_next_cycle"><div class="ew-table-header-caption"><?php echo $apc->next_cycle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_cycle" class="<?php echo $apc->next_cycle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->next_cycle) ?>',1);"><div id="elh_apc_next_cycle" class="apc_next_cycle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->next_cycle->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->next_cycle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->next_cycle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->delay->Visible) { // delay ?>
	<?php if ($apc->sortUrl($apc->delay) == "") { ?>
		<th data-name="delay" class="<?php echo $apc->delay->headerCellClass() ?>"><div id="elh_apc_delay" class="apc_delay"><div class="ew-table-header-caption"><?php echo $apc->delay->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delay" class="<?php echo $apc->delay->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->delay) ?>',1);"><div id="elh_apc_delay" class="apc_delay">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->delay->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->delay->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->delay->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->delay_method->Visible) { // delay_method ?>
	<?php if ($apc->sortUrl($apc->delay_method) == "") { ?>
		<th data-name="delay_method" class="<?php echo $apc->delay_method->headerCellClass() ?>"><div id="elh_apc_delay_method" class="apc_delay_method"><div class="ew-table-header-caption"><?php echo $apc->delay_method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delay_method" class="<?php echo $apc->delay_method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->delay_method) ?>',1);"><div id="elh_apc_delay_method" class="apc_delay_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->delay_method->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->delay_method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->delay_method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->last_updated->Visible) { // last_updated ?>
	<?php if ($apc->sortUrl($apc->last_updated) == "") { ?>
		<th data-name="last_updated" class="<?php echo $apc->last_updated->headerCellClass() ?>"><div id="elh_apc_last_updated" class="apc_last_updated"><div class="ew-table-header-caption"><?php echo $apc->last_updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_updated" class="<?php echo $apc->last_updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->last_updated) ?>',1);"><div id="elh_apc_last_updated" class="apc_last_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->last_updated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($apc->last_updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->last_updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->user_level->Visible) { // user_level ?>
	<?php if ($apc->sortUrl($apc->user_level) == "") { ?>
		<th data-name="user_level" class="<?php echo $apc->user_level->headerCellClass() ?>"><div id="elh_apc_user_level" class="apc_user_level"><div class="ew-table-header-caption"><?php echo $apc->user_level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_level" class="<?php echo $apc->user_level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->user_level) ?>',1);"><div id="elh_apc_user_level" class="apc_user_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->user_level->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->user_level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->user_level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->visible->Visible) { // visible ?>
	<?php if ($apc->sortUrl($apc->visible) == "") { ?>
		<th data-name="visible" class="<?php echo $apc->visible->headerCellClass() ?>"><div id="elh_apc_visible" class="apc_visible"><div class="ew-table-header-caption"><?php echo $apc->visible->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="visible" class="<?php echo $apc->visible->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->visible) ?>',1);"><div id="elh_apc_visible" class="apc_visible">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->visible->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->visible->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->visible->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->operator->Visible) { // operator ?>
	<?php if ($apc->sortUrl($apc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $apc->operator->headerCellClass() ?>"><div id="elh_apc_operator" class="apc_operator"><div class="ew-table-header-caption"><?php echo $apc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $apc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->operator) ?>',1);"><div id="elh_apc_operator" class="apc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->datetime->Visible) { // datetime ?>
	<?php if ($apc->sortUrl($apc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $apc->datetime->headerCellClass() ?>"><div id="elh_apc_datetime" class="apc_datetime"><div class="ew-table-header-caption"><?php echo $apc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $apc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->datetime) ?>',1);"><div id="elh_apc_datetime" class="apc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->status->Visible) { // status ?>
	<?php if ($apc->sortUrl($apc->status) == "") { ?>
		<th data-name="status" class="<?php echo $apc->status->headerCellClass() ?>"><div id="elh_apc_status" class="apc_status"><div class="ew-table-header-caption"><?php echo $apc->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $apc->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->status) ?>',1);"><div id="elh_apc_status" class="apc_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->order_by->Visible) { // order_by ?>
	<?php if ($apc->sortUrl($apc->order_by) == "") { ?>
		<th data-name="order_by" class="<?php echo $apc->order_by->headerCellClass() ?>"><div id="elh_apc_order_by" class="apc_order_by"><div class="ew-table-header-caption"><?php echo $apc->order_by->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="order_by" class="<?php echo $apc->order_by->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->order_by) ?>',1);"><div id="elh_apc_order_by" class="apc_order_by">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->order_by->caption() ?></span><span class="ew-table-header-sort"><?php if ($apc->order_by->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->order_by->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($apc->url->Visible) { // url ?>
	<?php if ($apc->sortUrl($apc->url) == "") { ?>
		<th data-name="url" class="<?php echo $apc->url->headerCellClass() ?>"><div id="elh_apc_url" class="apc_url"><div class="ew-table-header-caption"><?php echo $apc->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $apc->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $apc->SortUrl($apc->url) ?>',1);"><div id="elh_apc_url" class="apc_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $apc->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($apc->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($apc->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$apc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($apc->ExportAll && $apc->isExport()) {
	$apc_list->StopRec = $apc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($apc_list->TotalRecs > $apc_list->StartRec + $apc_list->DisplayRecs - 1)
		$apc_list->StopRec = $apc_list->StartRec + $apc_list->DisplayRecs - 1;
	else
		$apc_list->StopRec = $apc_list->TotalRecs;
}
$apc_list->RecCnt = $apc_list->StartRec - 1;
if ($apc_list->Recordset && !$apc_list->Recordset->EOF) {
	$apc_list->Recordset->moveFirst();
	$selectLimit = $apc_list->UseSelectLimit;
	if (!$selectLimit && $apc_list->StartRec > 1)
		$apc_list->Recordset->move($apc_list->StartRec - 1);
} elseif (!$apc->AllowAddDeleteRow && $apc_list->StopRec == 0) {
	$apc_list->StopRec = $apc->GridAddRowCount;
}

// Initialize aggregate
$apc->RowType = ROWTYPE_AGGREGATEINIT;
$apc->resetAttributes();
$apc_list->renderRow();
while ($apc_list->RecCnt < $apc_list->StopRec) {
	$apc_list->RecCnt++;
	if ($apc_list->RecCnt >= $apc_list->StartRec) {
		$apc_list->RowCnt++;

		// Set up key count
		$apc_list->KeyCount = $apc_list->RowIndex;

		// Init row class and style
		$apc->resetAttributes();
		$apc->CssClass = "";
		if ($apc->isGridAdd()) {
		} else {
			$apc_list->loadRowValues($apc_list->Recordset); // Load row values
		}
		$apc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$apc->RowAttrs = array_merge($apc->RowAttrs, array('data-rowindex'=>$apc_list->RowCnt, 'id'=>'r' . $apc_list->RowCnt . '_apc', 'data-rowtype'=>$apc->RowType));

		// Render row
		$apc_list->renderRow();

		// Render list options
		$apc_list->renderListOptions();
?>
	<tr<?php echo $apc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$apc_list->ListOptions->render("body", "left", $apc_list->RowCnt);
?>
	<?php if ($apc->apcid->Visible) { // apcid ?>
		<td data-name="apcid"<?php echo $apc->apcid->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_apcid" class="apc_apcid">
<span<?php echo $apc->apcid->viewAttributes() ?>>
<?php echo $apc->apcid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $apc->grp->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_grp" class="apc_grp">
<span<?php echo $apc->grp->viewAttributes() ?>>
<?php echo $apc->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->description->Visible) { // description ?>
		<td data-name="description"<?php echo $apc->description->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_description" class="apc_description">
<span<?php echo $apc->description->viewAttributes() ?>>
<?php if ((!EmptyString($apc->description->getViewValue())) && $apc->description->linkAttributes() <> "") { ?>
<a<?php echo $apc->description->linkAttributes() ?>><?php echo $apc->description->getViewValue() ?></a>
<?php } else { ?>
<?php echo $apc->description->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->cron->Visible) { // cron ?>
		<td data-name="cron"<?php echo $apc->cron->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_cron" class="apc_cron">
<span<?php echo $apc->cron->viewAttributes() ?>>
<?php echo $apc->cron->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->next_cycle->Visible) { // next_cycle ?>
		<td data-name="next_cycle"<?php echo $apc->next_cycle->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_next_cycle" class="apc_next_cycle">
<span<?php echo $apc->next_cycle->viewAttributes() ?>>
<?php echo $apc->next_cycle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->delay->Visible) { // delay ?>
		<td data-name="delay"<?php echo $apc->delay->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_delay" class="apc_delay">
<span<?php echo $apc->delay->viewAttributes() ?>>
<?php echo $apc->delay->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->delay_method->Visible) { // delay_method ?>
		<td data-name="delay_method"<?php echo $apc->delay_method->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_delay_method" class="apc_delay_method">
<span<?php echo $apc->delay_method->viewAttributes() ?>>
<?php echo $apc->delay_method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->last_updated->Visible) { // last_updated ?>
		<td data-name="last_updated"<?php echo $apc->last_updated->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_last_updated" class="apc_last_updated">
<span<?php echo $apc->last_updated->viewAttributes() ?>>
<?php echo $apc->last_updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->user_level->Visible) { // user_level ?>
		<td data-name="user_level"<?php echo $apc->user_level->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_user_level" class="apc_user_level">
<span<?php echo $apc->user_level->viewAttributes() ?>>
<?php echo $apc->user_level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->visible->Visible) { // visible ?>
		<td data-name="visible"<?php echo $apc->visible->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_visible" class="apc_visible">
<span<?php echo $apc->visible->viewAttributes() ?>>
<?php echo $apc->visible->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $apc->operator->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_operator" class="apc_operator">
<span<?php echo $apc->operator->viewAttributes() ?>>
<?php echo $apc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $apc->datetime->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_datetime" class="apc_datetime">
<span<?php echo $apc->datetime->viewAttributes() ?>>
<?php echo $apc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->status->Visible) { // status ?>
		<td data-name="status"<?php echo $apc->status->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_status" class="apc_status">
<span<?php echo $apc->status->viewAttributes() ?>>
<?php echo $apc->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->order_by->Visible) { // order_by ?>
		<td data-name="order_by"<?php echo $apc->order_by->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_order_by" class="apc_order_by">
<span<?php echo $apc->order_by->viewAttributes() ?>>
<?php echo $apc->order_by->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($apc->url->Visible) { // url ?>
		<td data-name="url"<?php echo $apc->url->cellAttributes() ?>>
<span id="el<?php echo $apc_list->RowCnt ?>_apc_url" class="apc_url">
<span<?php echo $apc->url->viewAttributes() ?>>
<?php echo $apc->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$apc_list->ListOptions->render("body", "right", $apc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$apc->isGridAdd())
		$apc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$apc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($apc_list->Recordset)
	$apc_list->Recordset->Close();
?>
<?php if (!$apc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$apc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($apc_list->Pager)) $apc_list->Pager = new PrevNextPager($apc_list->StartRec, $apc_list->DisplayRecs, $apc_list->TotalRecs, $apc_list->AutoHidePager) ?>
<?php if ($apc_list->Pager->RecordCount > 0 && $apc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($apc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($apc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $apc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($apc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($apc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $apc_list->pageUrl() ?>start=<?php echo $apc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $apc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($apc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $apc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $apc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $apc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($apc_list->TotalRecs > 0 && (!$apc_list->AutoHidePageSizeSelector || $apc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="apc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($apc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($apc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($apc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($apc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $apc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($apc_list->TotalRecs == 0 && !$apc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $apc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$apc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$apc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$apc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_apc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$apc_list->terminate();
?>