<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_search = new apc_search();

// Run the page
$apc_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($apc_search->IsModal) { ?>
var fapcsearch = currentAdvancedSearchForm = new ew.Form("fapcsearch", "search");
<?php } else { ?>
var fapcsearch = currentForm = new ew.Form("fapcsearch", "search");
<?php } ?>

// Form_CustomValidate event
fapcsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapcsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapcsearch.lists["x_grp[]"] = <?php echo $apc_search->grp->Lookup->toClientList() ?>;
fapcsearch.lists["x_grp[]"].options = <?php echo JsonEncode($apc_search->grp->lookupOptions()) ?>;
fapcsearch.lists["x_cron"] = <?php echo $apc_search->cron->Lookup->toClientList() ?>;
fapcsearch.lists["x_cron"].options = <?php echo JsonEncode($apc_search->cron->options(FALSE, TRUE)) ?>;
fapcsearch.lists["x_delay_method"] = <?php echo $apc_search->delay_method->Lookup->toClientList() ?>;
fapcsearch.lists["x_delay_method"].options = <?php echo JsonEncode($apc_search->delay_method->options(FALSE, TRUE)) ?>;
fapcsearch.lists["x_user_level[]"] = <?php echo $apc_search->user_level->Lookup->toClientList() ?>;
fapcsearch.lists["x_user_level[]"].options = <?php echo JsonEncode($apc_search->user_level->lookupOptions()) ?>;
fapcsearch.lists["x_visible"] = <?php echo $apc_search->visible->Lookup->toClientList() ?>;
fapcsearch.lists["x_visible"].options = <?php echo JsonEncode($apc_search->visible->options(FALSE, TRUE)) ?>;
fapcsearch.lists["x_operator"] = <?php echo $apc_search->operator->Lookup->toClientList() ?>;
fapcsearch.lists["x_operator"].options = <?php echo JsonEncode($apc_search->operator->lookupOptions()) ?>;
fapcsearch.lists["x_status"] = <?php echo $apc_search->status->Lookup->toClientList() ?>;
fapcsearch.lists["x_status"].options = <?php echo JsonEncode($apc_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fapcsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_apcid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($apc->apcid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_next_cycle");
	if (elm && !ew.checkEuroDate(elm.value))
		return this.onError(elm, "<?php echo JsEncode($apc->next_cycle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_delay");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($apc->delay->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_order_by");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($apc->order_by->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $apc_search->showPageHeader(); ?>
<?php
$apc_search->showMessage();
?>
<form name="fapcsearch" id="fapcsearch" class="<?php echo $apc_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$apc_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($apc->apcid->Visible) { // apcid ?>
	<div id="r_apcid" class="form-group row">
		<label for="x_apcid" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_apcid"><?php echo $apc->apcid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_apcid" id="z_apcid" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->apcid->cellAttributes() ?>>
			<span id="el_apc_apcid">
<input type="text" data-table="apc" data-field="x_apcid" name="x_apcid" id="x_apcid" placeholder="<?php echo HtmlEncode($apc->apcid->getPlaceHolder()) ?>" value="<?php echo $apc->apcid->EditValue ?>"<?php echo $apc->apcid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_grp"><?php echo $apc->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->grp->cellAttributes() ?>>
			<span id="el_apc_grp">
<div id="tp_x_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="apc" data-field="x_grp" data-value-separator="<?php echo $apc->grp->displayValueSeparatorAttribute() ?>" name="x_grp[]" id="x_grp[]" value="{value}"<?php echo $apc->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $apc->grp->checkBoxListHtml(FALSE, "x_grp[]") ?>
</div></div>
<?php echo $apc->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_code"><?php echo $apc->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->code->cellAttributes() ?>>
			<span id="el_apc_code">
<input type="text" data-table="apc" data-field="x_code" name="x_code" id="x_code" size="35" placeholder="<?php echo HtmlEncode($apc->code->getPlaceHolder()) ?>" value="<?php echo $apc->code->EditValue ?>"<?php echo $apc->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label for="x_description" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_description"><?php echo $apc->description->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_description" id="z_description" value="LIKE"></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->description->cellAttributes() ?>>
			<span id="el_apc_description">
<input type="text" data-table="apc" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($apc->description->getPlaceHolder()) ?>" value="<?php echo $apc->description->EditValue ?>"<?php echo $apc->description->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->cron->Visible) { // cron ?>
	<div id="r_cron" class="form-group row">
		<label for="x_cron" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_cron"><?php echo $apc->cron->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cron" id="z_cron" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->cron->cellAttributes() ?>>
			<span id="el_apc_cron">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_cron" data-value-separator="<?php echo $apc->cron->displayValueSeparatorAttribute() ?>" id="x_cron" name="x_cron"<?php echo $apc->cron->editAttributes() ?>>
		<?php echo $apc->cron->selectOptionListHtml("x_cron") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->next_cycle->Visible) { // next_cycle ?>
	<div id="r_next_cycle" class="form-group row">
		<label for="x_next_cycle" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_next_cycle"><?php echo $apc->next_cycle->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_cycle" id="z_next_cycle" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->next_cycle->cellAttributes() ?>>
			<span id="el_apc_next_cycle">
<input type="text" data-table="apc" data-field="x_next_cycle" data-format="11" name="x_next_cycle" id="x_next_cycle" placeholder="<?php echo HtmlEncode($apc->next_cycle->getPlaceHolder()) ?>" value="<?php echo $apc->next_cycle->EditValue ?>"<?php echo $apc->next_cycle->editAttributes() ?>>
<?php if (!$apc->next_cycle->ReadOnly && !$apc->next_cycle->Disabled && !isset($apc->next_cycle->EditAttrs["readonly"]) && !isset($apc->next_cycle->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fapcsearch", "x_next_cycle", {"ignoreReadonly":true,"useCurrent":false,"format":11});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->delay->Visible) { // delay ?>
	<div id="r_delay" class="form-group row">
		<label for="x_delay" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_delay"><?php echo $apc->delay->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delay" id="z_delay" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->delay->cellAttributes() ?>>
			<span id="el_apc_delay">
<input type="text" data-table="apc" data-field="x_delay" name="x_delay" id="x_delay" size="30" placeholder="<?php echo HtmlEncode($apc->delay->getPlaceHolder()) ?>" value="<?php echo $apc->delay->EditValue ?>"<?php echo $apc->delay->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->delay_method->Visible) { // delay_method ?>
	<div id="r_delay_method" class="form-group row">
		<label for="x_delay_method" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_delay_method"><?php echo $apc->delay_method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delay_method" id="z_delay_method" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->delay_method->cellAttributes() ?>>
			<span id="el_apc_delay_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_delay_method" data-value-separator="<?php echo $apc->delay_method->displayValueSeparatorAttribute() ?>" id="x_delay_method" name="x_delay_method"<?php echo $apc->delay_method->editAttributes() ?>>
		<?php echo $apc->delay_method->selectOptionListHtml("x_delay_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->last_updated->Visible) { // last_updated ?>
	<div id="r_last_updated" class="form-group row">
		<label for="x_last_updated" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_last_updated"><?php echo $apc->last_updated->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_last_updated" id="z_last_updated" value="LIKE"></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->last_updated->cellAttributes() ?>>
			<span id="el_apc_last_updated">
<input type="text" data-table="apc" data-field="x_last_updated" name="x_last_updated" id="x_last_updated" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($apc->last_updated->getPlaceHolder()) ?>" value="<?php echo $apc->last_updated->EditValue ?>"<?php echo $apc->last_updated->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->user_level->Visible) { // user_level ?>
	<div id="r_user_level" class="form-group row">
		<label class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_user_level"><?php echo $apc->user_level->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_user_level" id="z_user_level" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->user_level->cellAttributes() ?>>
			<span id="el_apc_user_level">
<div id="tp_x_user_level" class="ew-template"><input type="checkbox" class="form-check-input" data-table="apc" data-field="x_user_level" data-value-separator="<?php echo $apc->user_level->displayValueSeparatorAttribute() ?>" name="x_user_level[]" id="x_user_level[]" value="{value}"<?php echo $apc->user_level->editAttributes() ?>></div>
<div id="dsl_x_user_level" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $apc->user_level->checkBoxListHtml(FALSE, "x_user_level[]") ?>
</div></div>
<?php echo $apc->user_level->Lookup->getParamTag("p_x_user_level") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->visible->Visible) { // visible ?>
	<div id="r_visible" class="form-group row">
		<label for="x_visible" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_visible"><?php echo $apc->visible->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_visible" id="z_visible" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->visible->cellAttributes() ?>>
			<span id="el_apc_visible">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_visible" data-value-separator="<?php echo $apc->visible->displayValueSeparatorAttribute() ?>" id="x_visible" name="x_visible"<?php echo $apc->visible->editAttributes() ?>>
		<?php echo $apc->visible->selectOptionListHtml("x_visible") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_operator"><?php echo $apc->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->operator->cellAttributes() ?>>
			<span id="el_apc_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_operator" data-value-separator="<?php echo $apc->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $apc->operator->editAttributes() ?>>
		<?php echo $apc->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $apc->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_datetime"><?php echo $apc->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->datetime->cellAttributes() ?>>
			<span id="el_apc_datetime">
<input type="text" data-table="apc" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($apc->datetime->getPlaceHolder()) ?>" value="<?php echo $apc->datetime->EditValue ?>"<?php echo $apc->datetime->editAttributes() ?>>
<?php if (!$apc->datetime->ReadOnly && !$apc->datetime->Disabled && !isset($apc->datetime->EditAttrs["readonly"]) && !isset($apc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fapcsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_status"><?php echo $apc->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->status->cellAttributes() ?>>
			<span id="el_apc_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="apc" data-field="x_status" data-value-separator="<?php echo $apc->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $apc->status->editAttributes() ?>>
		<?php echo $apc->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->order_by->Visible) { // order_by ?>
	<div id="r_order_by" class="form-group row">
		<label for="x_order_by" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_order_by"><?php echo $apc->order_by->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_order_by" id="z_order_by" value="="></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->order_by->cellAttributes() ?>>
			<span id="el_apc_order_by">
<input type="text" data-table="apc" data-field="x_order_by" name="x_order_by" id="x_order_by" size="30" placeholder="<?php echo HtmlEncode($apc->order_by->getPlaceHolder()) ?>" value="<?php echo $apc->order_by->EditValue ?>"<?php echo $apc->order_by->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($apc->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label for="x_url" class="<?php echo $apc_search->LeftColumnClass ?>"><span id="elh_apc_url"><?php echo $apc->url->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_url" id="z_url" value="LIKE"></span>
		</label>
		<div class="<?php echo $apc_search->RightColumnClass ?>"><div<?php echo $apc->url->cellAttributes() ?>>
			<span id="el_apc_url">
<input type="text" data-table="apc" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($apc->url->getPlaceHolder()) ?>" value="<?php echo $apc->url->EditValue ?>"<?php echo $apc->url->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$apc_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $apc_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$apc_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$apc_search->terminate();
?>