<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$apc_view = new apc_view();

// Run the page
$apc_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$apc_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$apc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fapcview = currentForm = new ew.Form("fapcview", "view");

// Form_CustomValidate event
fapcview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fapcview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fapcview.lists["x_grp[]"] = <?php echo $apc_view->grp->Lookup->toClientList() ?>;
fapcview.lists["x_grp[]"].options = <?php echo JsonEncode($apc_view->grp->lookupOptions()) ?>;
fapcview.lists["x_cron"] = <?php echo $apc_view->cron->Lookup->toClientList() ?>;
fapcview.lists["x_cron"].options = <?php echo JsonEncode($apc_view->cron->options(FALSE, TRUE)) ?>;
fapcview.lists["x_delay_method"] = <?php echo $apc_view->delay_method->Lookup->toClientList() ?>;
fapcview.lists["x_delay_method"].options = <?php echo JsonEncode($apc_view->delay_method->options(FALSE, TRUE)) ?>;
fapcview.lists["x_user_level[]"] = <?php echo $apc_view->user_level->Lookup->toClientList() ?>;
fapcview.lists["x_user_level[]"].options = <?php echo JsonEncode($apc_view->user_level->lookupOptions()) ?>;
fapcview.lists["x_visible"] = <?php echo $apc_view->visible->Lookup->toClientList() ?>;
fapcview.lists["x_visible"].options = <?php echo JsonEncode($apc_view->visible->options(FALSE, TRUE)) ?>;
fapcview.lists["x_operator"] = <?php echo $apc_view->operator->Lookup->toClientList() ?>;
fapcview.lists["x_operator"].options = <?php echo JsonEncode($apc_view->operator->lookupOptions()) ?>;
fapcview.lists["x_status"] = <?php echo $apc_view->status->Lookup->toClientList() ?>;
fapcview.lists["x_status"].options = <?php echo JsonEncode($apc_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$apc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $apc_view->ExportOptions->render("body") ?>
<?php $apc_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $apc_view->showPageHeader(); ?>
<?php
$apc_view->showMessage();
?>
<form name="fapcview" id="fapcview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($apc_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $apc_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="apc">
<input type="hidden" name="modal" value="<?php echo (int)$apc_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($apc->apcid->Visible) { // apcid ?>
	<tr id="r_apcid">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_apcid"><?php echo $apc->apcid->caption() ?></span></td>
		<td data-name="apcid"<?php echo $apc->apcid->cellAttributes() ?>>
<span id="el_apc_apcid">
<span<?php echo $apc->apcid->viewAttributes() ?>>
<?php echo $apc->apcid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_grp"><?php echo $apc->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $apc->grp->cellAttributes() ?>>
<span id="el_apc_grp">
<span<?php echo $apc->grp->viewAttributes() ?>>
<?php echo $apc->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_code"><?php echo $apc->code->caption() ?></span></td>
		<td data-name="code"<?php echo $apc->code->cellAttributes() ?>>
<span id="el_apc_code">
<span<?php echo $apc->code->viewAttributes() ?>>
<?php echo $apc->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_description"><?php echo $apc->description->caption() ?></span></td>
		<td data-name="description"<?php echo $apc->description->cellAttributes() ?>>
<span id="el_apc_description">
<span<?php echo $apc->description->viewAttributes() ?>>
<?php if ((!EmptyString($apc->description->getViewValue())) && $apc->description->linkAttributes() <> "") { ?>
<a<?php echo $apc->description->linkAttributes() ?>><?php echo $apc->description->getViewValue() ?></a>
<?php } else { ?>
<?php echo $apc->description->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->cron->Visible) { // cron ?>
	<tr id="r_cron">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_cron"><?php echo $apc->cron->caption() ?></span></td>
		<td data-name="cron"<?php echo $apc->cron->cellAttributes() ?>>
<span id="el_apc_cron">
<span<?php echo $apc->cron->viewAttributes() ?>>
<?php echo $apc->cron->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->next_cycle->Visible) { // next_cycle ?>
	<tr id="r_next_cycle">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_next_cycle"><?php echo $apc->next_cycle->caption() ?></span></td>
		<td data-name="next_cycle"<?php echo $apc->next_cycle->cellAttributes() ?>>
<span id="el_apc_next_cycle">
<span<?php echo $apc->next_cycle->viewAttributes() ?>>
<?php echo $apc->next_cycle->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->delay->Visible) { // delay ?>
	<tr id="r_delay">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_delay"><?php echo $apc->delay->caption() ?></span></td>
		<td data-name="delay"<?php echo $apc->delay->cellAttributes() ?>>
<span id="el_apc_delay">
<span<?php echo $apc->delay->viewAttributes() ?>>
<?php echo $apc->delay->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->delay_method->Visible) { // delay_method ?>
	<tr id="r_delay_method">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_delay_method"><?php echo $apc->delay_method->caption() ?></span></td>
		<td data-name="delay_method"<?php echo $apc->delay_method->cellAttributes() ?>>
<span id="el_apc_delay_method">
<span<?php echo $apc->delay_method->viewAttributes() ?>>
<?php echo $apc->delay_method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->last_updated->Visible) { // last_updated ?>
	<tr id="r_last_updated">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_last_updated"><?php echo $apc->last_updated->caption() ?></span></td>
		<td data-name="last_updated"<?php echo $apc->last_updated->cellAttributes() ?>>
<span id="el_apc_last_updated">
<span<?php echo $apc->last_updated->viewAttributes() ?>>
<?php echo $apc->last_updated->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->user_level->Visible) { // user_level ?>
	<tr id="r_user_level">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_user_level"><?php echo $apc->user_level->caption() ?></span></td>
		<td data-name="user_level"<?php echo $apc->user_level->cellAttributes() ?>>
<span id="el_apc_user_level">
<span<?php echo $apc->user_level->viewAttributes() ?>>
<?php echo $apc->user_level->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->visible->Visible) { // visible ?>
	<tr id="r_visible">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_visible"><?php echo $apc->visible->caption() ?></span></td>
		<td data-name="visible"<?php echo $apc->visible->cellAttributes() ?>>
<span id="el_apc_visible">
<span<?php echo $apc->visible->viewAttributes() ?>>
<?php echo $apc->visible->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_operator"><?php echo $apc->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $apc->operator->cellAttributes() ?>>
<span id="el_apc_operator">
<span<?php echo $apc->operator->viewAttributes() ?>>
<?php echo $apc->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_datetime"><?php echo $apc->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $apc->datetime->cellAttributes() ?>>
<span id="el_apc_datetime">
<span<?php echo $apc->datetime->viewAttributes() ?>>
<?php echo $apc->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_status"><?php echo $apc->status->caption() ?></span></td>
		<td data-name="status"<?php echo $apc->status->cellAttributes() ?>>
<span id="el_apc_status">
<span<?php echo $apc->status->viewAttributes() ?>>
<?php echo $apc->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->order_by->Visible) { // order_by ?>
	<tr id="r_order_by">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_order_by"><?php echo $apc->order_by->caption() ?></span></td>
		<td data-name="order_by"<?php echo $apc->order_by->cellAttributes() ?>>
<span id="el_apc_order_by">
<span<?php echo $apc->order_by->viewAttributes() ?>>
<?php echo $apc->order_by->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($apc->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $apc_view->TableLeftColumnClass ?>"><span id="elh_apc_url"><?php echo $apc->url->caption() ?></span></td>
		<td data-name="url"<?php echo $apc->url->cellAttributes() ?>>
<span id="el_apc_url">
<span<?php echo $apc->url->viewAttributes() ?>>
<?php echo $apc->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$apc_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$apc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$apc_view->terminate();
?>