<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 
?>
<?php include_once "autoload.php" ?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$app = new app();

// Run the page
$app->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();
?>
<?php include_once "header.php" ?>
<?php

unlink('manifest.json');
$row=ExecuteRow("SELECT `name` FROM `portal_info` limit 1");
$name = $row['name'];

$arr = Array (
			"icons" => Array (
				Array (
				"src" => ".p_uploads/pi/icons/android-icon-36x36.png",
				"sizes" => "36x36",
				"type" => "image/png",
				"density" => "0.75"			 	
				),
				Array (
				"src" => ".p_uploads/pi/icons/android-icon-48x48.png",
				"sizes" => "48x48",
				"type" => "image/png",
				"density" => "1.0"			 	
				),
				Array (
				"src" => ".p_uploads/pi/icons/android-icon-72x72.png",
				"sizes" => "72x72",
				"type" => "image/png",
				"density" => "1.5"			 	
				),
				Array (
				"src" => ".p_uploads/pi/icons/android-icon-96x96.png",
				"sizes" => "96x96",
				"type" => "image/png",
				"density" => "2.0"			 	
				),
				Array (
				"src" => ".p_uploads/pi/icons/android-icon-144x144.png",
				"sizes" => "144x144",
				"type" => "image/png",
				"density" => "3.0"			 	
				),
				Array (
				"src" => ".p_uploads/pi/icons/android-icon-192x192.png",
				"sizes" => "192x192",
				"type" => "image/png",
				"density" => "4.0"			 	
				)
			),
		"name" => $name,
		"short_name" => $name,
		"start_url" => "db.php",
		"background_color" => "purple",
		"description" => "Integer Systems. All rights reserved. Helpline +91 9829221171",
		"display" => "standalone"	
	);
				
	$json = json_encode(($arr), JSON_PRETTY_PRINT);
	$file = fopen('manifest.json','w+') or die("File not found");
	fwrite($file, $json);
	fclose($file);


echo 	'	<div class="add-button col-lg-12 col-md-12 col-sm-12">
				<a href="" class="button" style="background-color:rgb(0, 200, 0)">
					<div class="col-3" style="float:left;  height: 100%"><img src=".p_uploads/pi/icons/favicon-96x96.png" alt="" height="70" width="70"></div>
					<div class="col-9" style="float:left; height: 100%">INSTALL APP<br> <h6>Add to Home Screen</h6></div>
				</a>
				<div class="clearfix"></div>
			</div>';
echo 	'	<div class="add-button-db col-lg-12 col-md-12 col-sm-12">
				<a href="db.php" class="button" style="background-color:rgb(200, 0, 0)">
				<div class="col-3" style="float:left;  height: 100%"><i class="fa fa-forward fa-2x" style="color:white";></i></div>
					<div class="col-9" style="float:left; height: 100%">DASHBOARD<br><h6>Back to Dashboard</h6></div>
				</a>
				<div class="clearfix"></div>
			</div>';		
echo 	'	<div class="add-button-ins col-lg-12 col-md-12 col-sm-12">
				<a href="db.php" class="button" style="background-color:rgb(0, 0, 200)">
				<div class="col-3" style="float:left;  height: 100%"><i class="fa fa-forward fa-2x" style="color:white";></i></div>
					<div class="col-9" style="float:left; height: 100%">DASHBOARD<br><h6>App Already Installed</h6></div>
				</a>
				<div class="clearfix"></div>
			</div>';
	?>

<div class="col-3" style="float:left;  height: 100%"><i class="fa fa-forward fa-2x" style="color:white";></i></div>
	
<style>
.button {
  border: none;
  color: white;
  padding: 15px 5px 15px 5px;
  text-align: center;
  text-decoration: none;
  display: inline-block;
  font-size: 30px;
  margin: 10px 0px;
  cursor: pointer;
  font-weight: 1000;
  width: 100%;
  height: 100px;
  margin-bottom: 8px;
}
.blink_text {
	animation:1s blinker linear infinite;
	-webkit-animation:1s blinker linear infinite;
	-moz-animation:1s blinker linear infinite;

	 color: yellow;
	}
 @-moz-keyframes blinker {  
	 0% { opacity: 5.0; }
	 50% { opacity: 0.5; }
	 100% { opacity: 5.0; }
	 }

	@-webkit-keyframes blinker {  
	 0% { opacity: 5.0; }
	 50% { opacity: 0.5; }
	 100% { opacity: 5.0; }
	 }

	@keyframes blinker {  
	 0% { opacity: 5.0; }
	 50% { opacity: 0.5; }
	 100% { opacity: 5.0; }
	}

</style>

<script>

const addBtn = document.querySelector('.add-button');
const addBtnIns = document.querySelector('.add-button-ins');
const addBtnDb = document.querySelector('.add-button-db');
addBtn.style.display = 'none';
addBtnIns.style.display = 'none';
addBtnDb.style.display = 'none';

if ('serviceWorker' in navigator) {
  navigator.serviceWorker
	.register('sw.js')
	.then(() => { console.log('Service Worker Registered'); });
}
else
{
console.log('Service Worker Not Registered')
}

// Code to handle install prompt on desktop
let deferredPrompt;

window.addEventListener('beforeinstallprompt', (e) => {
  // Prevent Chrome 67 and earlier from automatically showing the prompt
  e.preventDefault();
  // Stash the event so it can be triggered later.

  if (deferredPrompt = e)
 // Update UI to notify the user they can add to home screen
  addBtn.style.display = 'block';
  addBtnDb.style.display = 'block';
  addBtnIns.style.display = 'none';

  addBtn.addEventListener('click', () => {
	// hide our user interface that shows our A2HS button

	// Show the prompt
	deferredPrompt.prompt();

	// Wait for the user to respond to the prompt
	deferredPrompt.userChoice.then((choiceResult) => 
	  {
	  if (choiceResult.outcome === 'accepted') {
		console.log('User accepted the App prompt');
	  } 
		else 
	  {
		console.log('User dismissed the App prompt');
	  }
	  deferredPrompt = null;
	});
  });
}, 
  addBtnIns.style.display = 'block');
  
  setTimeout(function(){
	location = 'app.php'
  },15000)
</script>
<?php if (DEBUG_ENABLED) echo GetDebugMessage(); ?>
<?php include_once "footer.php" ?>
<?php
$app->terminate();
?>