<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$audittrail_u_add = new audittrail_u_add();

// Run the page
$audittrail_u_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$audittrail_u_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var faudittrail_uadd = currentForm = new ew.Form("faudittrail_uadd", "add");

// Validate form
faudittrail_uadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($audittrail_u_add->_userid->Required) { ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->_userid->caption(), $audittrail_u->_userid->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__userid");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($audittrail_u->_userid->errorMessage()) ?>");
		<?php if ($audittrail_u_add->ip->Required) { ?>
			elm = this.getElements("x" + infix + "_ip");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->ip->caption(), $audittrail_u->ip->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($audittrail_u_add->page_title->Required) { ?>
			elm = this.getElements("x" + infix + "_page_title");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->page_title->caption(), $audittrail_u->page_title->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($audittrail_u_add->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->url->caption(), $audittrail_u->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($audittrail_u_add->comment->Required) { ?>
			elm = this.getElements("x" + infix + "_comment");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->comment->caption(), $audittrail_u->comment->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($audittrail_u_add->user_agent->Required) { ?>
			elm = this.getElements("x" + infix + "_user_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->user_agent->caption(), $audittrail_u->user_agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($audittrail_u_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $audittrail_u->datetime->caption(), $audittrail_u->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
faudittrail_uadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
faudittrail_uadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $audittrail_u_add->showPageHeader(); ?>
<?php
$audittrail_u_add->showMessage();
?>
<form name="faudittrail_uadd" id="faudittrail_uadd" class="<?php echo $audittrail_u_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($audittrail_u_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $audittrail_u_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="audittrail_u">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$audittrail_u_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($audittrail_u->_userid->Visible) { // userid ?>
	<div id="r__userid" class="form-group row">
		<label id="elh_audittrail_u__userid" for="x__userid" class="<?php echo $audittrail_u_add->LeftColumnClass ?>"><?php echo $audittrail_u->_userid->caption() ?><?php echo ($audittrail_u->_userid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $audittrail_u_add->RightColumnClass ?>"><div<?php echo $audittrail_u->_userid->cellAttributes() ?>>
<span id="el_audittrail_u__userid">
<input type="text" data-table="audittrail_u" data-field="x__userid" name="x__userid" id="x__userid" size="30" placeholder="<?php echo HtmlEncode($audittrail_u->_userid->getPlaceHolder()) ?>" value="<?php echo $audittrail_u->_userid->EditValue ?>"<?php echo $audittrail_u->_userid->editAttributes() ?>>
</span>
<?php echo $audittrail_u->_userid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($audittrail_u->ip->Visible) { // ip ?>
	<div id="r_ip" class="form-group row">
		<label id="elh_audittrail_u_ip" for="x_ip" class="<?php echo $audittrail_u_add->LeftColumnClass ?>"><?php echo $audittrail_u->ip->caption() ?><?php echo ($audittrail_u->ip->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $audittrail_u_add->RightColumnClass ?>"><div<?php echo $audittrail_u->ip->cellAttributes() ?>>
<span id="el_audittrail_u_ip">
<input type="text" data-table="audittrail_u" data-field="x_ip" name="x_ip" id="x_ip" size="30" maxlength="15" placeholder="<?php echo HtmlEncode($audittrail_u->ip->getPlaceHolder()) ?>" value="<?php echo $audittrail_u->ip->EditValue ?>"<?php echo $audittrail_u->ip->editAttributes() ?>>
</span>
<?php echo $audittrail_u->ip->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($audittrail_u->page_title->Visible) { // page_title ?>
	<div id="r_page_title" class="form-group row">
		<label id="elh_audittrail_u_page_title" for="x_page_title" class="<?php echo $audittrail_u_add->LeftColumnClass ?>"><?php echo $audittrail_u->page_title->caption() ?><?php echo ($audittrail_u->page_title->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $audittrail_u_add->RightColumnClass ?>"><div<?php echo $audittrail_u->page_title->cellAttributes() ?>>
<span id="el_audittrail_u_page_title">
<input type="text" data-table="audittrail_u" data-field="x_page_title" name="x_page_title" id="x_page_title" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($audittrail_u->page_title->getPlaceHolder()) ?>" value="<?php echo $audittrail_u->page_title->EditValue ?>"<?php echo $audittrail_u->page_title->editAttributes() ?>>
</span>
<?php echo $audittrail_u->page_title->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($audittrail_u->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_audittrail_u_url" for="x_url" class="<?php echo $audittrail_u_add->LeftColumnClass ?>"><?php echo $audittrail_u->url->caption() ?><?php echo ($audittrail_u->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $audittrail_u_add->RightColumnClass ?>"><div<?php echo $audittrail_u->url->cellAttributes() ?>>
<span id="el_audittrail_u_url">
<textarea data-table="audittrail_u" data-field="x_url" name="x_url" id="x_url" cols="35" rows="4" placeholder="<?php echo HtmlEncode($audittrail_u->url->getPlaceHolder()) ?>"<?php echo $audittrail_u->url->editAttributes() ?>><?php echo $audittrail_u->url->EditValue ?></textarea>
</span>
<?php echo $audittrail_u->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($audittrail_u->comment->Visible) { // comment ?>
	<div id="r_comment" class="form-group row">
		<label id="elh_audittrail_u_comment" for="x_comment" class="<?php echo $audittrail_u_add->LeftColumnClass ?>"><?php echo $audittrail_u->comment->caption() ?><?php echo ($audittrail_u->comment->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $audittrail_u_add->RightColumnClass ?>"><div<?php echo $audittrail_u->comment->cellAttributes() ?>>
<span id="el_audittrail_u_comment">
<input type="text" data-table="audittrail_u" data-field="x_comment" name="x_comment" id="x_comment" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($audittrail_u->comment->getPlaceHolder()) ?>" value="<?php echo $audittrail_u->comment->EditValue ?>"<?php echo $audittrail_u->comment->editAttributes() ?>>
</span>
<?php echo $audittrail_u->comment->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($audittrail_u->user_agent->Visible) { // user_agent ?>
	<div id="r_user_agent" class="form-group row">
		<label id="elh_audittrail_u_user_agent" for="x_user_agent" class="<?php echo $audittrail_u_add->LeftColumnClass ?>"><?php echo $audittrail_u->user_agent->caption() ?><?php echo ($audittrail_u->user_agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $audittrail_u_add->RightColumnClass ?>"><div<?php echo $audittrail_u->user_agent->cellAttributes() ?>>
<span id="el_audittrail_u_user_agent">
<input type="text" data-table="audittrail_u" data-field="x_user_agent" name="x_user_agent" id="x_user_agent" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($audittrail_u->user_agent->getPlaceHolder()) ?>" value="<?php echo $audittrail_u->user_agent->EditValue ?>"<?php echo $audittrail_u->user_agent->editAttributes() ?>>
</span>
<?php echo $audittrail_u->user_agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$audittrail_u_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $audittrail_u_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $audittrail_u_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$audittrail_u_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$audittrail_u_add->terminate();
?>