<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$auto_programme_edit = new auto_programme_edit();

// Run the page
$auto_programme_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$auto_programme_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fauto_programmeedit = currentForm = new ew.Form("fauto_programmeedit", "edit");

// Validate form
fauto_programmeedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($auto_programme_edit->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $auto_programme->grp->caption(), $auto_programme->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($auto_programme_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $auto_programme->description->caption(), $auto_programme->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($auto_programme_edit->last_updated->Required) { ?>
			elm = this.getElements("x" + infix + "_last_updated");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $auto_programme->last_updated->caption(), $auto_programme->last_updated->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($auto_programme_edit->user_level->Required) { ?>
			elm = this.getElements("x" + infix + "_user_level[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $auto_programme->user_level->caption(), $auto_programme->user_level->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($auto_programme_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $auto_programme->id->caption(), $auto_programme->id->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fauto_programmeedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fauto_programmeedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fauto_programmeedit.lists["x_grp"] = <?php echo $auto_programme_edit->grp->Lookup->toClientList() ?>;
fauto_programmeedit.lists["x_grp"].options = <?php echo JsonEncode($auto_programme_edit->grp->lookupOptions()) ?>;
fauto_programmeedit.lists["x_user_level[]"] = <?php echo $auto_programme_edit->user_level->Lookup->toClientList() ?>;
fauto_programmeedit.lists["x_user_level[]"].options = <?php echo JsonEncode($auto_programme_edit->user_level->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $auto_programme_edit->showPageHeader(); ?>
<?php
$auto_programme_edit->showMessage();
?>
<form name="fauto_programmeedit" id="fauto_programmeedit" class="<?php echo $auto_programme_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($auto_programme_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $auto_programme_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="auto_programme">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$auto_programme_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($auto_programme->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_auto_programme_grp" for="x_grp" class="<?php echo $auto_programme_edit->LeftColumnClass ?>"><?php echo $auto_programme->grp->caption() ?><?php echo ($auto_programme->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $auto_programme_edit->RightColumnClass ?>"><div<?php echo $auto_programme->grp->cellAttributes() ?>>
<span id="el_auto_programme_grp">
<span<?php echo $auto_programme->grp->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($auto_programme->grp->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="auto_programme" data-field="x_grp" name="x_grp" id="x_grp" value="<?php echo HtmlEncode($auto_programme->grp->CurrentValue) ?>">
<?php echo $auto_programme->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($auto_programme->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_auto_programme_description" for="x_description" class="<?php echo $auto_programme_edit->LeftColumnClass ?>"><?php echo $auto_programme->description->caption() ?><?php echo ($auto_programme->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $auto_programme_edit->RightColumnClass ?>"><div<?php echo $auto_programme->description->cellAttributes() ?>>
<span id="el_auto_programme_description">
<span<?php echo $auto_programme->description->viewAttributes() ?>>
<?php if ((!EmptyString($auto_programme->description->EditValue)) && $auto_programme->description->linkAttributes() <> "") { ?>
<a<?php echo $auto_programme->description->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($auto_programme->description->EditValue) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($auto_programme->description->EditValue) ?>">
<?php } ?>
</span>
</span>
<input type="hidden" data-table="auto_programme" data-field="x_description" name="x_description" id="x_description" value="<?php echo HtmlEncode($auto_programme->description->CurrentValue) ?>">
<?php echo $auto_programme->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($auto_programme->last_updated->Visible) { // last_updated ?>
	<div id="r_last_updated" class="form-group row">
		<label id="elh_auto_programme_last_updated" for="x_last_updated" class="<?php echo $auto_programme_edit->LeftColumnClass ?>"><?php echo $auto_programme->last_updated->caption() ?><?php echo ($auto_programme->last_updated->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $auto_programme_edit->RightColumnClass ?>"><div<?php echo $auto_programme->last_updated->cellAttributes() ?>>
<span id="el_auto_programme_last_updated">
<span<?php echo $auto_programme->last_updated->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($auto_programme->last_updated->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="auto_programme" data-field="x_last_updated" name="x_last_updated" id="x_last_updated" value="<?php echo HtmlEncode($auto_programme->last_updated->CurrentValue) ?>">
<?php echo $auto_programme->last_updated->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($auto_programme->user_level->Visible) { // user_level ?>
	<div id="r_user_level" class="form-group row">
		<label id="elh_auto_programme_user_level" class="<?php echo $auto_programme_edit->LeftColumnClass ?>"><?php echo $auto_programme->user_level->caption() ?><?php echo ($auto_programme->user_level->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $auto_programme_edit->RightColumnClass ?>"><div<?php echo $auto_programme->user_level->cellAttributes() ?>>
<span id="el_auto_programme_user_level">
<div id="tp_x_user_level" class="ew-template"><input type="checkbox" class="form-check-input" data-table="auto_programme" data-field="x_user_level" data-value-separator="<?php echo $auto_programme->user_level->displayValueSeparatorAttribute() ?>" name="x_user_level[]" id="x_user_level[]" value="{value}"<?php echo $auto_programme->user_level->editAttributes() ?>></div>
<div id="dsl_x_user_level" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $auto_programme->user_level->checkBoxListHtml(FALSE, "x_user_level[]") ?>
</div></div>
<?php echo $auto_programme->user_level->Lookup->getParamTag("p_x_user_level") ?>
</span>
<?php echo $auto_programme->user_level->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($auto_programme->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_auto_programme_id" for="x_id" class="<?php echo $auto_programme_edit->LeftColumnClass ?>"><?php echo $auto_programme->id->caption() ?><?php echo ($auto_programme->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $auto_programme_edit->RightColumnClass ?>"><div<?php echo $auto_programme->id->cellAttributes() ?>>
<span id="el_auto_programme_id">
<span<?php echo $auto_programme->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($auto_programme->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="auto_programme" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($auto_programme->id->CurrentValue) ?>">
<?php echo $auto_programme->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
	<input type="hidden" data-table="auto_programme" data-field="x_apcid" name="x_apcid" id="x_apcid" value="<?php echo HtmlEncode($auto_programme->apcid->CurrentValue) ?>">
<?php if (!$auto_programme_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $auto_programme_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $auto_programme_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$auto_programme_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$auto_programme_edit->terminate();
?>