<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$auto_programme_list = new auto_programme_list();

// Run the page
$auto_programme_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$auto_programme_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$auto_programme->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fauto_programmelist = currentForm = new ew.Form("fauto_programmelist", "list");
fauto_programmelist.formKeyCountName = '<?php echo $auto_programme_list->FormKeyCountName ?>';

// Form_CustomValidate event
fauto_programmelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fauto_programmelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fauto_programmelist.lists["x_grp"] = <?php echo $auto_programme_list->grp->Lookup->toClientList() ?>;
fauto_programmelist.lists["x_grp"].options = <?php echo JsonEncode($auto_programme_list->grp->lookupOptions()) ?>;
fauto_programmelist.lists["x_user_level[]"] = <?php echo $auto_programme_list->user_level->Lookup->toClientList() ?>;
fauto_programmelist.lists["x_user_level[]"].options = <?php echo JsonEncode($auto_programme_list->user_level->lookupOptions()) ?>;

// Form object for search
var fauto_programmelistsrch = currentSearchForm = new ew.Form("fauto_programmelistsrch");

// Filters
fauto_programmelistsrch.filterList = <?php echo $auto_programme_list->getFilterList() ?>;

// Init search panel as collapsed
fauto_programmelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$auto_programme->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($auto_programme_list->TotalRecs > 0 && $auto_programme_list->ExportOptions->visible()) { ?>
<?php $auto_programme_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($auto_programme_list->ImportOptions->visible()) { ?>
<?php $auto_programme_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($auto_programme_list->SearchOptions->visible()) { ?>
<?php $auto_programme_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($auto_programme_list->FilterOptions->visible()) { ?>
<?php $auto_programme_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$auto_programme_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$auto_programme->isExport() && !$auto_programme->CurrentAction) { ?>
<form name="fauto_programmelistsrch" id="fauto_programmelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($auto_programme_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fauto_programmelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="auto_programme">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($auto_programme_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($auto_programme_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $auto_programme_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($auto_programme_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($auto_programme_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($auto_programme_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($auto_programme_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $auto_programme_list->showPageHeader(); ?>
<?php
$auto_programme_list->showMessage();
?>
<?php if ($auto_programme_list->TotalRecs > 0 || $auto_programme->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($auto_programme_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> auto_programme">
<?php if (!$auto_programme->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$auto_programme->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($auto_programme_list->Pager)) $auto_programme_list->Pager = new PrevNextPager($auto_programme_list->StartRec, $auto_programme_list->DisplayRecs, $auto_programme_list->TotalRecs, $auto_programme_list->AutoHidePager) ?>
<?php if ($auto_programme_list->Pager->RecordCount > 0 && $auto_programme_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($auto_programme_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($auto_programme_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $auto_programme_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($auto_programme_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($auto_programme_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $auto_programme_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($auto_programme_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $auto_programme_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $auto_programme_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $auto_programme_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($auto_programme_list->TotalRecs > 0 && (!$auto_programme_list->AutoHidePageSizeSelector || $auto_programme_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="auto_programme">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($auto_programme_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($auto_programme_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($auto_programme_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($auto_programme_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($auto_programme_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($auto_programme->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $auto_programme_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fauto_programmelist" id="fauto_programmelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($auto_programme_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $auto_programme_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="auto_programme">
<div id="gmp_auto_programme" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($auto_programme_list->TotalRecs > 0 || $auto_programme->isGridEdit()) { ?>
<table id="tbl_auto_programmelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$auto_programme_list->RowType = ROWTYPE_HEADER;

// Render list options
$auto_programme_list->renderListOptions();

// Render list options (header, left)
$auto_programme_list->ListOptions->render("header", "left");
?>
<?php if ($auto_programme->grp->Visible) { // grp ?>
	<?php if ($auto_programme->sortUrl($auto_programme->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $auto_programme->grp->headerCellClass() ?>"><div id="elh_auto_programme_grp" class="auto_programme_grp"><div class="ew-table-header-caption"><?php echo $auto_programme->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $auto_programme->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $auto_programme->SortUrl($auto_programme->grp) ?>',2);"><div id="elh_auto_programme_grp" class="auto_programme_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $auto_programme->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($auto_programme->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($auto_programme->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($auto_programme->description->Visible) { // description ?>
	<?php if ($auto_programme->sortUrl($auto_programme->description) == "") { ?>
		<th data-name="description" class="<?php echo $auto_programme->description->headerCellClass() ?>"><div id="elh_auto_programme_description" class="auto_programme_description"><div class="ew-table-header-caption"><?php echo $auto_programme->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $auto_programme->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $auto_programme->SortUrl($auto_programme->description) ?>',2);"><div id="elh_auto_programme_description" class="auto_programme_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $auto_programme->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($auto_programme->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($auto_programme->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($auto_programme->last_updated->Visible) { // last_updated ?>
	<?php if ($auto_programme->sortUrl($auto_programme->last_updated) == "") { ?>
		<th data-name="last_updated" class="<?php echo $auto_programme->last_updated->headerCellClass() ?>"><div id="elh_auto_programme_last_updated" class="auto_programme_last_updated"><div class="ew-table-header-caption"><?php echo $auto_programme->last_updated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="last_updated" class="<?php echo $auto_programme->last_updated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $auto_programme->SortUrl($auto_programme->last_updated) ?>',2);"><div id="elh_auto_programme_last_updated" class="auto_programme_last_updated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $auto_programme->last_updated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($auto_programme->last_updated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($auto_programme->last_updated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($auto_programme->user_level->Visible) { // user_level ?>
	<?php if ($auto_programme->sortUrl($auto_programme->user_level) == "") { ?>
		<th data-name="user_level" class="<?php echo $auto_programme->user_level->headerCellClass() ?>"><div id="elh_auto_programme_user_level" class="auto_programme_user_level"><div class="ew-table-header-caption"><?php echo $auto_programme->user_level->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="user_level" class="<?php echo $auto_programme->user_level->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $auto_programme->SortUrl($auto_programme->user_level) ?>',2);"><div id="elh_auto_programme_user_level" class="auto_programme_user_level">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $auto_programme->user_level->caption() ?></span><span class="ew-table-header-sort"><?php if ($auto_programme->user_level->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($auto_programme->user_level->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$auto_programme_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($auto_programme->ExportAll && $auto_programme->isExport()) {
	$auto_programme_list->StopRec = $auto_programme_list->TotalRecs;
} else {

	// Set the last record to display
	if ($auto_programme_list->TotalRecs > $auto_programme_list->StartRec + $auto_programme_list->DisplayRecs - 1)
		$auto_programme_list->StopRec = $auto_programme_list->StartRec + $auto_programme_list->DisplayRecs - 1;
	else
		$auto_programme_list->StopRec = $auto_programme_list->TotalRecs;
}
$auto_programme_list->RecCnt = $auto_programme_list->StartRec - 1;
if ($auto_programme_list->Recordset && !$auto_programme_list->Recordset->EOF) {
	$auto_programme_list->Recordset->moveFirst();
	$selectLimit = $auto_programme_list->UseSelectLimit;
	if (!$selectLimit && $auto_programme_list->StartRec > 1)
		$auto_programme_list->Recordset->move($auto_programme_list->StartRec - 1);
} elseif (!$auto_programme->AllowAddDeleteRow && $auto_programme_list->StopRec == 0) {
	$auto_programme_list->StopRec = $auto_programme->GridAddRowCount;
}

// Initialize aggregate
$auto_programme->RowType = ROWTYPE_AGGREGATEINIT;
$auto_programme->resetAttributes();
$auto_programme_list->renderRow();
while ($auto_programme_list->RecCnt < $auto_programme_list->StopRec) {
	$auto_programme_list->RecCnt++;
	if ($auto_programme_list->RecCnt >= $auto_programme_list->StartRec) {
		$auto_programme_list->RowCnt++;

		// Set up key count
		$auto_programme_list->KeyCount = $auto_programme_list->RowIndex;

		// Init row class and style
		$auto_programme->resetAttributes();
		$auto_programme->CssClass = "";
		if ($auto_programme->isGridAdd()) {
		} else {
			$auto_programme_list->loadRowValues($auto_programme_list->Recordset); // Load row values
		}
		$auto_programme->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$auto_programme->RowAttrs = array_merge($auto_programme->RowAttrs, array('data-rowindex'=>$auto_programme_list->RowCnt, 'id'=>'r' . $auto_programme_list->RowCnt . '_auto_programme', 'data-rowtype'=>$auto_programme->RowType));

		// Render row
		$auto_programme_list->renderRow();

		// Render list options
		$auto_programme_list->renderListOptions();
?>
	<tr<?php echo $auto_programme->rowAttributes() ?>>
<?php

// Render list options (body, left)
$auto_programme_list->ListOptions->render("body", "left", $auto_programme_list->RowCnt);
?>
	<?php if ($auto_programme->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $auto_programme->grp->cellAttributes() ?>>
<span id="el<?php echo $auto_programme_list->RowCnt ?>_auto_programme_grp" class="auto_programme_grp">
<span<?php echo $auto_programme->grp->viewAttributes() ?>>
<?php echo $auto_programme->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($auto_programme->description->Visible) { // description ?>
		<td data-name="description"<?php echo $auto_programme->description->cellAttributes() ?>>
<span id="el<?php echo $auto_programme_list->RowCnt ?>_auto_programme_description" class="auto_programme_description">
<span<?php echo $auto_programme->description->viewAttributes() ?>>
<?php if ((!EmptyString($auto_programme->description->getViewValue())) && $auto_programme->description->linkAttributes() <> "") { ?>
<a<?php echo $auto_programme->description->linkAttributes() ?>><?php echo $auto_programme->description->getViewValue() ?></a>
<?php } else { ?>
<?php echo $auto_programme->description->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($auto_programme->last_updated->Visible) { // last_updated ?>
		<td data-name="last_updated"<?php echo $auto_programme->last_updated->cellAttributes() ?>>
<span id="el<?php echo $auto_programme_list->RowCnt ?>_auto_programme_last_updated" class="auto_programme_last_updated">
<span<?php echo $auto_programme->last_updated->viewAttributes() ?>>
<?php echo $auto_programme->last_updated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($auto_programme->user_level->Visible) { // user_level ?>
		<td data-name="user_level"<?php echo $auto_programme->user_level->cellAttributes() ?>>
<span id="el<?php echo $auto_programme_list->RowCnt ?>_auto_programme_user_level" class="auto_programme_user_level">
<span<?php echo $auto_programme->user_level->viewAttributes() ?>>
<?php echo $auto_programme->user_level->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$auto_programme_list->ListOptions->render("body", "right", $auto_programme_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$auto_programme->isGridAdd())
		$auto_programme_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$auto_programme->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($auto_programme_list->Recordset)
	$auto_programme_list->Recordset->Close();
?>
<?php if (!$auto_programme->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$auto_programme->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($auto_programme_list->Pager)) $auto_programme_list->Pager = new PrevNextPager($auto_programme_list->StartRec, $auto_programme_list->DisplayRecs, $auto_programme_list->TotalRecs, $auto_programme_list->AutoHidePager) ?>
<?php if ($auto_programme_list->Pager->RecordCount > 0 && $auto_programme_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($auto_programme_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($auto_programme_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $auto_programme_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($auto_programme_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($auto_programme_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $auto_programme_list->pageUrl() ?>start=<?php echo $auto_programme_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $auto_programme_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($auto_programme_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $auto_programme_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $auto_programme_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $auto_programme_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($auto_programme_list->TotalRecs > 0 && (!$auto_programme_list->AutoHidePageSizeSelector || $auto_programme_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="auto_programme">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($auto_programme_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($auto_programme_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($auto_programme_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($auto_programme_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($auto_programme_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($auto_programme->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $auto_programme_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($auto_programme_list->TotalRecs == 0 && !$auto_programme->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $auto_programme_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$auto_programme_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$auto_programme->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$auto_programme->isExport()) { ?>
<script>
ew.scrollableTable("gmp_auto_programme", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$auto_programme_list->terminate();
?>