<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_compiled_list = new b_account_compiled_list();

// Run the page
$b_account_compiled_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_compiled_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_account_compiled->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_account_compiledlist = currentForm = new ew.Form("fb_account_compiledlist", "list");
fb_account_compiledlist.formKeyCountName = '<?php echo $b_account_compiled_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_account_compiledlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_compiledlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_compiledlist.lists["x_grp"] = <?php echo $b_account_compiled_list->grp->Lookup->toClientList() ?>;
fb_account_compiledlist.lists["x_grp"].options = <?php echo JsonEncode($b_account_compiled_list->grp->lookupOptions()) ?>;
fb_account_compiledlist.lists["x_frequency"] = <?php echo $b_account_compiled_list->frequency->Lookup->toClientList() ?>;
fb_account_compiledlist.lists["x_frequency"].options = <?php echo JsonEncode($b_account_compiled_list->frequency->options(FALSE, TRUE)) ?>;
fb_account_compiledlist.lists["x_status"] = <?php echo $b_account_compiled_list->status->Lookup->toClientList() ?>;
fb_account_compiledlist.lists["x_status"].options = <?php echo JsonEncode($b_account_compiled_list->status->lookupOptions()) ?>;
fb_account_compiledlist.lists["x_branch"] = <?php echo $b_account_compiled_list->branch->Lookup->toClientList() ?>;
fb_account_compiledlist.lists["x_branch"].options = <?php echo JsonEncode($b_account_compiled_list->branch->lookupOptions()) ?>;

// Form object for search
var fb_account_compiledlistsrch = currentSearchForm = new ew.Form("fb_account_compiledlistsrch");

// Validate function for search
fb_account_compiledlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fb_account_compiledlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_compiledlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_compiledlistsrch.lists["x_status"] = <?php echo $b_account_compiled_list->status->Lookup->toClientList() ?>;
fb_account_compiledlistsrch.lists["x_status"].options = <?php echo JsonEncode($b_account_compiled_list->status->lookupOptions()) ?>;
fb_account_compiledlistsrch.lists["x_branch"] = <?php echo $b_account_compiled_list->branch->Lookup->toClientList() ?>;
fb_account_compiledlistsrch.lists["x_branch"].options = <?php echo JsonEncode($b_account_compiled_list->branch->lookupOptions()) ?>;

// Filters
fb_account_compiledlistsrch.filterList = <?php echo $b_account_compiled_list->getFilterList() ?>;

// Init search panel as collapsed
fb_account_compiledlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_account_compiled->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_account_compiled_list->TotalRecs > 0 && $b_account_compiled_list->ExportOptions->visible()) { ?>
<?php $b_account_compiled_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_compiled_list->ImportOptions->visible()) { ?>
<?php $b_account_compiled_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_compiled_list->SearchOptions->visible()) { ?>
<?php $b_account_compiled_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_compiled_list->FilterOptions->visible()) { ?>
<?php $b_account_compiled_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_account_compiled_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$b_account_compiled->isExport() && !$b_account_compiled->CurrentAction) { ?>
<form name="fb_account_compiledlistsrch" id="fb_account_compiledlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($b_account_compiled_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fb_account_compiledlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="b_account_compiled">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$b_account_compiled_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$b_account_compiled->RowType = ROWTYPE_SEARCH;

// Render row
$b_account_compiled->resetAttributes();
$b_account_compiled_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($b_account_compiled->account_no->Visible) { // account_no ?>
	<div id="xsc_account_no" class="ew-cell form-group">
		<label for="x_account_no" class="ew-search-caption ew-label"><?php echo $b_account_compiled->account_no->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_account_no" id="z_account_no" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="b_account_compiled" data-field="x_account_no" name="x_account_no" id="x_account_no" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($b_account_compiled->account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->account_no->EditValue ?>"<?php echo $b_account_compiled->account_no->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($b_account_compiled->formal_name->Visible) { // formal_name ?>
	<div id="xsc_formal_name" class="ew-cell form-group">
		<label for="x_formal_name" class="ew-search-caption ew-label"><?php echo $b_account_compiled->formal_name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="b_account_compiled" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_compiled->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->formal_name->EditValue ?>"<?php echo $b_account_compiled->formal_name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($b_account_compiled->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $b_account_compiled->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_compiled" data-field="x_status" data-value-separator="<?php echo $b_account_compiled->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $b_account_compiled->status->editAttributes() ?>>
		<?php echo $b_account_compiled->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $b_account_compiled->status->Lookup->getParamTag("p_x_status") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($b_account_compiled->branch->Visible) { // branch ?>
	<div id="xsc_branch" class="ew-cell form-group">
		<label for="x_branch" class="ew-search-caption ew-label"><?php echo $b_account_compiled->branch->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_branch" id="z_branch" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_compiled" data-field="x_branch" data-value-separator="<?php echo $b_account_compiled->branch->displayValueSeparatorAttribute() ?>" id="x_branch" name="x_branch"<?php echo $b_account_compiled->branch->editAttributes() ?>>
		<?php echo $b_account_compiled->branch->selectOptionListHtml("x_branch") ?>
	</select>
</div>
<?php echo $b_account_compiled->branch->Lookup->getParamTag("p_x_branch") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($b_account_compiled_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($b_account_compiled_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $b_account_compiled_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($b_account_compiled_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($b_account_compiled_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($b_account_compiled_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($b_account_compiled_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $b_account_compiled_list->showPageHeader(); ?>
<?php
$b_account_compiled_list->showMessage();
?>
<?php if ($b_account_compiled_list->TotalRecs > 0 || $b_account_compiled->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_account_compiled_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_account_compiled">
<?php if (!$b_account_compiled->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_account_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_compiled_list->Pager)) $b_account_compiled_list->Pager = new PrevNextPager($b_account_compiled_list->StartRec, $b_account_compiled_list->DisplayRecs, $b_account_compiled_list->TotalRecs, $b_account_compiled_list->AutoHidePager) ?>
<?php if ($b_account_compiled_list->Pager->RecordCount > 0 && $b_account_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_compiled_list->TotalRecs > 0 && (!$b_account_compiled_list->AutoHidePageSizeSelector || $b_account_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($b_account_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($b_account_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_account_compiledlist" id="fb_account_compiledlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_compiled_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_compiled_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_compiled">
<div id="gmp_b_account_compiled" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_account_compiled_list->TotalRecs > 0 || $b_account_compiled->isGridEdit()) { ?>
<table id="tbl_b_account_compiledlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_account_compiled_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_account_compiled_list->renderListOptions();

// Render list options (header, left)
$b_account_compiled_list->ListOptions->render("header", "left");
?>
<?php if ($b_account_compiled->id->Visible) { // id ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_account_compiled->id->headerCellClass() ?>"><div id="elh_b_account_compiled_id" class="b_account_compiled_id"><div class="ew-table-header-caption"><?php echo $b_account_compiled->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_account_compiled->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->id) ?>',1);"><div id="elh_b_account_compiled_id" class="b_account_compiled_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->grp->Visible) { // grp ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $b_account_compiled->grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_compiled_grp" class="b_account_compiled_grp"><div class="ew-table-header-caption"><?php echo $b_account_compiled->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $b_account_compiled->grp->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->grp) ?>',1);"><div id="elh_b_account_compiled_grp" class="b_account_compiled_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->account_no->Visible) { // account_no ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->account_no) == "") { ?>
		<th data-name="account_no" class="<?php echo $b_account_compiled->account_no->headerCellClass() ?>"><div id="elh_b_account_compiled_account_no" class="b_account_compiled_account_no"><div class="ew-table-header-caption"><?php echo $b_account_compiled->account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_no" class="<?php echo $b_account_compiled->account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->account_no) ?>',1);"><div id="elh_b_account_compiled_account_no" class="b_account_compiled_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->formal_name->Visible) { // formal_name ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $b_account_compiled->formal_name->headerCellClass() ?>"><div id="elh_b_account_compiled_formal_name" class="b_account_compiled_formal_name"><div class="ew-table-header-caption"><?php echo $b_account_compiled->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $b_account_compiled->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->formal_name) ?>',1);"><div id="elh_b_account_compiled_formal_name" class="b_account_compiled_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->balance->Visible) { // balance ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->balance) == "") { ?>
		<th data-name="balance" class="<?php echo $b_account_compiled->balance->headerCellClass() ?>"><div id="elh_b_account_compiled_balance" class="b_account_compiled_balance"><div class="ew-table-header-caption"><?php echo $b_account_compiled->balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="balance" class="<?php echo $b_account_compiled->balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->balance) ?>',1);"><div id="elh_b_account_compiled_balance" class="b_account_compiled_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->balance->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->loan_amount->Visible) { // loan_amount ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->loan_amount) == "") { ?>
		<th data-name="loan_amount" class="<?php echo $b_account_compiled->loan_amount->headerCellClass() ?>"><div id="elh_b_account_compiled_loan_amount" class="b_account_compiled_loan_amount"><div class="ew-table-header-caption"><?php echo $b_account_compiled->loan_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="loan_amount" class="<?php echo $b_account_compiled->loan_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->loan_amount) ?>',1);"><div id="elh_b_account_compiled_loan_amount" class="b_account_compiled_loan_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->loan_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->loan_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->loan_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->emi_amount->Visible) { // emi_amount ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->emi_amount) == "") { ?>
		<th data-name="emi_amount" class="<?php echo $b_account_compiled->emi_amount->headerCellClass() ?>"><div id="elh_b_account_compiled_emi_amount" class="b_account_compiled_emi_amount"><div class="ew-table-header-caption"><?php echo $b_account_compiled->emi_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emi_amount" class="<?php echo $b_account_compiled->emi_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->emi_amount) ?>',1);"><div id="elh_b_account_compiled_emi_amount" class="b_account_compiled_emi_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->emi_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->emi_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->emi_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->no_of_emi->Visible) { // no_of_emi ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->no_of_emi) == "") { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_compiled->no_of_emi->headerCellClass() ?>"><div id="elh_b_account_compiled_no_of_emi" class="b_account_compiled_no_of_emi"><div class="ew-table-header-caption"><?php echo $b_account_compiled->no_of_emi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_compiled->no_of_emi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->no_of_emi) ?>',1);"><div id="elh_b_account_compiled_no_of_emi" class="b_account_compiled_no_of_emi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->no_of_emi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->no_of_emi->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->no_of_emi->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->disbursement_amount->Visible) { // disbursement_amount ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->disbursement_amount) == "") { ?>
		<th data-name="disbursement_amount" class="<?php echo $b_account_compiled->disbursement_amount->headerCellClass() ?>"><div id="elh_b_account_compiled_disbursement_amount" class="b_account_compiled_disbursement_amount"><div class="ew-table-header-caption"><?php echo $b_account_compiled->disbursement_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="disbursement_amount" class="<?php echo $b_account_compiled->disbursement_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->disbursement_amount) ?>',1);"><div id="elh_b_account_compiled_disbursement_amount" class="b_account_compiled_disbursement_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->disbursement_amount->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->disbursement_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->disbursement_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->frequency->Visible) { // frequency ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->frequency) == "") { ?>
		<th data-name="frequency" class="<?php echo $b_account_compiled->frequency->headerCellClass() ?>"><div id="elh_b_account_compiled_frequency" class="b_account_compiled_frequency"><div class="ew-table-header-caption"><?php echo $b_account_compiled->frequency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="frequency" class="<?php echo $b_account_compiled->frequency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->frequency) ?>',1);"><div id="elh_b_account_compiled_frequency" class="b_account_compiled_frequency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->frequency->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->frequency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->frequency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->status->Visible) { // status ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->status) == "") { ?>
		<th data-name="status" class="<?php echo $b_account_compiled->status->headerCellClass() ?>"><div id="elh_b_account_compiled_status" class="b_account_compiled_status"><div class="ew-table-header-caption"><?php echo $b_account_compiled->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $b_account_compiled->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->status) ?>',1);"><div id="elh_b_account_compiled_status" class="b_account_compiled_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->end_date->Visible) { // end_date ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->end_date) == "") { ?>
		<th data-name="end_date" class="<?php echo $b_account_compiled->end_date->headerCellClass() ?>"><div id="elh_b_account_compiled_end_date" class="b_account_compiled_end_date"><div class="ew-table-header-caption"><?php echo $b_account_compiled->end_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="end_date" class="<?php echo $b_account_compiled->end_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->end_date) ?>',1);"><div id="elh_b_account_compiled_end_date" class="b_account_compiled_end_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->end_date->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->end_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->end_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->due_emi->Visible) { // due_emi ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->due_emi) == "") { ?>
		<th data-name="due_emi" class="<?php echo $b_account_compiled->due_emi->headerCellClass() ?>"><div id="elh_b_account_compiled_due_emi" class="b_account_compiled_due_emi"><div class="ew-table-header-caption"><?php echo $b_account_compiled->due_emi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="due_emi" class="<?php echo $b_account_compiled->due_emi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->due_emi) ?>',1);"><div id="elh_b_account_compiled_due_emi" class="b_account_compiled_due_emi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->due_emi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->due_emi->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->due_emi->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->branch->Visible) { // branch ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->branch) == "") { ?>
		<th data-name="branch" class="<?php echo $b_account_compiled->branch->headerCellClass() ?>"><div id="elh_b_account_compiled_branch" class="b_account_compiled_branch"><div class="ew-table-header-caption"><?php echo $b_account_compiled->branch->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="branch" class="<?php echo $b_account_compiled->branch->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->branch) ?>',1);"><div id="elh_b_account_compiled_branch" class="b_account_compiled_branch">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->branch->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->branch->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->branch->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_compiled->mobile->Visible) { // mobile ?>
	<?php if ($b_account_compiled->sortUrl($b_account_compiled->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $b_account_compiled->mobile->headerCellClass() ?>"><div id="elh_b_account_compiled_mobile" class="b_account_compiled_mobile"><div class="ew-table-header-caption"><?php echo $b_account_compiled->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $b_account_compiled->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_compiled->SortUrl($b_account_compiled->mobile) ?>',1);"><div id="elh_b_account_compiled_mobile" class="b_account_compiled_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_compiled->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_compiled->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_compiled->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_account_compiled_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_account_compiled->ExportAll && $b_account_compiled->isExport()) {
	$b_account_compiled_list->StopRec = $b_account_compiled_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_account_compiled_list->TotalRecs > $b_account_compiled_list->StartRec + $b_account_compiled_list->DisplayRecs - 1)
		$b_account_compiled_list->StopRec = $b_account_compiled_list->StartRec + $b_account_compiled_list->DisplayRecs - 1;
	else
		$b_account_compiled_list->StopRec = $b_account_compiled_list->TotalRecs;
}
$b_account_compiled_list->RecCnt = $b_account_compiled_list->StartRec - 1;
if ($b_account_compiled_list->Recordset && !$b_account_compiled_list->Recordset->EOF) {
	$b_account_compiled_list->Recordset->moveFirst();
	$selectLimit = $b_account_compiled_list->UseSelectLimit;
	if (!$selectLimit && $b_account_compiled_list->StartRec > 1)
		$b_account_compiled_list->Recordset->move($b_account_compiled_list->StartRec - 1);
} elseif (!$b_account_compiled->AllowAddDeleteRow && $b_account_compiled_list->StopRec == 0) {
	$b_account_compiled_list->StopRec = $b_account_compiled->GridAddRowCount;
}

// Initialize aggregate
$b_account_compiled->RowType = ROWTYPE_AGGREGATEINIT;
$b_account_compiled->resetAttributes();
$b_account_compiled_list->renderRow();
while ($b_account_compiled_list->RecCnt < $b_account_compiled_list->StopRec) {
	$b_account_compiled_list->RecCnt++;
	if ($b_account_compiled_list->RecCnt >= $b_account_compiled_list->StartRec) {
		$b_account_compiled_list->RowCnt++;

		// Set up key count
		$b_account_compiled_list->KeyCount = $b_account_compiled_list->RowIndex;

		// Init row class and style
		$b_account_compiled->resetAttributes();
		$b_account_compiled->CssClass = "";
		if ($b_account_compiled->isGridAdd()) {
		} else {
			$b_account_compiled_list->loadRowValues($b_account_compiled_list->Recordset); // Load row values
		}
		$b_account_compiled->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_account_compiled->RowAttrs = array_merge($b_account_compiled->RowAttrs, array('data-rowindex'=>$b_account_compiled_list->RowCnt, 'id'=>'r' . $b_account_compiled_list->RowCnt . '_b_account_compiled', 'data-rowtype'=>$b_account_compiled->RowType));

		// Render row
		$b_account_compiled_list->renderRow();

		// Render list options
		$b_account_compiled_list->renderListOptions();
?>
	<tr<?php echo $b_account_compiled->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_account_compiled_list->ListOptions->render("body", "left", $b_account_compiled_list->RowCnt);
?>
	<?php if ($b_account_compiled->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_account_compiled->id->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_id" class="b_account_compiled_id">
<span<?php echo $b_account_compiled->id->viewAttributes() ?>>
<?php echo $b_account_compiled->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $b_account_compiled->grp->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_grp" class="b_account_compiled_grp">
<span<?php echo $b_account_compiled->grp->viewAttributes() ?>>
<?php echo $b_account_compiled->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->account_no->Visible) { // account_no ?>
		<td data-name="account_no"<?php echo $b_account_compiled->account_no->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_account_no" class="b_account_compiled_account_no">
<span<?php echo $b_account_compiled->account_no->viewAttributes() ?>>
<?php echo $b_account_compiled->account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $b_account_compiled->formal_name->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_formal_name" class="b_account_compiled_formal_name">
<span<?php echo $b_account_compiled->formal_name->viewAttributes() ?>>
<?php echo $b_account_compiled->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->balance->Visible) { // balance ?>
		<td data-name="balance"<?php echo $b_account_compiled->balance->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_balance" class="b_account_compiled_balance">
<span<?php echo $b_account_compiled->balance->viewAttributes() ?>>
<?php echo $b_account_compiled->balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->loan_amount->Visible) { // loan_amount ?>
		<td data-name="loan_amount"<?php echo $b_account_compiled->loan_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_loan_amount" class="b_account_compiled_loan_amount">
<span<?php echo $b_account_compiled->loan_amount->viewAttributes() ?>>
<?php echo $b_account_compiled->loan_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->emi_amount->Visible) { // emi_amount ?>
		<td data-name="emi_amount"<?php echo $b_account_compiled->emi_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_emi_amount" class="b_account_compiled_emi_amount">
<span<?php echo $b_account_compiled->emi_amount->viewAttributes() ?>>
<?php echo $b_account_compiled->emi_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->no_of_emi->Visible) { // no_of_emi ?>
		<td data-name="no_of_emi"<?php echo $b_account_compiled->no_of_emi->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_no_of_emi" class="b_account_compiled_no_of_emi">
<span<?php echo $b_account_compiled->no_of_emi->viewAttributes() ?>>
<?php echo $b_account_compiled->no_of_emi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->disbursement_amount->Visible) { // disbursement_amount ?>
		<td data-name="disbursement_amount"<?php echo $b_account_compiled->disbursement_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_disbursement_amount" class="b_account_compiled_disbursement_amount">
<span<?php echo $b_account_compiled->disbursement_amount->viewAttributes() ?>>
<?php echo $b_account_compiled->disbursement_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->frequency->Visible) { // frequency ?>
		<td data-name="frequency"<?php echo $b_account_compiled->frequency->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_frequency" class="b_account_compiled_frequency">
<span<?php echo $b_account_compiled->frequency->viewAttributes() ?>>
<?php echo $b_account_compiled->frequency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->status->Visible) { // status ?>
		<td data-name="status"<?php echo $b_account_compiled->status->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_status" class="b_account_compiled_status">
<span<?php echo $b_account_compiled->status->viewAttributes() ?>>
<?php echo $b_account_compiled->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->end_date->Visible) { // end_date ?>
		<td data-name="end_date"<?php echo $b_account_compiled->end_date->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_end_date" class="b_account_compiled_end_date">
<span<?php echo $b_account_compiled->end_date->viewAttributes() ?>>
<?php echo $b_account_compiled->end_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->due_emi->Visible) { // due_emi ?>
		<td data-name="due_emi"<?php echo $b_account_compiled->due_emi->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_due_emi" class="b_account_compiled_due_emi">
<span<?php echo $b_account_compiled->due_emi->viewAttributes() ?>>
<?php echo $b_account_compiled->due_emi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->branch->Visible) { // branch ?>
		<td data-name="branch"<?php echo $b_account_compiled->branch->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_branch" class="b_account_compiled_branch">
<span<?php echo $b_account_compiled->branch->viewAttributes() ?>>
<?php echo $b_account_compiled->branch->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_compiled->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $b_account_compiled->mobile->cellAttributes() ?>>
<span id="el<?php echo $b_account_compiled_list->RowCnt ?>_b_account_compiled_mobile" class="b_account_compiled_mobile">
<span<?php echo $b_account_compiled->mobile->viewAttributes() ?>>
<?php echo $b_account_compiled->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_account_compiled_list->ListOptions->render("body", "right", $b_account_compiled_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_account_compiled->isGridAdd())
		$b_account_compiled_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$b_account_compiled->RowType = ROWTYPE_AGGREGATE;
$b_account_compiled->resetAttributes();
$b_account_compiled_list->renderRow();
?>
<?php if ($b_account_compiled_list->TotalRecs > 0 && !$b_account_compiled->isGridAdd() && !$b_account_compiled->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$b_account_compiled_list->renderListOptions();

// Render list options (footer, left)
$b_account_compiled_list->ListOptions->render("footer", "left");
?>
	<?php if ($b_account_compiled->id->Visible) { // id ?>
		<td data-name="id" class="<?php echo $b_account_compiled->id->footerCellClass() ?>"><span id="elf_b_account_compiled_id" class="b_account_compiled_id">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->grp->Visible) { // grp ?>
		<td data-name="grp" class="<?php echo $b_account_compiled->grp->footerCellClass() ?>"><span id="elf_b_account_compiled_grp" class="b_account_compiled_grp">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->account_no->Visible) { // account_no ?>
		<td data-name="account_no" class="<?php echo $b_account_compiled->account_no->footerCellClass() ?>"><span id="elf_b_account_compiled_account_no" class="b_account_compiled_account_no">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name" class="<?php echo $b_account_compiled->formal_name->footerCellClass() ?>"><span id="elf_b_account_compiled_formal_name" class="b_account_compiled_formal_name">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->balance->Visible) { // balance ?>
		<td data-name="balance" class="<?php echo $b_account_compiled->balance->footerCellClass() ?>"><span id="elf_b_account_compiled_balance" class="b_account_compiled_balance">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_compiled->balance->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->loan_amount->Visible) { // loan_amount ?>
		<td data-name="loan_amount" class="<?php echo $b_account_compiled->loan_amount->footerCellClass() ?>"><span id="elf_b_account_compiled_loan_amount" class="b_account_compiled_loan_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_compiled->loan_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->emi_amount->Visible) { // emi_amount ?>
		<td data-name="emi_amount" class="<?php echo $b_account_compiled->emi_amount->footerCellClass() ?>"><span id="elf_b_account_compiled_emi_amount" class="b_account_compiled_emi_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_compiled->emi_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->no_of_emi->Visible) { // no_of_emi ?>
		<td data-name="no_of_emi" class="<?php echo $b_account_compiled->no_of_emi->footerCellClass() ?>"><span id="elf_b_account_compiled_no_of_emi" class="b_account_compiled_no_of_emi">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->disbursement_amount->Visible) { // disbursement_amount ?>
		<td data-name="disbursement_amount" class="<?php echo $b_account_compiled->disbursement_amount->footerCellClass() ?>"><span id="elf_b_account_compiled_disbursement_amount" class="b_account_compiled_disbursement_amount">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $b_account_compiled->disbursement_amount->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->frequency->Visible) { // frequency ?>
		<td data-name="frequency" class="<?php echo $b_account_compiled->frequency->footerCellClass() ?>"><span id="elf_b_account_compiled_frequency" class="b_account_compiled_frequency">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->status->Visible) { // status ?>
		<td data-name="status" class="<?php echo $b_account_compiled->status->footerCellClass() ?>"><span id="elf_b_account_compiled_status" class="b_account_compiled_status">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->end_date->Visible) { // end_date ?>
		<td data-name="end_date" class="<?php echo $b_account_compiled->end_date->footerCellClass() ?>"><span id="elf_b_account_compiled_end_date" class="b_account_compiled_end_date">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->due_emi->Visible) { // due_emi ?>
		<td data-name="due_emi" class="<?php echo $b_account_compiled->due_emi->footerCellClass() ?>"><span id="elf_b_account_compiled_due_emi" class="b_account_compiled_due_emi">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->branch->Visible) { // branch ?>
		<td data-name="branch" class="<?php echo $b_account_compiled->branch->footerCellClass() ?>"><span id="elf_b_account_compiled_branch" class="b_account_compiled_branch">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($b_account_compiled->mobile->Visible) { // mobile ?>
		<td data-name="mobile" class="<?php echo $b_account_compiled->mobile->footerCellClass() ?>"><span id="elf_b_account_compiled_mobile" class="b_account_compiled_mobile">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$b_account_compiled_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_account_compiled->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_account_compiled_list->Recordset)
	$b_account_compiled_list->Recordset->Close();
?>
<?php if (!$b_account_compiled->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_account_compiled->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_compiled_list->Pager)) $b_account_compiled_list->Pager = new PrevNextPager($b_account_compiled_list->StartRec, $b_account_compiled_list->DisplayRecs, $b_account_compiled_list->TotalRecs, $b_account_compiled_list->AutoHidePager) ?>
<?php if ($b_account_compiled_list->Pager->RecordCount > 0 && $b_account_compiled_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_compiled_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_compiled_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_compiled_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_compiled_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_compiled_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_compiled_list->pageUrl() ?>start=<?php echo $b_account_compiled_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_compiled_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_compiled_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_compiled_list->TotalRecs > 0 && (!$b_account_compiled_list->AutoHidePageSizeSelector || $b_account_compiled_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_compiled">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($b_account_compiled_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_compiled_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_compiled_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($b_account_compiled->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_compiled_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_account_compiled_list->TotalRecs == 0 && !$b_account_compiled->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_account_compiled_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_account_compiled_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_account_compiled->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$b_account_compiled->isExport()) { ?>
<script>
ew.scrollableTable("gmp_b_account_compiled", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_account_compiled_list->terminate();
?>