<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_compiled_search = new b_account_compiled_search();

// Run the page
$b_account_compiled_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_compiled_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($b_account_compiled_search->IsModal) { ?>
var fb_account_compiledsearch = currentAdvancedSearchForm = new ew.Form("fb_account_compiledsearch", "search");
<?php } else { ?>
var fb_account_compiledsearch = currentForm = new ew.Form("fb_account_compiledsearch", "search");
<?php } ?>

// Form_CustomValidate event
fb_account_compiledsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_compiledsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_compiledsearch.lists["x_grp"] = <?php echo $b_account_compiled_search->grp->Lookup->toClientList() ?>;
fb_account_compiledsearch.lists["x_grp"].options = <?php echo JsonEncode($b_account_compiled_search->grp->lookupOptions()) ?>;
fb_account_compiledsearch.lists["x_frequency"] = <?php echo $b_account_compiled_search->frequency->Lookup->toClientList() ?>;
fb_account_compiledsearch.lists["x_frequency"].options = <?php echo JsonEncode($b_account_compiled_search->frequency->options(FALSE, TRUE)) ?>;
fb_account_compiledsearch.lists["x_status"] = <?php echo $b_account_compiled_search->status->Lookup->toClientList() ?>;
fb_account_compiledsearch.lists["x_status"].options = <?php echo JsonEncode($b_account_compiled_search->status->lookupOptions()) ?>;
fb_account_compiledsearch.lists["x_branch"] = <?php echo $b_account_compiled_search->branch->Lookup->toClientList() ?>;
fb_account_compiledsearch.lists["x_branch"].options = <?php echo JsonEncode($b_account_compiled_search->branch->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fb_account_compiledsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_loan_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->loan_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_emi_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->emi_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no_of_emi");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->no_of_emi->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_disbursement_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->disbursement_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_end_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->end_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_due_emi");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->due_emi->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_mobile");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($b_account_compiled->mobile->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_compiled_search->showPageHeader(); ?>
<?php
$b_account_compiled_search->showMessage();
?>
<form name="fb_account_compiledsearch" id="fb_account_compiledsearch" class="<?php echo $b_account_compiled_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_compiled_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_compiled_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_compiled">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_compiled_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($b_account_compiled->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label for="x_grp" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_grp"><?php echo $b_account_compiled->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->grp->cellAttributes() ?>>
			<span id="el_b_account_compiled_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_compiled" data-field="x_grp" data-value-separator="<?php echo $b_account_compiled->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $b_account_compiled->grp->editAttributes() ?>>
		<?php echo $b_account_compiled->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $b_account_compiled->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->account_no->Visible) { // account_no ?>
	<div id="r_account_no" class="form-group row">
		<label for="x_account_no" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_account_no"><?php echo $b_account_compiled->account_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_account_no" id="z_account_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->account_no->cellAttributes() ?>>
			<span id="el_b_account_compiled_account_no">
<input type="text" data-table="b_account_compiled" data-field="x_account_no" name="x_account_no" id="x_account_no" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($b_account_compiled->account_no->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->account_no->EditValue ?>"<?php echo $b_account_compiled->account_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label for="x_formal_name" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_formal_name"><?php echo $b_account_compiled->formal_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_formal_name" id="z_formal_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->formal_name->cellAttributes() ?>>
			<span id="el_b_account_compiled_formal_name">
<input type="text" data-table="b_account_compiled" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_compiled->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->formal_name->EditValue ?>"<?php echo $b_account_compiled->formal_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->balance->Visible) { // balance ?>
	<div id="r_balance" class="form-group row">
		<label for="x_balance" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_balance"><?php echo $b_account_compiled->balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_balance" id="z_balance" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->balance->cellAttributes() ?>>
			<span id="el_b_account_compiled_balance">
<input type="text" data-table="b_account_compiled" data-field="x_balance" name="x_balance" id="x_balance" size="30" placeholder="<?php echo HtmlEncode($b_account_compiled->balance->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->balance->EditValue ?>"<?php echo $b_account_compiled->balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label for="x_loan_amount" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_loan_amount"><?php echo $b_account_compiled->loan_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_loan_amount" id="z_loan_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->loan_amount->cellAttributes() ?>>
			<span id="el_b_account_compiled_loan_amount">
<input type="text" data-table="b_account_compiled" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_compiled->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->loan_amount->EditValue ?>"<?php echo $b_account_compiled->loan_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label for="x_emi_amount" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_emi_amount"><?php echo $b_account_compiled->emi_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_emi_amount" id="z_emi_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->emi_amount->cellAttributes() ?>>
			<span id="el_b_account_compiled_emi_amount">
<input type="text" data-table="b_account_compiled" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_compiled->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->emi_amount->EditValue ?>"<?php echo $b_account_compiled->emi_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label for="x_no_of_emi" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_no_of_emi"><?php echo $b_account_compiled->no_of_emi->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no_of_emi" id="z_no_of_emi" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->no_of_emi->cellAttributes() ?>>
			<span id="el_b_account_compiled_no_of_emi">
<input type="text" data-table="b_account_compiled" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_compiled->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->no_of_emi->EditValue ?>"<?php echo $b_account_compiled->no_of_emi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label for="x_disbursement_amount" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_disbursement_amount"><?php echo $b_account_compiled->disbursement_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_disbursement_amount" id="z_disbursement_amount" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->disbursement_amount->cellAttributes() ?>>
			<span id="el_b_account_compiled_disbursement_amount">
<input type="text" data-table="b_account_compiled" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_compiled->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->disbursement_amount->EditValue ?>"<?php echo $b_account_compiled->disbursement_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_frequency"><?php echo $b_account_compiled->frequency->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_frequency" id="z_frequency" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->frequency->cellAttributes() ?>>
			<span id="el_b_account_compiled_frequency">
<div id="tp_x_frequency" class="ew-template"><input type="radio" class="form-check-input" data-table="b_account_compiled" data-field="x_frequency" data-value-separator="<?php echo $b_account_compiled->frequency->displayValueSeparatorAttribute() ?>" name="x_frequency" id="x_frequency" value="{value}"<?php echo $b_account_compiled->frequency->editAttributes() ?>></div>
<div id="dsl_x_frequency" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $b_account_compiled->frequency->radioButtonListHtml(FALSE, "x_frequency") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_status"><?php echo $b_account_compiled->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->status->cellAttributes() ?>>
			<span id="el_b_account_compiled_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_compiled" data-field="x_status" data-value-separator="<?php echo $b_account_compiled->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $b_account_compiled->status->editAttributes() ?>>
		<?php echo $b_account_compiled->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $b_account_compiled->status->Lookup->getParamTag("p_x_status") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->end_date->Visible) { // end_date ?>
	<div id="r_end_date" class="form-group row">
		<label for="x_end_date" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_end_date"><?php echo $b_account_compiled->end_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_end_date" id="z_end_date" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->end_date->cellAttributes() ?>>
			<span id="el_b_account_compiled_end_date">
<input type="text" data-table="b_account_compiled" data-field="x_end_date" name="x_end_date" id="x_end_date" placeholder="<?php echo HtmlEncode($b_account_compiled->end_date->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->end_date->EditValue ?>"<?php echo $b_account_compiled->end_date->editAttributes() ?>>
<?php if (!$b_account_compiled->end_date->ReadOnly && !$b_account_compiled->end_date->Disabled && !isset($b_account_compiled->end_date->EditAttrs["readonly"]) && !isset($b_account_compiled->end_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fb_account_compiledsearch", "x_end_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->due_emi->Visible) { // due_emi ?>
	<div id="r_due_emi" class="form-group row">
		<label for="x_due_emi" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_due_emi"><?php echo $b_account_compiled->due_emi->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_due_emi" id="z_due_emi" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->due_emi->cellAttributes() ?>>
			<span id="el_b_account_compiled_due_emi">
<input type="text" data-table="b_account_compiled" data-field="x_due_emi" name="x_due_emi" id="x_due_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_compiled->due_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->due_emi->EditValue ?>"<?php echo $b_account_compiled->due_emi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->branch->Visible) { // branch ?>
	<div id="r_branch" class="form-group row">
		<label for="x_branch" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_branch"><?php echo $b_account_compiled->branch->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_branch" id="z_branch" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->branch->cellAttributes() ?>>
			<span id="el_b_account_compiled_branch">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_compiled" data-field="x_branch" data-value-separator="<?php echo $b_account_compiled->branch->displayValueSeparatorAttribute() ?>" id="x_branch" name="x_branch"<?php echo $b_account_compiled->branch->editAttributes() ?>>
		<?php echo $b_account_compiled->branch->selectOptionListHtml("x_branch") ?>
	</select>
</div>
<?php echo $b_account_compiled->branch->Lookup->getParamTag("p_x_branch") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label for="x_mobile" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled_mobile"><?php echo $b_account_compiled->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_mobile" id="z_mobile" value="="></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->mobile->cellAttributes() ?>>
			<span id="el_b_account_compiled_mobile">
<input type="text" data-table="b_account_compiled" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_compiled->mobile->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->mobile->EditValue ?>"<?php echo $b_account_compiled->mobile->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($b_account_compiled->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $b_account_compiled_search->LeftColumnClass ?>"><span id="elh_b_account_compiled__email"><?php echo $b_account_compiled->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $b_account_compiled_search->RightColumnClass ?>"><div<?php echo $b_account_compiled->_email->cellAttributes() ?>>
			<span id="el_b_account_compiled__email">
<input type="text" data-table="b_account_compiled" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_compiled->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_compiled->_email->EditValue ?>"<?php echo $b_account_compiled->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_compiled_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_compiled_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_compiled_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$b_account_compiled_search->terminate();
?>