<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_agent_add = new b_account_info_agent_add();

// Run the page
$b_account_info_agent_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_agent_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fb_account_info_agentadd = currentForm = new ew.Form("fb_account_info_agentadd", "add");

// Validate form
fb_account_info_agentadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($b_account_info_agent_add->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->id->caption(), $b_account_info_agent->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->b_type->Required) { ?>
			elm = this.getElements("x" + infix + "_b_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->b_type->caption(), $b_account_info_agent->b_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->grp->caption(), $b_account_info_agent->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->account_type->Required) { ?>
			elm = this.getElements("x" + infix + "_account_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->account_type->caption(), $b_account_info_agent->account_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->aadhaar_no->Required) { ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->aadhaar_no->caption(), $b_account_info_agent->aadhaar_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_aadhaar_no");
			if (elm && !ew.checkByRegEx(elm.value, /^[2-9]{1}[0-9]{3}[0-9]{4}[0-9]{4}$/))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->aadhaar_no->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->formal_name->Required) { ?>
			elm = this.getElements("x" + infix + "_formal_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->formal_name->caption(), $b_account_info_agent->formal_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->mobile->caption(), $b_account_info_agent->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->mobile->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->_email->caption(), $b_account_info_agent->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.checkEmail(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->_email->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->status->caption(), $b_account_info_agent->status->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->status->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->pan_no->Required) { ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->pan_no->caption(), $b_account_info_agent->pan_no->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pan_no");
			if (elm && !ew.checkByRegEx(elm.value, /([A-Z]){5}([0-9]){4}([A-Z]){1}$/))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->pan_no->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->other_details->Required) { ?>
			elm = this.getElements("x" + infix + "_other_details");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->other_details->caption(), $b_account_info_agent->other_details->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->loan_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->loan_amount->caption(), $b_account_info_agent->loan_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_loan_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->loan_amount->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->int_40->Required) { ?>
			elm = this.getElements("x" + infix + "_int_40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->int_40->caption(), $b_account_info_agent->int_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_int_40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->int_40->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->disbursement_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->disbursement_amount->caption(), $b_account_info_agent->disbursement_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_disbursement_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->disbursement_amount->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->emi_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->emi_amount->caption(), $b_account_info_agent->emi_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_emi_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->emi_amount->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->no_of_emi->Required) { ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->no_of_emi->caption(), $b_account_info_agent->no_of_emi->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_no_of_emi");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($b_account_info_agent->no_of_emi->errorMessage()) ?>");
		<?php if ($b_account_info_agent_add->frequency->Required) { ?>
			elm = this.getElements("x" + infix + "_frequency");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->frequency->caption(), $b_account_info_agent->frequency->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->operator->caption(), $b_account_info_agent->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($b_account_info_agent_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $b_account_info_agent->datetime->caption(), $b_account_info_agent->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fb_account_info_agentadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_info_agentadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_info_agentadd.lists["x_b_type"] = <?php echo $b_account_info_agent_add->b_type->Lookup->toClientList() ?>;
fb_account_info_agentadd.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_agent_add->b_type->options(FALSE, TRUE)) ?>;
fb_account_info_agentadd.lists["x_grp"] = <?php echo $b_account_info_agent_add->grp->Lookup->toClientList() ?>;
fb_account_info_agentadd.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_agent_add->grp->lookupOptions()) ?>;
fb_account_info_agentadd.lists["x_account_type"] = <?php echo $b_account_info_agent_add->account_type->Lookup->toClientList() ?>;
fb_account_info_agentadd.lists["x_account_type"].options = <?php echo JsonEncode($b_account_info_agent_add->account_type->lookupOptions()) ?>;
fb_account_info_agentadd.lists["x_status"] = <?php echo $b_account_info_agent_add->status->Lookup->toClientList() ?>;
fb_account_info_agentadd.lists["x_status"].options = <?php echo JsonEncode($b_account_info_agent_add->status->lookupOptions()) ?>;
fb_account_info_agentadd.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_info_agentadd.lists["x_frequency"] = <?php echo $b_account_info_agent_add->frequency->Lookup->toClientList() ?>;
fb_account_info_agentadd.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_agent_add->frequency->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $b_account_info_agent_add->showPageHeader(); ?>
<?php
$b_account_info_agent_add->showMessage();
?>
<form name="fb_account_info_agentadd" id="fb_account_info_agentadd" class="<?php echo $b_account_info_agent_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_agent_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_agent_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info_agent">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$b_account_info_agent_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($b_account_info_agent->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_b_account_info_agent_id" for="x_id" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->id->caption() ?><?php echo ($b_account_info_agent->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->id->cellAttributes() ?>><?php echo $b_account_info_agent->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->b_type->Visible) { // b_type ?>
	<div id="r_b_type" class="form-group row">
		<label id="elh_b_account_info_agent_b_type" for="x_b_type" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->b_type->caption() ?><?php echo ($b_account_info_agent->b_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->b_type->cellAttributes() ?>>
<span id="el_b_account_info_agent_b_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_b_type" data-value-separator="<?php echo $b_account_info_agent->b_type->displayValueSeparatorAttribute() ?>" id="x_b_type" name="x_b_type"<?php echo $b_account_info_agent->b_type->editAttributes() ?>>
		<?php echo $b_account_info_agent->b_type->selectOptionListHtml("x_b_type") ?>
	</select>
</div>
</span>
<?php echo $b_account_info_agent->b_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_b_account_info_agent_grp" for="x_grp" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->grp->caption() ?><?php echo ($b_account_info_agent->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->grp->cellAttributes() ?>>
<span id="el_b_account_info_agent_grp">
<?php $b_account_info_agent->grp->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$b_account_info_agent->grp->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_grp" data-value-separator="<?php echo $b_account_info_agent->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $b_account_info_agent->grp->editAttributes() ?>>
		<?php echo $b_account_info_agent->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $b_account_info_agent->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $b_account_info_agent->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->account_type->Visible) { // account_type ?>
	<div id="r_account_type" class="form-group row">
		<label id="elh_b_account_info_agent_account_type" for="x_account_type" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->account_type->caption() ?><?php echo ($b_account_info_agent->account_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->account_type->cellAttributes() ?>>
<span id="el_b_account_info_agent_account_type">
<?php $b_account_info_agent->account_type->EditAttrs["onchange"] = "ew.autoFill(this);" . @$b_account_info_agent->account_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_account_type" data-value-separator="<?php echo $b_account_info_agent->account_type->displayValueSeparatorAttribute() ?>" id="x_account_type" name="x_account_type"<?php echo $b_account_info_agent->account_type->editAttributes() ?>>
		<?php echo $b_account_info_agent->account_type->selectOptionListHtml("x_account_type") ?>
	</select>
</div>
<?php echo $b_account_info_agent->account_type->Lookup->getParamTag("p_x_account_type") ?>
</span>
<?php echo $b_account_info_agent->account_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->aadhaar_no->Visible) { // aadhaar_no ?>
	<div id="r_aadhaar_no" class="form-group row">
		<label id="elh_b_account_info_agent_aadhaar_no" for="x_aadhaar_no" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->aadhaar_no->caption() ?><?php echo ($b_account_info_agent->aadhaar_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->aadhaar_no->cellAttributes() ?>>
<span id="el_b_account_info_agent_aadhaar_no">
<input type="text" data-table="b_account_info_agent" data-field="x_aadhaar_no" name="x_aadhaar_no" id="x_aadhaar_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($b_account_info_agent->aadhaar_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->aadhaar_no->EditValue ?>"<?php echo $b_account_info_agent->aadhaar_no->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->aadhaar_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->formal_name->Visible) { // formal_name ?>
	<div id="r_formal_name" class="form-group row">
		<label id="elh_b_account_info_agent_formal_name" for="x_formal_name" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->formal_name->caption() ?><?php echo ($b_account_info_agent->formal_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->formal_name->cellAttributes() ?>>
<span id="el_b_account_info_agent_formal_name">
<input type="text" data-table="b_account_info_agent" data-field="x_formal_name" name="x_formal_name" id="x_formal_name" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info_agent->formal_name->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->formal_name->EditValue ?>"<?php echo $b_account_info_agent->formal_name->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->formal_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_b_account_info_agent_mobile" for="x_mobile" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->mobile->caption() ?><?php echo ($b_account_info_agent->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->mobile->cellAttributes() ?>>
<span id="el_b_account_info_agent_mobile">
<input type="text" data-table="b_account_info_agent" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info_agent->mobile->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->mobile->EditValue ?>"<?php echo $b_account_info_agent->mobile->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_b_account_info_agent__email" for="x__email" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->_email->caption() ?><?php echo ($b_account_info_agent->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->_email->cellAttributes() ?>>
<span id="el_b_account_info_agent__email">
<input type="text" data-table="b_account_info_agent" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($b_account_info_agent->_email->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->_email->EditValue ?>"<?php echo $b_account_info_agent->_email->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_b_account_info_agent_status" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->status->caption() ?><?php echo ($b_account_info_agent->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->status->cellAttributes() ?>>
<span id="el_b_account_info_agent_status">
<?php
$wrkonchange = "" . trim(@$b_account_info_agent->status->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$b_account_info_agent->status->EditAttrs["onchange"] = "";
?>
<span id="as_x_status" class="text-nowrap" style="z-index: 8890">
	<input type="text" class="form-control" name="sv_x_status" id="sv_x_status" value="<?php echo RemoveHtml($b_account_info_agent->status->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->status->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($b_account_info_agent->status->getPlaceHolder()) ?>"<?php echo $b_account_info_agent->status->editAttributes() ?>>
</span>
<input type="hidden" data-table="b_account_info_agent" data-field="x_status" data-value-separator="<?php echo $b_account_info_agent->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?php echo HtmlEncode($b_account_info_agent->status->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fb_account_info_agentadd.createAutoSuggest({"id":"x_status","forceSelect":true});
</script>
<?php echo $b_account_info_agent->status->Lookup->getParamTag("p_x_status") ?>
</span>
<?php echo $b_account_info_agent->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->pan_no->Visible) { // pan_no ?>
	<div id="r_pan_no" class="form-group row">
		<label id="elh_b_account_info_agent_pan_no" for="x_pan_no" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->pan_no->caption() ?><?php echo ($b_account_info_agent->pan_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->pan_no->cellAttributes() ?>>
<span id="el_b_account_info_agent_pan_no">
<input type="text" data-table="b_account_info_agent" data-field="x_pan_no" name="x_pan_no" id="x_pan_no" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($b_account_info_agent->pan_no->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->pan_no->EditValue ?>"<?php echo $b_account_info_agent->pan_no->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->pan_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->other_details->Visible) { // other_details ?>
	<div id="r_other_details" class="form-group row">
		<label id="elh_b_account_info_agent_other_details" for="x_other_details" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->other_details->caption() ?><?php echo ($b_account_info_agent->other_details->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->other_details->cellAttributes() ?>>
<span id="el_b_account_info_agent_other_details">
<textarea data-table="b_account_info_agent" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?php echo HtmlEncode($b_account_info_agent->other_details->getPlaceHolder()) ?>"<?php echo $b_account_info_agent->other_details->editAttributes() ?>><?php echo $b_account_info_agent->other_details->EditValue ?></textarea>
</span>
<?php echo $b_account_info_agent->other_details->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->loan_amount->Visible) { // loan_amount ?>
	<div id="r_loan_amount" class="form-group row">
		<label id="elh_b_account_info_agent_loan_amount" for="x_loan_amount" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->loan_amount->caption() ?><?php echo ($b_account_info_agent->loan_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->loan_amount->cellAttributes() ?>>
<span id="el_b_account_info_agent_loan_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_loan_amount" name="x_loan_amount" id="x_loan_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->loan_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->loan_amount->EditValue ?>"<?php echo $b_account_info_agent->loan_amount->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->loan_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->int_40->Visible) { // int_@ ?>
	<div id="r_int_40" class="form-group row">
		<label id="elh_b_account_info_agent_int_40" for="x_int_40" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->int_40->caption() ?><?php echo ($b_account_info_agent->int_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->int_40->cellAttributes() ?>>
<span id="el_b_account_info_agent_int_40">
<input type="text" data-table="b_account_info_agent" data-field="x_int_40" name="x_int_40" id="x_int_40" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->int_40->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->int_40->EditValue ?>"<?php echo $b_account_info_agent->int_40->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->int_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->disbursement_amount->Visible) { // disbursement_amount ?>
	<div id="r_disbursement_amount" class="form-group row">
		<label id="elh_b_account_info_agent_disbursement_amount" for="x_disbursement_amount" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->disbursement_amount->caption() ?><?php echo ($b_account_info_agent->disbursement_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->disbursement_amount->cellAttributes() ?>>
<span id="el_b_account_info_agent_disbursement_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_disbursement_amount" name="x_disbursement_amount" id="x_disbursement_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->disbursement_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->disbursement_amount->EditValue ?>"<?php echo $b_account_info_agent->disbursement_amount->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->disbursement_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->emi_amount->Visible) { // emi_amount ?>
	<div id="r_emi_amount" class="form-group row">
		<label id="elh_b_account_info_agent_emi_amount" for="x_emi_amount" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->emi_amount->caption() ?><?php echo ($b_account_info_agent->emi_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->emi_amount->cellAttributes() ?>>
<span id="el_b_account_info_agent_emi_amount">
<input type="text" data-table="b_account_info_agent" data-field="x_emi_amount" name="x_emi_amount" id="x_emi_amount" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->emi_amount->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->emi_amount->EditValue ?>"<?php echo $b_account_info_agent->emi_amount->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->emi_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->no_of_emi->Visible) { // no_of_emi ?>
	<div id="r_no_of_emi" class="form-group row">
		<label id="elh_b_account_info_agent_no_of_emi" for="x_no_of_emi" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->no_of_emi->caption() ?><?php echo ($b_account_info_agent->no_of_emi->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->no_of_emi->cellAttributes() ?>>
<span id="el_b_account_info_agent_no_of_emi">
<input type="text" data-table="b_account_info_agent" data-field="x_no_of_emi" name="x_no_of_emi" id="x_no_of_emi" size="30" placeholder="<?php echo HtmlEncode($b_account_info_agent->no_of_emi->getPlaceHolder()) ?>" value="<?php echo $b_account_info_agent->no_of_emi->EditValue ?>"<?php echo $b_account_info_agent->no_of_emi->editAttributes() ?>>
</span>
<?php echo $b_account_info_agent->no_of_emi->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($b_account_info_agent->frequency->Visible) { // frequency ?>
	<div id="r_frequency" class="form-group row">
		<label id="elh_b_account_info_agent_frequency" for="x_frequency" class="<?php echo $b_account_info_agent_add->LeftColumnClass ?>"><?php echo $b_account_info_agent->frequency->caption() ?><?php echo ($b_account_info_agent->frequency->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $b_account_info_agent_add->RightColumnClass ?>"><div<?php echo $b_account_info_agent->frequency->cellAttributes() ?>>
<span id="el_b_account_info_agent_frequency">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="b_account_info_agent" data-field="x_frequency" data-value-separator="<?php echo $b_account_info_agent->frequency->displayValueSeparatorAttribute() ?>" id="x_frequency" name="x_frequency"<?php echo $b_account_info_agent->frequency->editAttributes() ?>>
		<?php echo $b_account_info_agent->frequency->selectOptionListHtml("x_frequency") ?>
	</select>
</div>
</span>
<?php echo $b_account_info_agent->frequency->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$b_account_info_agent_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $b_account_info_agent_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $b_account_info_agent_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$b_account_info_agent_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");
//$('#x_aadhaar_no').attr('type', 'number');

$('#x_mobile').attr('type', 'number');
$('#x_otp').attr('type', 'number');
$('#x_no_of_emi').attr('type', 'number');
			$("#x_loan_amount").val('');
			$("#r_loan_amount").hide();
			$("#x_emi_amount").val('');
			$("#r_emi_amount").hide();
			$("#x_disbursement_amount").val('');
			$("#r_disbursement_amount").hide();
			$("#x_frequency").val('');
			$("#r_frequency").hide();

			//$("#x_fund_o").val('');
			//$("#r_fund_o").hide();
			//$("#x_fund_o_no").val('');
			//$("#r_fund_o_no").hide();

			$("#x_no_of_emi").val('');
			$("#r_no_of_emi").hide();
</script>
<?php include_once "footer.php" ?>
<?php
$b_account_info_agent_add->terminate();
?>