<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$b_account_info_agent_list = new b_account_info_agent_list();

// Run the page
$b_account_info_agent_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$b_account_info_agent_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$b_account_info_agent->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fb_account_info_agentlist = currentForm = new ew.Form("fb_account_info_agentlist", "list");
fb_account_info_agentlist.formKeyCountName = '<?php echo $b_account_info_agent_list->FormKeyCountName ?>';

// Form_CustomValidate event
fb_account_info_agentlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fb_account_info_agentlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fb_account_info_agentlist.lists["x_b_type"] = <?php echo $b_account_info_agent_list->b_type->Lookup->toClientList() ?>;
fb_account_info_agentlist.lists["x_b_type"].options = <?php echo JsonEncode($b_account_info_agent_list->b_type->options(FALSE, TRUE)) ?>;
fb_account_info_agentlist.lists["x_grp"] = <?php echo $b_account_info_agent_list->grp->Lookup->toClientList() ?>;
fb_account_info_agentlist.lists["x_grp"].options = <?php echo JsonEncode($b_account_info_agent_list->grp->lookupOptions()) ?>;
fb_account_info_agentlist.lists["x_account_type"] = <?php echo $b_account_info_agent_list->account_type->Lookup->toClientList() ?>;
fb_account_info_agentlist.lists["x_account_type"].options = <?php echo JsonEncode($b_account_info_agent_list->account_type->lookupOptions()) ?>;
fb_account_info_agentlist.lists["x_status"] = <?php echo $b_account_info_agent_list->status->Lookup->toClientList() ?>;
fb_account_info_agentlist.lists["x_status"].options = <?php echo JsonEncode($b_account_info_agent_list->status->lookupOptions()) ?>;
fb_account_info_agentlist.autoSuggests["x_status"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fb_account_info_agentlist.lists["x_frequency"] = <?php echo $b_account_info_agent_list->frequency->Lookup->toClientList() ?>;
fb_account_info_agentlist.lists["x_frequency"].options = <?php echo JsonEncode($b_account_info_agent_list->frequency->options(FALSE, TRUE)) ?>;

// Form object for search
var fb_account_info_agentlistsrch = currentSearchForm = new ew.Form("fb_account_info_agentlistsrch");

// Filters
fb_account_info_agentlistsrch.filterList = <?php echo $b_account_info_agent_list->getFilterList() ?>;

// Init search panel as collapsed
fb_account_info_agentlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$b_account_info_agent->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($b_account_info_agent_list->TotalRecs > 0 && $b_account_info_agent_list->ExportOptions->visible()) { ?>
<?php $b_account_info_agent_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_info_agent_list->ImportOptions->visible()) { ?>
<?php $b_account_info_agent_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_info_agent_list->SearchOptions->visible()) { ?>
<?php $b_account_info_agent_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($b_account_info_agent_list->FilterOptions->visible()) { ?>
<?php $b_account_info_agent_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$b_account_info_agent_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$b_account_info_agent->isExport() && !$b_account_info_agent->CurrentAction) { ?>
<form name="fb_account_info_agentlistsrch" id="fb_account_info_agentlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($b_account_info_agent_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fb_account_info_agentlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="b_account_info_agent">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($b_account_info_agent_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($b_account_info_agent_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $b_account_info_agent_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($b_account_info_agent_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($b_account_info_agent_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($b_account_info_agent_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($b_account_info_agent_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $b_account_info_agent_list->showPageHeader(); ?>
<?php
$b_account_info_agent_list->showMessage();
?>
<?php if ($b_account_info_agent_list->TotalRecs > 0 || $b_account_info_agent->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($b_account_info_agent_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> b_account_info_agent">
<?php if (!$b_account_info_agent->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$b_account_info_agent->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_info_agent_list->Pager)) $b_account_info_agent_list->Pager = new PrevNextPager($b_account_info_agent_list->StartRec, $b_account_info_agent_list->DisplayRecs, $b_account_info_agent_list->TotalRecs, $b_account_info_agent_list->AutoHidePager) ?>
<?php if ($b_account_info_agent_list->Pager->RecordCount > 0 && $b_account_info_agent_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_info_agent_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_info_agent_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_info_agent_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_info_agent_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_info_agent_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_info_agent_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_info_agent_list->TotalRecs > 0 && (!$b_account_info_agent_list->AutoHidePageSizeSelector || $b_account_info_agent_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_info_agent">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($b_account_info_agent_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_info_agent_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_info_agent_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($b_account_info_agent->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_info_agent_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fb_account_info_agentlist" id="fb_account_info_agentlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($b_account_info_agent_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $b_account_info_agent_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="b_account_info_agent">
<input type="hidden" name="exporttype" id="exporttype" value="">
<div id="gmp_b_account_info_agent" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($b_account_info_agent_list->TotalRecs > 0 || $b_account_info_agent->isGridEdit()) { ?>
<table id="tbl_b_account_info_agentlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$b_account_info_agent_list->RowType = ROWTYPE_HEADER;

// Render list options
$b_account_info_agent_list->renderListOptions();

// Render list options (header, left)
$b_account_info_agent_list->ListOptions->render("header", "left");
?>
<?php if ($b_account_info_agent->id->Visible) { // id ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->id) == "") { ?>
		<th data-name="id" class="<?php echo $b_account_info_agent->id->headerCellClass() ?>"><div id="elh_b_account_info_agent_id" class="b_account_info_agent_id"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $b_account_info_agent->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->id) ?>',1);"><div id="elh_b_account_info_agent_id" class="b_account_info_agent_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->b_type->Visible) { // b_type ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->b_type) == "") { ?>
		<th data-name="b_type" class="<?php echo $b_account_info_agent->b_type->headerCellClass() ?>"><div id="elh_b_account_info_agent_b_type" class="b_account_info_agent_b_type"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->b_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_type" class="<?php echo $b_account_info_agent->b_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->b_type) ?>',1);"><div id="elh_b_account_info_agent_b_type" class="b_account_info_agent_b_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->b_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->b_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->b_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->grp->Visible) { // grp ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $b_account_info_agent->grp->headerCellClass() ?>"><div id="elh_b_account_info_agent_grp" class="b_account_info_agent_grp"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $b_account_info_agent->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->grp) ?>',1);"><div id="elh_b_account_info_agent_grp" class="b_account_info_agent_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->account_type->Visible) { // account_type ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->account_type) == "") { ?>
		<th data-name="account_type" class="<?php echo $b_account_info_agent->account_type->headerCellClass() ?>"><div id="elh_b_account_info_agent_account_type" class="b_account_info_agent_account_type"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->account_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_type" class="<?php echo $b_account_info_agent->account_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->account_type) ?>',1);"><div id="elh_b_account_info_agent_account_type" class="b_account_info_agent_account_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->account_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->account_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->account_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->account_no->Visible) { // account_no ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->account_no) == "") { ?>
		<th data-name="account_no" class="<?php echo $b_account_info_agent->account_no->headerCellClass() ?>"><div id="elh_b_account_info_agent_account_no" class="b_account_info_agent_account_no"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->account_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="account_no" class="<?php echo $b_account_info_agent->account_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->account_no) ?>',1);"><div id="elh_b_account_info_agent_account_no" class="b_account_info_agent_account_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->account_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->account_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->account_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->formal_name->Visible) { // formal_name ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->formal_name) == "") { ?>
		<th data-name="formal_name" class="<?php echo $b_account_info_agent->formal_name->headerCellClass() ?>"><div id="elh_b_account_info_agent_formal_name" class="b_account_info_agent_formal_name"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->formal_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="formal_name" class="<?php echo $b_account_info_agent->formal_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->formal_name) ?>',1);"><div id="elh_b_account_info_agent_formal_name" class="b_account_info_agent_formal_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->formal_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->formal_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->formal_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->mobile->Visible) { // mobile ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $b_account_info_agent->mobile->headerCellClass() ?>"><div id="elh_b_account_info_agent_mobile" class="b_account_info_agent_mobile"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $b_account_info_agent->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->mobile) ?>',1);"><div id="elh_b_account_info_agent_mobile" class="b_account_info_agent_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->mobile->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->status->Visible) { // status ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->status) == "") { ?>
		<th data-name="status" class="<?php echo $b_account_info_agent->status->headerCellClass() ?>"><div id="elh_b_account_info_agent_status" class="b_account_info_agent_status"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $b_account_info_agent->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->status) ?>',1);"><div id="elh_b_account_info_agent_status" class="b_account_info_agent_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->loan_amount->Visible) { // loan_amount ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->loan_amount) == "") { ?>
		<th data-name="loan_amount" class="<?php echo $b_account_info_agent->loan_amount->headerCellClass() ?>"><div id="elh_b_account_info_agent_loan_amount" class="b_account_info_agent_loan_amount"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->loan_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="loan_amount" class="<?php echo $b_account_info_agent->loan_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->loan_amount) ?>',1);"><div id="elh_b_account_info_agent_loan_amount" class="b_account_info_agent_loan_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->loan_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->loan_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->loan_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->int_40->Visible) { // int_@ ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->int_40) == "") { ?>
		<th data-name="int_40" class="<?php echo $b_account_info_agent->int_40->headerCellClass() ?>"><div id="elh_b_account_info_agent_int_40" class="b_account_info_agent_int_40"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->int_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="int_40" class="<?php echo $b_account_info_agent->int_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->int_40) ?>',1);"><div id="elh_b_account_info_agent_int_40" class="b_account_info_agent_int_40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->int_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->int_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->int_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->disbursement_amount->Visible) { // disbursement_amount ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->disbursement_amount) == "") { ?>
		<th data-name="disbursement_amount" class="<?php echo $b_account_info_agent->disbursement_amount->headerCellClass() ?>"><div id="elh_b_account_info_agent_disbursement_amount" class="b_account_info_agent_disbursement_amount"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->disbursement_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="disbursement_amount" class="<?php echo $b_account_info_agent->disbursement_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->disbursement_amount) ?>',1);"><div id="elh_b_account_info_agent_disbursement_amount" class="b_account_info_agent_disbursement_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->disbursement_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->disbursement_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->disbursement_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->emi_amount->Visible) { // emi_amount ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->emi_amount) == "") { ?>
		<th data-name="emi_amount" class="<?php echo $b_account_info_agent->emi_amount->headerCellClass() ?>"><div id="elh_b_account_info_agent_emi_amount" class="b_account_info_agent_emi_amount"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->emi_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="emi_amount" class="<?php echo $b_account_info_agent->emi_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->emi_amount) ?>',1);"><div id="elh_b_account_info_agent_emi_amount" class="b_account_info_agent_emi_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->emi_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->emi_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->emi_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->no_of_emi->Visible) { // no_of_emi ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->no_of_emi) == "") { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_info_agent->no_of_emi->headerCellClass() ?>"><div id="elh_b_account_info_agent_no_of_emi" class="b_account_info_agent_no_of_emi"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->no_of_emi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_of_emi" class="<?php echo $b_account_info_agent->no_of_emi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->no_of_emi) ?>',1);"><div id="elh_b_account_info_agent_no_of_emi" class="b_account_info_agent_no_of_emi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->no_of_emi->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->no_of_emi->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->no_of_emi->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->frequency->Visible) { // frequency ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->frequency) == "") { ?>
		<th data-name="frequency" class="<?php echo $b_account_info_agent->frequency->headerCellClass() ?>"><div id="elh_b_account_info_agent_frequency" class="b_account_info_agent_frequency"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->frequency->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="frequency" class="<?php echo $b_account_info_agent->frequency->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->frequency) ?>',1);"><div id="elh_b_account_info_agent_frequency" class="b_account_info_agent_frequency">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->frequency->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->frequency->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->frequency->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->otp_delivery_datetime) == "") { ?>
		<th data-name="otp_delivery_datetime" class="<?php echo $b_account_info_agent->otp_delivery_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_agent_otp_delivery_datetime" class="b_account_info_agent_otp_delivery_datetime"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->otp_delivery_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="otp_delivery_datetime" class="<?php echo $b_account_info_agent->otp_delivery_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->otp_delivery_datetime) ?>',1);"><div id="elh_b_account_info_agent_otp_delivery_datetime" class="b_account_info_agent_otp_delivery_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->otp_delivery_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->otp_delivery_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->otp_delivery_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($b_account_info_agent->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
	<?php if ($b_account_info_agent->sortUrl($b_account_info_agent->otp_verify_datetime) == "") { ?>
		<th data-name="otp_verify_datetime" class="<?php echo $b_account_info_agent->otp_verify_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_b_account_info_agent_otp_verify_datetime" class="b_account_info_agent_otp_verify_datetime"><div class="ew-table-header-caption"><?php echo $b_account_info_agent->otp_verify_datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="otp_verify_datetime" class="<?php echo $b_account_info_agent->otp_verify_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $b_account_info_agent->SortUrl($b_account_info_agent->otp_verify_datetime) ?>',1);"><div id="elh_b_account_info_agent_otp_verify_datetime" class="b_account_info_agent_otp_verify_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $b_account_info_agent->otp_verify_datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($b_account_info_agent->otp_verify_datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($b_account_info_agent->otp_verify_datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$b_account_info_agent_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($b_account_info_agent->ExportAll && $b_account_info_agent->isExport()) {
	$b_account_info_agent_list->StopRec = $b_account_info_agent_list->TotalRecs;
} else {

	// Set the last record to display
	if ($b_account_info_agent_list->TotalRecs > $b_account_info_agent_list->StartRec + $b_account_info_agent_list->DisplayRecs - 1)
		$b_account_info_agent_list->StopRec = $b_account_info_agent_list->StartRec + $b_account_info_agent_list->DisplayRecs - 1;
	else
		$b_account_info_agent_list->StopRec = $b_account_info_agent_list->TotalRecs;
}
$b_account_info_agent_list->RecCnt = $b_account_info_agent_list->StartRec - 1;
if ($b_account_info_agent_list->Recordset && !$b_account_info_agent_list->Recordset->EOF) {
	$b_account_info_agent_list->Recordset->moveFirst();
	$selectLimit = $b_account_info_agent_list->UseSelectLimit;
	if (!$selectLimit && $b_account_info_agent_list->StartRec > 1)
		$b_account_info_agent_list->Recordset->move($b_account_info_agent_list->StartRec - 1);
} elseif (!$b_account_info_agent->AllowAddDeleteRow && $b_account_info_agent_list->StopRec == 0) {
	$b_account_info_agent_list->StopRec = $b_account_info_agent->GridAddRowCount;
}

// Initialize aggregate
$b_account_info_agent->RowType = ROWTYPE_AGGREGATEINIT;
$b_account_info_agent->resetAttributes();
$b_account_info_agent_list->renderRow();
while ($b_account_info_agent_list->RecCnt < $b_account_info_agent_list->StopRec) {
	$b_account_info_agent_list->RecCnt++;
	if ($b_account_info_agent_list->RecCnt >= $b_account_info_agent_list->StartRec) {
		$b_account_info_agent_list->RowCnt++;

		// Set up key count
		$b_account_info_agent_list->KeyCount = $b_account_info_agent_list->RowIndex;

		// Init row class and style
		$b_account_info_agent->resetAttributes();
		$b_account_info_agent->CssClass = "";
		if ($b_account_info_agent->isGridAdd()) {
		} else {
			$b_account_info_agent_list->loadRowValues($b_account_info_agent_list->Recordset); // Load row values
		}
		$b_account_info_agent->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$b_account_info_agent->RowAttrs = array_merge($b_account_info_agent->RowAttrs, array('data-rowindex'=>$b_account_info_agent_list->RowCnt, 'id'=>'r' . $b_account_info_agent_list->RowCnt . '_b_account_info_agent', 'data-rowtype'=>$b_account_info_agent->RowType));

		// Render row
		$b_account_info_agent_list->renderRow();

		// Render list options
		$b_account_info_agent_list->renderListOptions();
?>
	<tr<?php echo $b_account_info_agent->rowAttributes() ?>>
<?php

// Render list options (body, left)
$b_account_info_agent_list->ListOptions->render("body", "left", $b_account_info_agent_list->RowCnt);
?>
	<?php if ($b_account_info_agent->id->Visible) { // id ?>
		<td data-name="id"<?php echo $b_account_info_agent->id->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_id" class="b_account_info_agent_id">
<span<?php echo $b_account_info_agent->id->viewAttributes() ?>>
<?php echo $b_account_info_agent->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->b_type->Visible) { // b_type ?>
		<td data-name="b_type"<?php echo $b_account_info_agent->b_type->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_b_type" class="b_account_info_agent_b_type">
<span<?php echo $b_account_info_agent->b_type->viewAttributes() ?>>
<?php echo $b_account_info_agent->b_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $b_account_info_agent->grp->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_grp" class="b_account_info_agent_grp">
<span<?php echo $b_account_info_agent->grp->viewAttributes() ?>>
<?php echo $b_account_info_agent->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->account_type->Visible) { // account_type ?>
		<td data-name="account_type"<?php echo $b_account_info_agent->account_type->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_account_type" class="b_account_info_agent_account_type">
<span<?php echo $b_account_info_agent->account_type->viewAttributes() ?>>
<?php echo $b_account_info_agent->account_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->account_no->Visible) { // account_no ?>
		<td data-name="account_no"<?php echo $b_account_info_agent->account_no->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_account_no" class="b_account_info_agent_account_no">
<span<?php echo $b_account_info_agent->account_no->viewAttributes() ?>>
<?php echo $b_account_info_agent->account_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->formal_name->Visible) { // formal_name ?>
		<td data-name="formal_name"<?php echo $b_account_info_agent->formal_name->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_formal_name" class="b_account_info_agent_formal_name">
<span<?php echo $b_account_info_agent->formal_name->viewAttributes() ?>>
<?php echo $b_account_info_agent->formal_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $b_account_info_agent->mobile->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_mobile" class="b_account_info_agent_mobile">
<span<?php echo $b_account_info_agent->mobile->viewAttributes() ?>>
<?php echo $b_account_info_agent->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->status->Visible) { // status ?>
		<td data-name="status"<?php echo $b_account_info_agent->status->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_status" class="b_account_info_agent_status">
<span<?php echo $b_account_info_agent->status->viewAttributes() ?>>
<?php echo $b_account_info_agent->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->loan_amount->Visible) { // loan_amount ?>
		<td data-name="loan_amount"<?php echo $b_account_info_agent->loan_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_loan_amount" class="b_account_info_agent_loan_amount">
<span<?php echo $b_account_info_agent->loan_amount->viewAttributes() ?>>
<?php echo $b_account_info_agent->loan_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->int_40->Visible) { // int_@ ?>
		<td data-name="int_40"<?php echo $b_account_info_agent->int_40->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_int_40" class="b_account_info_agent_int_40">
<span<?php echo $b_account_info_agent->int_40->viewAttributes() ?>>
<?php echo $b_account_info_agent->int_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->disbursement_amount->Visible) { // disbursement_amount ?>
		<td data-name="disbursement_amount"<?php echo $b_account_info_agent->disbursement_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_disbursement_amount" class="b_account_info_agent_disbursement_amount">
<span<?php echo $b_account_info_agent->disbursement_amount->viewAttributes() ?>>
<?php echo $b_account_info_agent->disbursement_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->emi_amount->Visible) { // emi_amount ?>
		<td data-name="emi_amount"<?php echo $b_account_info_agent->emi_amount->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_emi_amount" class="b_account_info_agent_emi_amount">
<span<?php echo $b_account_info_agent->emi_amount->viewAttributes() ?>>
<?php echo $b_account_info_agent->emi_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->no_of_emi->Visible) { // no_of_emi ?>
		<td data-name="no_of_emi"<?php echo $b_account_info_agent->no_of_emi->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_no_of_emi" class="b_account_info_agent_no_of_emi">
<span<?php echo $b_account_info_agent->no_of_emi->viewAttributes() ?>>
<?php echo $b_account_info_agent->no_of_emi->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->frequency->Visible) { // frequency ?>
		<td data-name="frequency"<?php echo $b_account_info_agent->frequency->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_frequency" class="b_account_info_agent_frequency">
<span<?php echo $b_account_info_agent->frequency->viewAttributes() ?>>
<?php echo $b_account_info_agent->frequency->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->otp_delivery_datetime->Visible) { // otp_delivery_datetime ?>
		<td data-name="otp_delivery_datetime"<?php echo $b_account_info_agent->otp_delivery_datetime->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_otp_delivery_datetime" class="b_account_info_agent_otp_delivery_datetime">
<span<?php echo $b_account_info_agent->otp_delivery_datetime->viewAttributes() ?>>
<?php echo $b_account_info_agent->otp_delivery_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($b_account_info_agent->otp_verify_datetime->Visible) { // otp_verify_datetime ?>
		<td data-name="otp_verify_datetime"<?php echo $b_account_info_agent->otp_verify_datetime->cellAttributes() ?>>
<span id="el<?php echo $b_account_info_agent_list->RowCnt ?>_b_account_info_agent_otp_verify_datetime" class="b_account_info_agent_otp_verify_datetime">
<span<?php echo $b_account_info_agent->otp_verify_datetime->viewAttributes() ?>>
<?php echo $b_account_info_agent->otp_verify_datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$b_account_info_agent_list->ListOptions->render("body", "right", $b_account_info_agent_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$b_account_info_agent->isGridAdd())
		$b_account_info_agent_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$b_account_info_agent->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($b_account_info_agent_list->Recordset)
	$b_account_info_agent_list->Recordset->Close();
?>
<?php if (!$b_account_info_agent->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$b_account_info_agent->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($b_account_info_agent_list->Pager)) $b_account_info_agent_list->Pager = new PrevNextPager($b_account_info_agent_list->StartRec, $b_account_info_agent_list->DisplayRecs, $b_account_info_agent_list->TotalRecs, $b_account_info_agent_list->AutoHidePager) ?>
<?php if ($b_account_info_agent_list->Pager->RecordCount > 0 && $b_account_info_agent_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($b_account_info_agent_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($b_account_info_agent_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $b_account_info_agent_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($b_account_info_agent_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($b_account_info_agent_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $b_account_info_agent_list->pageUrl() ?>start=<?php echo $b_account_info_agent_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($b_account_info_agent_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $b_account_info_agent_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($b_account_info_agent_list->TotalRecs > 0 && (!$b_account_info_agent_list->AutoHidePageSizeSelector || $b_account_info_agent_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="b_account_info_agent">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="20"<?php if ($b_account_info_agent_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($b_account_info_agent_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($b_account_info_agent_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="ALL"<?php if ($b_account_info_agent->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $b_account_info_agent_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($b_account_info_agent_list->TotalRecs == 0 && !$b_account_info_agent->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $b_account_info_agent_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$b_account_info_agent_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$b_account_info_agent->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$b_account_info_agent->isExport()) { ?>
<script>
ew.scrollableTable("gmp_b_account_info_agent", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$b_account_info_agent_list->terminate();
?>